/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import stanford.netdb.directory.Directory;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.util.ACL;
import stanford.netdb.util.Config_Loader;
import stanford.netdb.util.Property;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Server
implements SignalHandler {
    protected static Logger logger = null;
    protected static String host = null;
    protected static int port = 0;
    protected static String instance = null;
    protected static String schema = null;
    protected static String user = null;
    protected static String pass = null;
    protected static String s_user = null;
    protected static String s_pass = null;

    protected Server() {
    }

    public static void init() throws Exception {
        Server server = new Server();
        Signal.handle(new Signal("HUP"), server);
        Config_Loader.load_all(false);
        logger = (Logger)Class.forName(System.getProperty("logging.class", "stanford.netdb.logging.Silent_Logger")).newInstance();
        NetDB_Logger.default_logger(logger);
        String string = System.getProperty("logging.level", "INFO");
        if (string.equals("")) {
            string = "INFO";
        }
        logger.setLevel(Level.parse(string.toUpperCase()));
        host = System.getProperty("database.host");
        port = Property.fetch_as_int("database.port");
        instance = System.getProperty("database.instance");
        schema = System.getProperty("database.schema", "netdb");
        user = System.getProperty("database.user");
        pass = System.getProperty("database.password");
        s_user = System.getProperty("database.search_user");
        s_pass = System.getProperty("database.search_password");
    }

    protected static Datastore datastore() throws Exception {
        return new Datastore(host, port, instance, schema, user, pass, s_user, s_pass);
    }

    protected static Directory directory() throws Exception {
        Directory directory = (Directory)Class.forName(System.getProperty("directory.class")).newInstance();
        directory.init();
        return directory;
    }

    protected static ACL acl() {
        ACL aCL = new ACL(System.getProperty("acl.path", ""), "acl");
        long l = Property.fetch_as_long("acl.age");
        if (l > 0L) {
            aCL.age(l);
        }
        return aCL;
    }

    @Override
    public void handle(Signal signal) {
        if (signal == null) {
            return;
        }
        if ("HUP".equals(signal.getName())) {
            this.sighup();
        }
    }

    private void sighup() {
        try {
            logger.config("SIGHUP received. Reloading config files.");
            Config_Loader.load_all(true);
            logger.config("Reloading complete.");
        }
        catch (Exception exception) {
            logger.config("An error occurred while processing a 'HUP' signal: " + exception.getMessage());
        }
    }
}

