/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SRV_Record
implements Comparable<SRV_Record>,
Comparator<SRV_Record>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern pattern = Pattern.compile("(\\d+) +(\\d+) +(\\d+) +(.+)");
    private Integer priority = 0;
    private Integer weight = 0;
    private Integer port = 0;
    private String host = "";

    public SRV_Record() {
    }

    public SRV_Record(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.priority = Integer.parseInt(matcher.group(1));
            this.weight = Integer.parseInt(matcher.group(2));
            this.port = Integer.parseInt(matcher.group(3));
            this.host = matcher.group(4).trim();
        }
    }

    public SRV_Record(Integer n, Integer n2, Integer n3, String string) {
        this.priority(n);
        this.weight(n2);
        this.port(n3);
        this.host(string);
    }

    public Integer priority() {
        return this.priority;
    }

    public Integer weight() {
        return this.weight;
    }

    public Integer port() {
        return this.port;
    }

    public String host() {
        return this.host;
    }

    public SRV_Record priority(Integer n) {
        this.priority = n;
        return this;
    }

    public SRV_Record weight(Integer n) {
        this.weight = n;
        return this;
    }

    public SRV_Record port(Integer n) {
        this.port = n;
        return this;
    }

    public SRV_Record host(String string) {
        this.host = string.trim();
        return this;
    }

    public String toString() {
        return this.priority + " " + this.weight + " " + this.port + " " + this.host;
    }

    @Override
    public int compareTo(SRV_Record sRV_Record) {
        return this.compare(this, sRV_Record);
    }

    @Override
    public int compare(SRV_Record sRV_Record, SRV_Record sRV_Record2) {
        if (sRV_Record == null && sRV_Record2 == null) {
            return 0;
        }
        if (sRV_Record == null) {
            return -1;
        }
        if (sRV_Record2 == null) {
            return 1;
        }
        if (sRV_Record.priority < sRV_Record2.priority) {
            return -1;
        }
        if (sRV_Record.priority > sRV_Record2.priority) {
            return 1;
        }
        return 0;
    }
}

