/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.util.Cache;

public class ACL
extends NetDB_Logger {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_NAME = "ACL cache";
    private static final Pattern ACL_PATTERN = Pattern.compile("^(.+?) +(.+)$");
    private static final int ACCESS_GROUP = 1;
    private static final int NAME_GROUP = 2;
    private String path = "";
    private String name = "";
    private long age = 300L;

    public ACL(String string, String string2) {
        this.path = string;
        this.name = string2;
    }

    public ACL(String string, String string2, long l) {
        this.path = string;
        this.name = string2;
        this.age = l;
    }

    public synchronized String access(String string) throws Exception {
        Hashtable<String, String> hashtable;
        String string2;
        Cache<Hashtable<String, String>> cache = Cache.fetch_hashtable_cache(CACHE_NAME + this.name, this.age);
        if (cache.is_old().booleanValue()) {
            cache.data(this.read_acl());
        }
        if ((string2 = (hashtable = cache.data()).get(string)) == null) {
            string2 = hashtable.get("all");
            this.logger().finer("Using the default ACL access '" + string2 + "' for user '" + string + "'.");
        } else {
            this.logger().finer("Found ACL access '" + string2 + "' for user '" + string + "'.");
        }
        return string2;
    }

    public Boolean has_access(String string) throws Exception {
        String string2 = this.access(string);
        if (string2.equals("allow") || string2.equals("stat")) {
            return true;
        }
        return false;
    }

    private Hashtable<String, String> read_acl() throws Exception {
        this.logger().finer("Loading ACL");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("all", "allow");
        File file = new File(this.path);
        if (!file.exists()) {
            this.logger().severe("The ACL file '" + this.path + "' does not exist.");
            return hashtable;
        }
        FileReader fileReader = new FileReader(file);
        String string = "";
        int n = fileReader.read();
        while (n > 0) {
            if ((char)n == '\n') {
                this.process_line(string, hashtable);
                string = "";
            } else {
                string = string + (char)n;
            }
            n = fileReader.read();
        }
        this.process_line(string, hashtable);
        return hashtable;
    }

    private void process_line(String string, Hashtable<String, String> hashtable) {
        string = string.replaceAll("#.+", "");
        if ((string = string.trim()).equals("")) {
            return;
        }
        Matcher matcher = ACL_PATTERN.matcher(string);
        if (matcher.matches()) {
            hashtable.put(matcher.group(2), matcher.group(1).toLowerCase());
        } else {
            this.logger().finest("ACL class cannot parse the line '" + string + "'.");
        }
    }

    public long age() {
        return this.age;
    }

    public synchronized ACL age(long l) {
        this.age = l;
        Cache cache = Cache.shared(CACHE_NAME + this.name);
        if (cache != null) {
            cache.age(l);
        }
        return this;
    }
}

