/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.ssparser;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.IP.IP;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;

public class SSparser {
    public static final String IP_LOW = "ip_low";
    public static final String IP_HIGH = "ip_high";
    public static final String STRING = "string";
    public static final String HW_ADDRESS = "hw";
    public static final String NAME = "name";
    public static final String ORIGINAL_NAME = "original_name";
    public static final String DOMAIN = "domain";
    public static boolean debug = false;
    private static Pattern whitespace = Pattern.compile("\\s+");
    private static Pattern rangeWithDash = Pattern.compile("^([-0-9a-fA-F\\[\\]\\/%*?_.:]+)\\s*-\\s*([-0-9a-fA-F\\[\\]\\/%*?_.:]+)$");
    private static Pattern hwWithColons = Pattern.compile("^[a-fA-F0-9]{1,2}(:[a-fA-F0-9]{1,2}){5}$");
    private static Pattern hwWithDashes = Pattern.compile("^[a-fA-F0-9]{1,2}(-[a-fA-F0-9]{1,2}){5}$");
    private static Pattern hwWithSpaces = Pattern.compile("^[a-fA-F0-9]{1,2}( [a-fA-F0-9]{1,2}){5}$");
    private static Pattern hwWithDots = Pattern.compile("^[a-fA-F0-9]{4}(\\.[a-fA-F0-9]{4}){2}$");
    private static Pattern hwMiddleColon = Pattern.compile("^[a-fA-F0-9]{6}:[a-fA-F0-9]{6}$");
    private static Pattern hwEndColon = Pattern.compile("^[a-fA-F0-9]{12}:$");
    private static Pattern hw12hex = Pattern.compile("^[a-fA-F0-9]{12}$");
    private static Pattern colon = Pattern.compile(":");
    private static Pattern dash = Pattern.compile("-");
    private static Pattern ipAddress = Pattern.compile("^[0-9a-fA-F\\[\\]\\/%*?_:^][-0-9a-fA-F\\[\\]\\/%*?_.:^]*$");
    private static Pattern ipV4Address = Pattern.compile("^\\d{1,3}\\.[-0-9\\[\\]\\/%*?_.^]*$");
    private static Pattern ipV6Address = Pattern.compile("^[0-9a-fA-f:]{0,4}\\:[-0-9a-fA-F\\[\\]\\/%*?_.:^]*$");
    private static Pattern dnsName = Pattern.compile("^[-a-zA-Z0-9\\^\\[\\].%*_?]+$");
    private static Pattern misplacedCaret = Pattern.compile("[^\\[]\\^");
    private static Pattern slash = Pattern.compile("\\/");
    private static Pattern reCharsWcaret = Pattern.compile("[\\]\\[*%_?^]");
    private static Pattern reCharsWdash = Pattern.compile("[\\]\\[*%_?-]");
    private static Pattern doubleDots = Pattern.compile("\\.\\.");
    private static Pattern bracketExp = Pattern.compile("\\[.*?\\]");
    private static Pattern tooManyDots = Pattern.compile("\\..*\\..*\\..*\\.");
    private static Pattern toSepandRest = Pattern.compile("(.*[.:])(.*)");

    public static Hashtable<String, String> parse(String string) throws Exception {
        String string2 = new String(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = new String[]{"de", "ad", "be", "ef", "ca", "fe"};
        boolean bl = false;
        boolean bl2 = false;
        string = string.trim();
        string = string.replace('*', '%');
        if (rangeWithDash.matcher(string = string.replace('?', '_')).matches()) {
            string = rangeWithDash.matcher(string).replaceFirst("$1-$2");
        }
        if (hwWithSpaces.matcher(string).matches()) {
            hashtable.put(STRING, string);
            stringArray = whitespace.split(string);
            bl = true;
        } else {
            if (whitespace.matcher(string).find()) {
                hashtable.put(STRING, string);
                return hashtable;
            }
            if (hwWithColons.matcher(string).matches()) {
                stringArray = colon.split(string);
                bl = true;
            } else if (hwWithDashes.matcher(string).matches()) {
                stringArray = dash.split(string);
                bl = true;
                bl2 = true;
            } else if (hwWithDots.matcher(string).matches()) {
                stringArray[0] = string.substring(0, 2);
                stringArray[1] = string.substring(2, 4);
                stringArray[2] = string.substring(5, 7);
                stringArray[3] = string.substring(7, 9);
                stringArray[4] = string.substring(10, 12);
                stringArray[5] = string.substring(12, 14);
                bl = true;
                bl2 = true;
            } else if (hwMiddleColon.matcher(string).matches()) {
                stringArray[0] = string.substring(0, 2);
                stringArray[1] = string.substring(2, 4);
                stringArray[2] = string.substring(4, 6);
                stringArray[3] = string.substring(7, 9);
                stringArray[4] = string.substring(9, 11);
                stringArray[5] = string.substring(11, 13);
                bl = true;
            } else if (hwEndColon.matcher(string).matches()) {
                stringArray[0] = string.substring(0, 2);
                stringArray[1] = string.substring(2, 4);
                stringArray[2] = string.substring(4, 6);
                stringArray[3] = string.substring(6, 8);
                stringArray[4] = string.substring(8, 10);
                stringArray[5] = string.substring(10, 12);
                bl = true;
            } else if (hw12hex.matcher(string).matches()) {
                stringArray[0] = string.substring(0, 2);
                stringArray[1] = string.substring(2, 4);
                stringArray[2] = string.substring(4, 6);
                stringArray[3] = string.substring(6, 8);
                stringArray[4] = string.substring(8, 10);
                stringArray[5] = string.substring(10, 12);
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            String string3 = "";
            for (int i = 0; i < 6; ++i) {
                if (stringArray[i].length() == 1) {
                    string3 = string3 + "0";
                }
                string3 = string3 + stringArray[i];
            }
            hashtable.put(HW_ADDRESS, string3);
            if (bl2) {
                hashtable.put(NAME, string2);
            }
            return hashtable;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (ipV4Address.matcher(string).matches() || ipV6Address.matcher(string).matches()) {
            bl3 = true;
        } else if (dnsName.matcher(string).matches() && !misplacedCaret.matcher(string).find()) {
            bl4 = true;
        } else {
            hashtable.put(STRING, string);
            return hashtable;
        }
        if (bl4) {
            int n = string.indexOf(46);
            hashtable.put(ORIGINAL_NAME, new String(string));
            String string4 = string;
            String string5 = "";
            if (n != -1) {
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1, string.length());
            }
            hashtable.put(NAME, string4);
            if (string5 != null && string5.length() > 0) {
                hashtable.put(DOMAIN, string5);
            }
            return hashtable;
        }
        return SSparser.parse_ip(string);
    }

    public static Hashtable<String, String> parse_ip(String string) throws Exception {
        Prefix prefix;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        string = string.trim();
        string = string.replace('*', '%');
        if (rangeWithDash.matcher(string = string.replace('?', '_')).matches()) {
            string = rangeWithDash.matcher(string).replaceFirst("$1-$2");
        }
        if (!ipAddress.matcher(string).matches()) {
            throw new Exception("bad IP address expression");
        }
        if (slash.matcher(string).find() && reCharsWdash.matcher(string).find() || doubleDots.matcher(string).find()) {
            throw new Exception("bad IP address expression");
        }
        String string2 = bracketExp.matcher(string).replaceAll("");
        if (string2.indexOf(45) > -1) {
            Object object;
            Object object2;
            if (reCharsWcaret.matcher(string).find()) {
                throw new Exception("bad IP address expression");
            }
            String[] stringArray = dash.split(string2);
            String string3 = null;
            String string4 = null;
            try {
                string3 = stringArray[0];
                string4 = stringArray[1];
            }
            catch (Exception exception) {
                throw new Exception("bad IP address expression");
            }
            if (tooManyDots.matcher(string3).find() || tooManyDots.matcher(string4).find()) {
                throw new Exception("bad IP address expression");
            }
            if (!toSepandRest.matcher(string4).matches()) {
                object2 = toSepandRest.matcher(string3);
                if (!((Matcher)object2).matches()) {
                    throw new Exception("bad IP address expression");
                }
                try {
                    object = ((Matcher)object2).group(1);
                    String string5 = ((Matcher)object2).group(2);
                    int n = string5.length() - string4.length();
                    if (n > 0) {
                        string4 = string5.substring(0, n) + string4;
                    }
                    string4 = (String)object + string4;
                }
                catch (Exception exception) {
                    throw new Exception("bad IP address expression");
                }
            }
            try {
                object2 = new IPaddress(string3);
            }
            catch (Exception exception) {
                throw new Exception("bad IP address expression, " + string3);
            }
            try {
                object = new IPaddress(string4);
            }
            catch (Exception exception) {
                throw new Exception("bad IP address expression, " + string4);
            }
            if (IPaddress.cmp((IP)object2, (IP)object) == 1) {
                throw new Exception("bad IP range, low > high");
            }
            string3 = ((IPaddress)object2).toString();
            string4 = ((IPaddress)object).toString();
            hashtable.put(IP_LOW, string3);
            hashtable.put(IP_HIGH, string4);
            if (debug) {
                System.out.println("ip [" + string3 + "] - [" + string4 + "]");
            }
            return hashtable;
        }
        if (reCharsWcaret.matcher(string).find()) {
            if (misplacedCaret.matcher(string).find() || tooManyDots.matcher(string).find()) {
                hashtable.put(STRING, string);
            } else {
                hashtable.put(IP_LOW, string);
                if (debug) {
                    System.out.println("ip [" + string + "] - [null]");
                }
            }
            return hashtable;
        }
        if (tooManyDots.matcher(string).find()) {
            throw new Exception("bad IP address expression, " + string);
        }
        String string6 = string;
        if (!slash.matcher(string).find()) {
            string6 = string6 + (colon.matcher(string).find() ? "/128" : "/32");
        }
        try {
            prefix = new Prefix(string6);
        }
        catch (Exception exception) {
            throw new Exception("bad IP address expression, " + string);
        }
        String string7 = prefix.address().toString();
        String string8 = prefix.broadcast().toString();
        hashtable.put(IP_LOW, string7);
        hashtable.put(IP_HIGH, string8);
        if (debug) {
            System.out.println("ip [" + string7 + "] - [" + string8 + "]");
        }
        return hashtable;
    }
}

