/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.User;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;
import stanford.netdb.middleware.User_i;
import stanford.netdb.util.Queue;

public class Queued_User
extends UnicastRemoteObject
implements User_i {
    public static final long serialVersionUID = 1L;
    private NetDB_Datastore datastore = null;

    public Queued_User(Datastore datastore) throws RemoteException {
        try {
            this.datastore = new NetDB_Datastore(datastore);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Failed to create NetDB_Datastore.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable search(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = User._search(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable login(String string) throws Exception, No_Datastore_Defined {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = User._login(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable info(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = User._load_object("", this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User commit(User user, Boolean bl) throws Exception {
        Queue.enqueue();
        User user2 = null;
        try {
            user.bind(this.datastore);
            user2 = user._commit(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return user2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws Exception {
        Queue.enqueue();
        try {
            User._delete(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock_Result lock_record(User user) throws Exception {
        Queue.enqueue();
        Lock_Result lock_Result = null;
        try {
            user.bind(this.datastore);
            lock_Result = User._lock_record("", this.datastore, user.handle());
        }
        finally {
            Queue.dequeue();
        }
        return lock_Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean unlock_record(User user) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            user.bind(this.datastore);
            bl = user._unlock(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean has_access(User user, String string) throws Exception {
        Queue.enqueue();
        Boolean bl = null;
        try {
            bl = User._has_access("", this.datastore, user, string);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handle(Integer n) throws Exception {
        Queue.enqueue();
        String string = null;
        try {
            string = User._handle(this.datastore, n);
        }
        finally {
            Queue.dequeue();
        }
        return string;
    }

    @Override
    public Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    @Override
    public Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer verify_or_die(Integer n, String string) throws Exception {
        Queue.enqueue();
        Integer n2 = null;
        try {
            n2 = User._verify_or_die("", this.datastore, n, string);
        }
        finally {
            Queue.dequeue();
        }
        return n2;
    }
}

