/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import stanford.netdb.Group;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;
import stanford.netdb.middleware.Owner_i;
import stanford.netdb.util.Queue;

public class Queued_Owner
extends UnicastRemoteObject
implements Owner_i {
    public static final long serialVersionUID = 1L;
    private NetDB_Datastore datastore = null;

    public Queued_Owner(Datastore datastore) throws RemoteException {
        try {
            this.datastore = new NetDB_Datastore(datastore);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Failed to create NetDB_Datastore.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable search(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Group._search(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable info(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Group._load_object("", this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group commit(Group group, Boolean bl) throws Exception {
        Queue.enqueue();
        Group group2 = null;
        try {
            group.bind(this.datastore);
            group2 = group._commit(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return group2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws Exception {
        Queue.enqueue();
        try {
            Group._delete(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock_Result lock_record(Group group) throws Exception {
        Queue.enqueue();
        Lock_Result lock_Result = null;
        try {
            group.bind(this.datastore);
            lock_Result = Group._lock_record("", this.datastore, group.handle());
        }
        finally {
            Queue.dequeue();
        }
        return lock_Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean unlock_record(Group group) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            group.bind(this.datastore);
            bl = group._unlock(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean has_access(Integer n, String string, Integer n2) throws Exception {
        Queue.enqueue();
        Boolean bl = null;
        try {
            bl = Group._has_access("", this.datastore, n, string, n2);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable list(Boolean bl) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Group._list(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handle(Integer n) throws Exception {
        Queue.enqueue();
        String string = null;
        try {
            string = Group._handle(this.datastore, n);
        }
        finally {
            Queue.dequeue();
        }
        return string;
    }

    @Override
    public Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    @Override
    public Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer verify_or_die(Integer n, String string) throws Exception {
        Queue.enqueue();
        Integer n2 = null;
        try {
            n2 = Group._verify_or_die("", this.datastore, n, string);
        }
        finally {
            Queue.dequeue();
        }
        return n2;
    }
}

