/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network;
import stanford.netdb.User;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;
import stanford.netdb.middleware.Network_i;
import stanford.netdb.util.Queue;

public class Queued_Network
extends UnicastRemoteObject
implements Network_i {
    public static final long serialVersionUID = 1L;
    private NetDB_Datastore datastore = null;

    public Queued_Network(Datastore datastore) throws RemoteException {
        try {
            this.datastore = new NetDB_Datastore(datastore);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Failed to create NetDB_Datastore.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable search(String string, String string2, String string3) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Network._search(this.datastore, string, string2, string3);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable info(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Network._load_object("", this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network commit(Network network, Boolean bl) throws Exception {
        Queue.enqueue();
        Network network2 = null;
        try {
            network.bind(this.datastore);
            network2 = network._commit(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return network2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws Exception {
        Queue.enqueue();
        try {
            Network._delete(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock_Result lock_record(Network network) throws Exception {
        Queue.enqueue();
        Lock_Result lock_Result = null;
        try {
            network.bind(this.datastore);
            lock_Result = Network._lock_record("", this.datastore, network.handle());
        }
        finally {
            Queue.dequeue();
        }
        return lock_Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean unlock_record(Network network) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            network.bind(this.datastore);
            bl = network._unlock(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer next_available_vlan(Integer n) throws Exception {
        Queue.enqueue();
        Integer n2 = null;
        try {
            n2 = Network._next_available_vlan(this.datastore, n);
        }
        finally {
            Queue.dequeue();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean has_access(User user, String string) throws Exception {
        Queue.enqueue();
        Boolean bl = null;
        try {
            bl = Network._has_access("", this.datastore, user, string);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable list() throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Network._list(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    @Override
    public Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    @Override
    public Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer verify_or_die(Integer n, String string) throws Exception {
        Queue.enqueue();
        Integer n2 = null;
        try {
            n2 = Network._verify_or_die("", this.datastore, n, string);
        }
        finally {
            Queue.dequeue();
        }
        return n2;
    }
}

