/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import stanford.netdb.Domain;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.User;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Domain_i;
import stanford.netdb.middleware.Lock_Result;
import stanford.netdb.util.Queue;

public class Queued_Domain
extends UnicastRemoteObject
implements Domain_i {
    public static final long serialVersionUID = 1L;
    private NetDB_Datastore datastore = null;

    public Queued_Domain(Datastore datastore) throws RemoteException {
        try {
            this.datastore = new NetDB_Datastore(datastore);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Failed to create NetDB_Datastore.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable search(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Domain._search(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable info(String string) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Domain._load_object("", this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Domain commit(Domain domain, Boolean bl) throws Exception {
        Queue.enqueue();
        Domain domain2 = null;
        try {
            domain.bind(this.datastore);
            domain2 = domain._commit(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return domain2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws Exception {
        Queue.enqueue();
        try {
            Domain._delete(this.datastore, string);
        }
        finally {
            Queue.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock_Result lock_record(Domain domain) throws Exception {
        Queue.enqueue();
        Lock_Result lock_Result = null;
        try {
            domain.bind(this.datastore);
            lock_Result = Domain._lock_record("", this.datastore, domain.handle());
        }
        finally {
            Queue.dequeue();
        }
        return lock_Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean unlock_record(Domain domain) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            domain.bind(this.datastore);
            bl = domain._unlock(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean has_access(User user, String string) throws Exception {
        Queue.enqueue();
        Boolean bl = null;
        try {
            bl = Domain._has_access("", this.datastore, user, string);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean can_use(Domain domain) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            bl = domain._can_use(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean can_use_as_name(Domain domain) throws Exception {
        Queue.enqueue();
        Boolean bl = false;
        try {
            bl = domain._can_use_as_name(this.datastore);
        }
        finally {
            Queue.dequeue();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable list(Boolean bl) throws Exception {
        Queue.enqueue();
        Hashtable hashtable = null;
        try {
            hashtable = Domain._list(this.datastore, bl);
        }
        finally {
            Queue.dequeue();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handle(Integer n) throws Exception {
        Queue.enqueue();
        String string = null;
        try {
            string = Domain._handle(this.datastore, n);
        }
        finally {
            Queue.dequeue();
        }
        return string;
    }

    @Override
    public Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    @Override
    public Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer verify_or_die(Integer n, String string) throws Exception {
        Queue.enqueue();
        Integer n2 = null;
        try {
            n2 = Domain._verify_or_die("", this.datastore, n, string);
        }
        finally {
            Queue.dequeue();
        }
        return n2;
    }
}

