/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import stanford.netdb.directory.Directory;
import stanford.netdb.directory.Directory_Record;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Directory_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Record;

public class NetDB_Directory
extends NetDB_Record
implements Directory_i {
    private static final long serialVersionUID = 1L;
    private Directory_i remote_object = null;
    private Directory dir = null;

    public NetDB_Directory(Datastore datastore, Directory directory) {
        super(datastore);
        this.dir = directory;
    }

    protected Directory_i open_remote_connection() throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = (MCP_i)this.datastore.open_remote_connection();
        return mCP_i.directory();
    }

    @Override
    public Directory_Record lookup_exact(String string) throws Exception, IllegalArgumentException {
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        Directory_Record directory_Record = null;
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.dir.connect(this.datastore.directory_connection());
            directory_Record = this.dir.lookup_exact(string);
            this.dir.disconnect();
        } else {
            this.remote_object = this.open_remote_connection();
            directory_Record = this.remote_object.lookup_exact(string);
            this.datastore.close_remote_connection();
        }
        return directory_Record;
    }

    @Override
    public Vector<Directory_Record> lookup_by_key(String string) throws Exception {
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        Vector<Directory_Record> vector = null;
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.dir.connect(this.datastore.directory_connection());
            vector = this.dir.lookup_by_key(string);
            this.dir.disconnect();
        } else {
            this.remote_object = this.open_remote_connection();
            vector = this.remote_object.lookup_by_key(string);
            this.datastore.close_remote_connection();
        }
        return vector;
    }

    @Override
    public Vector<Directory_Record> lookup_by_name(String string) throws Exception {
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        Vector<Directory_Record> vector = null;
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.dir.connect(this.datastore.directory_connection());
            vector = this.dir.lookup_by_name(string);
            this.dir.disconnect();
        } else {
            this.remote_object = this.open_remote_connection();
            vector = this.remote_object.lookup_by_name(string);
            this.datastore.close_remote_connection();
        }
        return vector;
    }

    @Override
    public Vector<Directory_Record> lookup_by_UID(String string) throws Exception {
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        Vector<Directory_Record> vector = null;
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.dir.connect(this.datastore.directory_connection());
            vector = this.dir.lookup_by_UID(string);
            this.dir.disconnect();
        } else {
            this.remote_object = this.open_remote_connection();
            vector = this.remote_object.lookup_by_UID(string);
            this.datastore.close_remote_connection();
        }
        return vector;
    }
}

