/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.middleware.DB_Statement;
import stanford.netdb.middleware.Null;
import stanford.netdb.middleware.OutParam;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.middleware.Rollback_Delay;
import stanford.netdb.middleware.Session_ID;
import stanford.netdb.util.Property;
import stanford.netdb.util.TZ_Timestamp;

public class NetDB_Connection {
    protected static final String COLUMN_NAMES_KEY = "column_names";
    protected static final String RESULT_KEY = "resultSet";
    private static Calendar calendar = null;
    private static Boolean sql_timing = false;
    private static String db_schema = "";
    private static int sql_delay = Property.fetch_as_int("database.max_query_run_time", "600");
    private static int transaction_idle = Property.fetch_as_int("database.max_transaction_idle", "30");
    private Rollback_Delay auto_rollback = null;
    private Session_ID session_id = null;
    private Integer transaction_id = null;
    private Connection con = null;
    private String db_url;
    private Properties db_props;

    public NetDB_Connection(String string, Properties properties) {
        this.db_url = string;
        this.db_props = properties;
    }

    public static Boolean sql_timing() {
        return sql_timing;
    }

    public static void sql_timing(Boolean bl) {
        sql_timing = bl;
    }

    public static String db_schema() {
        return db_schema;
    }

    public static void db_schema(String string) {
        db_schema = string.trim();
    }

    public Session_ID session_id() {
        return this.session_id;
    }

    public void session_id(Session_ID session_ID) {
        this.session_id = session_ID;
    }

    protected Integer transaction_id() {
        return this.transaction_id;
    }

    protected void transaction_id(Integer n) {
        this.transaction_id = n;
    }

    protected String logged_session_id() {
        return this.logged_session_id(true);
    }

    protected String logged_session_id(Boolean bl) {
        String string = "null session_id";
        if (this.session_id != null) {
            string = this.session_id.toString(bl);
        }
        if (this.transaction_id != null) {
            string = string + "-" + this.transaction_id;
        }
        return string;
    }

    public Boolean isValid() {
        try {
            if (this.con != null) {
                return this.con.isValid(5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized void release() throws SQLException {
        this.cancel_rollback_timer();
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
        System.gc();
    }

    public void commit(Logger logger) throws SQLException {
        this.cancel_rollback_timer();
        logger.finer(this.logged_session_id() + " COMMITTING");
        try {
            this.con.commit();
        }
        catch (Exception exception) {
            this.rollback(logger);
        }
    }

    public void rollback(Logger logger) throws SQLException {
        this.cancel_rollback_timer();
        if (this.con != null && this.transaction_id != null && this.transaction_id != -1) {
            logger.finer(this.logged_session_id() + " ROLLING BACK");
            this.con.rollback();
            this.transaction_id = -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Result_Hash execute(Logger var1_1, DB_Statement var2_2) throws Exception, SQLException {
        var3_3 = var2_2.get_type();
        var4_4 = null;
        var5_5 = null;
        this.start_rollback_timer(NetDB_Connection.sql_delay);
        try {
            if (this.con == null || this.con.isClosed()) {
                this.con = DriverManager.getConnection(this.db_url, this.db_props);
                this.con.setAutoCommit(false);
                this.con.setTransactionIsolation(2);
            }
            var5_5 = this.con.createStatement();
            if (NetDB_Connection.db_schema != null && NetDB_Connection.db_schema.length() > 0) {
                var5_5.execute("ALTER SESSION SET CURRENT_SCHEMA=" + NetDB_Connection.db_schema);
            }
            switch (var3_3) {
                case 1: {
                    var4_4 = this.select(var1_1, var2_2, "XXX: statement id");
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    var4_4 = this.stored_procedure(var1_1, var2_2);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                default: {
                    throw new Exception("Unknown DB_Statement type '" + var3_3 + "'");
                }
            }
        }
        catch (Exception var6_7) {
            if (var6_7 instanceof SQLException) {
                this.sql_session_timeout(var4_4, ((SQLException)var6_7).getErrorCode());
            }
            if ((var7_8 = var6_7.getMessage()) == null) {
                var7_8 = "";
            }
            var8_9 = var7_8;
            var8_9 = var8_9.replaceAll("^ORA-\\d+:.", "");
            if (Property.fetch_as_Boolean("rmi.log_all_exceptions", "false").booleanValue()) {
                var1_1.info(Exception_Formatter.stack_trace(var6_7));
            }
            this.rollback(var1_1);
            throw new Exception(var8_9);
        }
        finally {
            try {
                var5_5.close();
            }
            catch (Exception var10_11) {}
        }
        this.start_rollback_timer(NetDB_Connection.transaction_idle);
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result_Hash select(Logger logger, DB_Statement dB_Statement, String string) throws Exception, SQLException {
        Result_Hash result_Hash = new Result_Hash();
        ResultSet resultSet = null;
        Vector vector = new Vector();
        String string2 = dB_Statement.toString();
        if (string2 != null && string2.length() > 0) {
            logger.fine(this.logged_session_id() + " " + string2);
        }
        Statement statement = this.con.createStatement();
        long l = Calendar.getInstance().getTime().getTime();
        try {
            int n;
            if (db_schema != null && db_schema.length() > 0) {
                statement.execute("ALTER SESSION SET CURRENT_SCHEMA=" + db_schema);
            }
            resultSet = statement.executeQuery(dB_Statement.get_SQL(db_schema));
            if (sql_timing.booleanValue()) {
                long l2 = Calendar.getInstance().getTime().getTime();
                double d = (double)(l2 - l) / 1000.0;
                logger.info("[" + dB_Statement.toString() + "] completed in " + d + " sec.");
            }
            SQLWarning sQLWarning = resultSet.getWarnings();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Vector<String> vector2 = new Vector<String>(resultSetMetaData.getColumnCount());
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                vector2.addElement(resultSetMetaData.getColumnName(n + 1));
            }
            result_Hash.put_vector(COLUMN_NAMES_KEY, vector2);
            n = 0;
            int n2 = resultSetMetaData.getColumnCount();
            Vector vector3 = new Vector();
            result_Hash.put_vector(RESULT_KEY, vector3);
            while (resultSet.next()) {
                Vector<Object> vector4 = new Vector<Object>();
                vector3.addElement(vector4);
                for (int i = 1; i <= n2; ++i) {
                    Object object;
                    Object object2 = resultSet.getObject(i);
                    if (object2 instanceof ResultSet) {
                        try {
                            n = 0;
                            object = new Result_Hash();
                            this.generic_picker(logger, (ResultSet)object2, (Result_Hash)object);
                            vector4.addElement(object);
                            continue;
                        }
                        finally {
                            try {
                                ((ResultSet)object2).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    object = object2;
                    if (object2 instanceof TIMESTAMP) {
                        object = new TZ_Timestamp(((TIMESTAMP)object2).timestampValue());
                    }
                    vector4.addElement(object);
                }
            }
            if (n != 0) {
                result_Hash.put_object("metadata", resultSetMetaData);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return result_Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result_Hash stored_procedure(Logger logger, DB_Statement dB_Statement) throws Exception, SQLException {
        Statement statement = null;
        Statement statement2 = null;
        Result_Hash result_Hash = new Result_Hash();
        int n = dB_Statement.get_type();
        Object[] objectArray = dB_Statement.get_values();
        try {
            int n2;
            if (logger.getLevel().intValue() <= Level.INFO.intValue()) {
                String string = this.logged_session_id() + " " + dB_Statement.toString();
                if (string.contains("NetDB_User.login")) {
                    logger.info(string);
                } else {
                    logger.fine(string);
                }
            }
            if (n == 2) {
                statement = this.con.prepareCall(dB_Statement.get_SQL(db_schema));
                statement2 = (CallableStatement)statement;
            } else {
                statement = this.con.prepareStatement(dB_Statement.get_SQL(db_schema));
            }
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new Exception("NetDB_Connection::callDB (...) values[" + i + "] (" + dB_Statement.get_parameter_name(i) + ") is null");
                }
                if (objectArray[i] instanceof OutParam) {
                    OutParam outParam = (OutParam)objectArray[i];
                    statement2.registerOutParameter(i + 1, outParam.get_type());
                    if (!outParam.has_initial_value()) continue;
                    this.set_parameter_value((PreparedStatement)statement, i + 1, outParam.initial_value());
                    continue;
                }
                this.set_parameter_value((PreparedStatement)statement, i + 1, objectArray[i]);
            }
            long l = NetDB_Connection.time();
            for (n2 = 0; n2 < 15; ++n2) {
                try {
                    statement.execute();
                    break;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != 8177) {
                        throw sQLException;
                    }
                    logger.finest(this.logged_session_id() + " ORA-08177. Attempting call again. (Attempt number:  " + n2 + ")");
                    continue;
                }
            }
            if (sql_timing.booleanValue()) {
                logger.info(this.logged_session_id() + " [" + dB_Statement.toString() + "] completed in " + (double)(NetDB_Connection.time() - l) / 1000.0 + " sec.");
            }
            if (n == 2) {
                try {
                    Object object = statement2.getObject(1);
                    ResultSet resultSet = null;
                    try {
                        resultSet = (ResultSet)statement2.getObject(1);
                        this.generic_picker(logger, resultSet, result_Hash);
                    }
                    catch (ClassCastException classCastException) {
                        result_Hash.put_object("return_value", object);
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    logger.finest(this.logged_session_id() + " Exception ignored while processing results: " + exception.getMessage());
                }
            }
            if (objectArray != null) {
                dB_Statement.last_out_param_found = -1;
                block43: for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (!(objectArray[n2] instanceof OutParam)) continue;
                    switch (((OutParam)objectArray[n2]).get_type()) {
                        case -6: 
                        case 2: 
                        case 4: {
                            objectArray[n2] = new Integer(statement2.getInt(n2 + 1));
                            continue block43;
                        }
                        case 12: {
                            objectArray[n2] = statement2.getString(n2 + 1);
                            continue block43;
                        }
                        case 93: {
                            objectArray[n2] = statement2.getTimestamp(n2 + 1);
                            continue block43;
                        }
                        case -7: {
                            objectArray[n2] = new Boolean(statement2.getBoolean(n2 + 1));
                            continue block43;
                        }
                        case -10: {
                            continue block43;
                        }
                        default: {
                            throw new Exception("Unsupported Out Parameter type.");
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            if (!this.sql_session_timeout(result_Hash, sQLException.getErrorCode())) {
                String string = "";
                SQLException sQLException2 = sQLException;
                do {
                    logger.finest(this.logged_session_id() + " SQLException encountered: " + sQLException2.getMessage().trim());
                    String string2 = sQLException2.getMessage().trim();
                    if (string2.startsWith("ORA")) {
                        string2 = string2.substring(string2.indexOf(":") + 2, string2.indexOf("\n"));
                    }
                    string = string + string2;
                } while ((sQLException2 = sQLException2.getNextException()) != null);
                throw new Exception(string);
            }
        }
        catch (Exception exception) {
            logger.finest(this.logged_session_id() + " Exception encountered:\n" + Exception_Formatter.stack_trace(exception));
            throw exception;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                statement2.close();
            }
            catch (Exception exception) {}
        }
        return result_Hash;
    }

    private void set_parameter_value(PreparedStatement preparedStatement, int n, Object object) throws Exception, SQLException {
        if (object instanceof Null) {
            preparedStatement.setNull(n, ((Null)object).getType());
        } else if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Boolean) {
            preparedStatement.setBoolean(n, (Boolean)object);
        } else if (object instanceof BigInteger) {
            preparedStatement.setString(n, ((BigInteger)object).toString());
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof TZ_Timestamp) {
            TimeZone timeZone = TimeZone.getTimeZone(((TZ_Timestamp)object).time_zone());
            Calendar calendar = Calendar.getInstance(timeZone);
            preparedStatement.setTimestamp(n, (Timestamp)object, calendar);
        } else {
            throw new Exception("Unsupported SQL type [" + object.getClass().getName() + "]");
        }
    }

    public void generic_picker(Logger logger, ResultSet resultSet, Result_Hash result_Hash) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1).trim();
        }
        Boolean bl2 = false;
        if (!(n == 7 && "TYPE".equals(stringArray[0]) && "KEY".equals(stringArray[1]) && "HASH_LEVEL".equals(stringArray[2]) && "VALUE_TYPE".equals(stringArray[3]) && "VALUE_STRING".equals(stringArray[4]) && "VALUE_TIMESTAMP".equals(stringArray[5]) && "VALUE_INT".equals(stringArray[6]))) {
            bl2 = true;
        }
        if (result_Hash.get("return_value") == null) {
            result_Hash.put_hash("return_value", new Result_Hash());
        }
        Vector<Result_Hash> vector = new Vector<Result_Hash>();
        Result_Hash result_Hash2 = result_Hash.get_hash("return_value");
        boolean bl3 = false;
        vector.addElement(result_Hash2);
        try {
            resultSet.setFetchSize(Property.fetch_as_Integer("database.fetch_size", "1000"));
        }
        catch (Exception exception) {
            logger.info("Failed to change fetch size: " + exception.getMessage());
        }
        while (resultSet != null && resultSet.next()) {
            String string;
            String string2 = resultSet.getString("TYPE");
            if ("data".equals(string2)) {
                string = resultSet.getString("KEY");
                int n2 = resultSet.getInt("HASH_LEVEL");
                if (n2 > -1) {
                    Result_Hash result_Hash3 = (Result_Hash)vector.elementAt(n2);
                    result_Hash2 = new Result_Hash();
                    result_Hash3.put_hash(string, result_Hash2);
                    if (vector.size() == n2 + 1) {
                        vector.addElement(result_Hash2);
                    } else {
                        vector.setElementAt(result_Hash2, n2 + 1);
                    }
                }
                if (!bl2.booleanValue()) continue;
                this.process_nonstandard_columns(stringArray, n, resultSet, result_Hash, result_Hash2, n2);
                continue;
            }
            if ("key".equals(string2)) {
                string = resultSet.getString("KEY");
                String string3 = resultSet.getString("VALUE_TYPE");
                if ("string".equals(string3)) {
                    if (resultSet.getString("VALUE_STRING") != null) {
                        result_Hash2.put_string(string, resultSet.getString("VALUE_STRING").trim());
                    }
                } else if ("integer".equals(string3)) {
                    if (resultSet.getString("VALUE_INT") != null) {
                        result_Hash2.put_integer(string, new Integer(resultSet.getInt("VALUE_INT")));
                    }
                } else if ("biginteger".equals(string3)) {
                    if (resultSet.getString("VALUE_INT") != null) {
                        result_Hash2.put_bigint(string, resultSet.getBigDecimal("VALUE_INT").toBigInteger());
                    }
                } else if ("boolean".equals(string3)) {
                    if (resultSet.getString("VALUE_INT") != null) {
                        if (resultSet.getInt("VALUE_INT") != 0) {
                            result_Hash2.put_boolean(string, Boolean.TRUE);
                        } else {
                            result_Hash2.put_boolean(string, Boolean.FALSE);
                        }
                    }
                } else if ("timestamp".equals(string3) && resultSet.getTimestamp("VALUE_TIMESTAMP") != null) {
                    result_Hash2.put_timestamp(string, resultSet.getTimestamp("VALUE_TIMESTAMP"));
                }
                if (!bl2.booleanValue()) continue;
                this.process_nonstandard_columns(stringArray, n, resultSet, result_Hash, result_Hash2, 0);
                continue;
            }
            logger.severe(this.logged_session_id() + " Unknown entry " + string2 + " in the \"TYPE\" column from the Generic Picker.");
        }
        resultSet.close();
    }

    private void process_nonstandard_columns(String[] stringArray, int n, ResultSet resultSet, Result_Hash result_Hash, Result_Hash result_Hash2, int n2) throws SQLException {
        for (int i = 0; i < n; ++i) {
            Object object;
            if ("TYPE".equals(stringArray[i]) || "KEY".equals(stringArray[i]) || "HASH_LEVEL".equals(stringArray[i]) || "VALUE_TYPE".equals(stringArray[i]) || "VALUE_STRING".equals(stringArray[i]) || "VALUE_TIMESTAMP".equals(stringArray[i]) || "VALUE_INT".equals(stringArray[i]) || (object = resultSet.getObject(i + 1)) == null) continue;
            if (object instanceof String) {
                object = ((String)object).trim();
            }
            Result_Hash result_Hash3 = result_Hash2;
            if (n2 == -1) {
                result_Hash3 = result_Hash;
            }
            if (object instanceof DATE) {
                result_Hash3.put_object(stringArray[i].trim().toLowerCase(), ((DATE)object).timestampValue());
                continue;
            }
            if (object instanceof TIMESTAMP) {
                result_Hash3.put_timestamp(stringArray[i].trim().toLowerCase(), ((TIMESTAMP)object).timestampValue());
                continue;
            }
            result_Hash3.put_object(stringArray[i].trim().toLowerCase(), object);
        }
    }

    private boolean sql_session_timeout(Result_Hash result_Hash, int n) throws Exception {
        if (n != 2399 && n != 2393) {
            return false;
        }
        throw new Exception("Your search has exceeded currently available resources.  The results may be incomplete.  Try again later or refine your search.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void start_rollback_timer(int n) {
        block3: {
            block2: {
                if (this.auto_rollback == null) break block2;
                if (this.auto_rollback == null) break block3;
                NetDB_Connection netDB_Connection = this;
                if (!netDB_Connection.auto_rollback.interrupted()) break block3;
            }
            this.auto_rollback = new Rollback_Delay(this, n);
            return;
        }
        this.auto_rollback.delay(n);
    }

    protected void cancel_rollback_timer() {
        if (this.auto_rollback != null) {
            this.auto_rollback.interrupt();
        }
    }

    private static long time() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar.getTime().getTime();
    }
}

