/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import stanford.netdb.exceptions.Idiot_Programmer;
import stanford.netdb.logging.Silent_Logger;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.util.Kerberos;
import stanford.netdb.util.Resource_Reader;

public class Handshake {
    public static final long serialVersionUID = 1L;
    private static Oid krb5Mechanism = null;
    private static String client_version = "";
    public String accepted_principal = "";
    private Boolean completed = false;

    public Boolean completed() {
        return this.completed;
    }

    public static MCP_i initiate(Kerberos kerberos, MCP_i mCP_i, Logger logger) throws Exception {
        Subject subject = kerberos.certify();
        String string = kerberos.certified_principal();
        string = string.substring(0, string.indexOf("@"));
        Handshake_Initiator handshake_Initiator = new Handshake_Initiator(mCP_i, logger);
        try {
            Subject.doAsPrivileged(subject, handshake_Initiator, null);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                throw new Exception(exception.getCause());
            }
            throw exception;
        }
        if (!string.equals(handshake_Initiator.mcp().operating_user_netid())) {
            throw new Idiot_Programmer("op_user is not authenticated user.  Please contact the NetDB team and inform them of this error.");
        }
        return handshake_Initiator.mcp;
    }

    public byte[] accept(Kerberos kerberos, byte[] byArray) throws Exception {
        Handshake_Acceptor handshake_Acceptor = new Handshake_Acceptor(byArray);
        Subject subject = kerberos.certify();
        try {
            Subject.doAsPrivileged(subject, handshake_Acceptor, null);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                throw new Exception(exception.getCause());
            }
            throw exception;
        }
        if (handshake_Acceptor.principal != null && !handshake_Acceptor.principal.equals("")) {
            this.accepted_principal = handshake_Acceptor.principal;
        }
        return handshake_Acceptor.ret_token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String client_version() throws Exception {
        String string = client_version;
        synchronized (string) {
            if (client_version == null || client_version.equals("")) {
                String string2 = System.getProperty("resource.client_version", "client_version");
                client_version = Resource_Reader.string_data(string2, true);
                client_version.replaceAll("\n", "");
            }
        }
        return client_version.trim();
    }

    static {
        try {
            krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
        }
        catch (Exception exception) {
            System.err.println("There was a problem creating the Kerberos 5 mechanism OID: " + exception.getMessage());
        }
    }

    private class Handshake_Acceptor
    implements PrivilegedExceptionAction<Handshake_Acceptor> {
        private byte[] token = null;
        public byte[] ret_token = null;
        public String principal = "";

        public Handshake_Acceptor(byte[] byArray) {
            this.token = byArray;
        }

        @Override
        public Handshake_Acceptor run() throws Exception {
            GSSManager gSSManager = null;
            GSSContext gSSContext = null;
            if (gSSManager == null) {
                gSSManager = GSSManager.getInstance();
            }
            if (gSSContext == null) {
                gSSContext = gSSManager.createContext((GSSCredential)null);
            }
            if (!gSSContext.isEstablished()) {
                this.ret_token = gSSContext.acceptSecContext(this.token, 0, this.token.length);
            }
            if (gSSContext.isEstablished()) {
                if (gSSContext.getMutualAuthState()) {
                    Handshake.this.completed = true;
                }
                this.principal = ((Object)gSSContext.getSrcName()).toString();
                gSSContext.dispose();
                gSSManager = null;
            }
            return null;
        }
    }

    private static class Handshake_Initiator
    implements PrivilegedExceptionAction<Handshake_Initiator> {
        public MCP_i mcp = null;
        public Logger logger = null;

        public Handshake_Initiator(MCP_i mCP_i, Logger logger) {
            this.mcp = mCP_i;
            this.logger = logger;
            if (this.logger == null) {
                this.logger = new Silent_Logger();
            }
        }

        public MCP_i mcp() {
            return this.mcp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Handshake_Initiator run() throws Exception {
            block13: {
                GSSManager gSSManager = null;
                GSSContext gSSContext = null;
                try {
                    Object object;
                    if (gSSContext == null) {
                        Object object2;
                        if (gSSManager == null) {
                            gSSManager = GSSManager.getInstance();
                        }
                        if ((object = System.getProperty("rmi.kerberos.principal")) == null || ((String)object).equals("")) {
                            object2 = System.getProperty("resource.rmi_kerberos_principal", "rmi_kerberos_principal");
                            object = Resource_Reader.string_data((String)object2);
                        }
                        object2 = gSSManager.createName((String)object, null);
                        gSSContext = gSSManager.createContext((GSSName)object2, krb5Mechanism, null, 0);
                    }
                    gSSContext.requestMutualAuth(true);
                    gSSContext.requestConf(true);
                    gSSContext.requestInteg(true);
                    object = new byte[0];
                    while (!gSSContext.isEstablished()) {
                        if ((object = (Object)gSSContext.initSecContext((byte[])object, 0, ((Object)object).length)) == null) continue;
                        object = this.mcp.handshake((byte[])object);
                    }
                    if (!gSSContext.getMutualAuthState()) break block13;
                    this.mcp.check_client_version(Handshake.client_version());
                    try {
                        this.mcp.is_current_version();
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        this.logger.severe(exception.getMessage());
                    }
                    this.mcp = this.mcp.authenticate(Handshake.client_version());
                }
                finally {
                    try {
                        gSSContext.dispose();
                        gSSContext = null;
                        gSSManager = null;
                    }
                    catch (Exception exception) {}
                }
            }
            return this;
        }
    }
}

