/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.field2sql.Field2SQL;
import stanford.netdb.field2sql.IPAddressSQLBuilder;
import stanford.netdb.field2sql.NetDBPostFilter;
import stanford.netdb.middleware.DB_Statement;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.ssparser.SSparser;
import stanford.netdb.util.Date_Formatter;

public abstract class Full_Search<T>
extends DB_Statement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String COLUMN_NAMES_KEY = "column_names";
    protected static final String RESULT_KEY = "resultSet";
    protected static final String MODIFIED_AT_COLUMN = "Date Modified";
    protected static final String MODIFIED_BY_COLUMN = "Modified By";
    protected static final String CREATED_AT_COLUMN = "Date Created";
    protected static final String CREATED_BY_COLUMN = "Created By";
    public static final String DONT_INCLUDE = "-1";
    protected Hashtable<String, Boolean> include_fields = new Hashtable();

    public Full_Search() {
        this.db_call_type = 1;
    }

    protected Vector perform_search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Vector vector = null;
        if (netDB_Datastore.is_remote().booleanValue()) {
            MCP_i mCP_i = (MCP_i)((Datastore)netDB_Datastore).open_remote_connection();
            vector = mCP_i.full_search().remote_search(this);
        } else {
            vector = new Vector();
            NetDB_Connection netDB_Connection = netDB_Datastore.open_direct_connection("Full_Search.perform_search", true);
            vector.add(netDB_Connection.execute(this.logger(), this));
            netDB_Connection.release();
        }
        return vector;
    }

    protected abstract Vector<T> process_results(NetDB_Datastore var1, Result_Hash var2) throws Exception;

    protected static String n2s(Object object) {
        if (object == null) {
            return "";
        }
        return (String)object;
    }

    protected static Hashtable nHash(Object object) {
        if (object == null) {
            return new Hashtable();
        }
        return (Hashtable)object;
    }

    protected String type(String string) {
        if (string.equals("txt") || string.equals("hws") || string.equals("b")) {
            return "String";
        }
        if (string.equals("num")) {
            return "Numeric";
        }
        if (string.equals("ips")) {
            return "IP";
        }
        if (string.equals("tst")) {
            return "Timestamp";
        }
        if (string.equals("ns")) {
            return "NoSortString";
        }
        if (string.equals("nn")) {
            return "NoSortNumber";
        }
        if (string.equals("ni")) {
            return "NoSortIP";
        }
        return string;
    }

    protected void assmDisplayOrder(Vector vector, Hashtable hashtable) {
        Object object;
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equals("displayOrder.Actions") || !((String)object).startsWith("displayOrder.")) continue;
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            Matcher matcher = Pattern.compile("^displayOrder\\.(txt|num|ip|hw|tst|b|ns|nn|ni)\\.(\\d+)\\.(.+)$").matcher((CharSequence)object);
            if (!matcher.matches() || matcher.group(3) == null) continue;
            String string = matcher.group(3).trim();
            String string2 = Full_Search.n2s(hashtable.get(object));
            hashtable3.put("type", this.type(matcher.group(1)));
            hashtable3.put("def_place", matcher.group(2));
            hashtable3.put("requested_place", string2);
            hashtable3.put("name", string);
            vector.addElement(hashtable3);
            if ((!string.equals("LowRes") && !string.equals("HighRes") || string2.equals(DONT_INCLUDE)) && !string.equals("AddressSpace")) continue;
            hashtable2.put(string, hashtable3);
        }
        if (hashtable2.get("AddressSpace") != null) {
            object = (Hashtable)hashtable2.get("AddressSpace");
            Full_Search.nHash(hashtable2.get("LowRes")).put("def_place", ((Hashtable)object).get("def_place"));
            Full_Search.nHash(hashtable2.get("LowRes")).put("requested_place", ((Hashtable)object).get("requested_place"));
            Full_Search.nHash(hashtable2.get("HighRes")).put("def_place", ((Hashtable)object).get("def_place"));
            Full_Search.nHash(hashtable2.get("HighRes")).put("requested_place", ((Hashtable)object).get("requested_place"));
        }
    }

    protected String assmCommonSQL(Hashtable hashtable) throws Exception {
        return this.assmCommonSQL(hashtable, null);
    }

    protected String assmCommonSQL(Hashtable hashtable, Vector<Exception> vector) throws Exception {
        String string;
        String string2 = "";
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4;
            String string5;
            string = (String)hashtable.get("fs.table");
            Object object = (String)enumeration.nextElement();
            Object object2 = object;
            if (((String)object2).contains("fs.FS_NodeType.cb.i")) {
                bl = true;
            }
            if (((String)object2).startsWith("fs.FS_NodeType.cb.i.not_")) {
                string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + " ( SELECT ID FROM FS_Node MINUS ( SELECT ID FROM FS_NodeType WHERE type = '" + ((String)object2).substring(24) + "' ) ) ";
                continue;
            }
            if (((String)object2).equals("txt.customFields") || ((String)object2).equals("txt.DHCPoptions") || ((String)object2).equals("txt.NetDHCPoptions") || ((String)object2).equals("txt.ASDHCPoptions") || ((String)object).endsWith(" error") || ((String)object2).equals("cb.i.Name:Node") || ((String)object2).equals("cb.i.Name:Alias") || ((String)object2).equals("cb.i.Name:Interface") || ((String)object2).equals("cb.i.Name:IP") || ((String)object2).equals("cb.i.Name:IPC")) continue;
            Matcher matcher = Pattern.compile("^fs\\.([^.]+)\\.(.*)$").matcher((CharSequence)object);
            if (matcher.matches() && matcher.group(2) != null) {
                string = matcher.group(1);
                object = matcher.group(2);
            }
            if ((matcher = Pattern.compile("^(txt|num|tst|ip|hw|ns)\\.(group.\\.)?(.*)").matcher((CharSequence)object)).matches()) {
                String string6;
                string5 = Full_Search.n2s(hashtable.get(object2)).trim();
                if (string5.length() == 0) continue;
                string4 = matcher.group(3);
                string3 = "";
                try {
                    string3 = Full_Search.parseField(hashtable, (String)object2, (String)object, string5, string, string4);
                }
                catch (Exception exception) {
                    if (vector == null) {
                        throw exception;
                    }
                    vector.add(exception);
                }
                if (((String)object2).equals("fs.FS_NameNode.txt.fullname_lc")) {
                    string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + " ( select node_id id from FS_NameNode where id in " + string3 + " and ";
                    string6 = "";
                    string6 = string6 + (hashtable.get("cb.i.Name:Node") == null ? "" : (string6.length() > 0 ? " or " : "") + hashtable.get("cb.i.Name:Node"));
                    string6 = string6 + (hashtable.get("cb.i.Name:Alias") == null ? "" : (string6.length() > 0 ? " or " : "") + hashtable.get("cb.i.Name:Alias"));
                    string6 = string6 + (hashtable.get("cb.i.Name:Interface") == null ? "" : (string6.length() > 0 ? " or " : "") + hashtable.get("cb.i.Name:Interface"));
                    string6 = string6 + (hashtable.get("cb.i.Name:IP") == null ? "" : (string6.length() > 0 ? " or " : "") + hashtable.get("cb.i.Name:IP"));
                    string6 = string6 + (hashtable.get("cb.i.Name:IPC") == null ? "" : (string6.length() > 0 ? " or " : "") + hashtable.get("cb.i.Name:IPC"));
                    string2 = string2 + " ( " + string6 + " ) ) ";
                } else if (matcher.group(2) != null) {
                    string6 = (String)hashtable2.get(matcher.group(2));
                    if (string6 == null) {
                        string6 = "";
                    }
                    string6 = string6 + (string6.length() > 0 ? " union " : "") + " ( " + string3 + " ) ";
                    hashtable2.put(matcher.group(2), string6);
                } else {
                    string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + string3;
                }
                bl = true;
                continue;
            }
            if (((String)object).startsWith("rb.")) {
                if (!((String)object).startsWith("rb.b.") || (string5 = Full_Search.n2s(hashtable.get(object2)).trim()).equals(DONT_INCLUDE)) continue;
                string4 = ((String)object).substring(5);
                string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + " ( SELECT ID FROM " + string + " WHERE " + string4 + " = " + string5 + " ) ";
                continue;
            }
            if (!((String)object).startsWith("cb.") || !((String)object).startsWith("cb.i.")) continue;
            string5 = null;
            string4 = Full_Search.n2s(hashtable.get(object2)).trim();
            if (string4.length() == 0) continue;
            if (((String)object).startsWith("cb.i.f")) {
                string5 = string4;
            }
            if ((matcher = Pattern.compile("^(group.\\.)(.+)$").matcher(string4)).matches()) {
                string3 = (String)hashtable2.get(matcher.group(1));
                if (string3 == null) {
                    string3 = "";
                }
                string3 = string3 + (string3.length() > 0 ? " union " : "") + (string5 == null ? " ( SELECT ID FROM " + string + " WHERE " + matcher.group(2) + " ) " : matcher.group(2));
                hashtable2.put(matcher.group(1), string3);
                continue;
            }
            string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + (string5 == null ? " ( SELECT ID FROM " + string + " WHERE " + string4 + " ) " : string4);
        }
        if (hashtable.get("tst.last_login >= ") != null && string2.trim().length() > 0) {
            bl = true;
        }
        if (!bl) {
            throw new Exception("Please enter some search criteria.");
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + (string2.equals("") ? "" : " INTERSECT ") + " ( " + hashtable2.get(enumeration.nextElement()) + " ) ";
        }
        if (vector != null && vector.size() > 0) {
            string = "";
            for (Exception exception : vector) {
                string = string + exception.getMessage() + "\n";
            }
            throw new Exception("The following errors were encountered:\n" + string);
        }
        return string2;
    }

    protected String modBlock(Hashtable hashtable) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (string5.matches("^displayOrder\\..*\\.Modified By$")) {
                string = string5;
                continue;
            }
            if (string5.matches("^displayOrder\\..*\\.Date Modified$")) {
                string2 = string5;
                continue;
            }
            if (string5.matches("^displayOrder\\..*\\.Created By$")) {
                string3 = string5;
                continue;
            }
            if (!string5.matches("^displayOrder\\..*\\.Date Created$")) continue;
            string4 = string5;
        }
        return (Full_Search.n2s(hashtable.get(string)).equals(DONT_INCLUDE) ? "" : ", mod_by_name || '(' || mod_by_netid || ')' \"Modified By\"") + (Full_Search.n2s(hashtable.get(string2)).equals(DONT_INCLUDE) ? "" : ", modified \"Date Modified\"") + (Full_Search.n2s(hashtable.get(string3)).equals(DONT_INCLUDE) ? "" : ", created_by_name || '(' || created_by_netid || ')' \"Created By\"") + (Full_Search.n2s(hashtable.get(string4)).equals(DONT_INCLUDE) ? "" : ", created \"Date Created\"");
    }

    private static String parseField(Hashtable hashtable, String string, String string2, String string3, String string4, String string5) throws Exception {
        if ((string3 = string3.trim()).length() == 0) {
            return "";
        }
        String string6 = null;
        if (string.equals("fs.FS_NameNode.txt.fullname_lc")) {
            string6 = "Name";
        } else if (string.equals("fs.FS_NodeMX.txt.fullname_lc")) {
            string6 = "Receives Mail for";
        } else if (string.equals("fs.FS_Node.txt.lower(state)")) {
            string6 = "State";
        } else if (string.equals("fs.FS_NodeIPaddress.ip.IPaddress")) {
            string6 = "IP Address";
        } else if (string.equals("fs.FS_NodeIPaddress.hw.lower(HW_address)")) {
            string6 = "Hardware Address";
        } else if (string.equals("txt.DHCPoptions")) {
            string6 = "DHCP Options";
        } else if (string.equals("fs.FS_Node.txt.groupZ.lower(owner)")) {
            string6 = "Group";
        } else if (string.equals("fs.FS_Node.txt.lower(department)")) {
            string6 = "Department";
        } else if (string.equals("fs.FS_Node.txt.lower(location)")) {
            string6 = "Location";
        } else if (string.equals("fs.FS_Node.txt.lower(site)")) {
            string6 = "Site";
        } else if (string.equals("fs.FS_Node.txt.lower(code)")) {
            string6 = "Code";
        } else if (string.equals("fs.FS_Node.txt.lower(room)")) {
            string6 = "Room";
        } else if (string.equals("fs.FS_Node.tst.expiration >= ") || string.equals("fs.FS_Node.tst.expiration <= ")) {
            string6 = "Expiration Date";
        } else if (string.equals("fs.FS_Node.txt.lower(make)") || string.equals("fs.FS_Node.txt.lower(model)")) {
            string6 = "Make & Model";
        } else if (string.equals("fs.FS_Node.txt.lower(os)")) {
            string6 = "OS";
        } else if (string.equals("fs.FS_Node_Admin.txt.groupA.lower(ateam)") || string.equals("fs.FS_Node_Admin.txt.groupA.lower(admin_name)") || string.equals("fs.FS_Node_Admin.txt.groupA.lower(admin_netid)")) {
            string6 = "Administrator";
        } else if (string.equals("fs.FS_Node_User.txt.groupU.lower(user_netid)") || string.equals("fs.FS_Node_User.txt.groupU.lower(user_name)")) {
            string6 = "Node User";
        } else if (string.equals("txt.customFields")) {
            string6 = "Custom Fields";
        } else if (string.equals("fs.FS_Node.txt.lower(comments)")) {
            string6 = "Comment";
        } else if ((string.equals("txt.lower(netid)") || string.equals("txt.lower(name)")) && hashtable.get("txt.NetDB.IP.text(starting_address)") != null) {
            string6 = "User";
        } else if (string.equals("tst.last_login >= ") || string.equals("tst.last_login <= ")) {
            string6 = "Last Login";
        } else if (string.equals("txt.lower(organization)")) {
            string6 = "Department";
        } else if (string.equals("txt.cons_name")) {
            string6 = "Networking Consultant";
        } else if (string.equals("txt.lower(owner)") && hashtable.get("txt.NetDB.IP.text(starting_address)") != null) {
            string6 = "Group";
        } else if (string.equals("txt.lower(comments)")) {
            string6 = "Comment";
        } else if (string.equals("txt.lower(phone)")) {
            string6 = "Phone";
        } else if (string.equals("txt.lower(email)")) {
            string6 = "Email";
        } else if (string.equals("txt.lower(def_domain)")) {
            string6 = "Default Domain";
        } else if (string.equals("txt.NetDB.IP.text(starting_address)")) {
            string6 = "Starting Address";
        } else if (string.equals("txt.lower(def_group)")) {
            string6 = "Default Group";
        } else if (string.equals("fs.FS_NameNetwork.txt.fullname_lc")) {
            string6 = "Name";
        } else if (string.equals("fs.FS_AddressSpace.ip.address")) {
            string6 = "Address Spaces";
        } else if (string.equals("fs.FS_NetworkInfo.txt.lower(dhcp_service)")) {
            string6 = "DHCP Service";
        } else if (string.equals("txt.NetDHCPoptions")) {
            string6 = "Network DHCP Options";
        } else if (string.equals("fs.FS_NetworkInfo.txt.lower(owner)")) {
            string6 = "Network Group";
        } else if (string.equals("fs.FS_NetworkInfo.txt.vlan")) {
            string6 = "VLAN";
        } else if (string.equals("fs.FS_NetworkInfo.txt.lower(comments)")) {
            string6 = "Network Comment";
        } else if (string.equals("txt.ASDHCPoptions")) {
            string6 = "Address Space DHCP Options";
        } else if (string.equals("fs.FS_AddressSpaceOwner.txt.lower(owner)")) {
            string6 = "Address Space Group";
        } else if (string.equals("fs.FS_AddressSpace.txt.lower(comments)")) {
            string6 = "Address Space Comment";
        } else if (string.equals("fs.FS_NetworkIPaddresses.ip.IPaddress")) {
            string6 = "Dynamic DHCP Address";
        } else if (string.equals("fs.FS_NetworkIPaddresses.txt.fullname_lc")) {
            string6 = "Dynamic DHCP Address Name";
        } else if (string.equals("txt.lower(name)") && hashtable.get("txt.lower(member_netid)") != null) {
            string6 = "Team Name";
        } else if (string.equals("txt.lower(owner)") && hashtable.get("txt.lower(member_netid)") != null) {
            string6 = "Group";
        } else if (string.equals("txt.lower(member_netid)") || string.equals("txt.lower(member_name)")) {
            string6 = "Member";
        } else if (string.equals("txt.lower(domain)")) {
            string6 = "Domain Name";
        } else if (string.equals("txt.lower(owner)") && hashtable.get("txt.lower(domain)") != null) {
            string6 = "Group";
        } else if (string.equals("tst.logdate <=") || string.equals("tst.logdate >=")) {
            string6 = "Date of Action";
        } else if (string.equals("txt.lower(record_name)")) {
            string6 = "Record Name";
        } else if (string.equals("num.record_id")) {
            string6 = "Record ID";
        } else if (string.equals("ip.IPaddress")) {
            string6 = "IP Address";
        } else if ((string.equals("txt.lower(netid)") || string.equals("txt.lower(name)")) && hashtable.get("txt.lower(record_name)") != null) {
            string6 = "User";
        } else if (string.equals("txt.lower(owner)")) {
            string6 = "Group Name";
        } else if (string.equals("txt.lower(nvl(comments,' '))")) {
            string6 = "Comment";
        } else if (string.equals("txt.groupM.lower(mod_by_netid)") || string.equals("txt.groupM.lower(mod_by_name)")) {
            string6 = "Modified by";
        } else if (string.equals("tst.modified <= ") || string.equals("tst.modified >= ")) {
            string6 = "Modified Date";
        } else if (string.equals("txt.groupC.lower(created_by_name)") || string.equals("txt.groupC.lower(created_by_netid)")) {
            string6 = "Created by";
        } else if (string.equals("tst.created <= ") || string.equals("tst.created >= ")) {
            string6 = "Created Date";
        }
        String string7 = " ( SELECT id FROM " + string4 + " WHERE ";
        if (string2.startsWith("txt.") || string2.startsWith("ns.")) {
            if (string2.equals("txt.lower(domain)") || string2.equals("txt.lower(fqdn)")) {
                return Field2SQL.parseField(Field2SQL.DOMAIN_NAME, string4, string5, string3.equals(".") ? ".." : string3, string6, new NetDBPostFilter());
            }
            if (string2.equals("txt.lower(record_name)") && (Full_Search.n2s(hashtable.get("rb.b.recordtype")).equals("'node'") || Full_Search.n2s(hashtable.get("rb.b.recordtype")).equals("'network'"))) {
                return Field2SQL.parseField(Field2SQL.LOG_NAME, string4, string5, string3.equals(".") ? ".." : string3, string6, new NetDBPostFilter());
            }
            if (string5.equals("lower(custom_field)") || string5.equals("lower(dhcp_option)")) {
                return Field2SQL.parseField(Field2SQL.STRING, string4, string5, string3, string6, new NetDBPostFilter(){

                    @Override
                    public String field_filter(String string, String string2, String string3, String string4) {
                        if (!string.equals("REGEXP_LIKE") && (NetDBPostFilter.column1_p.matcher(string3).matches() || NetDBPostFilter.column2_p.matcher(string3).matches())) {
                            string4 = string4.toLowerCase();
                        }
                        int n = string4.indexOf("=");
                        String string5 = string4;
                        if (n > -1) {
                            string5 = string4.substring(0, n).trim().replaceAll("#eql", "=");
                            String string6 = string4.substring(n + 1).trim().replaceAll("#eql", "=");
                            return string5 + "#eql" + string6;
                        }
                        return string5.replaceAll("#eql", "=");
                    }
                });
            }
            return Field2SQL.parseField(Field2SQL.STRING, string4, string5, string3, string6, new NetDBPostFilter());
        }
        if (string2.startsWith("hw.")) {
            new SSparser();
            Hashtable<String, String> hashtable2 = SSparser.parse(string3);
            if (hashtable2.get("hw") == null) {
                if (string3.matches("^[0123456789abcdefABCDEF*%?_\\.:-]+$")) {
                    return string7 + string5 + " like '" + string3.replace('*', '%').replace('?', '_').replaceAll("(\\.|:|-)", "").toLowerCase() + "' ) ";
                }
                throw new IllegalArgumentException("\"" + string3 + "\" is not a hardware address.");
            }
            return string7 + string5 + " = '" + hashtable2.get("hw") + "' ) ";
        }
        if (string2.startsWith("ip.")) {
            return Field2SQL.buildField(Field2SQL.STRING, string4, string5, string3, string6, new IPAddressSQLBuilder(string));
        }
        if (string2.startsWith("num.")) {
            return Field2SQL.parseIntField(string4, string5, string3, string6);
        }
        if (string2.startsWith("tst.")) {
            return string7 + string5 + "to_date('" + Date_Formatter.format("MM-dd-yyyy HH:mm:ss", string3) + "', 'mm-dd-yyyy hh24:mi:ss') ) ";
        }
        throw new Exception("Invalid field type in a name \"" + string2 + "\".");
    }

    protected static String parseStringForFullSearch(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception("Invalid string expression.");
        }
        String string3 = string.replace('*', '%').replace('?', '_');
        String string4 = string3.replaceAll("\\\\[%\\_]", "");
        if (string4.indexOf("%") > -1 || string4.indexOf("_") > -1) {
            return " ( " + string2 + " LIKE '" + string3.trim() + "' ESCAPE '\\') ";
        }
        return " ( " + string2 + " = '" + string.trim() + "' ) ";
    }

    protected static String parseIntegerForFullSearch(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception("Invalid numeric expression.");
        }
        return " ( " + string2 + " = " + string.trim() + " ) ";
    }

    protected static String parseTimestampForFullSearch(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception("Invalid date expression.");
        }
        if (string.trim().length() == 0) {
            return "";
        }
        String string3 = string.trim().replace('-', '/');
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setLenient(true);
        try {
            return " ( " + string2 + "to_date('" + new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format(dateFormat.parse(string3)) + "', 'mm-dd-yyyy hh24:mi:ss') ) ";
        }
        catch (Exception exception) {
            throw new Exception("Invalid date expression [" + string.trim() + "].");
        }
    }
}

