/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.User;
import stanford.netdb.exceptions.Action_Not_Permitted;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.middleware.Access_i;
import stanford.netdb.middleware.Address_Space_i;
import stanford.netdb.middleware.AdminTeam_i;
import stanford.netdb.middleware.DHCPoption_i;
import stanford.netdb.middleware.DHCPservice_i;
import stanford.netdb.middleware.Default_i;
import stanford.netdb.middleware.Domain_i;
import stanford.netdb.middleware.Handshake;
import stanford.netdb.middleware.IPaddress_i;
import stanford.netdb.middleware.InterfaceType_i;
import stanford.netdb.middleware.Interface_i;
import stanford.netdb.middleware.Location_i;
import stanford.netdb.middleware.Log_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.MXrecord_i;
import stanford.netdb.middleware.Make_i;
import stanford.netdb.middleware.ModelType_i;
import stanford.netdb.middleware.Model_i;
import stanford.netdb.middleware.Name_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.Network_i;
import stanford.netdb.middleware.NodeType_i;
import stanford.netdb.middleware.Node_i;
import stanford.netdb.middleware.OS_i;
import stanford.netdb.middleware.Organization_i;
import stanford.netdb.middleware.Owner_i;
import stanford.netdb.middleware.Person_i;
import stanford.netdb.middleware.Session_ID;
import stanford.netdb.middleware.State_i;
import stanford.netdb.middleware.User_i;
import stanford.netdb.util.Kerberos;
import stanford.netdb.util.Property;
import stanford.netdb.util.SRV_Record;

public class Datastore<T extends Datastore>
extends NetDB_Logger {
    private static final long serialVersionUID = 1L;
    private long srv_age = 162000L;
    private Timestamp srv_lookup = null;
    private String srv_record = null;
    private String passed_srv = null;
    private SRV_Record used_srv = null;
    private Vector<SRV_Record> srv_hosts = new Vector();
    private String host = null;
    private int port = 0;
    private String user_name = null;
    private String user_password = null;
    private String search_user_name = null;
    private String search_user_password = null;
    private String instance = null;
    private String schema = null;
    private String keytab = null;
    private String principal = null;
    private String krb5_conf = null;
    private String directory_connection = null;
    private Session_ID session_id = null;
    private Kerberos kerberos = null;
    protected User operating_user = null;
    private MCP_i mcp = null;
    private Hashtable<String, NetDB_Connection> active_transactions = new Hashtable();
    protected Boolean search_connection = false;
    private static Integer transaction_counter = 0;
    protected Integer transaction_id = 0;
    private static final Pattern expected_probe_error = Pattern.compile("Your client \\(.+\\) is not compatible with the RMI server.  Compatible versions: (.+)");

    public Datastore(String string) {
        this.passed_srv = string;
        this.srv_record(string);
    }

    public Datastore(String string, String string2) {
        this.passed_srv = string;
        this.srv_record(string);
        Kerberos.krb5_conf(string2);
    }

    public Datastore(String string, String string2, String string3) {
        this.passed_srv = string;
        this.srv_record(string);
        this.keytab(string2);
        this.principal(string3);
    }

    public Datastore(String string, String string2, String string3, String string4) {
        this.passed_srv = string;
        this.srv_record(string);
        this.keytab(string2);
        this.principal(string3);
        Kerberos.krb5_conf(string4);
    }

    public Datastore(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.host(string, n);
        this.user(string4, string5);
        this.search_user(string6, string7);
        this.instance(string2);
        this.schema(string3);
    }

    public Datastore(String string, int n) {
        this(string, n, "", "", "");
    }

    public Datastore(String string, int n, String string2) {
        this(string, n, "", "", string2);
    }

    public Datastore(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, "");
    }

    public Datastore(String string, int n, String string2, String string3, String string4) {
        this.host(string, n);
        this.keytab(string2);
        this.principal(string3);
        Kerberos.krb5_conf(string4);
    }

    public Datastore(Datastore datastore) {
        this.logger(datastore.logger);
        this.srv_record = datastore.srv_record;
        this.host = datastore.host;
        this.port = datastore.port;
        this.instance = datastore.instance;
        this.schema = datastore.schema;
        this.user_name = datastore.user_name;
        this.user_password = datastore.user_password;
        this.search_user_name = datastore.search_user_name;
        this.search_user_password = datastore.search_user_password;
        this.keytab = datastore.keytab;
        this.principal = datastore.principal;
        this.krb5_conf = datastore.krb5_conf;
        this.directory_connection = datastore.directory_connection;
        this.kerberos = datastore.kerberos;
        this.operating_user = datastore.operating_user;
        this.session_id = datastore.session_id;
    }

    public String srv_record() {
        return this.srv_record;
    }

    public Vector<SRV_Record> srv_hosts() {
        return (Vector)this.srv_hosts.clone();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String user_name() {
        return this.user_name;
    }

    public String user_password() {
        return this.user_password;
    }

    public String search_user_name() {
        return this.search_user_name;
    }

    public String search_user_password() {
        return this.search_user_password;
    }

    public String instance() {
        return this.instance;
    }

    public String schema() {
        return this.schema;
    }

    public String keytab() {
        return this.keytab;
    }

    public String principal() {
        return this.principal;
    }

    public String directory_connection() {
        return this.directory_connection;
    }

    public User operating_user() {
        return this.operating_user;
    }

    protected Integer operating_user_id() throws Exception {
        if (this.operating_user != null && this.operating_user.identity() != null) {
            return this.operating_user.id();
        }
        return null;
    }

    public String operating_user_netid() throws Exception {
        String string = "";
        string = this.operating_user == null ? this.read_user_netid() : this.operating_user.netid();
        return string;
    }

    public Session_ID session_id() {
        return this.session_id;
    }

    public TYPE connection_type() {
        if (!(this.user_name == null || this.user_name.equals("") || this.user_password == null || this.user_password.equals("") || this.search_user_name == null || this.search_user_name.equals("") || this.search_user_password == null || this.search_user_password.equals(""))) {
            return TYPE.DATABASE;
        }
        return TYPE.RMI;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(Boolean bl) {
        String string = "";
        string = this.srv_record != null && !this.srv_record.equals("") ? this.srv_record : this.host + ":" + this.port;
        if (bl.booleanValue()) {
            if (this.srv_record != null && !this.srv_record.equals("")) {
                string = "    " + this.host + ":" + this.port;
            }
            string = string + "    instance: " + this.instance + "    schema: " + this.schema + "    user: " + this.user_name();
        }
        return string;
    }

    protected T srv_record(String string) {
        if (string != null) {
            if (!(string = string.trim()).startsWith("_")) {
                String string2 = System.getProperty("rmi.srv_prefix", "_rmi._tcp.");
                if (!string2.endsWith(".")) {
                    string2 = string2 + ".";
                }
                string = string2 + string;
                this.logger.info("SRV record was expected to start with an underscore.  '" + string + "' will be used instead.");
            }
            this.srv_record = string;
        }
        return (T)this;
    }

    protected T host(String string) {
        if (string != null) {
            this.host = string.trim();
        }
        return (T)this;
    }

    protected T port(int n) {
        this.port = n;
        return (T)this;
    }

    protected T user_name(String string) {
        this.user_name = string;
        return (T)this;
    }

    protected T user_password(String string) {
        this.user_password = string;
        return (T)this;
    }

    protected T search_user_name(String string) {
        this.search_user_name = string;
        return (T)this;
    }

    protected T search_user_password(String string) {
        this.search_user_password = string;
        return (T)this;
    }

    protected T instance(String string) {
        this.instance = string;
        return (T)this;
    }

    protected T schema(String string) {
        this.schema = string;
        return (T)this;
    }

    protected T host(String string, int n) {
        this.host(string);
        this.port(n);
        return (T)this;
    }

    protected T user(String string, String string2) {
        this.user_name(string);
        this.user_password(string2);
        if (this.connection_type() == TYPE.RMI) {
            this.operating_user = null;
            this.mcp = null;
        }
        return (T)this;
    }

    protected T search_user(String string, String string2) {
        this.search_user_name(string);
        this.search_user_password(string2);
        if (this.connection_type() == TYPE.RMI) {
            this.operating_user = null;
            this.mcp = null;
        }
        return (T)this;
    }

    protected T directory_connection(String string) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        if (this.connection_type() == TYPE.RMI) {
            throw new Action_Not_Permitted("The directory cannot be set when using an RMI connection.");
        }
        this.directory_connection = string;
        return (T)this;
    }

    public T operating_user(String string) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        if (this.connection_type() == TYPE.RMI) {
            throw new Action_Not_Permitted("The operating user cannot be set when using an RMI connection.");
        }
        this.operating_user = User.load(new NetDB_Datastore(this), string);
        this.mcp = null;
        this.operating_user = null;
        return (T)this;
    }

    public T operating_user(User user) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        if (this.connection_type() == TYPE.RMI) {
            throw new Action_Not_Permitted("The operating user cannot be set when using an RMI connection.");
        }
        if (user != null) {
            if (user.is_partial().booleanValue()) {
                this.operating_user(user.netid());
            } else {
                this.operating_user = user;
            }
        }
        return (T)this;
    }

    public T keytab(String string) {
        this.keytab = string.trim();
        return (T)this;
    }

    public T principal(String string) {
        this.principal = string.trim();
        return (T)this;
    }

    public Boolean equals(Datastore datastore) {
        String string = "";
        String string2 = "";
        if (this.srv_record != null && !this.srv_record.equals("")) {
            string = this.srv_record;
        } else if (this.host != null) {
            string = this.host.toLowerCase() + ":" + this.port;
        }
        if (datastore != null) {
            if (datastore.srv_record != null && !datastore.srv_record.equals("")) {
                string2 = datastore.srv_record;
            } else if (datastore.host != null) {
                string2 = datastore.host.toLowerCase() + ":" + datastore.port;
            }
        }
        return string.equals(string2);
    }

    protected void session_id(Session_ID session_ID) {
        this.session_id = session_ID;
    }

    private synchronized Integer next_transaction_id() {
        if (transaction_counter < 0) {
            transaction_counter = 0;
        }
        Integer n = transaction_counter;
        Integer n2 = transaction_counter = Integer.valueOf(transaction_counter + 1);
        return n;
    }

    private String logged_session_id(NetDB_Connection netDB_Connection) {
        return netDB_Connection.logged_session_id();
    }

    protected String start_transaction(String string) throws Exception {
        return this.start_transaction(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String start_transaction(String string, Boolean bl) throws Exception {
        String string2 = "";
        if (this.connection_type() == TYPE.RMI) {
            if (Property.fetch_as_Boolean("rmi.debug_transactions", "false").booleanValue()) {
                System.out.println("Starting transaction '" + string + "'");
            }
            this.open_remote_connection();
        } else {
            this.transaction_id = this.next_transaction_id();
            string2 = string + "-" + this.transaction_id;
            if (Property.fetch_as_Boolean("rmi.debug_transactions", "false").booleanValue()) {
                System.out.println("Starting transaction '" + string2 + "'");
            }
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string2);
            }
            if (netDB_Connection == null) {
                netDB_Connection = this.open_direct_connection(string2, bl);
                hashtable = this.active_transactions;
                synchronized (hashtable) {
                    this.active_transactions.put(string2, netDB_Connection);
                }
            }
            if (netDB_Connection.transaction_id() == null) {
                netDB_Connection.transaction_id(this.transaction_id);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end_transaction(String string) throws Exception, SQLException {
        if (Property.fetch_as_Boolean("rmi.debug_transactions", "false").booleanValue()) {
            System.out.println("Ending transaction '" + string + "'");
        }
        if (this.connection_type() == TYPE.RMI) {
            if (this.mcp != null) {
                this.close_remote_connection();
            }
        } else {
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string);
            }
            if (netDB_Connection != null) {
                netDB_Connection.commit(this.logger());
                netDB_Connection.transaction_id(null);
            }
            this.close_direct_connection(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback_transaction(String string) throws Exception, SQLException {
        if (Property.fetch_as_Boolean("rmi.debug_transactions", "false").booleanValue()) {
            System.out.println("Rolling back transaction '" + string + "'");
        }
        if (this.connection_type() == TYPE.RMI) {
            if (this.mcp != null) {
                this.close_remote_connection();
            }
        } else {
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string);
            }
            if (netDB_Connection != null) {
                netDB_Connection.rollback(this.logger());
                netDB_Connection.transaction_id(null);
            }
            this.close_direct_connection(string);
        }
    }

    protected NetDB_Connection open_direct_connection(String string) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.open_direct_connection(string, false);
    }

    protected NetDB_Connection open_direct_connection(String string, Boolean bl) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (Property.fetch_as_Boolean("database.offline", "false").booleanValue()) {
            String string2 = System.getProperty("database.offline_reason");
            if (string2 == null || string2.equals("")) {
                string2 = "No reason specified.";
            }
            throw new Exception("Database is currently offline: " + string2);
        }
        String string3 = System.getProperty("database.type", "oracle");
        if ("oracle".equals(string3)) {
            return this.open_direct_oracle_connection(string, bl);
        }
        throw new Exception("Unknown database type '" + string3 + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetDB_Connection open_direct_oracle_connection(String string, Boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        NetDB_Connection netDB_Connection = null;
        Object object = this.active_transactions;
        synchronized (object) {
            netDB_Connection = this.active_transactions.get(string);
        }
        if (netDB_Connection != null && this.search_connection == bl) {
            return netDB_Connection;
        }
        this.search_connection = bl;
        Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
        object = this.user_name();
        String string2 = this.user_password();
        if (bl.booleanValue()) {
            object = this.search_user_name();
            string2 = this.search_user_password();
        }
        Properties properties = new Properties();
        properties.put("user", object);
        properties.put("password", string2);
        String string3 = String.format("jdbc:oracle:thin:@%s:%s:%s", this.host(), this.port(), this.instance);
        netDB_Connection = new NetDB_Connection(string3, properties);
        NetDB_Connection.db_schema(this.schema);
        netDB_Connection.session_id(this.session_id);
        return netDB_Connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close_direct_connection(String string) throws SQLException {
        NetDB_Connection netDB_Connection = null;
        Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
        synchronized (hashtable) {
            netDB_Connection = this.active_transactions.get(string);
        }
        if (netDB_Connection != null) {
            netDB_Connection.release();
            hashtable = this.active_transactions;
            synchronized (hashtable) {
                this.active_transactions.remove(string);
            }
        }
    }

    private Kerberos kerberos(String string, String string2) throws Exception {
        if (this.kerberos == null) {
            this.kerberos = new Kerberos();
            if (string != null && string2 != null) {
                this.kerberos.keytab(string).principal(string2);
            }
        }
        return this.kerberos;
    }

    protected String read_user_netid() throws Exception {
        Kerberos kerberos = this.kerberos(this.keytab, this.principal);
        kerberos.certify();
        return Kerberos.clean_principal(kerberos.certified_principal(), "/root", null);
    }

    protected MCP_i remote_authenticate(MCP_i mCP_i) throws Exception {
        MCP_i mCP_i2 = Handshake.initiate(this.kerberos(this.keytab, this.principal), mCP_i, this.logger());
        return mCP_i2;
    }

    public String probe() throws Exception {
        return this.probe(false);
    }

    /*
     * WARNING - void declaration
     */
    public String probe(Boolean bl) throws Exception {
        void var8_21;
        void var8_18;
        int n;
        void var8_12;
        String string;
        int n2 = 8;
        int n3 = 0;
        int n4 = 32;
        this.srv_resolve();
        Vector<String> vector = new Vector<String>();
        Boolean bl2 = false;
        if (this.srv_hosts.size() == 0) {
            bl2 = true;
            this.srv_hosts.add(new SRV_Record(0, 0, this.port, this.host));
        }
        for (SRV_Record object2 : this.srv_hosts) {
            string = object2.host() + ":" + object2.port();
            if (string.length() <= n3) continue;
            n3 = string.length();
        }
        n3 += 2;
        Object object3 = "  ";
        if (!bl2.booleanValue()) {
            object3 = (String)object3 + "%" + n2 + "s  ";
        }
        object3 = (String)object3 + "%" + n3 + "s  ";
        String string2 = "  ";
        string = "priority";
        String string3 = "server:port";
        String string4 = "version/status";
        if (!bl2.booleanValue()) {
            String string5 = String.format((String)object3, string, string3);
        } else {
            String string6 = String.format((String)object3, string3);
        }
        String string7 = (String)var8_12 + string4 + "\n  ";
        if (!bl2.booleanValue()) {
            void var8_14;
            for (n = 0; n < n2; ++n) {
                String string8 = (String)var8_14 + "-";
            }
            String string9 = (String)var8_14 + "  ";
        }
        for (n = 0; n < n3; ++n) {
            String string10 = (String)var8_18 + "-";
        }
        String string11 = (String)var8_18 + "  ";
        for (n = 0; n < n4; ++n) {
            String string12 = (String)var8_21 + "-";
        }
        String string13 = (String)var8_21 + "\n";
        if (bl.booleanValue()) {
            System.out.print(string13);
        }
        for (SRV_Record sRV_Record : this.srv_hosts) {
            String string14 = "";
            string14 = bl2 == false ? String.format((String)object3, sRV_Record.priority(), sRV_Record.host() + ":" + sRV_Record.port()) : String.format((String)object3, sRV_Record.host() + ":" + sRV_Record.port());
            MCP_i mCP_i = null;
            try {
                mCP_i = this.naming_lookup(sRV_Record.host(), sRV_Record.port());
                string14 = mCP_i != null ? string14 + mCP_i.server_version() : string14 + "MCP was null.  Server is up, and the port is open, but not responding as expected.";
            }
            catch (Exception exception) {
                String string15;
                block23: {
                    string15 = exception.getMessage();
                    if (string15.contains("Connection refused")) {
                        string15 = "Connection refused.";
                    } else if (string15.contains("method not supported by remote object")) {
                        try {
                            if (mCP_i != null) {
                                mCP_i.check_client_version("incompatible client version");
                            } else {
                                string15 = "Unable to determine server version (server is incompatible)";
                            }
                        }
                        catch (Exception exception2) {
                            string15 = exception2.getMessage();
                            Matcher matcher = expected_probe_error.matcher(string15);
                            if (!matcher.matches() || matcher.groupCount() <= 0) break block23;
                            string15 = matcher.group(1);
                        }
                    }
                }
                string14 = string14 + string15;
            }
            if (bl.booleanValue()) {
                System.out.println(string14);
            }
            vector.add(string14);
        }
        if (bl2.booleanValue()) {
            this.srv_hosts = new Vector();
        }
        Object object = string13;
        for (String string14 : vector) {
            object = (String)object + string14 + "\n";
        }
        return object;
    }

    protected void srv_resolve() throws Exception {
        if (this.srv_record == null || this.srv_record.equals("")) {
            return;
        }
        long l = new Date().getTime();
        if (this.srv_lookup == null || l - this.srv_lookup.getTime() > this.srv_age) {
            this.srv_hosts = new Vector();
            InitialDirContext initialDirContext = new InitialDirContext();
            Attributes attributes = initialDirContext.getAttributes("dns:/" + this.srv_record, new String[]{"SRV"});
            Attribute attribute = attributes.get("SRV");
            for (int i = 0; i < attribute.size(); ++i) {
                this.srv_hosts.add(new SRV_Record((String)attribute.get(i)));
            }
            Collections.sort(this.srv_hosts, new SRV_Record());
            this.srv_lookup = new Timestamp(l);
        }
    }

    protected void srv_select() throws Exception {
        String string = "";
        if (this.used_srv != null) {
            string = this.used_srv.toString();
        }
        String string2 = "";
        for (SRV_Record sRV_Record : this.srv_hosts) {
            if (sRV_Record.toString().equals(string)) continue;
            try {
                MCP_i mCP_i = this.naming_lookup(sRV_Record.host(), sRV_Record.port());
                if (mCP_i == null) continue;
                mCP_i.check_client_version(Handshake.client_version());
                this.host(sRV_Record.host());
                this.port(sRV_Record.port());
                this.used_srv = sRV_Record;
                break;
            }
            catch (Exception exception) {
                String string3 = sRV_Record.host();
                if (string3.endsWith(".")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string4 = "  " + string3 + ":" + sRV_Record.port() + " reported error:\n    " + exception.getMessage() + "\n";
                string2 = string2 + string4;
                this.logger.warning(string4);
            }
        }
        if (this.host == null && this.port == 0) {
            throw new Exception("Could not connect to NetDB service " + this.passed_srv + ".\n  " + string2.trim());
        }
    }

    private MCP_i naming_lookup() throws Exception {
        return this.naming_lookup(this.host(), this.port());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MCP_i naming_lookup(String string, Integer n) throws Exception {
        if (string == null) {
            string = "";
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, (int)n);
        Socket socket = new Socket();
        boolean bl = false;
        int n2 = 0;
        int n3 = Property.fetch_as_int("rmi.server.discovery.max_tries", "3");
        int n4 = Property.fetch_as_int("rmi.server.discovery.timeout", "500");
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            bl = true;
        }
        while (!bl && n2 < n3) {
            try {
                socket.connect(inetSocketAddress, n4);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            ++n2;
            n4 += n4;
        }
        if (bl) {
            Registry registry = LocateRegistry.getRegistry(string, n);
            if (registry != null) {
                MCP_i mCP_i = (MCP_i)registry.lookup("MCP");
                return mCP_i.spawn();
            }
        } else {
            throw new Exception("Host not reachable.");
        }
        return null;
    }

    protected Remote open_remote_connection() throws Exception, NotBoundException, MalformedURLException, RemoteException {
        if (this.mcp == null) {
            this.srv_resolve();
            this.srv_select();
            this.mcp = this.naming_lookup();
            this.mcp = this.remote_authenticate(this.mcp);
        } else {
            try {
                this.naming_lookup();
            }
            catch (Exception exception) {
                this.mcp = null;
                this.open_remote_connection();
            }
        }
        return this.mcp;
    }

    protected void close_remote_connection() {
    }

    protected void terminate_remote_connection(String string) {
        try {
            this.rollback_transaction(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mcp = null;
    }

    public static void defined_or_die(Datastore datastore) throws No_Datastore_Defined {
        if (datastore == null) {
            throw new No_Datastore_Defined("No NetDB datastore defined.");
        }
    }

    public Access_i remote_access() throws Exception {
        this.open_remote_connection();
        return this.mcp.access();
    }

    public Address_Space_i remote_address_space() throws Exception {
        this.open_remote_connection();
        return this.mcp.ip_address_space();
    }

    public AdminTeam_i remote_admin_team() throws Exception {
        this.open_remote_connection();
        return this.mcp.admin_team();
    }

    public Default_i remote_default() throws Exception {
        this.open_remote_connection();
        return this.mcp.global_default();
    }

    public DHCPoption_i remote_dhcp_option() throws Exception {
        this.open_remote_connection();
        return this.mcp.dhcp_option();
    }

    public DHCPservice_i remote_dhcp_service() throws Exception {
        this.open_remote_connection();
        return this.mcp.dhcp_service();
    }

    public Domain_i remote_domain() throws Exception {
        this.open_remote_connection();
        return this.mcp.domain();
    }

    public IPaddress_i remote_ip_address() throws Exception {
        this.open_remote_connection();
        return this.mcp.ip_address();
    }

    public Interface_i remote_interface() throws Exception {
        this.open_remote_connection();
        return this.mcp.iface();
    }

    public InterfaceType_i remote_interface_type() throws Exception {
        this.open_remote_connection();
        return this.mcp.interface_type();
    }

    public Location_i remote_location() throws Exception {
        this.open_remote_connection();
        return this.mcp.location();
    }

    public Log_i remote_log() throws Exception {
        this.open_remote_connection();
        return this.mcp.log();
    }

    public MXrecord_i remote_mx_record() throws Exception {
        this.open_remote_connection();
        return this.mcp.mx_record();
    }

    public Make_i remote_make() throws Exception {
        this.open_remote_connection();
        return this.mcp.make();
    }

    public Model_i remote_model() throws Exception {
        this.open_remote_connection();
        return this.mcp.model();
    }

    public ModelType_i remote_model_type() throws Exception {
        this.open_remote_connection();
        return this.mcp.model_type();
    }

    public Name_i remote_name() throws Exception {
        this.open_remote_connection();
        return this.mcp.name();
    }

    public Network_i remote_network() throws Exception {
        this.open_remote_connection();
        return this.mcp.network();
    }

    public Node_i remote_node() throws Exception {
        this.open_remote_connection();
        return this.mcp.node();
    }

    public NodeType_i remote_node_type() throws Exception {
        this.open_remote_connection();
        return this.mcp.node_type();
    }

    public OS_i remote_os() throws Exception {
        this.open_remote_connection();
        return this.mcp.os();
    }

    public Organization_i remote_organization() throws Exception {
        this.open_remote_connection();
        return this.mcp.organization();
    }

    public Owner_i remote_owner() throws Exception {
        this.open_remote_connection();
        return this.mcp.owner();
    }

    public Person_i remote_person() throws Exception {
        this.open_remote_connection();
        return this.mcp.person();
    }

    public State_i remote_state() throws Exception {
        this.open_remote_connection();
        return this.mcp.state();
    }

    public User_i remote_user() throws Exception {
        this.open_remote_connection();
        return this.mcp.user();
    }

    public static enum TYPE {
        DATABASE,
        RMI;

    }
}

