/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.middleware.Null;
import stanford.netdb.middleware.OutParam;

public abstract class DB_Statement
extends NetDB_Logger
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Object ref_cursor = new OutParam(-10);
    protected int last_out_param_found = -1;
    protected Object[] values = null;
    protected String[] parameter_name = null;
    public static final int SELECT = 1;
    public static final int ORA_FUN_CALL = 2;
    public static final int ORA_PROC_CALL = 3;
    protected int db_call_type = 0;

    protected abstract String get_SQL(String var1) throws Exception;

    public int get_type() {
        return this.db_call_type;
    }

    public Object[] get_values() {
        return this.values;
    }

    public String get_parameter_name(int n) {
        return this.parameter_name[n];
    }

    public Object get_first_out_param() {
        this.last_out_param_found = this.db_call_type == 2 ? 0 : -1;
        return this.get_next_out_param();
    }

    public Object get_next_out_param() {
        if (this.last_out_param_found == -1) {
            this.get_first_out_param();
        }
        for (int i = this.last_out_param_found + 1; i < this.values.length; ++i) {
            if (!(this.values[i] instanceof OutParam)) continue;
            this.last_out_param_found = i;
            return this.values[i];
        }
        return null;
    }

    public String toString() {
        String string = "";
        try {
            string = this.get_SQL(null);
            if (this.values == null) {
                this.values = new Object[0];
            }
            for (int i = 0; i < this.values.length; ++i) {
                Object object = this.values[i];
                if (object instanceof String) {
                    object = "'" + this.values[i] + "'";
                } else if (object instanceof Null) {
                    object = "Null";
                } else if (object == null) {
                    object = "null";
                }
                string = string.replaceFirst("\\?", object.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected String proc_call_sql(String string, String string2) {
        return this.proc_call_sql(string, string2, this.values.length);
    }

    protected String proc_call_sql(String string, String string2, int n) {
        int n2;
        if (string != null) {
            if (string.length() > 0 && !string.endsWith("\\.")) {
                string = string + ".";
            }
        } else {
            string = "";
        }
        int n3 = n;
        int n4 = 0;
        String string3 = "{call ";
        if (this.db_call_type != 3) {
            string3 = string3 + "? := ";
            if (((OutParam)this.values[0]).get_true_type() == 16) {
                string2 = "Util.to_int (" + string2;
            }
            --n3;
            n4 = 1;
        }
        if (n3 > 0) {
            string2 = string2 + " (";
        }
        string3 = string3 + string2;
        for (n2 = 0; n2 < n3; ++n2) {
            string3 = string3 + this.parameter_name[n2 + n4] + " => ";
            string3 = this.values[n2 + n4] instanceof Boolean ? string3 + "Util.to_boolean (?)" : string3 + "?";
            if (n2 + 1 >= n3) continue;
            string3 = string3 + ", ";
        }
        string2 = string2.replaceAll("\\$\\(SCHEMA\\)", "");
        n2 = 0;
        while ((n2 = string2.indexOf(40, n2)) != -1) {
            string3 = string3 + ")";
            ++n2;
        }
        string3 = string3.replaceAll("\\$\\(SCHEMA\\)\\.", "\\$\\(SCHEMA\\)");
        string3 = string3.replaceAll("\\$\\(SCHEMA\\)", string);
        return string3 + "}";
    }

    protected static void print_raw_data(Hashtable hashtable) throws SQLException {
        int n;
        Vector vector = (Vector)hashtable.get("data");
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)hashtable.get("meta_data");
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            System.out.print("<" + resultSetMetaData.getColumnName(n) + "> ");
        }
        System.out.println("");
        for (n = 0; n < vector.size(); ++n) {
            Vector vector2 = (Vector)vector.elementAt(n);
            for (int i = 0; i < vector2.size(); ++i) {
                System.out.print("[" + vector2.elementAt(i).toString().trim() + "] ");
            }
            System.out.println("");
        }
    }
}

