/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.field2sql;

import antlr.CommonAST;
import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.field2sql.FieldPostFilter;
import stanford.netdb.field2sql.FieldTreeParser;
import stanford.netdb.field2sql.NetDBPostFilter;
import stanford.netdb.field2sql.PostFilter;
import stanford.netdb.field2sql.StringsLexer;
import stanford.netdb.field2sql.StringsParser;

public class Field2SQL {
    public static int NUMERIC = 0;
    public static int STRING = 1;
    public static int DOMAIN_NAME = 2;
    public static int LOG_NAME = 3;
    private String field_display_name;
    private String table;
    private String column;
    private String str;
    private int type;
    private Object post_filter;
    private FieldPostFilter expr_builder;

    private Field2SQL(int n, String string, String string2, String string3, String string4, Object object, FieldPostFilter fieldPostFilter) {
        this.type = n;
        this.table = string;
        this.column = string2;
        this.str = Field2SQL.escape(string3) + ";";
        this.field_display_name = string4;
        this.post_filter = object;
        this.expr_builder = fieldPostFilter;
    }

    protected static String escape(String string) {
        return string.replaceAll("&", "&amp").replaceAll(";", "&semicolon").replaceAll("\\\\\\\\", "&dbl").replaceAll("\\\\/", "&v");
    }

    protected static String unescape(String string) {
        return Field2SQL.unescape(string, false);
    }

    protected static String unescape(String string, boolean bl) {
        return string.replaceAll("&v", bl ? "\\\\/" : "/").replaceAll("&dbl", "\\\\\\\\").replaceAll("&semicolon", ";").replaceAll("&amp", "&");
    }

    public static String buildField(int n, String string, String string2, String string3, String string4, FieldPostFilter fieldPostFilter) throws Exception {
        return new Field2SQL(n, string, string2, string3, string4, new FieldPostFilter(), fieldPostFilter).doParse();
    }

    public static String parseField(int n, String string, String string2, String string3, String string4, Object object) throws Exception {
        if (!(object instanceof FieldPostFilter) && !(object instanceof PostFilter)) {
            throw new Exception("post_filter must be instance of either PostFilter or FieldPostFilter.");
        }
        return new Field2SQL(n, string, string2, string3, string4, object, null).doParse();
    }

    public static String parseField(int n, String string, String string2, String string3, String string4) throws Exception {
        return new Field2SQL(n, string, string2, string3, string4, new FieldPostFilter(), null).doParse();
    }

    public static String parseStringField(String string, String string2, String string3, String string4) throws Exception {
        return new Field2SQL(STRING, string, string2, string3, string4, new FieldPostFilter(), null).doParse();
    }

    public static String parseIntField(String string, String string2, String string3, String string4) throws Exception {
        return new Field2SQL(NUMERIC, string, string2, string3, string4, new FieldPostFilter(), null).doParse();
    }

    private String doParse() throws Exception {
        try {
            StringsLexer stringsLexer = new StringsLexer(new StringReader(this.str));
            if (this.type == NUMERIC) {
                stringsLexer.match_numbers = true;
            }
            StringsParser stringsParser = new StringsParser(stringsLexer);
            stringsParser.expr();
            CommonAST commonAST = (CommonAST)stringsParser.getAST();
            FieldTreeParser fieldTreeParser = new FieldTreeParser();
            fieldTreeParser.table = this.table;
            fieldTreeParser.column = this.column;
            fieldTreeParser.post_filter = this.post_filter;
            fieldTreeParser.expression_builder = this.expr_builder;
            if (this.type == NUMERIC) {
                fieldTreeParser.match_numbers = true;
            } else if (this.type == DOMAIN_NAME || this.type == LOG_NAME) {
                fieldTreeParser.domain_name = true;
                if (this.type == LOG_NAME) {
                    fieldTreeParser.log_name = true;
                }
            }
            return fieldTreeParser.expr((AST)commonAST);
        }
        catch (Exception exception) {
            this.str = Field2SQL.unescape(this.str, true);
            String string = exception.getMessage();
            if (this.expr_builder != null && string != null && string.trim().length() > 0) {
                throw new Exception("In \"" + this.field_display_name + "\" field " + string.trim());
            }
            if (this.field_display_name != null) {
                throw new Exception("\"" + this.field_display_name + "\" field \"" + this.str.substring(0, this.str.length() - 1) + "\" is not a valid " + (this.type == NUMERIC ? "numeric" : "string") + " field.");
            }
            throw new Exception("Invalid " + (this.type == NUMERIC ? "numeric" : "string") + " field \"" + this.str.substring(0, this.str.length() - 1) + "\".");
        }
    }

    public static void main(String[] stringArray) {
        block56: {
            String string = "name";
            String string2 = "Record";
            boolean bl = false;
            try {
                String string3;
                if (stringArray.length == 0) {
                    String string4;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    int n = STRING;
                    System.out.print("NetDB Field Parser. Type 'help' for list of commands.\nCurrent settings are:\n");
                    Field2SQL.show_settings(n, bl, string2, string);
                    System.out.print(">>> ");
                    while ((string4 = bufferedReader.readLine()) != null) {
                        if ((string4 = string4.trim()).equals("exit") || string4.equals("quit")) {
                            return;
                        }
                        if (string4.equals("help")) {
                            Field2SQL.help(n, bl, string2, string);
                        } else if (string4.equals("netdb_filter")) {
                            if (bl) {
                                bl = false;
                                System.out.println("Stanford NetDB specific filter is inactive.\n");
                            } else {
                                bl = true;
                                System.out.println("Stanford NetDB specific filter is active.\n");
                            }
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.equals("numeric")) {
                            n = NUMERIC;
                            System.out.println("Type set to numeric.\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.equals("domain")) {
                            n = DOMAIN_NAME;
                            bl = true;
                            System.out.println("Type set to domain.\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.equals("log")) {
                            n = LOG_NAME;
                            bl = true;
                            System.out.println("Type set to log.\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.equals("string")) {
                            n = STRING;
                            System.out.println("Type set to string.\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.matches("column\\s*=\\s*\\S+\\s*$")) {
                            string = string4.substring(string4.indexOf("=") + 1).trim();
                            System.out.println("Column name set to \"" + string + "\".\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else if (string4.matches("table\\s*=\\s*\\S+\\s*$")) {
                            string2 = string4.substring(string4.indexOf("=") + 1).trim();
                            System.out.println("Table name set to \"" + string2 + "\".\n");
                            Field2SQL.show_settings(n, bl, string2, string);
                        } else {
                            try {
                                if (n == STRING || n == DOMAIN_NAME || n == LOG_NAME) {
                                    if (bl) {
                                        System.out.println(Field2SQL.parseField(n, string2, string, string4, null, new NetDBPostFilter()));
                                    } else {
                                        System.out.println(Field2SQL.parseStringField(string2, string, string4, null));
                                    }
                                } else {
                                    System.out.println(Field2SQL.parseIntField(string2, string, string4, null));
                                }
                            }
                            catch (Exception exception) {
                                System.out.println("ERROR: " + exception.getMessage());
                            }
                        }
                        System.out.print(">>> ");
                    }
                    break block56;
                }
                if (!stringArray[0].equals("test")) break block56;
                System.out.println("Regression test for Field2SQL parser.");
                int n = 0;
                try {
                    if (stringArray[1].equals("-v")) {
                        n = 1;
                    } else if (stringArray[1].equals("-vv")) {
                        n = 2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader("Field2SQL.java"));
                boolean bl2 = false;
                int n2 = 1;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).equals("BEGIN REGRESSION TEST DATA")) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl2 || string3.equals("")) continue;
                    if (string3.equals("END REGRESSION TEST DATA")) {
                        return;
                    }
                    Matcher matcher = Pattern.compile("^(\\S+)\\s+;(.*);.*;(.*);.*$").matcher(string3);
                    if (!matcher.matches() || matcher.groupCount() != 3) {
                        System.out.println("ERROR: Invalid test case [" + string3 + "]");
                        continue;
                    }
                    String string5 = matcher.group(1);
                    String string6 = matcher.group(2);
                    String string7 = matcher.group(3);
                    if (!string5.equals("COLUMN")) {
                        if (n > 0) {
                            System.out.print(Field2SQL.pad("\"" + string6 + "\"", 75) + " ");
                        } else {
                            System.out.print(Field2SQL.pad("" + n2++, 5));
                        }
                    }
                    String string8 = "";
                    try {
                        if (string5.equals("COLUMN")) {
                            string = string6;
                        } else if (string5.equals("STRING")) {
                            string8 = Field2SQL.parseStringField(string2, string, string6, null).trim();
                        } else if (string5.equals("NETDB")) {
                            string8 = Field2SQL.parseField(STRING, string2, string, string6, null, new NetDBPostFilter()).trim();
                        } else if (string5.equals("NUMERIC")) {
                            string8 = Field2SQL.parseIntField(string2, string, string6, null).trim();
                        } else {
                            System.out.println("ERROR: Invalid test type [" + string5 + "]");
                        }
                        if (string5.equals("COLUMN")) continue;
                        if (string7.equals("ERROR")) {
                            System.out.println("Failed. Expected ERROR.");
                            continue;
                        }
                        if (string7.equals(string8)) {
                            System.out.println("Ok.");
                            if (n != 2) continue;
                            System.out.println("\tResult \"" + string8 + "\"\n");
                            continue;
                        }
                        System.out.println("Failed.\nTest [" + string6 + "]\nExpected [" + string7 + "].\nFound    [" + string8 + "]\n");
                        if (n == 2) {
                            System.out.println("\tExpected \"" + string8 + "\"");
                        }
                        if (n == 1) {
                            System.out.println("\tGot      \"" + string8 + "\"");
                        }
                        if (n != 2) continue;
                        System.out.println("");
                    }
                    catch (Exception exception) {
                        if (string7.equals("ERROR")) {
                            System.out.println("Ok.");
                            if (n != 2) continue;
                            System.out.println("\tResult \"ERROR\"\n");
                            continue;
                        }
                        System.out.println("Failed. Expected success.");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String pad(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        int n2 = n - string.length();
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.concat(new String(cArray));
    }

    private static void help(int n, boolean bl, String string, String string2) {
        Field2SQL.help(n, bl, string, string2, false);
    }

    private static void show_settings(int n, boolean bl, String string, String string2) {
        Field2SQL.help(n, bl, string, string2, true);
    }

    private static void help(int n, boolean bl, String string, String string2, boolean bl2) {
        System.out.println((bl2 ? "" : "Commands:\nhelp               - to see this help.\n") + "netdb_filter" + (bl ? " (on)" : "     ") + "  - toggle Stanford NetDB specific filter.\n" + "numeric" + (n == NUMERIC ? " (on)" : "     ") + "       - sets field type to numeric.\n" + "domain" + (n == DOMAIN_NAME ? " (on)" : "     ") + "        - sets field type to domain ( Stanford NetDB specific ).\n" + "log" + (n == LOG_NAME ? " (on)" : "     ") + "           - sets field type to log ( Stanford NetDB specific ).\n" + "string" + (n == STRING ? " (on)" : "     ") + "        - sets field type to string.\n" + "table=<name>       - to set table to a given name. Current value is \"" + string + "\"\n" + "column=<name>      - to set column to a given name. Current value is \"" + string2 + "\"\n" + (bl2 ? "" : "(quit|exit)        - to quit program."));
    }
}

