/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.directory;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import stanford.netdb.directory.Directory;
import stanford.netdb.directory.Directory_Record;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.exceptions.Too_Many_Records;
import stanford.netdb.logging.NetDB_Logger;

public class LDAP
extends Configuration
implements Directory {
    private static final long serialVersionUID = 1L;
    private static final String CONTEXT_NAME = "LDAP";
    private static final String DN = "cn=People,dc=Stanford,dc=edu";
    private static String lock = "";
    private LoginContext context = null;
    private Exception saved_ex = null;
    private String url = System.getProperty("directory.url", "");
    private String keytab = System.getProperty("directory.kerberos.keytab", "");
    private String principal = System.getProperty("directory.kerberos.principal", "");

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("directory.url");
        String string2 = System.getProperty("directory.kerberos.keytab");
        String string3 = System.getProperty("directory.kerberos.principal");
        if (string == null) {
            throw new Insufficient_Information("The property 'directory.url' has not been set.");
        }
        if (string2 == null) {
            throw new Insufficient_Information("The property 'directory.kerberos.keytab' has not been set.");
        }
        if (string3 == null) {
            throw new Insufficient_Information("The property 'directory.kerberos.principal' has not been set.");
        }
        try {
            if (stringArray.length < 2) {
                System.out.println("Usage: $ LDAP (-n NetID|-r RegID|-l Lookup)");
            } else {
                LDAP lDAP = new LDAP();
                lDAP.init();
                if ("-n".equals(stringArray[0])) {
                    System.out.println(lDAP.lookup_by_UID(stringArray[1]));
                } else if ("-r".equals(stringArray[0])) {
                    System.out.println(lDAP.lookup_by_key(stringArray[1]));
                } else if ("-l".equals(stringArray[0])) {
                    System.out.println(lDAP.lookup_by_name(stringArray[1]));
                } else {
                    System.out.println("Usage: $ LDAP (-n NetID|-r RegID|-l Lookup)");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Boolean init() {
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        try {
            this.context = this.generate_context();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean connect(String string) {
        return true;
    }

    @Override
    public Boolean disconnect() {
        return true;
    }

    @Override
    public Vector<Directory_Record> lookup_by_name(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.NAME);
    }

    @Override
    public Vector<Directory_Record> lookup_by_key(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.KEY);
    }

    @Override
    public Vector<Directory_Record> lookup_by_UID(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.UID);
    }

    @Override
    public Directory_Record lookup_exact(String string) throws Exception, Record_Not_Found, Too_Many_Records {
        Vector<Directory_Record> vector = this.lookup(string, Directory.SEARCH_TYPE.KEY);
        if (vector == null && vector.size() == 0) {
            throw new Record_Not_Found("'" + string + "' was not found in the directory.");
        }
        if (vector.size() > 1) {
            throw new Too_Many_Records("'" + string + "' matched more than one entry in the directory.");
        }
        return vector.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Directory_Record> lookup(String string, Directory.SEARCH_TYPE sEARCH_TYPE) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Serializable serializable2;
        String string2 = null;
        string = string.trim();
        if (sEARCH_TYPE == Directory.SEARCH_TYPE.UID) {
            string2 = "(|(suSUNetID=" + string + ")(uid=" + string + "))";
        } else if (sEARCH_TYPE == Directory.SEARCH_TYPE.KEY) {
            string2 = "(suRegID=" + string + ")";
        } else if (sEARCH_TYPE == Directory.SEARCH_TYPE.NAME) {
            string2 = this.make_lookup_filter(string);
        }
        Object object4 = lock;
        synchronized (object4) {
            if (this.context == null) {
                this.relogin("LoginContext is null");
            }
            if ((serializable2 = this.context.getSubject()) == null) {
                this.relogin("Subject is null");
            }
            serializable2 = this.context.getSubject();
            object3 = ((Subject)serializable2).getPrivateCredentials();
            serializable = null;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof KerberosTicket)) continue;
                serializable = (KerberosTicket)object;
                break;
            }
            if (((Date)(object = ((KerberosTicket)serializable).getEndTime())).before(new Date())) {
                this.relogin("Ticked expired");
            }
        }
        object4 = Subject.doAs(this.context.getSubject(), new JndiSearchAction(string2));
        serializable2 = new Vector();
        try {
            while (object4 != null && object4.hasMore()) {
                object3 = new Directory_Record();
                serializable = (SearchResult)object4.next();
                object2 = ((SearchResult)serializable).getAttributes();
                ((Directory_Record)object3).name(this.attribute_value(object2.get("displayName")));
                ((Directory_Record)object3).reg_id(this.attribute_value(object2.get("suRegID")));
                ((Directory_Record)object3).phone(this.attribute_value(object2.get("telephoneNumber")));
                ((Directory_Record)object3).email(this.attribute_value(object2.get("mail")));
                ((Directory_Record)object3).net_id(this.attribute_value(object2.get("uid")));
                ((Directory_Record)object3).department(this.attribute_value(object2.get("ou")));
                object = this.attribute_value(object2.get("sn"));
                ((Directory_Record)object3).last_name(((String)object).substring(0, 1).toUpperCase().concat(((String)object).substring(1)));
                Attribute attribute = object2.get("suPrivilegeGroup");
                if (attribute != null && (attribute.contains("stanford:stanford") || attribute.contains("stanford:administrative"))) {
                    ((Directory_Record)object3).active(true);
                } else {
                    ((Directory_Record)object3).active(false);
                }
                Attribute attribute2 = object2.get("suVisibIdentity");
                if (attribute2 != null && (attribute2.contains("world") || attribute2.contains("stanford"))) {
                    ((Directory_Record)object3).directory_id(this.attribute_value(object2.get("suUniqueIdentifier")));
                }
                if (((Directory_Record)object3).reg_id() == null) continue;
                ((Vector)serializable2).add(object3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializable2;
    }

    private String make_lookup_filter(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = string;
        if (string4.indexOf("(") != -1 || string4.indexOf(")") != -1) {
            return "";
        }
        if (string4.indexOf(",") != -1) {
            string4 = string4.substring(string4.indexOf(",") + 1, string4.length()) + " " + string4.substring(0, string4.indexOf(","));
        }
        if ((string4 = string4.trim()).indexOf(" ") != -1) {
            string2 = string4.substring(0, string4.indexOf(" "));
            string3 = string4.substring(string4.indexOf(" "), string4.length()).trim();
            return "(|(&(sn=" + string3 + ")(gn=" + string2 + "))" + "(displayName=" + string2 + " " + string3 + ")" + "(suOtherName=" + string2 + " " + string3 + "))";
        }
        return "(|(uid=" + string4 + ")(suSUNetID=" + string4 + ")(suGeneralID=" + string4 + ")(sn=" + string4 + "))";
    }

    private void relogin(String string) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.context = this.generate_context();
                this.context.login();
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
    }

    private String attribute_value(Attribute attribute) throws NamingException {
        String string = "";
        if (attribute != null) {
            string = (String)attribute.get();
        }
        return string;
    }

    private LoginContext generate_context() throws Exception {
        return new LoginContext(CONTEXT_NAME, null, new TextCallbackHandler(), this);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (string == null || !string.equals(CONTEXT_NAME)) {
            return null;
        }
        String string2 = "com.sun.security.auth.module.Krb5LoginModule";
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("debug", "false");
        hashtable.put("doNotPrompt", "true");
        hashtable.put("useTicketCache", "true");
        hashtable.put("useKeyTab", "true");
        hashtable.put("storeKey", "false");
        hashtable.put("keyTab", System.getProperty("directory.kerberos.keytab"));
        hashtable.put("principal", System.getProperty("directory.kerberos.principal"));
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[]{new AppConfigurationEntry(string2, loginModuleControlFlag, hashtable)};
        return appConfigurationEntryArray;
    }

    private class JndiSearchAction
    implements PrivilegedExceptionAction<NamingEnumeration> {
        private String filter;

        public JndiSearchAction(String string) {
            this.filter = string;
        }

        @Override
        public NamingEnumeration run() throws Exception {
            return this.performJndiOperation();
        }

        private synchronized NamingEnumeration performJndiOperation() throws Exception {
            NamingEnumeration<SearchResult> namingEnumeration = null;
            Context context = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    hashtable.put("java.naming.provider.url", this.convert_hostname_to_address(LDAP.this.url));
                    hashtable.put("java.naming.security.authentication", "GSSAPI");
                    hashtable.put("javax.security.sasl.qop", "auth-conf");
                    NetDB_Logger.default_logger().finer("dir search = [" + this.filter + "]");
                    context = new InitialDirContext(hashtable);
                    namingEnumeration = context.search(LDAP.DN, this.filter, new SearchControls());
                    context.close();
                    continue;
                }
                catch (NamingException namingException) {
                    NetDB_Logger.default_logger().finer(namingException.toString());
                    throw namingException;
                }
                finally {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return namingEnumeration;
        }

        private String convert_hostname_to_address(String string) {
            Matcher matcher = Pattern.compile("(^.*://)(.*)(:.*)").matcher(string);
            if (!matcher.matches()) {
                return string;
            }
            try {
                return matcher.group(1) + InetAddress.getByName(matcher.group(2)).getHostAddress() + matcher.group(3);
            }
            catch (Exception exception) {
                return string;
            }
        }
    }
}

