/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.directory;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.directory.Directory;
import stanford.netdb.directory.Directory_Record;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.exceptions.Too_Many_Records;

public class Flat_File
implements Directory {
    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("directory.file");
        if (string == null) {
            throw new Insufficient_Information("The property 'directory.file' has not been set.");
        }
        try {
            if (stringArray.length < 2) {
                System.out.println("Usage: Flat_File (-n NetID|-r RegID|-l Lookup)");
            } else {
                Flat_File flat_File = new Flat_File();
                flat_File.init();
                if ("-n".equals(stringArray[0])) {
                    System.out.println(flat_File.lookup_by_UID(stringArray[1]));
                } else if ("-r".equals(stringArray[0])) {
                    System.out.println(flat_File.lookup_by_key(stringArray[1]));
                } else if ("-l".equals(stringArray[0])) {
                    System.out.println(flat_File.lookup_by_name(stringArray[1]));
                } else {
                    System.out.println("Usage: Flat_File (-n NetID|-r RegID|-l Lookup)");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Boolean init() throws Exception {
        return true;
    }

    @Override
    public Boolean connect(String string) throws Exception {
        return true;
    }

    @Override
    public Boolean disconnect() throws Exception {
        return true;
    }

    @Override
    public Vector<Directory_Record> lookup_by_name(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.NAME);
    }

    @Override
    public Vector<Directory_Record> lookup_by_key(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.KEY);
    }

    @Override
    public Vector<Directory_Record> lookup_by_UID(String string) throws Exception {
        return this.lookup(string, Directory.SEARCH_TYPE.UID);
    }

    @Override
    public Directory_Record lookup_exact(String string) throws Exception, Record_Not_Found, Too_Many_Records {
        Vector<Directory_Record> vector = this.lookup(string, Directory.SEARCH_TYPE.KEY);
        if (vector == null && vector.size() == 0) {
            throw new Record_Not_Found("'" + string + "' was not found in the directory.");
        }
        if (vector.size() > 1) {
            throw new Too_Many_Records("'" + string + "' matched more than one entry in the directory.");
        }
        return vector.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Directory_Record> lookup(String string, Directory.SEARCH_TYPE sEARCH_TYPE) throws Exception {
        Vector<Directory_Record> vector = new Vector<Directory_Record>();
        BufferedReader bufferedReader = null;
        try {
            Pattern pattern = Pattern.compile("^(\\S+):(.*)$");
            Directory_Record directory_Record = new Directory_Record();
            Boolean bl = false;
            String string2 = null;
            bufferedReader = new BufferedReader(new FileReader(System.getProperty("directory.file")));
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if ("begin".equals(string2 = string2.trim())) {
                    bl = true;
                    continue;
                }
                if (!bl.booleanValue()) continue;
                if ("person".equals(string2)) {
                    if (this.match(directory_Record, string, sEARCH_TYPE).booleanValue()) {
                        vector.add(directory_Record);
                        if (sEARCH_TYPE == Directory.SEARCH_TYPE.KEY || sEARCH_TYPE == Directory.SEARCH_TYPE.UID) {
                            object = vector;
                            return object;
                        }
                    }
                    directory_Record = new Directory_Record();
                    continue;
                }
                if ("end".equals(string2)) {
                    if (this.match(directory_Record, string, sEARCH_TYPE).booleanValue()) {
                        vector.add(directory_Record);
                    }
                    bl = false;
                    break;
                }
                object = pattern.matcher(string2);
                if (!((Matcher)object).matches()) continue;
                String string3 = ((Matcher)object).group(1);
                directory_Record.set(string3, ((Matcher)object).group(2).trim());
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    private Boolean match(Directory_Record directory_Record, String string, Directory.SEARCH_TYPE sEARCH_TYPE) {
        if (sEARCH_TYPE == Directory.SEARCH_TYPE.KEY && directory_Record.reg_id().equals(string) || sEARCH_TYPE == Directory.SEARCH_TYPE.UID && directory_Record.net_id().equals(string) || sEARCH_TYPE == Directory.SEARCH_TYPE.NAME && directory_Record.name().toLowerCase().matches("^.*" + string.trim().toLowerCase() + ".*$")) {
            return true;
        }
        return false;
    }
}

