/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Department;
import stanford.netdb.Domain;
import stanford.netdb.Domain_Name;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User_FS_Parameters;
import stanford.netdb.User_SS_Result;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;

public final class User
extends Lockable<User> {
    public static String template_name = "templates/toString/user.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private Person person = null;
    private Domain default_domain = null;
    private Group default_group = null;
    private IPaddress starting_address = null;
    private Boolean active = null;
    private Boolean all_groups = null;
    private Boolean all_records = null;
    private String comment = null;
    private Timestamp last_login = null;
    private Multi_Value_Attribute<Privilege> privileges = null;
    private Multi_Value_Attribute<Department> departments = null;

    public User() {
        this.init();
    }

    public User(Person person, Boolean bl, Domain domain) {
        this.init(person, domain, bl, this.all_groups, this.all_records);
    }

    public User(Person person, Boolean bl, Domain domain, Group group, IPaddress iPaddress, Boolean bl2, Boolean bl3, String string) {
        this.init(person, domain, group, iPaddress, bl, bl2, bl3, string);
    }

    public User(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public User(NetDB_Datastore netDB_Datastore, Person person, Boolean bl, Domain domain) {
        super(netDB_Datastore);
        this.init(person, domain, bl, this.all_groups, this.all_records);
    }

    public User(NetDB_Datastore netDB_Datastore, Person person, Boolean bl, Domain domain, Group group, IPaddress iPaddress, Boolean bl2, Boolean bl3, String string) {
        super(netDB_Datastore);
        this.init(person, domain, group, iPaddress, bl, bl2, bl3, string);
    }

    protected User(NetDB_Datastore netDB_Datastore, int n) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        super(netDB_Datastore);
        this.id = new Integer(n);
        this.person = new Person(netDB_Datastore);
        this.person.id(n);
        this.person.load_object("", "");
        this.flag_as_system_created();
    }

    protected User(NetDB_Datastore netDB_Datastore, Integer n, String string) {
        super(netDB_Datastore);
        if (n != null && n >= 0) {
            this.id = (int)n;
        }
        Person person = new Person(netDB_Datastore);
        person.netid(string);
        person.flag_as_system_created();
        this.identity(person);
        this.flag_as_system_created();
    }

    private void init() {
        this.init(null, null, null, null, null, null, null, null);
    }

    private void init(Person person, Domain domain, Boolean bl, Boolean bl2, Boolean bl3) {
        this.init(person, domain, null, null, bl, bl2, bl3, null);
    }

    private void init(Person person, Domain domain, Group group, IPaddress iPaddress, Boolean bl, Boolean bl2, Boolean bl3, String string) {
        if (person != null) {
            this.identity(person);
        }
        if (domain != null) {
            this.default_domain(domain);
        }
        if (group != null) {
            this.default_group(group);
        }
        if (iPaddress != null) {
            this.starting_address(iPaddress);
        }
        if (bl != null) {
            this.active(bl);
        }
        if (bl2 != null) {
            this.all_groups(bl2);
        }
        if (bl3 != null) {
            this.all_records(bl3);
        }
        if (string != null) {
            this.comment(string);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "User.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public Person identity() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.person, NetDB.unset_person, "User.identity");
        return this.person;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.person, NetDB.unset_person, "User.name");
        return this.person.name();
    }

    public String netID() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.netid();
    }

    public String netid() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.person, NetDB.unset_person, "User.netid");
        return this.person.netid();
    }

    public Domain default_domain() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.default_domain, NetDB.unset_domain, "User.default_domain");
        return this.default_domain;
    }

    public Group default_group() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.default_group, NetDB.unset_group, "User.default_group");
        return this.default_group;
    }

    public IPaddress starting_address() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.starting_address, NetDB.unset_address, "User.starting_address");
        return this.starting_address;
    }

    public Boolean active() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.active, NetDB.unset_boolean, "User.active");
        return this.active;
    }

    public Boolean all_groups() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.all_groups, NetDB.unset_boolean, "User.all_groups");
        return this.all_groups;
    }

    public Boolean all_records() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.all_records, NetDB.unset_boolean, "User.all_records");
        return this.all_records;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "User.comment");
        return this.comment;
    }

    public Timestamp last_login() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.last_login, NetDB.unset_timestamp, "User.last_login");
        return this.last_login;
    }

    public Collection<Privilege> privileges() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.privileges, NetDB.unset_mva_privilege, "User.privileges");
        if (this.privileges == null || this.privileges == NetDB.unset_mva_privilege) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.privileges.all_values();
    }

    public Collection<Department> departments() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.departments, NetDB.unset_mva_department, "User.departments");
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.departments.all_values();
    }

    @Override
    public String handle() throws Exception {
        if (this.person == null && this.id != NetDB.unset_integer && User.autocomplete().booleanValue()) {
            NetDB_Datastore.defined_or_die(this.datastore);
            String string = null;
            if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
                try {
                    string = this.datastore.remote_user().handle(this.id);
                }
                catch (Exception exception) {
                    throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
                }
                finally {
                    this.datastore.close_remote_connection();
                }
            } else {
                string = User._handle(this.datastore, this.id);
            }
            this.person = new Person(this.datastore);
            this.person.id(this.id);
            this.person.netid(string);
            this.person.flag_as_system_created();
        }
        return this.netid();
    }

    @Override
    protected User id(Integer n) {
        this.id = n;
        return this;
    }

    public User identity(Person person) {
        this.person = person;
        return this;
    }

    public User default_domain(Domain domain) {
        this.default_domain = domain;
        return this;
    }

    public User default_group(Group group) {
        this.default_group = group;
        return this;
    }

    public User starting_address(IPaddress iPaddress) {
        this.starting_address = iPaddress;
        return this;
    }

    public User active(Boolean bl) {
        this.active = bl;
        return this;
    }

    protected User last_login(Timestamp timestamp) {
        this.last_login = timestamp;
        return this;
    }

    public User all_groups(Boolean bl) {
        this.all_groups = bl;
        return this;
    }

    public User all_records(Boolean bl) {
        this.all_records = bl;
        return this;
    }

    public User comment(String string) {
        this.comment = string;
        return this;
    }

    public User grant_privilege(Privilege privilege) {
        if (this.privileges == null || this.privileges == NetDB.unset_mva_privilege) {
            this.privileges = new Multi_Value_Attribute();
        }
        this.privileges.add(privilege);
        return this;
    }

    public User grant_privileges(Collection<Privilege> collection) {
        Iterator<Privilege> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.grant_privilege(iterator.next());
        }
        return this;
    }

    public User revoke_privilege(Privilege privilege) {
        if (this.privileges != null) {
            this.privileges.remove(privilege, (Boolean)true);
        }
        return this;
    }

    public User revoke_privileges(Collection<Privilege> collection) {
        Iterator<Privilege> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.revoke_privilege(iterator.next());
        }
        return this;
    }

    public User add_department(Department department) {
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            this.departments = new Multi_Value_Attribute();
        }
        this.departments.add(department);
        return this;
    }

    public User add_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_department(iterator.next());
        }
        return this;
    }

    public User remove_department(Department department) {
        if (this.departments != null) {
            this.departments.remove(department, (Boolean)true);
        }
        return this;
    }

    public User remove_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_department(iterator.next());
        }
        return this;
    }

    @Override
    public User bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.privileges, netDB_Datastore);
        this.bind_children(this.departments, netDB_Datastore);
        return this;
    }

    @Override
    public User unbind() {
        super.unbind();
        this.unbind_children(this.privileges);
        this.unbind_children(this.departments);
        return this;
    }

    @Override
    public User unlink() {
        super.unlink();
        this.unlink_children(this.privileges);
        this.unlink_children(this.departments);
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        User user = null;
        if (!(netDB instanceof User)) {
            return;
        }
        user = (User)netDB;
        this.id = user.id;
        this.person = user.person;
        this.default_domain = user.default_domain;
        this.default_group = user.default_group;
        this.starting_address = user.starting_address;
        this.active = user.active;
        this.all_groups = user.all_groups;
        this.all_records = user.all_records;
        this.comment = user.comment;
        this.last_login = user.last_login;
        if (this.privileges != NetDB.unset_mva_privilege) {
            for (Privilege record : this.privileges()) {
                record.deep_update(netDB_Datastore, user.privileges());
            }
        }
        if (this.departments != NetDB.unset_mva_department) {
            for (Department department : this.departments()) {
                department.deep_update(netDB_Datastore, user.departments());
            }
        }
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (this.person != null) {
            string = this.person.single_value_attributes();
        }
        if (this.default_domain != null) {
            string2 = this.default_domain.single_value_attributes();
        }
        if (this.default_group != null) {
            string3 = this.default_group.single_value_attributes();
        }
        if (this.starting_address != null) {
            string4 = this.starting_address.toString();
        }
        return string + " " + string2 + " " + string3 + " " + string4 + " " + this.active + " " + this.all_groups + " " + this.all_records + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.person == null) {
            this.person = NetDB.unset_person;
        }
        if (this.default_domain == null) {
            this.default_domain = NetDB.unset_domain;
        }
        if (this.default_group == null) {
            this.default_group = NetDB.unset_group;
        }
        if (this.starting_address == null) {
            this.starting_address = NetDB.unset_address;
        }
        if (this.active == null) {
            this.active = NetDB.unset_boolean;
        }
        if (this.all_groups == null) {
            this.all_groups = NetDB.unset_boolean;
        }
        if (this.all_records == null) {
            this.all_records = NetDB.unset_boolean;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.last_login == null) {
            this.last_login = NetDB.unset_timestamp;
        }
        if (this.privileges == null) {
            this.privileges = NetDB.unset_mva_privilege;
        }
        if (this.departments == null) {
            this.departments = NetDB.unset_mva_department;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.IDENTITY) {
            if (this.person == NetDB.unset_person) {
                this.person = null;
            }
        } else if (field == Field.DEFAULT_DOMAIN) {
            if (this.default_domain == NetDB.unset_domain) {
                this.default_domain = null;
            }
        } else if (field == Field.DEFAULT_GROUP) {
            if (this.default_group == NetDB.unset_group) {
                this.default_group = null;
            }
        } else if (field == Field.STARTING_ADDRESS) {
            if (this.starting_address == NetDB.unset_address) {
                this.starting_address = null;
            }
        } else if (field == Field.ACTIVE) {
            if (this.active == NetDB.unset_boolean) {
                this.active = null;
            }
        } else if (field == Field.ALL_GROUPS) {
            if (this.all_groups == NetDB.unset_boolean) {
                this.all_groups = null;
            }
        } else if (field == Field.ALL_RECORDS) {
            if (this.all_records == NetDB.unset_boolean) {
                this.all_records = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.LAST_LOGIN) {
            if (this.last_login == NetDB.unset_timestamp) {
                this.last_login = null;
            }
        } else if (field == Field.PRIVILEGE) {
            if (this.privileges == NetDB.unset_mva_privilege) {
                this.privileges = null;
            }
        } else if (field == Field.DEPARTMENT && this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (this.person == NetDB.unset_person) {
            this.person = null;
        }
        if (this.default_domain == NetDB.unset_domain) {
            this.default_domain = null;
        }
        if (this.default_group == NetDB.unset_group) {
            this.default_group = null;
        }
        if (this.starting_address == NetDB.unset_address) {
            this.starting_address = null;
        }
        if (this.active == NetDB.unset_boolean) {
            this.active = null;
        }
        if (this.all_groups == NetDB.unset_boolean) {
            this.all_groups = null;
        }
        if (this.all_records == NetDB.unset_boolean) {
            this.all_records = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.last_login == NetDB.unset_timestamp) {
            this.last_login = null;
        }
        if (this.privileges == NetDB.unset_mva_privilege) {
            this.privileges = null;
        }
        if (this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "user", this, bl);
    }

    protected static User extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        User user = new User(netDB_Datastore);
        user.flag_as_system_created();
        user.extract(hashtable);
        return user;
    }

    @Override
    protected User extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        if (hashtable == null) {
            return this;
        }
        this.groups = new Multi_Value_Attribute();
        this.privileges = new Multi_Value_Attribute();
        this.departments = new Multi_Value_Attribute();
        super.extract(hashtable);
        try {
            object4 = (String)hashtable.get("default_addr_space");
            if (object4 == null) {
                object4 = (String)hashtable.get("starting_address");
            }
            if (object4 != null && ((String)object4).length() > 0) {
                if (((String)object4).contains("/")) {
                    serializable = new Prefix((String)object4);
                    this.starting_address = ((Prefix)serializable).address();
                } else {
                    this.starting_address = new IPaddress((String)object4);
                }
            }
        }
        catch (Exception exception) {
            this.logger().fine(Exception_Formatter.stack_trace(exception));
        }
        hashtable.remove("default_addr_space");
        hashtable.remove("starting_address");
        this.person = Person.extract(this.datastore, hashtable);
        this.id = this.person.id();
        this.active = (Boolean)hashtable.get("active?");
        hashtable.remove("active?");
        this.all_groups = (Boolean)hashtable.get("all_groups?");
        hashtable.remove("all_groups?");
        this.all_records = (Boolean)hashtable.get("all_objects?");
        hashtable.remove("all_objects?");
        if (hashtable.containsKey("last_login")) {
            this.last_login = (Timestamp)hashtable.get("last_login");
            hashtable.remove("last_login");
        }
        if (hashtable.containsKey("comment")) {
            this.comment = (String)hashtable.get("comment");
            hashtable.remove("comment");
        }
        if (hashtable.containsKey("default_domain")) {
            object4 = new Domain_Name(this.datastore, (String)hashtable.get("default_domain"));
            this.default_domain = new Domain(this.datastore, (Domain_Name)object4);
            this.default_domain.flag_as_system_created();
            hashtable.remove("default_domain");
        }
        object4 = (String)hashtable.get("default_group");
        hashtable.remove("default_group");
        serializable = (Hashtable)hashtable.get("groups");
        if (serializable != null) {
            object3 = ((Hashtable)serializable).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = new Group(this.datastore, (String)object2);
                ((NetDB)((Object)enumeration)).flag_as_system_created();
                if (object4 != null && ((String)object4).equals(object2)) {
                    this.default_group = enumeration;
                }
                this.add_owner((Group)((Object)enumeration));
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("records");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                object = new Privilege(this.datastore, (String)((Object)enumeration), (String)((Hashtable)object3).get(enumeration));
                ((NetDB)object).flag_as_system_created();
                this.grant_privilege((Privilege)object);
            }
        }
        hashtable.remove("records");
        object2 = (Hashtable)hashtable.get("departments");
        if (object2 != null) {
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Department department = new Department(this.datastore, (String)object);
                department.flag_as_system_created();
                department.extract((Hashtable)((Hashtable)object2).get(object));
                this.add_department(department);
            }
        }
        hashtable.remove("departments");
        NetDB.unhandled_keys(hashtable, "User.extract");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.user().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        return User.verify_or_die(this.datastore, string);
    }

    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return User.verify_or_die(netDB_Datastore, null, string);
    }

    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, Integer n, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Integer n2 = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = netDB_Datastore.remote_user().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            n2 = User._verify_or_die("", netDB_Datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.user().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.user().verify_or_die(string, n) : netDB_Datastore.user().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.USER);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.USER);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.USER);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.USER);
    }

    protected static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege._has_access(string, netDB_Datastore, user.id(), Record_Type.USER.toString(), null);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return User.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return User.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return User.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = false;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_user().has_access(user, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = User._has_access("", netDB_Datastore, user, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n = netDB_Datastore.user().verify_or_die(string, string2);
            if (User._has_access(string, netDB_Datastore, user).booleanValue() && Group._has_access(string, netDB_Datastore, user.id(), Record_Type.USER.toString(), n).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            Boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return false;
    }

    public static User login(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return User.login(netDB_Datastore, null);
    }

    public static User login(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_user().login(netDB_Datastore.operating_user_netid());
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = User._login(netDB_Datastore, string);
        }
        User user = User.extract(netDB_Datastore, hashtable);
        user.flag_as_loaded();
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _login(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            hashtable = netDB_Datastore.user().login(string2, string);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
        return hashtable;
    }

    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        Lock_Result lock_Result = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                lock_Result = this.datastore.remote_user().lock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            lock_Result = User._lock_record("", this.datastore, this.handle());
        }
        this.id = lock_Result.record_id();
        this.lock(lock_Result.lock());
        this.locked_by(lock_Result.locked_by());
        return lock_Result.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock_Result _lock_record(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Lock_Result lock_Result = new Lock_Result();
        Boolean bl = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            Integer n = netDB_Datastore.user().verify_or_die(string, string2);
            Hashtable hashtable = netDB_Datastore.user().lock_record(string, n);
            lock_Result.record_id(n);
            lock_Result.lock((Timestamp)hashtable.get("locked"));
            lock_Result.locked_by(netDB_Datastore.operating_user());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else if (bl2.booleanValue()) {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return lock_Result;
    }

    @Override
    public User unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_user().unlock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._unlock(this.datastore);
        }
        this.clear_lock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _unlock(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.user().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return bl;
    }

    public static User load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return User.load(NetDB.default_datastore(), bl, string);
    }

    public static User load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        User user = new User(netDB_Datastore);
        Person person = new Person(netDB_Datastore);
        person.netid(string);
        person.flag_as_system_created();
        user.identity(person);
        if (bl.booleanValue()) {
            user.lock_record();
        }
        user.load_object("", string);
        return user;
    }

    public static User load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return User.load(NetDB.default_datastore(), string);
    }

    public static User load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return User.load("", netDB_Datastore, string);
    }

    private static User load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        User user = new User(netDB_Datastore);
        user.load_object(string, string2);
        return user;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if ((string2 == null || string2.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_user().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = User._load_object(string, this.datastore, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            Integer n = netDB_Datastore.user().verify_or_die(string, string2);
            hashtable = netDB_Datastore.user().info(string, n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        User.delete(netDB_Datastore, this.handle());
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        User.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_user().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            User._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Lock_Result lock_Result = User._lock_record(string2, netDB_Datastore, string);
            netDB_Datastore.user().delete(string2, lock_Result.lock(), lock_Result.record_id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    @Override
    public User commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.person, "person");
        Insufficient_Information.defined_or_die(this.default_domain, "default domain");
        User user = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                user = netDB_Datastore.remote_user().commit(this, bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            user = this._commit(netDB_Datastore, bl);
        }
        if (user != null) {
            this.deep_update(netDB_Datastore, user);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User _commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        User user = null;
        Boolean bl2 = null;
        String string = "";
        try {
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (this.default_group != null) {
                string2 = this.default_group.handle();
            }
            if (this.default_domain != null) {
                string3 = this.default_domain.handle();
            }
            if (this.starting_address != null) {
                string4 = this.starting_address.toString();
            }
            this.person._insert_or_update(string, netDB_Datastore);
            if (this.created_by_user().booleanValue()) {
                user = new User();
                if (this.person == null) {
                    throw Insufficient_Information.missing_information("identity");
                }
                object = netDB_Datastore.user().insert(string, this.person.id().toString(), string2, string3, string4, NetDB.boolean_to_integer(this.active), NetDB.boolean_to_integer(this.all_records), NetDB.boolean_to_integer(this.all_groups), this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id(), netDB_Datastore.operating_user().netid());
            } else {
                user = User.load(string, netDB_Datastore, netDB_Datastore.user().handle(string, this.id));
                netDB_Datastore.user().update(string, this.lock(), this.id, string2, string3, string4, NetDB.boolean_to_integer(this.active), NetDB.boolean_to_integer(this.all_records), NetDB.boolean_to_integer(this.all_groups), this.comment);
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, user.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.privileges, user.privileges, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.departments, user.departments, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result2.only_in_set1();
            Vector vector4 = comparison_Result2.only_in_set2();
            Vector vector5 = comparison_Result3.only_in_set1();
            Vector vector6 = comparison_Result3.only_in_set2();
            for (n = 0; n < vector.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n)).handle(), this.id, Record_Type.USER.toString());
            }
            for (n = 0; n < vector2.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector2.get(n)).handle(), this.id, Record_Type.USER.toString());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.user().users_access(string, "remove", timestamp, this.id, ((Privilege)vector4.get(n)).handle());
            }
            for (n = 0; n < vector3.size(); ++n) {
                netDB_Datastore.user().users_access(string, "add", timestamp, this.id, ((Privilege)vector3.get(n)).handle());
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.user().org(string, "delete", timestamp, this.id, ((Department)vector6.get(n)).id());
            }
            for (n = 0; n < vector5.size(); ++n) {
                Department department = (Department)vector5.get(n);
                department.id(Department._verify_or_die(string, netDB_Datastore, department.name()));
                netDB_Datastore.user().org(string, "insert", timestamp, this.id, department.id());
            }
            netDB_Datastore.user().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl2.booleanValue() && bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<User_SS_Result> search() throws Exception, No_Datastore_Defined {
        return User.search(NetDB.default_datastore(), null);
    }

    public static Collection<User_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return User.search(NetDB.default_datastore(), string);
    }

    public static Collection<User_SS_Result> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return User.search(netDB_Datastore, null);
    }

    public static Collection<User_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_user().search(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = User._search(netDB_Datastore, string);
        }
        Vector<User_SS_Result> vector = new Vector<User_SS_Result>();
        for (String string2 : hashtable.keySet()) {
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            User_SS_Result user_SS_Result = new User_SS_Result((String)hashtable2.get("NetID"));
            user_SS_Result.name((String)hashtable2.get("name"));
            user_SS_Result.reg_id((String)hashtable2.get("RegID"));
            vector.add(user_SS_Result);
        }
        Collections.sort(vector, new User_SS_Result(""));
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _search(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name(), true);
            hashtable = string != null ? netDB_Datastore.simple_search().get_users(string2, string) : netDB_Datastore.simple_search().get_users(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    public static Collection<User> full_search(User_FS_Parameters user_FS_Parameters) throws Exception {
        return User.full_search(NetDB.default_datastore(), user_FS_Parameters);
    }

    public static Collection<User> full_search(NetDB_Datastore netDB_Datastore, User_FS_Parameters user_FS_Parameters) throws Exception {
        return user_FS_Parameters.search(netDB_Datastore);
    }
}

