/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.util.Cache;

public final class Privilege
extends Record<Privilege> {
    public static String template_name = "templates/toString/privilege.tmpl";
    private static final long serialVersionUID = 1L;
    private static String CACHE_NAME = "Privilege";
    private Integer id = null;
    private String name = null;
    private String display_name = null;
    private String comment = "";
    private Boolean default_access = false;

    public Privilege() {
        this.init();
    }

    public Privilege(String string) {
        this.init(string);
    }

    public Privilege(String string, String string2) {
        this.init(string, string2);
    }

    public Privilege(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Privilege(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Privilege(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    protected Privilege(NetDB_Datastore netDB_Datastore, Integer n) {
        super(netDB_Datastore);
        this.id = n;
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null, null);
    }

    private void init(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, String string3, Boolean bl) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.display_name(string2);
        }
        if (string3 != null) {
            this.comment(string3);
        }
        if (bl != null) {
            this.default_access(bl);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.id, NetDB.unset_integer, "Privilege.id");
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Privilege.name");
        return this.name;
    }

    public String display_name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.display_name, NetDB.unset_string, "Privilege.display_name");
        return this.display_name;
    }

    private String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Privilege.comment");
        return this.comment;
    }

    private Boolean default_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Privilege.default_access");
        return this.default_access;
    }

    @Override
    public String handle() throws Exception {
        if (this.name != null && this.name != NetDB.unset_string) {
            return this.name;
        }
        if (this.id == null) {
            throw new Insufficient_Information("The handle was not found and could not be loaded.");
        }
        this.name = this.handle(this.id);
        return this.name;
    }

    private Privilege name(String string) {
        this.name = string;
        return this;
    }

    private Privilege display_name(String string) {
        this.display_name = string;
        return this;
    }

    private Privilege comment(String string) {
        this.comment = string;
        return this;
    }

    private Privilege default_access(Boolean bl) {
        this.default_access = bl;
        return this;
    }

    @Override
    public Privilege unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((Privilege)netDB).id;
        this.name = ((Privilege)netDB).name;
        this.display_name = ((Privilege)netDB).display_name;
        this.comment = ((Privilege)netDB).comment;
        this.default_access = ((Privilege)netDB).default_access;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.display_name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.display_name == null) {
            this.display_name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.default_access == null) {
            this.default_access = NetDB.unset_boolean;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.DISPLAY_NAME) {
            if (NetDB.unset_string.equals(this.display_name)) {
                this.display_name = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.DEFAULT_ACCESS && this.default_access == NetDB.unset_boolean) {
            this.default_access = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.display_name)) {
            this.display_name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.default_access == NetDB.unset_boolean) {
            this.default_access = null;
        }
    }

    @Override
    public String toString() {
        String string = "";
        try {
            string = this.toString(NetDB.FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a Privilege into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "privilege", this, bl);
    }

    protected String handle(Integer n) throws Exception, No_Datastore_Defined {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                string = this.datastore.remote_access().handle(n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            string = Privilege._handle(this.datastore, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = "";
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.access().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    protected Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    protected Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    protected Integer verify_or_die(Integer n, String string) throws Exception {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Integer n2 = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = this.datastore.remote_access().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n2 = Privilege._verify_or_die("", this.datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.access().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.access().verify_or_die(string, n) : netDB_Datastore.access().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    protected static Boolean has_access(Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, record_Type);
    }

    protected static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, string);
    }

    protected static Boolean has_access(User user, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, user, record_Type);
    }

    protected static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, user, string);
    }

    protected static Boolean has_access(Record_Type record_Type, Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, record_Type, n);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, record_Type.toString(), null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, string, null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (user != null) {
            n = user.id();
        }
        return Privilege.has_access(netDB_Datastore, n, record_Type.toString(), null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (user != null) {
            n = user.id();
        }
        return Privilege.has_access(netDB_Datastore, n, string, null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Record_Type record_Type, Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, record_Type.toString(), n);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Integer n, String string, Integer n2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_access().has_access(n, string, n2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Privilege._has_access("", netDB_Datastore, n, string, n2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2, Integer n2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Comparable<User> comparable;
        NetDB.rmi_exception(netDB_Datastore);
        if (n == null) {
            comparable = netDB_Datastore.operating_user();
            if (comparable == null) {
                throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
            }
            n = ((User)comparable).id();
        }
        comparable = false;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            comparable = n2 != null ? netDB_Datastore.access().check_access(string, n, string2) : netDB_Datastore.access().check_access(string, n, string2, n2);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return comparable;
    }

    public static Privilege load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Privilege.load(NetDB.default_datastore(), string);
    }

    public static Privilege load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Privilege.load("", netDB_Datastore, string);
    }

    private static Privilege load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Privilege privilege = new Privilege(netDB_Datastore);
        privilege.load_object(string, string2);
        return privilege;
    }

    @Override
    protected synchronized void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Cache<Hashtable<String, String>> cache;
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string2 == null || string2.trim().equals("") || NetDB.unset_string.equals(string2) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        if (NetDB.unset_string.equals(string2) && this.id != null) {
            string2 = this.handle();
        }
        if (this.id == null) {
            this.id = this.verify_or_die(string2);
        }
        if ((cache = Cache.fetch_hashtable_cache(this.datastore.cache_name(CACHE_NAME))).is_old().booleanValue()) {
            cache.data(Privilege.cacheable_list(this.datastore));
        }
        this.name = string2;
        this.display_name = cache.data().get(string2);
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<Privilege> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.list(NetDB.default_datastore());
    }

    public static synchronized Collection<Privilege> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Vector<Privilege> vector = new Vector<Privilege>();
        Hashtable hashtable = Privilege.cacheable_list(netDB_Datastore);
        if (hashtable != null) {
            Cache.fetch_hashtable_cache(netDB_Datastore.cache_name(CACHE_NAME)).data(hashtable);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Privilege privilege = new Privilege(netDB_Datastore, string, (String)hashtable.get(string));
                privilege.flag_as_system_created();
                vector.add(privilege);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    protected static Hashtable cacheable_list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_access().list();
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Privilege._list(netDB_Datastore);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.access().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Privilege.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Privilege commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

