/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public class Person
extends Record<Person> {
    public static String template_name = "templates/toString/person.tmpl";
    private static final long serialVersionUID = 1L;
    private static final Pattern name_netid_pattern = Pattern.compile("(\\S+ *.*?)(?: *\\(([^(]*)\\))?");
    public static Comparator<Person> name_comparator = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person2) {
            if (person == null && person2 == null) {
                return 0;
            }
            if (person == null && person2 != null) {
                return 1;
            }
            if (person != null && person2 == null) {
                return -1;
            }
            String string = person.last_name;
            String string2 = person2.last_name;
            string = string == null ? "" : string + person.name;
            string2 = string2 == null ? "" : string2 + person2.name;
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    };
    public static Comparator<Person> regid_comparator = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person2) {
            if (person == null && person2 == null) {
                return 0;
            }
            if (person == null && person2 != null) {
                return 1;
            }
            if (person != null && person2 == null) {
                return -1;
            }
            String string = "";
            String string2 = "";
            if (person.reg_id != null) {
                string = person.reg_id;
            }
            if (person2.reg_id != null) {
                string2 = person2.reg_id;
            }
            if (string.equals(NetDB.unset_string) && string2.equals(NetDB.unset_string)) {
                return name_comparator.compare(person, person2);
            }
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    };
    protected Integer id = null;
    protected String reg_id = null;
    protected String dir_id = null;
    protected String name = null;
    protected String last_name = null;
    protected String phone = null;
    protected String email = null;
    protected String netid = null;
    protected Boolean active = null;

    public Person() {
        this.init();
    }

    protected Person(String string, String string2, Boolean bl) {
        this.init(string, string2, bl);
    }

    protected Person(String string, String string2, String string3, String string4, String string5, String string6, String string7, Boolean bl) {
        this.init(string, string2, string3, string4, string5, string6, string7, bl);
    }

    protected Person(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected Person(NetDB_Datastore netDB_Datastore, String string, String string2, Boolean bl) {
        super(netDB_Datastore);
        this.init(string, string2, bl);
    }

    protected Person(NetDB_Datastore netDB_Datastore, String string, String string2, String string3, String string4, String string5, String string6, String string7, Boolean bl) {
        super(netDB_Datastore);
        this.init(string, string2, string3, string4, string5, string6, string7, bl);
    }

    protected Person(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        Matcher matcher = name_netid_pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = null;
            if (matcher.groupCount() > 1 && "".equals(string3 = matcher.group(2))) {
                string3 = null;
            }
            this.init(null, null, string2, null, null, null, string3, null);
            this.flag_as_system_created();
        }
    }

    protected void init() {
        this.init(null, null, null, null, null, null, null, null);
    }

    protected void init(String string, String string2, Boolean bl) {
        this.init(string, null, string2, null, null, null, null, bl);
    }

    protected void init(String string, String string2, String string3, String string4, String string5, String string6, String string7, Boolean bl) {
        if (string != null) {
            this.reg_id(string);
        }
        if (string2 != null) {
            this.dir_id(string2);
        }
        if (string3 != null) {
            this.name(string3);
        }
        if (string4 != null) {
            this.last_name(string4);
        }
        if (string5 != null) {
            this.phone(string5);
        }
        if (string6 != null) {
            this.email(string6);
        }
        if (string7 != null) {
            this.netid(string7);
        }
        if (bl != null) {
            this.active(bl);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Person.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String regID() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.reg_id();
    }

    public String reg_id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.reg_id, NetDB.unset_string, "Person.reg_id");
        return this.reg_id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Person.name");
        return this.name;
    }

    public String netID() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.netid();
    }

    public String netid() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.netid, NetDB.unset_string, "Person.netid");
        return this.netid;
    }

    public String email() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.email, NetDB.unset_string, "Person.email");
        return this.email;
    }

    public String phone() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.phone, NetDB.unset_string, "Person.phone");
        return this.phone;
    }

    public Boolean active() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.active, NetDB.unset_boolean, "Person.active");
        return this.active;
    }

    public String lastname() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.last_name();
    }

    public String last_name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.last_name, NetDB.unset_string, "Person.last_name");
        return this.last_name;
    }

    public String dirID() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dir_id();
    }

    public String dir_id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.dir_id, NetDB.unset_string, "Person.dir_id");
        return this.dir_id;
    }

    @Override
    public String handle() {
        if (NetDB.unset_string.equals(this.reg_id)) {
            return "";
        }
        return this.reg_id;
    }

    protected Person id(Integer n) {
        this.id = n;
        return this;
    }

    protected Person reg_id(String string) {
        this.reg_id = string;
        return this;
    }

    protected Person name(String string) {
        this.name = string;
        return this;
    }

    protected Person netid(String string) {
        this.netid = string;
        return this;
    }

    protected Person email(String string) {
        this.email = string;
        return this;
    }

    protected Person phone(String string) {
        this.phone = string;
        return this;
    }

    protected Person active(Boolean bl) {
        this.active = bl;
        return this;
    }

    protected Person last_name(String string) {
        this.last_name = string;
        return this;
    }

    protected Person dir_id(String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        this.dir_id = string;
        return this;
    }

    @Override
    public Person unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((Person)netDB).id;
        this.reg_id = ((Person)netDB).reg_id;
        this.dir_id = ((Person)netDB).dir_id;
        this.name = ((Person)netDB).name;
        this.last_name = ((Person)netDB).last_name;
        this.phone = ((Person)netDB).phone;
        this.email = ((Person)netDB).email;
        this.netid = ((Person)netDB).netid;
        this.active = ((Person)netDB).active;
    }

    @Override
    public String single_value_attributes() {
        return this.reg_id + " " + this.dir_id + " " + this.name + " " + this.last_name + " " + this.phone + " " + this.email + " " + this.netid + " " + this.active;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.reg_id == null) {
            this.reg_id = NetDB.unset_string;
        }
        if (this.dir_id == null) {
            this.dir_id = NetDB.unset_string;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.last_name == null) {
            this.last_name = NetDB.unset_string;
        }
        if (this.phone == null) {
            this.phone = NetDB.unset_string;
        }
        if (this.email == null) {
            this.email = NetDB.unset_string;
        }
        if (this.netid == null) {
            this.netid = NetDB.unset_string;
        }
        if (this.active == null) {
            this.active = NetDB.unset_boolean;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.REG_ID) {
            if (NetDB.unset_string.equals(this.reg_id)) {
                this.reg_id = null;
            }
        } else if (field == Field.DIR_ID) {
            if (NetDB.unset_string.equals(this.dir_id)) {
                this.dir_id = null;
            }
        } else if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.LAST_NAME) {
            if (NetDB.unset_string.equals(this.last_name)) {
                this.last_name = null;
            }
        } else if (field == Field.PHONE) {
            if (NetDB.unset_string.equals(this.phone)) {
                this.phone = null;
            }
        } else if (field == Field.EMAIL) {
            if (NetDB.unset_string.equals(this.email)) {
                this.email = null;
            }
        } else if (field == Field.NETID) {
            if (NetDB.unset_string.equals(this.netid)) {
                this.netid = null;
            }
        } else if (field == Field.ACTIVE && this.active == NetDB.unset_boolean) {
            this.active = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.reg_id)) {
            this.reg_id = null;
        }
        if (NetDB.unset_string.equals(this.dir_id)) {
            this.dir_id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.last_name)) {
            this.last_name = null;
        }
        if (NetDB.unset_string.equals(this.phone)) {
            this.phone = null;
        }
        if (NetDB.unset_string.equals(this.email)) {
            this.email = null;
        }
        if (NetDB.unset_string.equals(this.netid)) {
            this.netid = null;
        }
        if (this.active == NetDB.unset_boolean) {
            this.active = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "person", this, bl);
    }

    @Override
    public Comparator<Person> sort_comparator() {
        return name_comparator;
    }

    @Override
    public int compareTo(Person person) {
        return this.compare(this, person);
    }

    @Override
    public int compare(Person person, Person person2) {
        return this.compare(person, person2, COMPARE_TYPE.REGID);
    }

    public int compare(Person person, Person person2, COMPARE_TYPE cOMPARE_TYPE) {
        int n = 0;
        if (cOMPARE_TYPE == COMPARE_TYPE.NAME) {
            n = name_comparator.compare(person, person2);
        } else if (cOMPARE_TYPE == COMPARE_TYPE.REGID) {
            n = regid_comparator.compare(person, person2);
        }
        return n;
    }

    protected static Person extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Person person = new Person(netDB_Datastore);
        person.extract(hashtable);
        return person;
    }

    protected Person extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        String string = (String)hashtable.get("id");
        if (string != null) {
            this.id(Integer.parseInt(string));
        }
        hashtable.remove("id");
        this.netid((String)hashtable.get("NetID"));
        hashtable.remove("NetID");
        this.last_name((String)hashtable.get("lastname"));
        hashtable.remove("lastname");
        this.name((String)hashtable.get("name"));
        hashtable.remove("name");
        this.dir_id((String)hashtable.get("DirID"));
        hashtable.remove("DirID");
        this.reg_id((String)hashtable.get("RegID"));
        hashtable.remove("RegID");
        this.phone((String)hashtable.get("phone"));
        hashtable.remove("phone");
        this.email((String)hashtable.get("email"));
        hashtable.remove("email");
        Boolean bl = (Boolean)hashtable.get("dirActive?");
        if (bl == null) {
            bl = (Boolean)hashtable.get("active?");
            hashtable.remove("active?");
        } else {
            hashtable.remove("dirActive?");
        }
        this.active(bl);
        NetDB.unhandled_keys(hashtable, "Person.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        Integer n = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n = this.datastore.remote_person().verify_or_die(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n = Person._verify_or_die("", this.datastore, null, string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("") || string2.equals(NetDB.unset_string)) {
            throw Insufficient_Information.missing_handle();
        }
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = netDB_Datastore.person().verify_or_die(string, n, string2);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Person load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Person.load(NetDB.default_datastore(), string);
    }

    public static Person load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Person.load("", netDB_Datastore, string);
    }

    private static Person load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Person person = new Person(netDB_Datastore);
        person.load_object(string, string2);
        return person;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_person().info(this.id, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = Person._load_object(string, this.datastore, this.id, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            if (n == null) {
                n = Person._verify_or_die(string, netDB_Datastore, null, string2);
            }
            hashtable = netDB_Datastore.person().info(string, n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Person.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Person commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }

    protected Person insert_or_update() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Person person = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                person = this.datastore.remote_person().insert_or_update(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.datastore.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            person = this._insert_or_update("", this.datastore);
        }
        if (person != null) {
            this.deep_update(this.datastore, person);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person _insert_or_update(String string, NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            Hashtable hashtable = netDB_Datastore.person().insert(string, this.id, this.reg_id, this.name, this.netid, this.email, this.phone, Person.boolean_to_integer(this.active), this.last_name, this.dir_id);
            if (hashtable != null) {
                this.id = new Integer((String)hashtable.get("id"));
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl2.booleanValue() && bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    public static enum COMPARE_TYPE {
        NAME,
        REGID;

    }
}

