/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public final class OS
extends Record<OS> {
    public static String template_name = "templates/toString/os.tmpl";
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String name = null;
    private String comment = null;
    private Person modified_by = null;
    private Timestamp modified = null;

    public OS() {
        this.init();
    }

    public OS(String string) {
        this.init(string);
    }

    public OS(String string, String string2) {
        this.init(string, string2);
    }

    public OS(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public OS(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public OS(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null, null);
    }

    private void init(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, Person person, Timestamp timestamp) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
        if (person != null) {
            this.modified_by(person);
        }
        if (timestamp != null) {
            this.modified(timestamp);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "OS.name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "OS.comment");
        return this.comment;
    }

    private Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "OS.modified_by");
        return this.modified_by;
    }

    private Timestamp modified() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified, NetDB.unset_timestamp, "OS.modified");
        return this.modified;
    }

    @Override
    public String handle() throws Insufficient_Information {
        if (this.name == null) {
            this.name = this.id;
        }
        if (this.name == null) {
            throw new Insufficient_Information("The OS does not have a handle or an ID defined.");
        }
        return this.name;
    }

    public OS name(String string) {
        this.name = string;
        return this;
    }

    public OS comment(String string) {
        this.comment = string;
        return this;
    }

    private OS modified_by(Person person) {
        this.modified_by = person;
        return this;
    }

    private OS modified(Timestamp timestamp) {
        this.modified = timestamp;
        return this;
    }

    @Override
    public OS unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((OS)netDB).id;
        this.name = ((OS)netDB).name;
        this.comment = ((OS)netDB).comment;
        this.modified_by = ((OS)netDB).modified_by;
        this.modified = ((OS)netDB).modified;
    }

    @Override
    public String single_value_attributes() {
        return this.name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
        if (this.modified == null) {
            this.modified = NetDB.unset_timestamp;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.MODIFIED_BY) {
            if (this.modified_by == NetDB.unset_person) {
                this.modified_by = null;
            }
        } else if (field == Field.MODIFIED_AT && this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
        if (this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "os", this, bl);
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.OS);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.OS);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.OS);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.OS);
    }

    public static OS load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return OS.load(NetDB.default_datastore(), string);
    }

    public static OS load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return OS.load("", netDB_Datastore, string);
    }

    private static OS load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        OS oS = new OS(netDB_Datastore);
        oS.load_object(string, string2);
        return oS;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_os().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = OS._load_object(string, this.datastore, string2);
        }
        String string3 = (String)hashtable.get("id");
        this.name(string3);
        this.comment((String)hashtable.get(string3));
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        String string3 = null;
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            string3 = netDB_Datastore.os().verify_or_die(string, string2);
            hashtable = netDB_Datastore.os().list(string, string3);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        Hashtable<String, String> hashtable2 = null;
        if (string3 != null && hashtable != null) {
            hashtable2 = new Hashtable<String, String>();
            hashtable2.put("id", string3);
            hashtable2.put(string3, (String)hashtable.get(string3));
        }
        return hashtable2;
    }

    public static Collection<OS> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(NetDB.default_datastore());
    }

    public static Collection<OS> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(NetDB.default_datastore(), string);
    }

    public static Collection<OS> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(netDB_Datastore, null);
    }

    public static Collection<OS> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<OS> vector = new Vector<OS>();
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_os().list(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = OS._list(netDB_Datastore, string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                OS oS = new OS(netDB_Datastore, string2, (String)hashtable.get(string2));
                oS.flag_as_system_created().flag_as_loaded();
                vector.add(oS);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.os().list(string2, string) : netDB_Datastore.os().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    @Override
    public void delete() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.delete(this.get_datastore());
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        OS.delete(netDB_Datastore, this.name);
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        OS.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_os().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            OS._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.os().delete(string2, string);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    @Override
    public OS commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.name, "name");
        OS oS = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                oS = netDB_Datastore.remote_os().commit(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            oS = this._commit(netDB_Datastore);
        }
        if (oS != null) {
            this.deep_update(netDB_Datastore, oS);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OS _commit(NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (this.created_by_user().booleanValue()) {
                netDB_Datastore.os().insert(string, this.name, this.comment);
            } else {
                netDB_Datastore.os().update(string, this.id, this.name, this.comment);
            }
            this.id = this.name;
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    public OS supplant(OS oS) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        if (this.created_by_user().booleanValue()) {
            throw new Exception("You must load the record that is being supplanted.");
        }
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_os().supplant(this.name, oS.name());
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = OS._supplant(netDB_Datastore, this.name, oS.name());
        }
        if (bl.booleanValue()) {
            this.flag_as_user_created().flag_as_modified();
        }
        return oS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _supplant(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.os().supplant(string3, string, string2);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string3);
                } else {
                    netDB_Datastore.end_transaction(string3);
                }
            }
        }
        return bl;
    }
}

