/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.util.Cache;

public final class Node_Type
extends Record<Node_Type> {
    public static String template_name = "templates/toString/node_type.tmpl";
    private static final long serialVersionUID = 1L;
    private static String CACHE_NAME = "Node_Type";
    private String type = null;
    private String extkey = null;
    private String plural = null;
    private String abbrev = null;
    private Integer rank = null;
    private String comment = null;
    private Privilege privilege = null;

    protected Node_Type() {
        this.init();
    }

    protected Node_Type(String string, String string2, String string3, String string4, Integer n) {
        this.init(string, string2, string3, string4, n);
    }

    protected Node_Type(String string, String string2, String string3, String string4, Integer n, String string5, Privilege privilege) {
        this.init(string, string2, string3, string4, n, string5, privilege);
    }

    protected Node_Type(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected Node_Type(NetDB_Datastore netDB_Datastore, String string, String string2, String string3, String string4, Integer n) {
        super(netDB_Datastore);
        this.init(string, string2, string3, string4, n);
    }

    protected Node_Type(NetDB_Datastore netDB_Datastore, String string, String string2, String string3, String string4, Integer n, String string5, Privilege privilege) {
        super(netDB_Datastore);
        this.init(string, string2, string3, string4, n, string5, privilege);
    }

    private void init() {
        this.init(null, null, null, null, null, null, null);
    }

    private void init(String string, String string2, String string3, String string4, Integer n) {
        this.init(string, string2, string3, string4, n, null, null);
    }

    private void init(String string, String string2, String string3, String string4, Integer n, String string5, Privilege privilege) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.extkey(string2);
        }
        if (string3 != null) {
            this.plural(string3);
        }
        if (string4 != null) {
            this.abbrev(string4);
        }
        if (n != null) {
            this.rank(n);
        }
        if (string5 != null) {
            this.comment(string5);
        }
        if (privilege != null) {
            this.privilege(privilege);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.type, NetDB.unset_string, "Node_Type.type");
        return this.type;
    }

    private String extkey() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.extkey, NetDB.unset_string, "Node_Type.extkey");
        return this.extkey;
    }

    public String plural() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.plural, NetDB.unset_string, "Node_Type.plural");
        return this.plural;
    }

    public String abbrev() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.abbrev, NetDB.unset_string, "Node_Type.abbrev");
        return this.abbrev;
    }

    public Integer rank() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.rank, NetDB.unset_integer, "Node_Type.rank");
        return this.rank;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Node_Type.comment");
        return this.comment;
    }

    public Privilege privilege() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.privilege, NetDB.unset_privilege, "Node_Type.privilege");
        return this.privilege;
    }

    @Override
    public String handle() {
        return this.type;
    }

    protected Node_Type name(String string) {
        this.type = string;
        return this;
    }

    protected Node_Type extkey(String string) {
        this.extkey = string;
        return this;
    }

    protected Node_Type plural(String string) {
        this.plural = string;
        return this;
    }

    protected Node_Type abbrev(String string) {
        this.abbrev = string;
        return this;
    }

    protected Node_Type rank(Integer n) {
        this.rank = n;
        return this;
    }

    protected Node_Type comment(String string) {
        this.comment = string;
        return this;
    }

    protected Node_Type privilege(Privilege privilege) {
        this.privilege = privilege;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.type = ((Node_Type)netDB).type;
        this.extkey = ((Node_Type)netDB).extkey;
        this.plural = ((Node_Type)netDB).plural;
        this.abbrev = ((Node_Type)netDB).abbrev;
        this.rank = ((Node_Type)netDB).rank;
        this.comment = ((Node_Type)netDB).comment;
        this.privilege = ((Node_Type)netDB).privilege;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.privilege != null) {
            string = this.privilege.single_value_attributes();
        }
        return this.type + " " + this.extkey + " " + this.plural + " " + this.abbrev + " " + this.rank + " " + this.comment + " " + string;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.type == null) {
            this.type = NetDB.unset_string;
        }
        if (this.extkey == null) {
            this.extkey = NetDB.unset_string;
        }
        if (this.plural == null) {
            this.plural = NetDB.unset_string;
        }
        if (this.abbrev == null) {
            this.abbrev = NetDB.unset_string;
        }
        if (this.rank == null) {
            this.rank = NetDB.unset_integer;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.privilege == null) {
            this.privilege = NetDB.unset_privilege;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.TYPE) {
            if (NetDB.unset_string.equals(this.type)) {
                this.type = null;
            }
        } else if (field == Field.EXTKEY) {
            if (NetDB.unset_string.equals(this.extkey)) {
                this.extkey = null;
            }
        } else if (field == Field.PLURAL) {
            if (NetDB.unset_string.equals(this.plural)) {
                this.plural = null;
            }
        } else if (field == Field.ABBREV) {
            if (NetDB.unset_string.equals(this.abbrev)) {
                this.abbrev = null;
            }
        } else if (field == Field.RANK) {
            if (this.rank == NetDB.unset_integer) {
                this.rank = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.PRIVILEGE && this.privilege == NetDB.unset_privilege) {
            this.privilege = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.type)) {
            this.type = null;
        }
        if (NetDB.unset_string.equals(this.extkey)) {
            this.extkey = null;
        }
        if (NetDB.unset_string.equals(this.plural)) {
            this.plural = null;
        }
        if (NetDB.unset_string.equals(this.abbrev)) {
            this.abbrev = null;
        }
        if (this.rank == NetDB.unset_integer) {
            this.rank = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.privilege == NetDB.unset_privilege) {
            this.privilege = null;
        }
    }

    @Override
    public String toString() {
        String string = "";
        try {
            string = this.toString(NetDB.FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a Node_Type into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "node_type", this, bl);
    }

    protected static Node_Type extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Node_Type node_Type = new Node_Type(netDB_Datastore);
        node_Type.flag_as_system_created();
        node_Type.extract(hashtable);
        return node_Type;
    }

    protected Node_Type extract(Hashtable hashtable) {
        String string;
        if (hashtable == null) {
            return this;
        }
        if (hashtable.containsKey("rank")) {
            this.rank((Integer)hashtable.get("rank"));
            hashtable.remove("rank");
        }
        if (hashtable.containsKey("plural")) {
            this.plural((String)hashtable.get("plural"));
            hashtable.remove("plural");
        }
        if (hashtable.containsKey("extkey")) {
            this.extkey((String)hashtable.get("extkey"));
            hashtable.remove("extkey");
        }
        if (hashtable.containsKey("abbrev")) {
            this.abbrev((String)hashtable.get("abbrev"));
            hashtable.remove("abbrev");
        }
        if (hashtable.containsKey("type")) {
            this.name((String)hashtable.get("type"));
            hashtable.remove("type");
        }
        if (hashtable.containsKey("description")) {
            this.comment((String)hashtable.get("description"));
            hashtable.remove("description");
        }
        if ((string = (String)hashtable.get("access")) != null) {
            Integer n = new Integer(string);
            Privilege privilege = new Privilege(this.datastore, n);
            privilege.flag_as_system_created();
            this.privilege(privilege);
        }
        hashtable.remove("access");
        NetDB.unhandled_keys(hashtable, "Node_Type.extract");
        return this;
    }

    private static synchronized Cache<Vector<Node_Type>> fetch_cache(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        Cache cache = Cache.shared(netDB_Datastore.cache_name(CACHE_NAME));
        if (cache == null) {
            cache = new Cache();
            Cache.shared(netDB_Datastore.cache_name(CACHE_NAME), cache);
        }
        return cache;
    }

    public Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(this.type);
    }

    public Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, this.type);
    }

    public Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, this.type);
    }

    public Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, this.type);
    }

    public static Node_Type load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Node_Type.load(NetDB.default_datastore(), string);
    }

    public static Node_Type load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Node_Type.load("", netDB_Datastore, string);
    }

    private static Node_Type load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Node_Type node_Type = new Node_Type(netDB_Datastore);
        node_Type.load_object(string, string2);
        return node_Type;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string2 == null || string2.trim().equals("") || NetDB.unset_string.equals(string2)) {
            throw Insufficient_Information.missing_handle();
        }
        Cache<Vector<Node_Type>> cache = Node_Type.fetch_cache(this.datastore);
        if (cache.is_old().booleanValue()) {
            Node_Type.list(this.datastore, true);
        }
        string2 = string2.toLowerCase();
        boolean bl = false;
        for (Node_Type node_Type : cache.data()) {
            if (!node_Type.handle().toLowerCase().equals(string2) && !node_Type.abbrev().toLowerCase().equals(string2)) continue;
            this.type = node_Type.type;
            this.extkey = node_Type.extkey;
            this.plural = node_Type.plural;
            this.abbrev = node_Type.abbrev;
            this.rank = node_Type.rank;
            this.comment = node_Type.comment;
            this.privilege = node_Type.privilege;
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
            break;
        }
        if (!bl) {
            throw new Record_Not_Found("'" + string2 + "' was not found.");
        }
    }

    public static Collection<Node_Type> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node_Type.list(NetDB.default_datastore());
    }

    public static Collection<Node_Type> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node_Type.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Node_Type> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node_Type.list(netDB_Datastore, false);
    }

    public static synchronized Collection<Node_Type> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<Node_Type> vector = new Vector<Node_Type>();
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_node_type().list(bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Node_Type._list(netDB_Datastore, bl);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Node_Type node_Type = Node_Type.extract(netDB_Datastore, (Hashtable)hashtable.get(string));
                node_Type.flag_as_loaded();
                vector.add(node_Type);
            }
            if (bl.booleanValue()) {
                Node_Type.fetch_cache(netDB_Datastore).data(vector);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.node_type().list(string, n) : netDB_Datastore.node_type().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Node_Type.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Node_Type commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

