/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Node_Type;
import stanford.netdb.Simple_Search_Result;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Node_SS_Result
extends Simple_Search_Result<Node_SS_Result> {
    private static final long serialVersionUID = 1L;
    private Integer node_id = null;
    private String closest_name = null;
    private String display_name = null;
    private String ip = null;
    private String department = null;
    private String make_and_model = null;
    private String os = null;
    private String received_by = null;
    private String received_by_fullname = null;
    private Integer preference = null;
    private Simple_Search_Result.NAME_TYPE closest_name_type = null;
    private Simple_Search_Result.IP_TYPE ip_type = null;
    private Simple_Search_Result.SEARCH_TYPE search_type = null;
    private Multi_Value_Attribute<Node_Type> types = new Multi_Value_Attribute();
    private transient NetDB_Datastore datastore = null;

    protected Node_SS_Result() {
    }

    protected Node_SS_Result(NetDB_Datastore netDB_Datastore, String string) {
        super(string);
        this.datastore = netDB_Datastore;
    }

    public String node_name() {
        return super.handle();
    }

    public Integer node_id() {
        return this.node_id;
    }

    public String name() {
        return this.closest_name;
    }

    public Simple_Search_Result.NAME_TYPE name_type() {
        return this.closest_name_type;
    }

    public String display_name() {
        return this.display_name;
    }

    public String IP() {
        return this.ip();
    }

    public String ip() {
        return this.ip;
    }

    public Simple_Search_Result.IP_TYPE IP_type() {
        return this.ip_type();
    }

    public Simple_Search_Result.IP_TYPE ip_type() {
        return this.ip_type;
    }

    public String department() {
        return this.department;
    }

    public String make_and_model() {
        return this.make_and_model;
    }

    public String OS() {
        return this.os();
    }

    public String os() {
        return this.os;
    }

    public String received_by() {
        return this.received_by;
    }

    public String received_by_fullname() {
        return this.received_by_fullname;
    }

    public Integer preference() {
        return this.preference;
    }

    public Collection<Node_Type> types() {
        if (this.types == null) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.types.all_values();
    }

    public Simple_Search_Result.SEARCH_TYPE search_type() {
        return this.search_type;
    }

    protected void node_id(String string) {
        if (string == null) {
            return;
        }
        this.node_id = new Integer(string);
    }

    protected void name(String string) {
        this.closest_name = string;
    }

    protected void name_type(String string, String string2) throws Exception {
        if (string == null) {
            return;
        }
        if (string2 != null) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.ALIAS;
        } else if (string.equals("node_name")) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.NODE;
        } else if (string.equals("ip_addr_name")) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.ADDRESS;
        } else if (string.equals("intfc_name")) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.INTERFACE;
        } else if (string.equals("ipc_addr_name")) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.IPC_ADDRESS;
        } else if (string.equals("MX")) {
            this.closest_name_type = Simple_Search_Result.NAME_TYPE.MX;
        } else {
            throw new Exception("Unknown name type '" + string + "'.");
        }
    }

    protected void display_name(String string) {
        this.display_name = string;
    }

    protected void ip(String string) {
        this.ip = string;
    }

    protected void ip_type(String string) throws Exception {
        if (string == null) {
            return;
        }
        if (string.equals("intfc_ip")) {
            this.ip_type = Simple_Search_Result.IP_TYPE.INTERFACE_ADDRESS;
        } else if (string.equals("ipc_ip")) {
            this.ip_type = Simple_Search_Result.IP_TYPE.IPC_ADDRESS;
        } else {
            throw new Exception("Unknown IP type '" + string + "'.");
        }
    }

    protected void department(String string) {
        this.department = string;
    }

    protected void make_and_model(String string) {
        this.make_and_model = string;
    }

    protected void os(String string) {
        this.os = string;
    }

    protected void received_by(String string) {
        this.received_by = string;
    }

    protected void received_by_fullname(String string) {
        this.received_by_fullname = string;
    }

    protected void preference(String string) {
        if (string == null) {
            return;
        }
        this.preference = new Integer(string);
    }

    protected void add_type(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (string == null) {
            return;
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.types == null) {
            this.types = new Multi_Value_Attribute();
        }
        this.types.add(Node_Type.load(this.datastore, string));
    }

    protected void search_type(Simple_Search_Result.SEARCH_TYPE sEARCH_TYPE) {
        this.search_type = sEARCH_TYPE;
    }

    @Override
    public int compareTo(Node_SS_Result node_SS_Result) {
        String string;
        String string2;
        block10: {
            string2 = "";
            string = "";
            if (node_SS_Result == null) {
                node_SS_Result = new Node_SS_Result(null, "");
            }
            if (this.search_type == Simple_Search_Result.SEARCH_TYPE.IP) {
                try {
                    string2 = this.ip.contains("/") ? new Prefix(this.ip).address().toString(16) : new IPaddress(this.ip).toString(16);
                }
                catch (Exception exception) {
                    string2 = this.ip;
                }
                try {
                    if (node_SS_Result.ip.contains("/")) {
                        string = new Prefix(node_SS_Result.ip).address().toString(16);
                        break block10;
                    }
                    string = new IPaddress(node_SS_Result.ip).toString(16);
                }
                catch (Exception exception) {
                    string = node_SS_Result.ip;
                }
            } else {
                string2 = this.closest_name;
                string = node_SS_Result.closest_name;
                if (string2 == null || string2.equals("")) {
                    string2 = super.handle();
                }
                if (string == null || string.equals("")) {
                    string = super.handle();
                }
            }
        }
        return string2.toLowerCase().compareTo(string.toLowerCase());
    }
}

