/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Address_Space;
import stanford.netdb.Attribute;
import stanford.netdb.DHCP_Option;
import stanford.netdb.DHCP_Service;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.FS_Boolean;
import stanford.netdb.Field;
import stanford.netdb.Full_Search_Parameters;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.IP_Address;
import stanford.netdb.IP_Pool;
import stanford.netdb.Location;
import stanford.netdb.Name;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network;
import stanford.netdb.middleware.Result_Hash;

public final class Network_FS_Parameters
extends Full_Search_Parameters<Network_FS_Parameters, Network> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_NAME = "displayOrder.txt.1.Name:Network";
    private static final String INCLUDE_LOCATION = "displayOrder.txt.2.Location";
    private static final String INCLUDE_SITE = "displayOrder.ns.20.Site";
    private static final String INCLUDE_CODE = "displayOrder.ns.21.Code";
    private static final String INCLUDE_ADDRESS_SPACE = "displayOrder.ni.5.AddressSpace";
    private static final String INCLUDE_SERVICE = "displayOrder.txt.6.Service";
    private static final String INCLUDE_NETWORK_OPTION = "displayOrder.txt.7.Network DHCPoption";
    private static final String INCLUDE_VLAN = "displayOrder.num.9.VLAN";
    private static final String INCLUDE_ADDRESS_SPACE_OPTION = "displayOrder.ns.11.AddressSpace DHCP Option";
    private static final String INCLUDE_ADDRESS_SPACE_GROUP = "displayOrder.ns.12.AS Group";
    private static final String INCLUDE_ADDRESS_SPACE_COMMENT = "displayOrder.ns.13.AScomment";
    private static final String INCLUDE_DHCP_ADDRESS = "displayOrder.ni.14.Address";
    private static final String INCLUDE_DHCP_ADDRESS_NAME = "displayOrder.ns.15.Name:DHCP Address";
    private static final String INCLUDE_ACTIVE_DHCP_ADDRESS = "displayOrder.ns.16.Active Address";
    private static final String INCLUDE_LOW_RES = "displayOrder.nn.20.LowRes";
    private static final String INCLUDE_HIGH_RES = "displayOrder.nn.21.HighRes";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String AS_PREFIX_COLUMN = "AS_PREFIX";
    private static final String IP_AS_PREFIX_COLUMN = "IP_AS_PREFIX";
    private static final String ADDRESS_TXT_COLUMN = "IPADDRESS_TXT";
    private static final String NAME_ID_COLUMN = "NAME_ID";
    private static final String NET_NAME_COLUMN = "NET_NAME";
    private static final String NET_DOMAIN_COLUMN = "NET_DOMAIN";
    private static final String LOCATION_COLUMN = "LOCATION";
    private static final String SERVICE_COLUMN = "Service";
    private static final String NETWORK_GROUP_COLUMN = "Network Group";
    private static final String VLAN_COLUMN = "VLAN";
    private static final String COMMENT_COLUMN = "Comment";
    private static final String NETWORK_DHCP_OPTION_COLUMN = "Network DHCPoption";
    private static final String AS_DHCP_OPTION_COLUMN = "AS_DHCP_OPTION";
    private static final String AS_OWNER_COLUMN = "AS_OWNER";
    private static final String AS_COMMENT_COLUMN = "AS_COMMENTS";
    private static final String SITE_COLUMN = "Site";
    private static final String CODE_COLUMN = "Code";
    private static final String IP_NAME_COLUMN = "IP_NAME";
    private static final String IP_DOMAIN_COLUMN = "IP_DOMAIN";
    private static final String IP_ACTIVE_COLUMN = "Active Address";
    private static final String LOW_RES_COLUMN = "LOWRES";
    private static final String HIGH_RES_COLUMN = "HIGHRES";
    private String name = "";
    private String location = "";
    private String site = "";
    private String code = "";
    private String address_space = "";
    private String dhcp_service = "";
    private String network_dhcp_setting = "";
    private String vlan = "";
    private String address_space_dhcp_setting = "";
    private String address_space_group = "";
    private String address_space_comment = "";
    private String dhcp_address = "";
    private String dhcp_address_name = "";
    private FS_Boolean dhcp_address_active = FS_Boolean.EITHER;

    public Network_FS_Parameters() {
        this.INCLUDE_MODIFIED_BY = "displayOrder.txt.17.Modified By";
        this.INCLUDE_MODIFIED = "displayOrder.tst.18.Date Modified";
        this.INCLUDE_CREATED_BY = "displayOrder.txt.19.Created By";
        this.INCLUDE_CREATED = "displayOrder.tst.20.Date Created";
        this.INCLUDE_OWNER = "displayOrder.txt.8.Network Group";
        this.INCLUDE_COMMENT = "displayOrder.txt.10.Comment";
        this.include_fields.put(INCLUDE_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_LOCATION, Boolean.FALSE);
        this.include_fields.put(INCLUDE_SITE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_CODE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADDRESS_SPACE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_SERVICE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_NETWORK_OPTION, Boolean.FALSE);
        this.include_fields.put(INCLUDE_VLAN, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_OPTION, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_GROUP, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_COMMENT, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DHCP_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DHCP_ADDRESS_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ACTIVE_DHCP_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_LOW_RES, Boolean.FALSE);
        this.include_fields.put(INCLUDE_HIGH_RES, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_OWNER, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_COMMENT, Boolean.FALSE);
    }

    public String name() {
        return this.name;
    }

    public Boolean include_name() {
        return (Boolean)this.include_fields.get(INCLUDE_NAME);
    }

    public String location() {
        return this.location;
    }

    public Boolean include_location() {
        return (Boolean)this.include_fields.get(INCLUDE_LOCATION);
    }

    public String site() {
        return this.site;
    }

    public Boolean include_site() {
        return (Boolean)this.include_fields.get(INCLUDE_SITE);
    }

    public String code() {
        return this.code;
    }

    public Boolean include_code() {
        return (Boolean)this.include_fields.get(INCLUDE_CODE);
    }

    public String address_space() {
        return this.address_space;
    }

    public Boolean include_address_space() {
        return (Boolean)this.include_fields.get(INCLUDE_ADDRESS_SPACE);
    }

    public String DHCP_service() {
        return this.dhcp_service();
    }

    public String dhcp_service() {
        return this.dhcp_service;
    }

    public Boolean include_DHCP_service() {
        return this.include_dhcp_service();
    }

    public Boolean include_dhcp_service() {
        return (Boolean)this.include_fields.get(INCLUDE_SERVICE);
    }

    public String network_DHCP_setting() {
        return this.network_dhcp_setting();
    }

    public String network_dhcp_setting() {
        return this.network_dhcp_setting;
    }

    public Boolean include_network_DHCP_setting() {
        return this.include_network_dhcp_setting();
    }

    public Boolean include_network_dhcp_setting() {
        return (Boolean)this.include_fields.get(INCLUDE_NETWORK_OPTION);
    }

    public String VLAN() {
        return this.vlan();
    }

    public String vlan() {
        return this.vlan;
    }

    public Boolean include_VLAN() {
        return this.include_vlan();
    }

    public Boolean include_vlan() {
        return (Boolean)this.include_fields.get(INCLUDE_VLAN);
    }

    public String address_space_DHCP_setting() {
        return this.address_space_dhcp_setting();
    }

    public String address_space_dhcp_setting() {
        return this.address_space_dhcp_setting;
    }

    public Boolean include_address_space_DHCP_setting() {
        return this.include_address_space_dhcp_setting();
    }

    public Boolean include_address_space_dhcp_setting() {
        return (Boolean)this.include_fields.get(INCLUDE_ADDRESS_SPACE_OPTION);
    }

    public String address_space_group() {
        return this.address_space_group;
    }

    public Boolean include_address_space_group() {
        return (Boolean)this.include_fields.get(INCLUDE_ADDRESS_SPACE_GROUP);
    }

    public String address_space_comment() {
        return this.address_space_comment;
    }

    public Boolean include_address_space_comment() {
        return (Boolean)this.include_fields.get(INCLUDE_ADDRESS_SPACE_COMMENT);
    }

    public String DHCP_address() {
        return this.dhcp_address();
    }

    public String dhcp_address() {
        return this.dhcp_address;
    }

    public Boolean include_DHCP_address() {
        return this.include_dhcp_address();
    }

    public Boolean include_dhcp_address() {
        return (Boolean)this.include_fields.get(INCLUDE_DHCP_ADDRESS);
    }

    public String DHCP_address_name() {
        return this.dhcp_address_name();
    }

    public String dhcp_address_name() {
        return this.dhcp_address_name;
    }

    public Boolean include_DHCP_address_name() {
        return this.include_dhcp_address_name();
    }

    public Boolean include_dhcp_address_name() {
        return (Boolean)this.include_fields.get(INCLUDE_DHCP_ADDRESS_NAME);
    }

    public Boolean DHCP_address_active() {
        return this.dhcp_address_active();
    }

    public Boolean dhcp_address_active() {
        return this.dhcp_address_active.value();
    }

    public Boolean include_DHCP_address_active() {
        return this.include_dhcp_address_active();
    }

    public Boolean include_dhcp_address_active() {
        return (Boolean)this.include_fields.get(INCLUDE_ACTIVE_DHCP_ADDRESS);
    }

    public Boolean include_low_res() {
        return (Boolean)this.include_fields.get(INCLUDE_LOW_RES);
    }

    public Boolean include_high_res() {
        return (Boolean)this.include_fields.get(INCLUDE_HIGH_RES);
    }

    public Network_FS_Parameters name(String string) {
        if (string == null) {
            string = "";
        }
        this.name = string;
        return this;
    }

    public Network_FS_Parameters name(String string, Boolean bl) {
        this.name(string);
        this.include_name(bl);
        return this;
    }

    public Network_FS_Parameters include_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NAME, bl);
        return this;
    }

    public Network_FS_Parameters location(String string) {
        if (string == null) {
            string = "";
        }
        this.location = string;
        return this;
    }

    public Network_FS_Parameters location(String string, Boolean bl) {
        this.location(string);
        this.include_location(bl);
        return this;
    }

    public Network_FS_Parameters include_location(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_LOCATION, bl);
        return this;
    }

    public Network_FS_Parameters site(String string) {
        if (string == null) {
            string = "";
        }
        this.site = string;
        return this;
    }

    public Network_FS_Parameters site(String string, Boolean bl) {
        this.site(string);
        this.include_site(bl);
        return this;
    }

    public Network_FS_Parameters include_site(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_SITE, bl);
        return this;
    }

    public Network_FS_Parameters code(String string) {
        if (string == null) {
            string = "";
        }
        this.code = string;
        return this;
    }

    public Network_FS_Parameters code(String string, Boolean bl) {
        this.code(string);
        this.include_code(bl);
        return this;
    }

    public Network_FS_Parameters include_code(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_CODE, bl);
        return this;
    }

    public Network_FS_Parameters address_space(String string) {
        if (string == null) {
            string = "";
        }
        this.address_space = string;
        return this;
    }

    public Network_FS_Parameters address_space(String string, Boolean bl) {
        this.address_space(string);
        this.include_address_space(bl);
        return this;
    }

    public Network_FS_Parameters include_address_space(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADDRESS_SPACE, bl);
        return this;
    }

    public Network_FS_Parameters DHCP_service(String string) {
        return this.dhcp_service(string);
    }

    public Network_FS_Parameters dhcp_service(String string) {
        if (string == null) {
            string = "";
        }
        this.dhcp_service = string;
        return this;
    }

    public Network_FS_Parameters DHCP_service(String string, Boolean bl) {
        return this.dhcp_service(string, bl);
    }

    public Network_FS_Parameters dhcp_service(String string, Boolean bl) {
        this.dhcp_service(string);
        this.include_dhcp_service(bl);
        return this;
    }

    public Network_FS_Parameters include_DHCP_service(Boolean bl) {
        return this.include_dhcp_service(bl);
    }

    public Network_FS_Parameters include_dhcp_service(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_SERVICE, bl);
        return this;
    }

    public Network_FS_Parameters network_DHCP_setting(String string) {
        return this.network_dhcp_setting(string);
    }

    public Network_FS_Parameters network_dhcp_setting(String string) {
        if (string == null) {
            string = "";
        }
        this.network_dhcp_setting = string;
        return this;
    }

    public Network_FS_Parameters network_DHCP_setting(String string, Boolean bl) {
        return this.network_dhcp_setting(string, bl);
    }

    public Network_FS_Parameters network_dhcp_setting(String string, Boolean bl) {
        this.network_dhcp_setting(string);
        this.include_network_dhcp_setting(bl);
        return this;
    }

    public Network_FS_Parameters include_network_DHCP_setting(Boolean bl) {
        return this.include_network_dhcp_setting(bl);
    }

    public Network_FS_Parameters include_network_dhcp_setting(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NETWORK_OPTION, bl);
        return this;
    }

    public Network_FS_Parameters VLAN(String string) {
        return this.vlan(string);
    }

    public Network_FS_Parameters vlan(String string) {
        if (string == null) {
            string = "";
        }
        this.vlan = string;
        return this;
    }

    public Network_FS_Parameters VLAN(String string, Boolean bl) {
        return this.vlan(string, bl);
    }

    public Network_FS_Parameters vlan(String string, Boolean bl) {
        this.vlan(string);
        this.include_vlan(bl);
        return this;
    }

    public Network_FS_Parameters include_VLAN(Boolean bl) {
        return this.include_vlan(bl);
    }

    public Network_FS_Parameters include_vlan(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_VLAN, bl);
        return this;
    }

    public Network_FS_Parameters address_space_DHCP_setting(String string) {
        return this.address_space_dhcp_setting(string);
    }

    public Network_FS_Parameters address_space_dhcp_setting(String string) {
        if (string == null) {
            string = "";
        }
        this.address_space_dhcp_setting = string;
        return this;
    }

    public Network_FS_Parameters address_space_DHCP_setting(String string, Boolean bl) {
        return this.address_space_dhcp_setting(string, bl);
    }

    public Network_FS_Parameters address_space_dhcp_setting(String string, Boolean bl) {
        this.address_space_dhcp_setting(string);
        this.include_address_space_dhcp_setting(bl);
        return this;
    }

    public Network_FS_Parameters include_address_space_DHCP_setting(Boolean bl) {
        return this.include_address_space_dhcp_setting(bl);
    }

    public Network_FS_Parameters include_address_space_dhcp_setting(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_OPTION, bl);
        return this;
    }

    public Network_FS_Parameters address_space_group(String string) {
        if (string == null) {
            string = "";
        }
        this.address_space_group = string;
        return this;
    }

    public Network_FS_Parameters address_space_group(String string, Boolean bl) {
        this.address_space_group(string);
        this.include_address_space_group(bl);
        return this;
    }

    public Network_FS_Parameters include_address_space_group(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_GROUP, bl);
        return this;
    }

    public Network_FS_Parameters address_space_comment(String string) {
        if (string == null) {
            string = "";
        }
        this.address_space_comment = string;
        return this;
    }

    public Network_FS_Parameters address_space_comment(String string, Boolean bl) {
        this.address_space_comment(string);
        this.include_address_space_comment(bl);
        return this;
    }

    public Network_FS_Parameters include_address_space_comment(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADDRESS_SPACE_COMMENT, bl);
        return this;
    }

    public Network_FS_Parameters DHCP_address(String string) {
        return this.dhcp_address(string);
    }

    public Network_FS_Parameters dhcp_address(String string) {
        if (string == null) {
            string = "";
        }
        this.dhcp_address = string;
        return this;
    }

    public Network_FS_Parameters DHCP_address(String string, Boolean bl) {
        return this.dhcp_address(string, bl);
    }

    public Network_FS_Parameters dhcp_address(String string, Boolean bl) {
        this.dhcp_address(string);
        this.include_dhcp_address(bl);
        return this;
    }

    public Network_FS_Parameters include_DHCP_address(Boolean bl) {
        return this.include_dhcp_address(bl);
    }

    public Network_FS_Parameters include_dhcp_address(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DHCP_ADDRESS, bl);
        return this;
    }

    public Network_FS_Parameters DHCP_address_name(String string) {
        return this.dhcp_address_name(string);
    }

    public Network_FS_Parameters dhcp_address_name(String string) {
        if (string == null) {
            string = "";
        }
        this.dhcp_address_name = string;
        return this;
    }

    public Network_FS_Parameters DHCP_address_name(String string, Boolean bl) {
        return this.dhcp_address_name(string, bl);
    }

    public Network_FS_Parameters dhcp_address_name(String string, Boolean bl) {
        this.dhcp_address_name(string);
        this.include_dhcp_address_name(bl);
        return this;
    }

    public Network_FS_Parameters include_DHCP_address_name(Boolean bl) {
        return this.include_dhcp_address_name(bl);
    }

    public Network_FS_Parameters include_dhcp_address_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DHCP_ADDRESS_NAME, bl);
        return this;
    }

    public Network_FS_Parameters DHCP_address_active(Boolean bl) {
        return this.dhcp_address_active(bl);
    }

    public Network_FS_Parameters dhcp_address_active(Boolean bl) {
        this.dhcp_address_active = new FS_Boolean(bl);
        return this;
    }

    public Network_FS_Parameters DHCP_address_active(Boolean bl, Boolean bl2) {
        return this.dhcp_address_active(bl, bl2);
    }

    public Network_FS_Parameters dhcp_address_active(Boolean bl, Boolean bl2) {
        this.dhcp_address_active(bl);
        this.include_dhcp_address_active(bl2);
        return this;
    }

    public Network_FS_Parameters include_DHCP_address_active(Boolean bl) {
        return this.include_dhcp_address_active(bl);
    }

    public Network_FS_Parameters include_dhcp_address_active(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ACTIVE_DHCP_ADDRESS, bl);
        return this;
    }

    public Network_FS_Parameters include_low_res(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_LOW_RES, bl);
        return this;
    }

    public Network_FS_Parameters include_high_res(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_HIGH_RES, bl);
        return this;
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        Hashtable<String, String> hashtable = this.legacy_search_params();
        String string2 = "WITH Records AS ( SELECT unique(id) record_id FROM ";
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        String string3 = hashtable.get("txt.NetDHCPoptions");
        if (string3 != null && string3.trim().length() > 0) {
            hashtable.put("fs.FS_NetworkDHCPoptions.txt.lower(dhcp_option)", string3.replaceAll("#", "#hsh").replaceAll("\\\\\\\\", "&bsl;").replaceAll("\\\\=", "#eql").replaceAll("&bsl;", "\\\\\\\\"));
        }
        if ((string3 = hashtable.get("txt.ASDHCPoptions")) != null && string3.trim().length() > 0) {
            hashtable.put("fs.FS_AddressSpace.txt.lower(dhcp_option)", string3.replaceAll("#", "#hsh").replaceAll("\\\\\\\\", "&bsl;").replaceAll("\\\\=", "#eql").replaceAll("&bsl;", "\\\\\\\\"));
        }
        Vector<Exception> vector2 = new Vector<Exception>();
        string2 = string2 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String string4 = "\nSELECT DISTINCT id \"ID\", to_char(id) \"handle\", AS_PREFIX, IP_AS_PREFIX, IPADDRESS_TXT";
        String string5 = "";
        if (!(hashtable.get(INCLUDE_LOCATION).equals("-1") && hashtable.get(INCLUDE_SITE).equals("-1") && hashtable.get(INCLUDE_CODE).equals("-1"))) {
            string5 = ", LOCATION";
        }
        string4 = string4 + (hashtable.get(INCLUDE_NAME).equals("-1") ? "" : ", NAME_ID, NET_NAME, NET_DOMAIN") + string5 + (hashtable.get(INCLUDE_SERVICE).equals("-1") ? "" : ", dhcp_service \"Service\"") + (hashtable.get(this.INCLUDE_OWNER).equals("-1") ? "" : ", owner \"Network Group\"") + (hashtable.get(INCLUDE_VLAN).equals("-1") ? "" : ", vlan \"VLAN\"") + (hashtable.get(this.INCLUDE_COMMENT).equals("-1") ? "" : ", comments \"Comment\"");
        if (!hashtable.get(INCLUDE_ADDRESS_SPACE).equals("-1") || !hashtable.get(INCLUDE_ADDRESS_SPACE_COMMENT).equals("-1")) {
            hashtable2.put("FS_AddressSpaceInfo", "");
        }
        if (!hashtable.get(INCLUDE_NETWORK_OPTION).equals("-1")) {
            string4 = string4 + ", net_dhcp_option \"Network DHCPoption\"";
            hashtable2.put("FS_NetworkDHCPoptionsInfo", "");
        }
        if (!hashtable.get(INCLUDE_ADDRESS_SPACE_OPTION).equals("-1")) {
            string4 = string4 + ", AS_DHCP_OPTION";
            hashtable2.put("FS_AddressSpaceInfo", "");
        }
        if (!hashtable.get(INCLUDE_ADDRESS_SPACE_GROUP).equals("-1")) {
            string4 = string4 + ", AS_OWNER";
            hashtable2.put("FS_AddressSpaceOwnerInfo", "");
        }
        string4 = string4 + (hashtable.get(INCLUDE_ADDRESS_SPACE_COMMENT).equals("-1") ? "" : ", AS_COMMENTS") + (hashtable.get(INCLUDE_SITE).equals("-1") ? "" : ", site \"Site\"") + (hashtable.get(INCLUDE_CODE).equals("-1") ? "" : ", code \"Code\"");
        if (!hashtable.get(INCLUDE_DHCP_ADDRESS).equals("-1")) {
            hashtable2.put("FS_AddressSpaceIPaddressInfo", "");
        }
        if (!hashtable.get(INCLUDE_DHCP_ADDRESS_NAME).equals("-1")) {
            string4 = string4 + ", IP_NAME, IP_DOMAIN";
            hashtable2.put("FS_AddressSpaceIPaddressInfo", "");
        }
        if (!hashtable.get(INCLUDE_ACTIVE_DHCP_ADDRESS).equals("-1")) {
            string4 = string4 + ", ip_active \"Active Address\"";
            hashtable2.put("FS_AddressSpaceIPaddressInfo", "");
        }
        if (!hashtable.get(INCLUDE_LOW_RES).equals("-1")) {
            string4 = string4 + ", trim(lowres) LOWRES";
            hashtable2.put("FS_AddressSpaceInfo", "");
        }
        if (!hashtable.get(INCLUDE_HIGH_RES).equals("-1")) {
            string4 = string4 + ", trim(highres) HIGHRES";
            hashtable2.put("FS_AddressSpaceInfo", "");
        }
        string4 = string4 + this.modBlock(hashtable);
        hashtable2.put("FS_NetworkInfo", "");
        Enumeration enumeration = hashtable2.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string2 = string2 + string4 + " FROM " + enumeration.nextElement() + " JOIN Records on ID = Records.record_id";
            if (n + 1 < hashtable2.size()) {
                string2 = string2 + "\nUNION";
            }
            ++n;
        }
        return string2;
    }

    @Override
    protected Vector<Network> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        int n19 = -1;
        int n20 = -1;
        int n21 = -1;
        int n22 = -1;
        int n23 = -1;
        int n24 = -1;
        int n25 = -1;
        int n26 = -1;
        int n27 = -1;
        int n28 = -1;
        int n29 = 0;
        for (String object2 : result_Hash.get_vector("column_names")) {
            if (object2.equals(ID_COLUMN)) {
                n = n29;
            } else if (object2.equals(HANDLE_COLUMN)) {
                n2 = n29;
            } else if (object2.equals(AS_PREFIX_COLUMN)) {
                n3 = n29;
            } else if (object2.equals(IP_AS_PREFIX_COLUMN)) {
                n4 = n29;
            } else if (object2.equals(ADDRESS_TXT_COLUMN)) {
                n5 = n29;
            } else if (object2.equals(NAME_ID_COLUMN)) {
                n6 = n29;
            } else if (object2.equals(NET_NAME_COLUMN)) {
                n7 = n29;
            } else if (object2.equals(NET_DOMAIN_COLUMN)) {
                n8 = n29;
            } else if (object2.equals(LOCATION_COLUMN)) {
                n9 = n29;
            } else if (object2.equals(SERVICE_COLUMN)) {
                n10 = n29;
            } else if (object2.equals(NETWORK_GROUP_COLUMN)) {
                n11 = n29;
            } else if (object2.equals(VLAN_COLUMN)) {
                n12 = n29;
            } else if (object2.equals(COMMENT_COLUMN)) {
                n13 = n29;
            } else if (object2.equals(NETWORK_DHCP_OPTION_COLUMN)) {
                n14 = n29;
            } else if (object2.equals(AS_DHCP_OPTION_COLUMN)) {
                n15 = n29;
            } else if (object2.equals(AS_OWNER_COLUMN)) {
                n16 = n29;
            } else if (object2.equals(AS_COMMENT_COLUMN)) {
                n17 = n29;
            } else if (object2.equals(SITE_COLUMN)) {
                n18 = n29;
            } else if (object2.equals(CODE_COLUMN)) {
                n19 = n29;
            } else if (object2.equals(IP_NAME_COLUMN)) {
                n20 = n29;
            } else if (object2.equals(IP_DOMAIN_COLUMN)) {
                n21 = n29;
            } else if (object2.equals(IP_ACTIVE_COLUMN)) {
                n22 = n29;
            } else if (object2.equals(LOW_RES_COLUMN)) {
                n23 = n29;
            } else if (object2.equals(HIGH_RES_COLUMN)) {
                n24 = n29;
            } else if (object2.equals("Modified By")) {
                n25 = n29;
            } else if (object2.equals("Date Modified")) {
                n26 = n29;
            } else if (object2.equals("Created By")) {
                n27 = n29;
            } else if (object2.equals("Date Created")) {
                n28 = n29;
            } else {
                netDB_Datastore.logger().severe("'" + object2 + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n29;
        }
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Address_Space> hashtable2 = new Hashtable<String, Address_Space>();
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        Vector<Network> vector = new Vector<Network>();
        for (Vector vector2 : (Vector)result_Hash.get("resultSet")) {
            Attribute attribute;
            Object object;
            Object object2;
            String string;
            Object n32;
            Network network = null;
            Address_Space address_Space = null;
            BigDecimal bigDecimal = (BigDecimal)vector2.get(n);
            int n30 = -1;
            if (bigDecimal != null) {
                n30 = bigDecimal.intValue();
            }
            if ((network = (Network)hashtable.get(n30)) == null) {
                network = new Network(netDB_Datastore);
                network.flag_as_system_created();
                network.id(n30);
                vector.add(network);
                hashtable.put(n30, network);
            }
            String string2 = "";
            if (n3 != -1 || n4 != -1) {
                string2 = (String)vector2.get(n3);
                if (string2 == null) {
                    string2 = (String)vector2.get(n4);
                }
                if (string2 != null && (address_Space = (Address_Space)hashtable2.get(string2)) == null) {
                    address_Space = new Address_Space(netDB_Datastore, new Prefix(string2));
                    address_Space.flag_as_system_created();
                    hashtable2.put(string2, address_Space);
                    network.add_address_space(address_Space);
                }
                network.flag_field_as_defined(Field.ADDRESS_SPACE);
            }
            if (address_Space != null) {
                if (n5 != -1) {
                    int string3 = 0;
                    n32 = new IP_Address(netDB_Datastore);
                    ((IP_Address)n32).flag_as_system_created();
                    string = (String)vector2.get(n5);
                    if (string != null) {
                        ++string3;
                        ((IP_Address)n32).address(new IPaddress(string));
                    }
                    if (n20 != -1 && n21 != -1) {
                        object2 = (String)vector2.get(n20);
                        object = (String)vector2.get(n21);
                        if (object2 != null && object != null) {
                            ++string3;
                            attribute = new A_Name(netDB_Datastore, (String)object2, (String)object);
                            ((A_Name)attribute).flag_as_system_created();
                            ((IP_Address)n32).add_name((A_Name)attribute);
                        }
                        ((IP_Address)n32).flag_field_as_defined(Field.NAME);
                    }
                    if (n22 != -1) {
                        object2 = (String)vector2.get(n22);
                        if (object2 != null) {
                            ++string3;
                            object = true;
                            if (!((String)object2).toLowerCase().equals("yes")) {
                                object = false;
                            }
                            ((IP_Address)n32).active((Boolean)object);
                        }
                        ((IP_Address)n32).flag_field_as_defined(Field.ACTIVE);
                    }
                    if (string3 > 0) {
                        object2 = (IP_Pool)hashtable3.get(string2);
                        if (object2 == null) {
                            object2 = new IP_Pool(netDB_Datastore);
                            ((IP_Pool)object2).flag_as_system_created();
                            hashtable3.put(string2, object2);
                            address_Space.add_pool((IP_Pool)object2);
                        }
                        ((IP_Pool)object2).add_address((IP_Address)n32);
                    }
                }
                if (n15 != -1) {
                    String string4 = (String)vector2.get(n15);
                    if (string4 != null) {
                        int n34 = string4.indexOf("=");
                        string = "";
                        object2 = "";
                        if (n34 == -1) {
                            string = string4;
                        } else {
                            string = string4.substring(0, n34);
                            object2 = string4.substring(n34 + 1, string4.length());
                        }
                        object = new DHCP_Option(netDB_Datastore, string);
                        attribute = new DHCP_Setting((DHCP_Option)object);
                        ((NetDB)object).flag_as_system_created();
                        if (object2 != null && !((String)object2).equals("")) {
                            ((DHCP_Setting)attribute).value((String)object2);
                        }
                        address_Space.add_dhcp_setting((DHCP_Setting)attribute);
                    }
                    address_Space.flag_field_as_defined(Field.DHCP_SETTING);
                }
                if (n16 != -1) {
                    String string5 = (String)vector2.get(n16);
                    if (string5 != null) {
                        string5 = string5.trim();
                        n32 = new Group(netDB_Datastore, string5);
                        ((NetDB)n32).flag_as_system_created();
                        address_Space.grant_access((Group)n32);
                    }
                    address_Space.flag_field_as_defined(Field.OWNER);
                }
                if (n17 != -1) {
                    String string6 = (String)vector2.get(n17);
                    if (string6 != null && string6.length() > 0) {
                        address_Space.comment(string6);
                    }
                    address_Space.flag_field_as_defined(Field.COMMENT);
                }
                if (n23 != -1) {
                    String string7 = (String)vector2.get(n23);
                    if (string7 != null) {
                        address_Space.low_res(new BigInteger(string7));
                    }
                    address_Space.flag_field_as_defined(Field.LOW_RES);
                }
                if (n24 != -1) {
                    String bigDecimal2 = (String)vector2.get(n24);
                    if (bigDecimal2 != null) {
                        address_Space.high_res(new BigInteger(bigDecimal2));
                    }
                    address_Space.flag_field_as_defined(Field.HIGH_RES);
                }
            }
            if (n6 != -1 && n7 != -1 && n8 != -1) {
                BigDecimal n33 = (BigDecimal)vector2.get(n6);
                n32 = (String)vector2.get(n7);
                string = (String)vector2.get(n8);
                if (n33 != null && n32 != null && string != null) {
                    object2 = new A_Name(netDB_Datastore);
                    ((A_Name)object2).flag_as_system_created();
                    ((Name)object2).id(new Integer(n33.intValue()));
                    ((Name)object2).name((String)n32);
                    ((Name)object2).domain(string);
                    network.add_name((A_Name)object2);
                }
                network.flag_field_as_defined(Field.NAME);
            }
            if (n9 != -1 || n18 != -1 || n19 != -1) {
                int string8 = 0;
                n32 = new Location(netDB_Datastore);
                ((NetDB)n32).flag_as_system_created();
                if (n9 != -1) {
                    string = (String)vector2.get(n9);
                    if (string != null && (string = string.trim()).length() > 0) {
                        ++string8;
                        ((Location)n32).name(string);
                    }
                    ((Location)n32).flag_field_as_defined(Field.NAME);
                }
                if (n18 != -1) {
                    string = (String)vector2.get(n18);
                    if (string != null && (string = string.trim()).length() > 0) {
                        ++string8;
                        ((Location)n32).site(string);
                    }
                    ((Location)n32).flag_field_as_defined(Field.SITE);
                }
                if (n19 != -1) {
                    string = (String)vector2.get(n19);
                    if (string != null && (string = string.trim()).length() > 0) {
                        ++string8;
                        ((Location)n32).code(string);
                    }
                    ((Location)n32).flag_field_as_defined(Field.CODE);
                }
                if (string8 > 0) {
                    network.add_location((Location)n32);
                }
                network.flag_field_as_defined(Field.LOCATION);
            }
            if (n10 != -1) {
                String string9 = (String)vector2.get(n10);
                if (string9 != null && !string9.equals("")) {
                    n32 = new DHCP_Service(netDB_Datastore, string9);
                    ((NetDB)n32).flag_as_system_created();
                    network.dhcp_service((DHCP_Service)n32);
                }
                network.flag_field_as_defined(Field.DHCP_SERVICE);
            }
            if (n11 != -1) {
                String bigDecimal3 = (String)vector2.get(n11);
                if (bigDecimal3 != null && (bigDecimal3 = bigDecimal3.trim()).length() > 0) {
                    n32 = new Group(netDB_Datastore, bigDecimal3);
                    ((NetDB)n32).flag_as_system_created();
                    network.add_owner((Group)n32);
                }
                network.flag_field_as_defined(Field.OWNER);
            }
            if (n12 != -1) {
                BigDecimal string10 = (BigDecimal)vector2.get(n12);
                if (string10 != null) {
                    network.vlan(new Integer(string10.intValue()));
                }
                network.flag_field_as_defined(Field.VLAN);
            }
            if (n13 != -1) {
                String string11 = (String)vector2.get(n13);
                if (string11 != null && (string11 = string11.trim()).length() > 0) {
                    network.comment(string11);
                }
                network.flag_field_as_defined(Field.COMMENT);
            }
            if (n14 != -1) {
                String string3 = (String)vector2.get(n14);
                if (string3 != null) {
                    int n31 = string3.indexOf("=");
                    string = "";
                    object2 = "";
                    if (n31 == -1) {
                        string = string3;
                    } else {
                        string = string3.substring(0, n31);
                        object2 = string3.substring(n31 + 1, string3.length());
                    }
                    object = new DHCP_Option(netDB_Datastore, string);
                    attribute = new DHCP_Setting((DHCP_Option)object);
                    ((NetDB)object).flag_as_system_created();
                    if (object2 != null && !((String)object2).equals("")) {
                        ((DHCP_Setting)attribute).value((String)object2);
                    }
                    network.add_dhcp_setting((DHCP_Setting)attribute);
                }
                network.flag_field_as_defined(Field.DHCP_SETTING);
            }
            super.process_common_results(network, vector2, n26, n25, n28, n27);
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected String child_params() {
        String string = "";
        return string;
    }

    public Hashtable<String, String> legacy_search_params() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_NetworkInfo");
        for (String string : this.include_fields.keySet()) {
            String string2 = "-1";
            if (((Boolean)this.include_fields.get(string)).booleanValue()) {
                string2 = "1";
            }
            hashtable.put(string, string2);
        }
        hashtable.put("fs.FS_NameNetwork.txt.fullname_lc", this.name);
        hashtable.put("fs.FS_NetworkInfo.txt.lower(location)", this.location.toLowerCase());
        hashtable.put("fs.FS_NetworkInfo.txt.lower(site)", this.site.toLowerCase());
        hashtable.put("fs.FS_NetworkInfo.txt.lower(code)", this.code.toLowerCase());
        hashtable.put("fs.FS_AddressSpace.ip.address", this.address_space);
        hashtable.put("fs.FS_NetworkInfo.txt.lower(dhcp_service)", this.dhcp_service.toLowerCase());
        hashtable.put("txt.NetDHCPoptions", this.network_dhcp_setting);
        hashtable.put("fs.FS_NetworkInfo.txt.vlan", this.vlan);
        hashtable.put("txt.ASDHCPoptions", this.address_space_dhcp_setting);
        hashtable.put("fs.FS_AddressSpaceOwner.txt.lower(owner)", this.address_space_group.toLowerCase());
        hashtable.put("fs.FS_AddressSpace.txt.lower(comments)", this.address_space_comment.toLowerCase());
        hashtable.put("fs.FS_NetworkIPaddresses.ip.IPaddress", this.dhcp_address);
        hashtable.put("fs.FS_NetworkIPaddresses.txt.fullname_lc", this.dhcp_address_name);
        hashtable.put("fs.FS_NetworkIPaddresses.rb.b.active", this.dhcp_address_active.sql_string());
        super.legacy_search_params(hashtable);
        hashtable.put("fs.FS_NetworkInfo.txt.lower(owner)", this.owner.toLowerCase());
        hashtable.put("fs.FS_NetworkInfo.txt.lower(comments)", this.comment.toLowerCase());
        return hashtable;
    }
}

