/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Hashtable;
import stanford.netdb.Domain_Name;
import stanford.netdb.Field;
import stanford.netdb.MX;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Action_Not_Permitted;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.util.TZ_Timestamp;

public abstract class Name<T extends Name>
extends NetDB<T> {
    private static final long serialVersionUID = 1L;
    public static String template_name = "templates/toString/name.tmpl";
    protected Integer id = null;
    protected String name = null;
    protected String domain = null;
    private TZ_Timestamp reserved = null;
    private Integer reserved_by = null;

    protected Name() {
        this.init();
    }

    protected Name(String string) {
        this.init(string);
    }

    protected Name(String string, String string2) {
        this.init(string, string2);
    }

    protected Name(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected Name(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    protected Name(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(Name.get_host(string), Name.get_domain(string));
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.domain(string2);
        }
    }

    protected Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Name.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Name.name");
        return this.name;
    }

    public String domain() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.domain, NetDB.unset_string, "Name.domain");
        return this.domain;
    }

    public String full_name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Name.generate_full_name(this.name(), this.domain());
    }

    public Boolean is_reserved() {
        if (this.reserved != null) {
            return true;
        }
        return false;
    }

    protected abstract String dns_type();

    @Override
    public String handle() {
        return Name.generate_full_name(this.name, this.domain);
    }

    protected T id(Integer n) {
        this.id = n;
        return (T)this;
    }

    public T name(String string) {
        if (this.name != null && !NetDB.unset_string.equals(this.name) && (string == null || string != null && !string.toLowerCase().equals(this.name))) {
            this.unbind();
        }
        this.name = string;
        return (T)this;
    }

    public T domain(String string) {
        return this.domain(string, true);
    }

    protected T domain(String string, Boolean bl) {
        if (bl.booleanValue() && this.domain != null && !NetDB.unset_string.equals(this.domain) && (string == null || string != null && !string.toLowerCase().equals(this.domain))) {
            this.unbind();
        }
        this.domain = string;
        return (T)this;
    }

    public T full_name(String string, String string2) {
        this.name(string);
        this.domain(string2);
        return (T)this;
    }

    public T full_name(String string) {
        this.name(Name.get_host(string));
        this.domain(Name.get_domain(string));
        return (T)this;
    }

    @Override
    public T unlink() {
        super.unlink();
        this.id = null;
        return (T)this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        this.id = ((Name)netDB).id;
        this.name = ((Name)netDB).name;
        this.domain = ((Name)netDB).domain;
        this.reserved = ((Name)netDB).reserved;
        this.reserved_by = ((Name)netDB).reserved_by;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.domain;
    }

    @Override
    protected void initialize_member_data() {
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.domain == null) {
            this.domain = NetDB.unset_string;
        }
        if (this.reserved == null) {
            this.reserved = NetDB.unset_tz_timestamp;
        }
        if (this.reserved_by == null) {
            this.reserved_by = NetDB.unset_integer;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.DOMAIN) {
            if (NetDB.unset_string.equals(this.domain)) {
                this.domain = null;
            }
        } else if (field == Field.RESERVED) {
            if (this.reserved == NetDB.unset_tz_timestamp) {
                this.reserved = null;
            }
        } else if (field == Field.RESERVED_BY && this.reserved_by == NetDB.unset_integer) {
            this.reserved_by = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.domain)) {
            this.domain = null;
        }
        if (this.reserved == NetDB.unset_tz_timestamp) {
            this.reserved = null;
        }
        if (this.reserved_by == NetDB.unset_integer) {
            this.reserved_by = null;
        }
    }

    public static String generate_full_name(String string, String string2) {
        if (string == null && string2 == null) {
            return "";
        }
        String string3 = "";
        String string4 = "";
        if (string != null) {
            string3 = string.trim();
        }
        if (string2 != null) {
            string4 = string2.trim();
        }
        if (string3.equals("") && string4.equals("")) {
            return "";
        }
        String string5 = string3 + "." + string4;
        if ((string5 = string5.replaceAll("\\.+$", "")).equals("")) {
            return ".";
        }
        return string5;
    }

    protected static String get_host(String string) {
        int n = string.indexOf(".");
        if (n <= 0) {
            return string;
        }
        return string.substring(0, n);
    }

    protected static String get_domain(String string) {
        int n = string.indexOf(".");
        if (n <= 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "name", this, bl);
    }

    protected Name extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        this.name((String)hashtable.get("name"));
        hashtable.remove("name");
        this.domain((String)hashtable.get("domain"));
        hashtable.remove("domain");
        NetDB.unhandled_keys(hashtable, "Name.extract");
        return this;
    }

    protected void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    protected Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.verify_or_die(string, this.dns_type());
    }

    protected Integer verify_or_die(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Integer n = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n = this.datastore.remote_name().verify_or_die(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.datastore.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n = Name._verify_or_die("", this.datastore, string, string2);
        }
        return n;
    }

    public Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore) throws Exception {
        this.id = Name._verify_or_die(string, netDB_Datastore, this.handle(), this.dns_type());
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, String string2, String string3) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = false;
        Integer n = null;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n = netDB_Datastore.name().verify_or_die(string, string2, string3, (Boolean)true);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n;
    }

    @Override
    protected T complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (T)this;
    }

    public T reserve() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.reserve(this.get_datastore());
    }

    public abstract T reserve(NetDB_Datastore var1) throws Exception, No_Datastore_Defined, Insufficient_Information;

    protected T reserve(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Timestamp timestamp;
        String string3;
        this.bind(netDB_Datastore);
        if (this.name == null) {
            throw Insufficient_Information.missing_information("name");
        }
        if (this.domain == null) {
            throw Insufficient_Information.missing_information("domain");
        }
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_name().reserve(this.name, this.domain, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Name._reserve(string, netDB_Datastore, this.name, this.domain, string2);
        }
        if ((string3 = (String)hashtable.get("id")) != null) {
            this.id(Integer.parseInt(string3));
        }
        this.reserved = (timestamp = (Timestamp)hashtable.get("reserved")) != null ? new TZ_Timestamp(timestamp) : null;
        this.reserved_by = netDB_Datastore.operating_user().id();
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _reserve(String string, NetDB_Datastore netDB_Datastore, String string2, String string3, String string4) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        Hashtable hashtable = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            hashtable = netDB_Datastore.name().reserve(string, string2, string3, string4);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else if (bl2.booleanValue()) {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return hashtable;
    }

    public T unreserve() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.unreserve(this.get_datastore());
    }

    public abstract T unreserve(NetDB_Datastore var1) throws Exception, No_Datastore_Defined, Insufficient_Information;

    protected T unreserve(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_name().cancel(this.id, this.name, this.domain, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            Name._unreserve(netDB_Datastore, this.id, this.name, this.domain, string);
        }
        this.reserved = null;
        this.reserved_by = null;
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _unreserve(NetDB_Datastore netDB_Datastore, Integer n, String string, String string2, String string3) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string4 = "";
        try {
            string4 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (n != null && n != NetDB.unset_integer) {
                netDB_Datastore.name().cancel(string4, n, string3);
            } else if (string != null && string2 != null) {
                netDB_Datastore.name().cancel(string4, Name.generate_full_name(string, string2), string3);
            } else {
                throw new Insufficient_Information("There isn't any data in the Name.");
            }
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string4);
                } else {
                    netDB_Datastore.end_transaction(string4);
                }
            }
        }
    }

    protected T accept(String string, NetDB_Datastore netDB_Datastore, Record_Type record_Type, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        this.bind(netDB_Datastore);
        if (this.created_by_user().booleanValue()) {
            netDB_Datastore.name().accept(string, this.full_name(), record_Type.toString(), n, timestamp);
            this.id = Name._verify_or_die(string, netDB_Datastore, this.full_name(), this.dns_type());
        }
        return (T)this;
    }

    protected T accept(String string, NetDB_Datastore netDB_Datastore, Record_Type record_Type, String string2, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        this.bind(netDB_Datastore);
        if (this.created_by_user().booleanValue()) {
            netDB_Datastore.name().accept(string, this.full_name(), record_Type.toString(), string2, timestamp);
            this.id = Name._verify_or_die(string, netDB_Datastore, this.full_name(), this.dns_type());
        }
        return (T)this;
    }

    protected T delete(String string, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Action_Not_Permitted {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (this instanceof MX) {
            throw new Action_Not_Permitted("Name.delete (...) is unable to delete an MX.  Call MX.delete (...) instead.");
        }
        if (!this.created_by_user().booleanValue()) {
            netDB_Datastore.name().delete(string, timestamp, this.full_name(), this.dns_type());
            this.flag_as_modified().flag_as_user_created();
        }
        return (T)this;
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, T t, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.created_by_user().booleanValue()) {
            this.accept(string, netDB_Datastore, record_Type, n, timestamp);
            this.full_name(netDB_Datastore.name().fullname(string, this.id));
        }
        if (this instanceof MX) {
            ((MX)this).commit(string, netDB_Datastore, (MX)t, n, timestamp, record_Type);
        } else if (this instanceof Domain_Name) {
            ((Domain_Name)this).commit(string, netDB_Datastore, (Domain_Name)t, n, timestamp, record_Type);
        }
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, T t, String string2, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.created_by_user().booleanValue()) {
            this.accept(string, netDB_Datastore, record_Type, string2, timestamp);
            this.full_name(netDB_Datastore.name().fullname(string, this.id));
        }
        if (this instanceof MX) {
            ((MX)this).commit(string, netDB_Datastore, (MX)t, string2, timestamp, record_Type);
        } else if (this instanceof Domain_Name) {
            ((Domain_Name)this).commit(string, netDB_Datastore, (Domain_Name)t, string2, timestamp, record_Type);
        }
    }
}

