/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Make;
import stanford.netdb.Model_Type;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public final class Model
extends Record<Model> {
    public static String template_name = "templates/toString/model.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private Make make = null;
    private Model_Type model_type = null;
    private Person modified_by = null;
    private Timestamp modified = null;

    public Model() {
        this.init();
    }

    public Model(String string, String string2) {
        this.init(string, string2);
    }

    public Model(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Model(String string, Make make) {
        this.init(string, make);
    }

    public Model(String string, Make make, Model_Type model_Type) {
        this.init(string, make, model_Type);
    }

    public Model(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, Make make) {
        super(netDB_Datastore);
        this.init(string, make);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, Make make, Model_Type model_Type) {
        super(netDB_Datastore);
        this.init(string, make, model_Type);
    }

    private void init() {
        this.init((String)null, (Make)null, (Model_Type)null);
    }

    private void init(String string, String string2) {
        this.init(string, new Make(string2), null);
    }

    private void init(String string, String string2, String string3) {
        this.init(string, new Make(string2), new Model_Type(string3));
    }

    private void init(String string, Make make) {
        this.init(string, make, null);
    }

    private void init(String string, Make make, Model_Type model_Type) {
        this.init(string, make, model_Type, null, null);
    }

    private void init(String string, Make make, Model_Type model_Type, Person person, Timestamp timestamp) {
        if (string != null) {
            this.name(string);
        }
        if (make != null) {
            this.make(make);
        }
        if (model_Type != null) {
            this.model_type(model_Type);
        }
        if (person != null) {
            this.modified_by(person);
        }
        if (timestamp != null) {
            this.modified(timestamp);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Model.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Model.name");
        return this.name;
    }

    public Make make() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.make, NetDB.unset_make, "Model.make");
        return this.make;
    }

    public Model_Type model_type() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.model_type, NetDB.unset_model_type, "Model.model_type");
        return this.model_type;
    }

    private Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "Model.modified_by");
        return this.modified_by;
    }

    private Timestamp modified() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified, NetDB.unset_timestamp, "Model.modified");
        return this.modified;
    }

    @Override
    public String handle() {
        return this.make.handle() + " " + this.name;
    }

    public Model name(String string) {
        this.name = string;
        return this;
    }

    public Model make(String string) {
        return this.make(new Make(string));
    }

    public Model make(Make make) {
        this.make = make;
        return this;
    }

    public Model model_type(String string) {
        return this.model_type(new Model_Type(string));
    }

    public Model model_type(Model_Type model_Type) {
        this.model_type = model_Type;
        return this;
    }

    private Model modified_by(Person person) {
        this.modified_by = person;
        return this;
    }

    private Model modified(Timestamp timestamp) {
        this.modified = timestamp;
        return this;
    }

    @Override
    public Model unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((Model)netDB).id;
        this.name = ((Model)netDB).name;
        this.make = ((Model)netDB).make;
        this.model_type = ((Model)netDB).model_type;
        this.modified_by = ((Model)netDB).modified_by;
        this.modified = ((Model)netDB).modified;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        String string2 = "";
        if (this.make != null) {
            string = this.make.single_value_attributes();
        }
        if (string2 != null) {
            string2 = this.model_type.single_value_attributes();
        }
        return this.name + " " + string + " " + string2;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.make == null) {
            this.make = NetDB.unset_make;
        }
        if (this.model_type == null) {
            this.model_type = NetDB.unset_model_type;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
        if (this.modified == null) {
            this.modified = NetDB.unset_timestamp;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.MAKE) {
            if (this.make == NetDB.unset_make) {
                this.make = null;
            }
        } else if (field == Field.MODEL_TYPE) {
            if (this.model_type == NetDB.unset_model_type) {
                this.model_type = null;
            }
        } else if (field == Field.MODIFIED_BY) {
            if (this.modified_by == NetDB.unset_person) {
                this.modified_by = null;
            }
        } else if (field == Field.MODIFIED_AT && this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (this.make == NetDB.unset_make) {
            this.make = null;
        }
        if (this.model_type == NetDB.unset_model_type) {
            this.model_type = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
        if (this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "model", this, bl);
    }

    protected static Model extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Model model = new Model(netDB_Datastore);
        model.flag_as_system_created();
        model.extract(hashtable);
        return model;
    }

    protected Model extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        String string = (String)hashtable.get("id");
        if (string != null) {
            this.id = Integer.parseInt(string);
        }
        hashtable.remove("id");
        this.name((String)hashtable.get("model"));
        hashtable.remove("model");
        this.make((String)hashtable.get("make"));
        hashtable.remove("make");
        this.model_type((String)hashtable.get("type"));
        hashtable.remove("type");
        this.make.flag_as_system_created();
        this.model_type.flag_as_system_created();
        NetDB.unhandled_keys(hashtable, "Model.extract");
        return this;
    }

    protected Boolean extract_make_and_model(String string) {
        int n = 0;
        Boolean bl = false;
        while (!bl.booleanValue() && n != -1) {
            n = string.indexOf(" ", n);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                this.verify_or_die(string2, string3);
                Make make = new Make(this.datastore);
                make.flag_as_system_created();
                make.name(string2);
                this.name(string3);
                this.make(make);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n <= 0) continue;
            ++n;
        }
        return bl;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.make.handle(), this.name);
    }

    private Integer verify_or_die(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        return Model.verify_or_die(this.datastore, string, string2);
    }

    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Integer n = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n = netDB_Datastore.remote_model().verify_or_die(null, string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            n = Model._verify_or_die("", netDB_Datastore, null, string, string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2, String string3) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            if ((n2 = n == null ? netDB_Datastore.model().verify_or_die(string, string2, string3) : (string2 == null ? netDB_Datastore.model().verify_or_die(string, n) : netDB_Datastore.model().verify_or_die(string, n, string2, string3))) == null) {
                throw new Record_Not_Found("'" + string2 + " " + string3 + "' was not found in the database.");
            }
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.MODEL);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.MODEL);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.MODEL);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.MODEL);
    }

    public static Model load(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Model.load(NetDB.default_datastore(), string, string2);
    }

    public static Model load(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Model model = new Model(netDB_Datastore);
        model.load_object(netDB_Datastore, string, string2);
        return model;
    }

    protected void load_object(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_model().info(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Model._load_object("", netDB_Datastore, string, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2, String string3) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            if (string3 == null || string3.trim().equals("") || string2 == null || string2.trim().equals("")) {
                throw Insufficient_Information.missing_handle();
            }
            Integer n = Model._verify_or_die(string, netDB_Datastore, null, string2, string3);
            Hashtable hashtable2 = netDB_Datastore.model().list(string3);
            if (hashtable2 != null) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    Hashtable hashtable3 = (Hashtable)hashtable2.get(string4);
                    if (!new Integer((String)hashtable3.get("id")).equals(n)) continue;
                    hashtable = hashtable3;
                    break;
                }
            }
            if (hashtable == null) {
                throw new Record_Not_Found("'" + string2 + " " + string3 + "' was not found in the database.");
            }
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    @Override
    protected void load_object(String string, String string2) throws Not_Implemented {
        throw new Not_Implemented("This class cannot be loaded with this method.");
    }

    public static Collection<Model> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(NetDB.default_datastore());
    }

    public static Collection<Model> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(NetDB.default_datastore(), string);
    }

    public static Collection<Model> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(netDB_Datastore, null);
    }

    public static Collection<Model> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Model> vector = new Vector<Model>();
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_model().list(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Model._list(netDB_Datastore, string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Model model = Model.extract(netDB_Datastore, (Hashtable)hashtable.get(string2));
                model.flag_as_loaded();
                vector.add(model);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.model().list(string2, string) : netDB_Datastore.model().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Model.delete(netDB_Datastore, this.make().name(), this.name);
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Model.delete(NetDB.default_datastore(), string, string2);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_model().delete(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            Model._delete(netDB_Datastore, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.model().delete(string3, Model._verify_or_die(string3, netDB_Datastore, null, string, string2));
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string3);
                } else {
                    netDB_Datastore.end_transaction(string3);
                }
            }
        }
    }

    @Override
    public Model commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.make, "make");
        Model model = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                model = netDB_Datastore.remote_model().commit(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            model = this._commit(netDB_Datastore);
        }
        if (model != null) {
            this.deep_update(netDB_Datastore, model);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model _commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (this.created_by_user().booleanValue()) {
                Hashtable hashtable = null;
                hashtable = this.model_type != null ? netDB_Datastore.model().insert(string, this.make.handle(), this.name, this.model_type.handle()) : netDB_Datastore.model().insert(string, this.make.handle(), this.name);
                this.id = new Integer((String)hashtable.get("id"));
            } else {
                this.verify_or_die();
                if (this.model_type != null) {
                    netDB_Datastore.model().update(string, this.id, this.make.handle(), this.name, this.model_type.handle());
                } else {
                    netDB_Datastore.model().update(string, this.id, this.make.handle(), this.name);
                }
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    public Model supplant(Model model) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.created_by_user().booleanValue()) {
            throw new Exception("You must load the record that is being supplanted.");
        }
        this.verify_or_die();
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_model().supplant(this.id, model.make().handle(), model.name());
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = Model._supplant(this.datastore, this.id, model.make().handle(), model.name());
        }
        if (bl.booleanValue()) {
            this.flag_as_user_created().flag_as_modified();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _supplant(NetDB_Datastore netDB_Datastore, Integer n, String string, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.model().supplant(string3, n, string, string2);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string3);
                } else {
                    netDB_Datastore.end_transaction(string3);
                }
            }
        }
        return bl;
    }
}

