/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Hashtable;
import stanford.netdb.Field;
import stanford.netdb.Name;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;

public final class MX
extends Name<MX> {
    public static String template_name = "templates/toString/mx.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final MX EMPTY = new MX();
    private static final String DNS_TYPE = "MX";
    private Integer pref = new Integer(10);

    protected MX() {
        this.init();
    }

    public MX(String string) {
        super(string);
        this.init();
    }

    public MX(String string, String string2) {
        super(string, string2);
        this.init();
    }

    public MX(String string, Integer n) {
        super(string);
        this.init(n);
    }

    public MX(String string, String string2, Integer n) {
        super(string, string2);
        this.init(n);
    }

    protected MX(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public MX(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore, string);
        this.init();
    }

    public MX(NetDB_Datastore netDB_Datastore, String string, Integer n) {
        super(netDB_Datastore, string);
        this.init(n);
    }

    public MX(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore, string, string2);
        this.init();
    }

    public MX(NetDB_Datastore netDB_Datastore, String string, String string2, Integer n) {
        super(netDB_Datastore, string, string2);
        this.init(n);
    }

    public MX(String string, int n) {
        this(string, new Integer(n));
    }

    public MX(String string, String string2, int n) {
        this(string, string2, new Integer(n));
    }

    public MX(NetDB_Datastore netDB_Datastore, String string, int n) {
        this(netDB_Datastore, string, new Integer(n));
    }

    public MX(NetDB_Datastore netDB_Datastore, String string, String string2, int n) {
        this(netDB_Datastore, string, string2, new Integer(n));
    }

    private void init() {
        this.init(null);
    }

    private void init(Integer n) {
        if (n != null) {
            this.pref(n);
        }
    }

    public Integer pref() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.pref, NetDB.unset_integer, "MX.pref");
        return this.pref;
    }

    @Override
    protected String dns_type() {
        return DNS_TYPE;
    }

    public MX pref(Integer n) {
        this.pref = n;
        return this;
    }

    public MX pref(int n) {
        return this.pref(new Integer(n));
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.pref = ((MX)netDB).pref;
    }

    @Override
    public String single_value_attributes() {
        return super.single_value_attributes() + " " + this.pref;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.pref == null) {
            this.pref = NetDB.unset_integer;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.PREF && this.pref == NetDB.unset_integer) {
            this.pref = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.pref == NetDB.unset_integer) {
            this.pref = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Name.toString(fORMAT, template_name, "mx", this, bl);
    }

    protected static MX extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        MX mX = new MX(netDB_Datastore);
        mX.flag_as_system_created();
        mX.extract(hashtable);
        return mX;
    }

    @Override
    protected MX extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        super.extract(hashtable);
        String string = (String)hashtable.get("pref");
        if (string != null) {
            this.pref(Integer.parseInt(string));
        }
        hashtable.remove("pref");
        NetDB.unhandled_keys(hashtable, "MX.extract");
        return this;
    }

    @Override
    public MX reserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (MX)super.reserve("", netDB_Datastore, DNS_TYPE);
    }

    protected MX reserve(String string, NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (MX)super.reserve(string, netDB_Datastore, DNS_TYPE);
    }

    @Override
    public MX unreserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (MX)super.unreserve(netDB_Datastore, DNS_TYPE);
    }

    @Override
    protected MX accept(String string, NetDB_Datastore netDB_Datastore, Record_Type record_Type, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        if (this.created_by_user().booleanValue()) {
            netDB_Datastore.name().accept(string, this.full_name(), record_Type.toString(), n, timestamp, this.pref);
            this.id = MX._verify_or_die(string, netDB_Datastore, this.full_name(), this.dns_type());
            this.full_name(netDB_Datastore.name().fullname(string, this.id));
        }
        return this;
    }

    @Override
    protected MX accept(String string, NetDB_Datastore netDB_Datastore, Record_Type record_Type, String string2, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        if (this.created_by_user().booleanValue()) {
            netDB_Datastore.name().accept(string, this.full_name(), record_Type.toString(), string2, timestamp, this.pref);
            this.id = MX._verify_or_die(string, netDB_Datastore, this.full_name(), this.dns_type());
            this.full_name(netDB_Datastore.name().fullname(string, this.id));
        }
        return this;
    }

    protected Name delete(String string, Timestamp timestamp, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        netDB_Datastore.mx().delete(string, timestamp, this.full_name(), string2);
        this.flag_as_modified().flag_as_user_created();
        return this;
    }

    @Override
    protected void commit(String string, NetDB_Datastore netDB_Datastore, MX mX, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.accept(string, netDB_Datastore, record_Type, n, timestamp);
        if (this.compare(mX) != 0) {
            netDB_Datastore.mx().update(string, timestamp, this.full_name(), n, this.pref);
        }
        this.flag_as_system_created().flag_as_loaded();
    }

    @Override
    protected void commit(String string, NetDB_Datastore netDB_Datastore, MX mX, String string2, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.accept(string, netDB_Datastore, record_Type, string2, timestamp);
        if (this.compare(mX) != 0) {
            netDB_Datastore.mx().update(string, timestamp, this.full_name(), string2, this.pref);
        }
        this.flag_as_system_created().flag_as_loaded();
    }
}

