/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import stanford.netdb.Admin_Team;
import stanford.netdb.Domain;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.Lockable;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network;
import stanford.netdb.Node;
import stanford.netdb.Person;
import stanford.netdb.State;
import stanford.netdb.User;
import stanford.netdb.exceptions.Data_Missing;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;

public final class Log_Entry
extends NetDB {
    public static String template_name = "templates/toString/log_entry.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer internal_id = null;
    private NetDB_Datastore datastore = null;
    private Timestamp date_of_action = null;
    private Integer record_id = null;
    private State node_state = null;
    private Person user = null;
    private RECORD_TYPE record_type = null;
    private ACTION action = null;
    private Vector<String> record_names = new Vector();
    private Vector<IPaddress> ip_addresses = new Vector();

    protected Log_Entry(NetDB_Datastore netDB_Datastore, Integer n) {
        this.datastore = netDB_Datastore;
        this.internal_id = n;
    }

    @Override
    public String handle() {
        if (this.internal_id != null) {
            return this.internal_id.toString();
        }
        return null;
    }

    public Timestamp date() throws Data_Missing {
        this.has_data(this.date_of_action, NetDB.unset_timestamp, "date_of_action");
        return this.date_of_action;
    }

    public Collection<String> record_name() throws Data_Missing {
        this.has_data(this.record_names, NetDB.unset_string_vector, "record_names");
        return this.record_names;
    }

    public Integer recordID() throws Data_Missing {
        return this.record_id();
    }

    public Integer record_id() throws Data_Missing {
        this.has_data(this.record_id, NetDB.unset_integer, "record_id");
        return this.record_id;
    }

    public RECORD_TYPE record_type() throws Data_Missing {
        this.has_data((Object)this.record_type, null, "record_type");
        return this.record_type;
    }

    public Collection<IPaddress> IP_address() throws Data_Missing {
        return this.ip_address();
    }

    public Collection<IPaddress> ip_address() throws Data_Missing {
        this.has_data(this.ip_addresses, NetDB.unset_ip_vector, "ip_addresses");
        Collections.sort(this.ip_addresses, IPaddress.ZERO);
        return this.ip_addresses;
    }

    public State node_state() throws Data_Missing {
        this.has_data(this.node_state, NetDB.unset_state, "node_state");
        return this.node_state;
    }

    public Person user() throws Data_Missing {
        this.has_data(this.user, NetDB.unset_person, "user");
        return this.user;
    }

    public String user_name() {
        String string = "";
        try {
            string = this.user.name();
        }
        catch (Exception exception) {
            this.datastore.logger().finest("An exception was ignored while fetching the user name:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    public String user_netID() {
        return this.user_netid();
    }

    public String user_netid() {
        String string = "";
        try {
            string = this.user.netid();
        }
        catch (Exception exception) {
            this.datastore.logger().finest("An exception was ignored while fetching the user netid: \n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    public ACTION action() throws Data_Missing {
        this.has_data((Object)this.action, null, "action");
        return this.action;
    }

    private void has_data(Object object, Object object2, String string) throws Data_Missing {
        if (object == object2) {
            throw new Data_Missing("'" + string + "' is not available.");
        }
    }

    protected Log_Entry date(Timestamp timestamp) {
        this.date_of_action = timestamp;
        return this;
    }

    protected Log_Entry add_record_name(String string) {
        if (this.record_names == NetDB.unset_string_vector) {
            this.record_names = new Vector();
        }
        if (!this.record_names.contains(string)) {
            this.record_names.add(string);
        }
        return this;
    }

    protected Log_Entry record_id(Integer n) {
        this.record_id = n;
        return this;
    }

    protected Log_Entry record_type(RECORD_TYPE rECORD_TYPE) {
        this.record_type = rECORD_TYPE;
        return this;
    }

    protected Log_Entry add_ip_address(IPaddress iPaddress) {
        if (this.ip_addresses == NetDB.unset_ip_vector) {
            this.ip_addresses = new Vector();
        }
        Boolean bl = false;
        for (IPaddress iPaddress2 : this.ip_addresses) {
            if (!iPaddress2.equals(iPaddress)) continue;
            bl = true;
            break;
        }
        if (!bl.booleanValue()) {
            this.ip_addresses.add(iPaddress);
        }
        return this;
    }

    protected Log_Entry node_state(State state) {
        this.node_state = state;
        return this;
    }

    protected Log_Entry user(String string) {
        this.user = new Person(this.datastore, string);
        return this;
    }

    protected Log_Entry action(ACTION aCTION) {
        this.action = aCTION;
        return this;
    }

    private Lockable load_record() throws Exception {
        return this.load_record(false);
    }

    private Lockable load_record(Boolean bl) throws Exception {
        Lockable lockable = null;
        if (this.record_type == RECORD_TYPE.ADMIN_TEAM) {
            lockable = new Admin_Team(this.datastore);
        } else if (this.record_type == RECORD_TYPE.DOMAIN) {
            lockable = new Domain(this.datastore);
        } else if (this.record_type == RECORD_TYPE.NETWORK) {
            lockable = new Network(this.datastore);
        } else if (this.record_type == RECORD_TYPE.NODE) {
            lockable = new Node(this.datastore);
        } else if (this.record_type == RECORD_TYPE.GROUP) {
            lockable = new Group(this.datastore);
        } else if (this.record_type == RECORD_TYPE.USER) {
            lockable = new User(this.datastore);
        }
        lockable.id(this.record_id);
        if (bl.booleanValue()) {
            lockable.lock_record();
        }
        lockable.complete_object();
        return lockable;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "log_entry", this, bl);
    }

    protected Log_Entry complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        throw new Not_Implemented("This class cannot be completed.");
    }

    @Override
    protected void initialize_member_data() {
        if (this.date_of_action == null) {
            this.date_of_action = NetDB.unset_timestamp;
        }
        if (this.record_id == null) {
            this.record_id = NetDB.unset_integer;
        }
        if (this.node_state == null) {
            this.node_state = NetDB.unset_state;
        }
        if (this.user == null) {
            this.user = NetDB.unset_person;
        }
        if (this.record_names == null) {
            this.record_names = NetDB.unset_string_vector;
        }
        if (this.ip_addresses == null) {
            this.ip_addresses = NetDB.unset_ip_vector;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.DATE_OF_ACTION) {
            if (this.date_of_action == NetDB.unset_timestamp) {
                this.date_of_action = null;
            }
        } else if (field == Field.ID) {
            if (this.record_id == NetDB.unset_integer) {
                this.record_id = null;
            }
        } else if (field == Field.STATE) {
            if (this.node_state == NetDB.unset_state) {
                this.node_state = null;
            }
        } else if (field == Field.USER) {
            if (this.user == NetDB.unset_person) {
                this.user = null;
            }
        } else if (field == Field.NAME) {
            if (this.record_names == NetDB.unset_string_vector) {
                this.record_names = null;
            }
        } else if (field == Field.ADDRESS && this.ip_addresses == NetDB.unset_ip_vector) {
            this.ip_addresses = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.date_of_action == NetDB.unset_timestamp) {
            this.date_of_action = null;
        }
        if (this.record_id == NetDB.unset_integer) {
            this.record_id = null;
        }
        if (this.node_state == NetDB.unset_state) {
            this.node_state = null;
        }
        if (this.user == NetDB.unset_person) {
            this.user = null;
        }
        if (this.record_names == NetDB.unset_string_vector) {
            this.record_names = null;
        }
        if (this.ip_addresses == NetDB.unset_ip_vector) {
            this.ip_addresses = null;
        }
    }

    @Override
    public String single_value_attributes() {
        return "";
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
    }

    public static enum RECORD_TYPE {
        ADMIN_TEAM("admin_team", "Admin Team"),
        DOMAIN("domain", "Domain"),
        NETWORK("network", "Network"),
        NODE("node", "Node"),
        GROUP("owner", "Owner"),
        USER("user", "User");

        String fs_value = "";
        String display_value = "";

        private RECORD_TYPE(String string2, String string3) {
            this.fs_value = string2;
            this.display_value = string3;
        }

        public String fs_value() {
            return this.fs_value;
        }

        protected String display_value() {
            return this.display_value;
        }

        public String toString() {
            return this.display_value;
        }

        public static RECORD_TYPE find(String string) {
            if (RECORD_TYPE.ADMIN_TEAM.fs_value.equals(string) || RECORD_TYPE.ADMIN_TEAM.display_value.equals(string)) {
                return ADMIN_TEAM;
            }
            if (RECORD_TYPE.DOMAIN.fs_value.equals(string) || RECORD_TYPE.DOMAIN.display_value.equals(string)) {
                return DOMAIN;
            }
            if (RECORD_TYPE.NETWORK.fs_value.equals(string) || RECORD_TYPE.NETWORK.display_value.equals(string)) {
                return NETWORK;
            }
            if (RECORD_TYPE.NODE.fs_value.equals(string) || RECORD_TYPE.NODE.display_value.equals(string)) {
                return NODE;
            }
            if (RECORD_TYPE.GROUP.fs_value.equals(string) || RECORD_TYPE.GROUP.display_value.equals(string)) {
                return GROUP;
            }
            if (RECORD_TYPE.USER.fs_value.equals(string) || RECORD_TYPE.USER.display_value.equals(string)) {
                return USER;
            }
            return null;
        }
    }

    public static enum ACTION {
        INSERT("cb.i.Add", "insert"),
        DELETE("cb.i.Delete", "delete"),
        UPDATE("cb.i.Update", "update");

        String fs_field = "";
        String fs_value = "";

        private ACTION(String string2, String string3) {
            this.fs_field = string2;
            this.fs_value = string3;
        }

        protected String fs_field() {
            return this.fs_field;
        }

        protected String fs_value() {
            return this.fs_value;
        }

        public String toString() {
            return this.fs_value;
        }

        public static ACTION find(String string) {
            if (ACTION.INSERT.fs_value.equals(string) || ACTION.INSERT.fs_field.equals(string)) {
                return INSERT;
            }
            if (ACTION.DELETE.fs_value.equals(string) || ACTION.DELETE.fs_field.equals(string)) {
                return DELETE;
            }
            if (ACTION.UPDATE.fs_value.equals(string) || ACTION.UPDATE.fs_field.equals(string)) {
                return UPDATE;
            }
            return null;
        }
    }
}

