/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Record;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.util.TZ_Timestamp;

public abstract class Lockable<T extends Lockable>
extends Record<T> {
    private static final long serialVersionUID = 1L;
    private TZ_Timestamp lock = null;
    private User locked_by = null;
    private Person created_by = null;
    private Person modified_by = null;
    private Timestamp created = null;
    private Timestamp modified = null;
    protected Multi_Value_Attribute<Group> groups = null;

    protected Lockable() {
    }

    protected Lockable(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
    }

    protected Timestamp lock() {
        return this.lock;
    }

    public Timestamp locked_at() {
        return this.lock;
    }

    public User locked_by() {
        return this.locked_by;
    }

    public Boolean is_locked() {
        if (this.lock == null || this.lock == NetDB.unset_tz_timestamp) {
            return false;
        }
        return true;
    }

    public Person created_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.created_by, NetDB.unset_person, "Lockable.created_by");
        return this.created_by;
    }

    public Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "Lockable.modified_by");
        return this.modified_by;
    }

    public Timestamp created_at() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.created, NetDB.unset_timestamp, "Lockable.created");
        return this.created;
    }

    public Timestamp modified_at() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified, NetDB.unset_timestamp, "Lockable.modified");
        return this.modified;
    }

    public Collection<Group> owners() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.groups, NetDB.unset_mva_group, "Lockable.owners");
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.groups.all_values();
    }

    protected abstract T id(Integer var1);

    protected T lock(Timestamp timestamp) {
        this.lock = timestamp != null ? new TZ_Timestamp(timestamp) : null;
        return (T)this;
    }

    protected T locked_by(User user) {
        this.locked_by = user;
        return (T)this;
    }

    protected T locked_by(int n, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        User user = new User(this.datastore, n, string);
        user.flag_as_system_created();
        return this.locked_by(user);
    }

    protected T modified_by(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.modified_by = new Person(netDB_Datastore, string);
        return (T)this;
    }

    protected T created_by(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.created_by = new Person(netDB_Datastore, string);
        return (T)this;
    }

    protected T modified_at(Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.modified = timestamp;
        return (T)this;
    }

    protected T created_at(Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.created = timestamp;
        return (T)this;
    }

    @Override
    public T unbind() {
        this.unbind_children(this.groups);
        return (T)((Lockable)super.unbind());
    }

    @Override
    public T unlink() {
        try {
            if (this.is_locked().booleanValue()) {
                this.unlock();
            }
        }
        catch (Exception exception) {
            this.logger().fine("Failed to unlock record: " + exception.getMessage());
        }
        this.unlink_children(this.groups);
        this.created_by = null;
        this.created = null;
        this.modified_by = null;
        this.modified = null;
        return (T)((Lockable)super.unlink());
    }

    public T add_owner(Group group) throws Exception {
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            this.groups = new Multi_Value_Attribute();
        }
        this.groups.add(group);
        return (T)this;
    }

    public T add_owners(Collection<Group> collection) throws Exception {
        for (Group group : collection) {
            this.add_owner(group);
        }
        return (T)this;
    }

    public T remove_owner(Group group) {
        if (this.groups != null) {
            this.groups.remove(group, (Boolean)true);
        }
        return (T)this;
    }

    public T remove_owners(Collection<Group> collection) {
        for (Group group : collection) {
            this.remove_owner(group);
        }
        return (T)this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        Lockable lockable = null;
        if (!(netDB instanceof Lockable)) {
            return;
        }
        lockable = (Lockable)netDB;
        this.lock = lockable.lock;
        this.locked_by = lockable.locked_by;
        this.created_by = lockable.created_by;
        this.modified_by = lockable.modified_by;
        this.created = lockable.created;
        this.modified = lockable.modified;
        if (this.groups != NetDB.unset_mva_group) {
            for (Group group : this.owners()) {
                group.deep_update(netDB_Datastore, lockable.owners());
            }
        }
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.lock == null) {
            this.lock = NetDB.unset_tz_timestamp;
        }
        if (this.locked_by == null) {
            this.locked_by = NetDB.unset_user;
        }
        if (this.created_by == null) {
            this.created_by = NetDB.unset_person;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
        if (this.created == null) {
            this.created = NetDB.unset_timestamp;
        }
        if (this.modified == null) {
            this.modified = NetDB.unset_timestamp;
        }
        if (this.groups == null) {
            this.groups = NetDB.unset_mva_group;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.LOCK) {
            if (this.lock == NetDB.unset_tz_timestamp) {
                this.lock = null;
            }
        } else if (field == Field.LOCKED_BY) {
            if (this.locked_by == NetDB.unset_user) {
                this.locked_by = null;
            }
        } else if (field == Field.CREATED_BY) {
            if (this.created_by == NetDB.unset_person) {
                this.created_by = null;
            }
        } else if (field == Field.MODIFIED_BY) {
            if (this.modified_by == NetDB.unset_person) {
                this.modified_by = null;
            }
        } else if (field == Field.CREATED_AT) {
            if (this.created == NetDB.unset_timestamp) {
                this.created = null;
            }
        } else if (field == Field.MODIFIED_AT) {
            if (this.modified == NetDB.unset_timestamp) {
                this.modified = null;
            }
        } else if (field == Field.OWNER && this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.lock == NetDB.unset_tz_timestamp) {
            this.lock = null;
        }
        if (this.locked_by == NetDB.unset_user) {
            this.locked_by = null;
        }
        if (this.created_by == NetDB.unset_person) {
            this.created_by = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
        if (this.created == NetDB.unset_timestamp) {
            this.created = null;
        }
        if (this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
        if (this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    protected Lockable extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (hashtable == null) {
            return this;
        }
        if (hashtable.containsKey("created")) {
            this.created = (Timestamp)hashtable.get("created");
            hashtable.remove("created");
        }
        if (hashtable.containsKey("modified")) {
            this.modified = (Timestamp)hashtable.get("modified");
            hashtable.remove("modified");
        }
        if (hashtable.containsKey("created.by")) {
            this.created_by = Person.extract(this.datastore, (Hashtable)hashtable.get("created.by"));
            hashtable.remove("created.by");
        }
        if (hashtable.containsKey("mod.by")) {
            this.modified_by = Person.extract(this.datastore, (Hashtable)hashtable.get("mod.by"));
            hashtable.remove("mod.by");
        }
        NetDB.unhandled_keys(hashtable, "Lockable.extract");
        return this;
    }

    protected abstract Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information;

    public abstract T unlock() throws Exception, No_Datastore_Defined;

    protected void clear_lock() {
        this.lock(null);
        this.locked_by(null);
    }

    @Override
    public T bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        try {
            if (this.datastore != null && !this.datastore.equals(netDB_Datastore).booleanValue()) {
                this.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.bind(netDB_Datastore);
        return (T)this;
    }

    public abstract T commit(NetDB_Datastore var1, Boolean var2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found;

    public T commit(Boolean bl) throws Exception, Not_Implemented, No_Datastore_Defined, Insufficient_Information {
        return this.commit(this.get_datastore(), bl);
    }

    @Override
    public T commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return this.commit(netDB_Datastore, true);
    }

    @Override
    public T commit() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return this.commit(this.get_datastore(), true);
    }
}

