/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public class Location
extends Record<Location> {
    public static String template_name = "templates/toString/location.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String site = null;
    private String code = null;

    public Location() {
        this.init();
    }

    public Location(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Location(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Location(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    private void init() {
        this.init(null, null, null);
    }

    private void init(String string, String string2, String string3) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.site(string2);
        }
        if (string3 != null) {
            this.code(string3);
        }
    }

    protected Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Location.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Location.name");
        return this.name;
    }

    public String site() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.site, NetDB.unset_string, "Location.site");
        return this.site;
    }

    public String code() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.code, NetDB.unset_string, "Location.code");
        return this.code;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public Location name(String string) {
        this.name = string;
        return this;
    }

    public Location site(String string) {
        this.site = string;
        return this;
    }

    public Location code(String string) {
        this.code = string;
        return this;
    }

    @Override
    public Location unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((Location)netDB).id;
        this.name = ((Location)netDB).name;
        this.site = ((Location)netDB).site;
        this.code = ((Location)netDB).code;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.site + " " + this.code;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.site == null) {
            this.site = NetDB.unset_string;
        }
        if (this.code == null) {
            this.code = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.SITE) {
            if (NetDB.unset_string.equals(this.site)) {
                this.site = null;
            }
        } else if (field == Field.CODE && NetDB.unset_string.equals(this.code)) {
            this.code = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.site)) {
            this.site = null;
        }
        if (NetDB.unset_string.equals(this.code)) {
            this.code = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "location", this, bl);
    }

    protected static Location extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Location location = new Location(netDB_Datastore);
        location.flag_as_system_created();
        location.extract(hashtable);
        return location;
    }

    protected Location extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        if (hashtable.containsKey("location_id")) {
            this.id = (Integer)hashtable.get("location_id");
            hashtable.remove("location_id");
        }
        if (hashtable.containsKey("location")) {
            this.name((String)hashtable.get("location"));
            hashtable.remove("location");
        }
        if (hashtable.containsKey("site")) {
            this.site((String)hashtable.get("site"));
            hashtable.remove("site");
        }
        if (hashtable.containsKey("code")) {
            this.code((String)hashtable.get("code"));
            hashtable.remove("code");
        }
        if (this.name == null || this.name.trim().equals("") || this.name.equals(NetDB.unset_string)) {
            this.name((String)hashtable.get("name"));
            hashtable.remove("name");
        }
        NetDB.unhandled_keys(hashtable, "Location.extract");
        return this;
    }

    protected String handle(Integer n) throws Exception, No_Datastore_Defined {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                string = this.datastore.remote_location().handle(n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            string = Location._handle(this.datastore, n);
        }
        this.name = this.name;
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = "";
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.location().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.verify_or_die(null, null, string);
    }

    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, Integer n, String string) throws Exception {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (n != null && n != NetDB.unset_integer) {
            return n;
        }
        Integer n2 = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = netDB_Datastore.remote_location().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            n2 = Location._verify_or_die("", netDB_Datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.location().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.location().verify_or_die(string, n) : netDB_Datastore.location().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.LOCATION);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.LOCATION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.LOCATION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.LOCATION);
    }

    public static Location load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Location.load(NetDB.default_datastore(), string);
    }

    public static Location load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Location.load("", netDB_Datastore, string);
    }

    private static Location load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Location location = new Location(netDB_Datastore);
        location.load_object(string, string2);
        return location;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Set set;
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_location().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = Location._load_object(string, this.datastore, string2);
        }
        if ((set = hashtable.keySet()).size() > 1) {
            throw new Exception("Expected one result, '" + set.size() + "' found.");
        }
        for (String string3 : set) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            this.extract((Hashtable)hashtable.get(string3));
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            Integer n = Location._verify_or_die(string, netDB_Datastore, null, string2);
            hashtable = netDB_Datastore.location().list(string, string2);
            ((Hashtable)hashtable.get(string2)).put("location_id", n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    public static Collection<Location> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(NetDB.default_datastore());
    }

    public static Collection<Location> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(NetDB.default_datastore(), string);
    }

    public static Collection<Location> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(netDB_Datastore, null);
    }

    protected static Collection<Location> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_location().list(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Location._list(netDB_Datastore, string);
        }
        Vector<Location> vector = new Vector<Location>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Location location = Location.extract(netDB_Datastore, (Hashtable)hashtable.get(string2));
                vector.add(location);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.location().list(string2, string) : netDB_Datastore.location().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Location.delete(netDB_Datastore, this.handle());
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Location.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = false;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_location().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Location._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Integer n = Location._verify_or_die(string2, netDB_Datastore, null, string);
            netDB_Datastore.location().delete(string2, n);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
        return bl;
    }

    @Override
    public Location commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.name, "name");
        Insufficient_Information.defined_or_die(this.site, "site");
        Insufficient_Information.defined_or_die(this.code, "code");
        Location location = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                location = netDB_Datastore.remote_location().commit(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            location = this._commit(netDB_Datastore);
        }
        if (location != null) {
            this.deep_update(netDB_Datastore, location);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location _commit(NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Location location = null;
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (this.created_by_user().booleanValue()) {
                location = new Location();
                Hashtable hashtable = netDB_Datastore.location().insert(string, this.name, this.site, this.code);
                this.id = new Integer((String)hashtable.get("id"));
            } else {
                location = Location.load(string, netDB_Datastore, netDB_Datastore.location().handle(string, this.id));
                if (this.compare(location) != 0) {
                    netDB_Datastore.location().update(string, this.id, this.name, this.site, this.code);
                }
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }
}

