/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public final class Interface_Type
extends Record<Interface_Type> {
    public static String template_name = "templates/toString/interface_type.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT = "Ethernet";
    private String name = null;
    private String comment = "";

    public Interface_Type() {
        this.init();
    }

    public Interface_Type(String string) {
        this.init(string);
    }

    public Interface_Type(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Interface_Type(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(string, null);
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Interface_Type.name");
        return this.name;
    }

    private String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Interface_Type.comment");
        return this.comment;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public Interface_Type name(String string) {
        this.name = string;
        return this;
    }

    private Interface_Type comment(String string) {
        this.comment = string;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.name = ((Interface_Type)netDB).name;
        this.comment = ((Interface_Type)netDB).comment;
    }

    @Override
    public String single_value_attributes() {
        return this.name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT && NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "interface_type", this, bl);
    }

    protected String verify_or_die(String string) throws Exception {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string2 = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                string2 = this.datastore.remote_interface_type().verify_or_die(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            string2 = Interface_Type._verify_or_die(this.datastore, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _verify_or_die(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string2 = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string2 = netDB_Datastore.interface_type().verify_or_die(string3, string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string3);
        }
        return string2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.INTERFACE_TYPE);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.INTERFACE_TYPE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.INTERFACE_TYPE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.INTERFACE_TYPE);
    }

    public static Interface_Type load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Interface_Type.load(NetDB.default_datastore(), string);
    }

    public static Interface_Type load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Interface_Type.load("", netDB_Datastore, string);
    }

    private static Interface_Type load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Interface_Type interface_Type = new Interface_Type(netDB_Datastore);
        interface_Type.load_object(string, string2);
        return interface_Type;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        this.name = this.verify_or_die(string2);
        this.flag_as_system_created().flag_as_loaded();
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Interface_Type.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Interface_Type commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

