/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP_Address;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Interface_Type;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Node;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.ssparser.SSparser;

public final class Interface
extends NetDB<Interface> {
    public static String template_name = "templates/toString/interface.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final Interface EMPTY = new Interface();
    private Integer id = null;
    private Interface_Type type = null;
    private Integer node = null;
    private Boolean roam = null;
    private Boolean dhcp = null;
    private String hardware_address = null;
    private String comment = null;
    private Multi_Value_Attribute<DHCP_Setting> settings = null;
    private Multi_Value_Attribute<A_Name> names = null;
    private Multi_Value_Attribute<Interface_IP_Address> addresses = null;

    public Interface() {
        this.init();
    }

    public Interface(Interface_Type interface_Type, Boolean bl, Boolean bl2) {
        this.init(interface_Type, bl, bl2);
    }

    public Interface(Interface_Type interface_Type, Boolean bl, Boolean bl2, String string, String string2) throws Exception {
        this.init(interface_Type, bl, bl2, string, string2);
    }

    public Interface(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Interface(NetDB_Datastore netDB_Datastore, Interface_Type interface_Type, Boolean bl, Boolean bl2) {
        super(netDB_Datastore);
        this.init(interface_Type, bl, bl2);
    }

    public Interface(NetDB_Datastore netDB_Datastore, Interface_Type interface_Type, Boolean bl, Boolean bl2, String string, String string2) throws Exception {
        super(netDB_Datastore);
        this.init(interface_Type, bl, bl2, string, string2);
    }

    private void init() {
        try {
            this.init(null, null, null, null, null);
        }
        catch (Exception exception) {
            this.logger().info("Ignoring exception: " + exception.getMessage());
        }
    }

    private void init(Interface_Type interface_Type, Boolean bl, Boolean bl2) {
        try {
            this.init(interface_Type, bl, bl2, null, null);
        }
        catch (Exception exception) {
            this.logger().info("Ignoring exception: " + exception.getMessage());
        }
    }

    private void init(Interface_Type interface_Type, Boolean bl, Boolean bl2, String string, String string2) throws Exception {
        if (interface_Type != null) {
            this.type(interface_Type);
        }
        if (bl != null) {
            this.roaming(bl);
        }
        if (bl2 != null) {
            this.dhcp(bl2);
        }
        if (string != null) {
            this.hardware_address(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
    }

    protected Integer id() {
        return this.id;
    }

    public Interface_Type type() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.type, NetDB.unset_interface_type, "Interface.type");
        return this.type;
    }

    public Integer node() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.node, NetDB.unset_integer, "Interface.node");
        return this.node;
    }

    public Boolean can_roam() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.roam();
    }

    public Boolean roam() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.roam, NetDB.unset_boolean, "Interface.roam");
        return this.roam;
    }

    public boolean is_DHCP_enabled() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp();
    }

    public Boolean is_dhcp_enabled() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp();
    }

    public boolean DHCP() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp();
    }

    public boolean dhcp() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.dhcp, NetDB.unset_boolean, "Interface.dhcp");
        return this.dhcp;
    }

    public String hardware_address() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.hardware_address, NetDB.unset_string, "Interface.hardware_address");
        return this.hardware_address;
    }

    public String pretty_hardware_address() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.pretty_hardware_address(4, ".");
    }

    public String pretty_hardware_address(int n, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        String string2 = this.hardware_address();
        String string3 = "";
        if (string2 == null || "".equals(string2) || NetDB.unset_string.equals(string2)) {
            return "";
        }
        if (n <= 0) {
            return string2;
        }
        for (int i = 0; i < string2.length(); i += n) {
            int n2 = i + n;
            String string4 = "";
            string4 = n2 < string2.length() ? string2.substring(i, n2) : string2.substring(i);
            if (i > 0) {
                string4 = string + string4;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Interface.comment");
        return this.comment;
    }

    public Collection<DHCP_Setting> DHCP_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp_settings();
    }

    public Collection<DHCP_Setting> dhcp_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.settings, NetDB.unset_mva_dhcp_setting, "Interface.settings");
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.settings.all_values();
    }

    public Collection<A_Name> names() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.names, NetDB.unset_mva_a_name, "Interface.names");
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.names.all_values();
    }

    public Collection<Interface_IP_Address> addresses() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.addresses, NetDB.unset_mva_interface_ip, "Interface.addresses");
        if (this.addresses == null || this.addresses == NetDB.unset_mva_interface_ip) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.addresses.all_values();
    }

    @Override
    public String handle() {
        if (this.hardware_address != null && !this.hardware_address.equals(NetDB.unset_string)) {
            return this.hardware_address;
        }
        if (this.addresses != null && this.addresses != NetDB.unset_mva_interface_ip && this.addresses.size() > 0) {
            try {
                return ((Interface_IP_Address)((Vector)this.addresses.all_values()).firstElement()).address().toString();
            }
            catch (Exception exception) {
            }
        } else if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    @Override
    public String unique_identifier() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    protected Interface id(Integer n) {
        this.id = n;
        return this;
    }

    public Interface type(Interface_Type interface_Type) {
        this.type = interface_Type;
        return this;
    }

    protected Interface node(Integer n) {
        this.node = n;
        return this;
    }

    public Interface roaming(Boolean bl) {
        this.roam = bl;
        return this;
    }

    public Interface DHCP(Boolean bl) {
        return this.dhcp(bl);
    }

    public Interface dhcp(Boolean bl) {
        this.dhcp = bl;
        return this;
    }

    public Interface hardware_address(String string) throws Exception {
        if (string == null || string.trim().equals("")) {
            this.hardware_address = null;
        } else if (string != null) {
            block6: {
                try {
                    Hashtable<String, String> hashtable = SSparser.parse(string);
                    this.hardware_address = hashtable.get("hw");
                }
                catch (Exception exception) {
                    if (exception.getMessage().contains("bad IP address")) break block6;
                    throw exception;
                }
            }
            if (this.hardware_address == null) {
                throw new Exception("Hardware address '" + string + "' is malformed.");
            }
        }
        return this;
    }

    public Interface comment(String string) {
        this.comment = string;
        return this;
    }

    public Interface add_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.add_dhcp_setting(dHCP_Setting);
    }

    public Interface add_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = new Multi_Value_Attribute();
        }
        this.settings.add(dHCP_Setting);
        return this;
    }

    public Interface add_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.add_dhcp_settings(collection);
    }

    public Interface add_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Interface remove_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.remove_dhcp_setting(dHCP_Setting);
    }

    public Interface remove_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings != null) {
            this.settings.remove(dHCP_Setting, (Boolean)true);
        }
        return this;
    }

    public Interface remove_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.remove_dhcp_settings(collection);
    }

    public Interface remove_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Interface add_name(A_Name a_Name) {
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            this.names = new Multi_Value_Attribute();
        }
        a_Name.flag_as_user_created();
        this.names.add(a_Name);
        return this;
    }

    public Interface add_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_name(iterator.next());
        }
        return this;
    }

    public Interface remove_name(A_Name a_Name) {
        if (this.names != null) {
            this.names.remove(a_Name, (Boolean)true);
        }
        return this;
    }

    public Interface remove_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_name(iterator.next());
        }
        return this;
    }

    public Interface add_address(Interface_IP_Address interface_IP_Address) {
        if (this.addresses == null || this.addresses == NetDB.unset_mva_interface_ip) {
            this.addresses = new Multi_Value_Attribute();
        }
        this.addresses.add(interface_IP_Address);
        return this;
    }

    public Interface add_addresses(Collection<Interface_IP_Address> collection) {
        Iterator<Interface_IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_address(iterator.next());
        }
        return this;
    }

    public Interface remove_address(Interface_IP_Address interface_IP_Address) {
        if (this.addresses != null) {
            this.addresses.remove(interface_IP_Address, (Boolean)true);
        }
        return this;
    }

    public Interface remove_addresses(Collection<Interface_IP_Address> collection) {
        Iterator<Interface_IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_address(iterator.next());
        }
        return this;
    }

    public Interface enable_DHCP() {
        return this.enable_dhcp();
    }

    public Interface enable_dhcp() {
        return this.dhcp(true);
    }

    public Interface disable_DHCP() {
        return this.disable_dhcp();
    }

    public Interface disable_dhcp() {
        return this.dhcp(false);
    }

    public Interface enable_roaming() {
        return this.roaming(true);
    }

    public Interface disable_roaming() {
        return this.roaming(false);
    }

    @Override
    public Interface bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.settings, netDB_Datastore);
        this.bind_children(this.names, netDB_Datastore);
        this.bind_children(this.addresses, netDB_Datastore);
        return this;
    }

    @Override
    public Interface unbind() {
        super.unbind();
        this.unbind_children(this.settings);
        this.unbind_children(this.names);
        this.unbind_children(this.addresses);
        return this;
    }

    @Override
    public Interface unlink() {
        super.unlink();
        this.unlink_children(this.settings);
        this.unlink_children(this.names);
        this.unlink_children(this.addresses);
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        Interface interface_ = null;
        if (!(netDB instanceof Interface)) {
            return;
        }
        interface_ = (Interface)netDB;
        this.id = interface_.id;
        this.type = interface_.type;
        this.node = interface_.node;
        this.roam = interface_.roam;
        this.dhcp = interface_.dhcp;
        this.hardware_address = interface_.hardware_address;
        this.comment = interface_.comment;
        this.settings = interface_.settings;
        if (this.names != NetDB.unset_mva_a_name) {
            for (A_Name netDB2 : this.names()) {
                netDB2.deep_update(netDB_Datastore, interface_.names());
            }
        }
        if (this.addresses != NetDB.unset_mva_interface_ip) {
            for (Interface_IP_Address interface_IP_Address : this.addresses()) {
                interface_IP_Address.deep_update(netDB_Datastore, interface_.addresses());
            }
        }
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.type != null) {
            string = this.type.single_value_attributes();
        }
        return this.id + " " + string + " " + this.roam + " " + this.dhcp + " " + this.hardware_address + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.type == null) {
            this.type = NetDB.unset_interface_type;
        }
        if (this.node == null) {
            this.node = NetDB.unset_integer;
        }
        if (this.roam == null) {
            this.roam = NetDB.unset_boolean;
        }
        if (this.dhcp == null) {
            this.dhcp = NetDB.unset_boolean;
        }
        if (this.hardware_address == null) {
            this.hardware_address = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.settings == null) {
            this.settings = NetDB.unset_mva_dhcp_setting;
        }
        if (this.names == null) {
            this.names = NetDB.unset_mva_a_name;
        }
        if (this.addresses == null) {
            this.addresses = NetDB.unset_mva_interface_ip;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.INTERFACE_TYPE) {
            if (this.type == NetDB.unset_interface_type) {
                this.type = null;
            }
        } else if (field == Field.NODE) {
            if (this.node == NetDB.unset_integer) {
                this.node = null;
            }
        } else if (field == Field.ROAM) {
            if (this.roam == NetDB.unset_boolean) {
                this.roam = null;
            }
        } else if (field == Field.DHCP) {
            if (this.dhcp == NetDB.unset_boolean) {
                this.dhcp = null;
            }
        } else if (field == Field.HW_ADDRESS) {
            if (NetDB.unset_string.equals(this.hardware_address)) {
                this.hardware_address = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.DHCP_SETTING) {
            if (this.settings == NetDB.unset_mva_dhcp_setting) {
                this.settings = null;
            }
        } else if (field == Field.NAME) {
            if (this.names == NetDB.unset_mva_a_name) {
                this.names = null;
            }
        } else if (field == Field.ADDRESS && this.addresses == NetDB.unset_mva_interface_ip) {
            this.addresses = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (this.type == NetDB.unset_interface_type) {
            this.type = null;
        }
        if (this.node == NetDB.unset_integer) {
            this.node = null;
        }
        if (this.roam == NetDB.unset_boolean) {
            this.roam = null;
        }
        if (this.dhcp == NetDB.unset_boolean) {
            this.dhcp = null;
        }
        if (NetDB.unset_string.equals(this.hardware_address)) {
            this.hardware_address = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = null;
        }
        if (this.names == NetDB.unset_mva_a_name) {
            this.names = null;
        }
        if (this.addresses == NetDB.unset_mva_interface_ip) {
            this.addresses = null;
        }
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_user_created();
            }
        }
        if (this.addresses != null) {
            for (Interface_IP_Address interface_IP_Address : this.addresses.all_values(true)) {
                interface_IP_Address.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_modified();
            }
        }
        if (this.addresses != null) {
            for (Interface_IP_Address interface_IP_Address : this.addresses.all_values(true)) {
                interface_IP_Address.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected Interface flag_as_system_created() {
        super.flag_as_system_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_system_created();
            }
        }
        if (this.addresses != null) {
            for (Interface_IP_Address interface_IP_Address : this.addresses.all_values(true)) {
                interface_IP_Address.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected Interface flag_as_loaded() {
        super.flag_as_loaded();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_loaded();
            }
        }
        if (this.addresses != null) {
            for (Interface_IP_Address interface_IP_Address : this.addresses.all_values(true)) {
                interface_IP_Address.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "interface", this, bl);
    }

    @Override
    public int compareTo(Interface interface_) {
        return this.compare(this, interface_);
    }

    @Override
    public int compare(Interface interface_, Interface interface_2) {
        if (interface_ == null && interface_2 == null) {
            return 0;
        }
        if (interface_ == null && interface_2 != null) {
            return 1;
        }
        if (interface_ != null && interface_2 == null) {
            return -1;
        }
        Boolean bl = false;
        Boolean bl2 = false;
        if (interface_.addresses != null && interface_.addresses.size() > 0) {
            bl = true;
        }
        if (interface_2.addresses != null && interface_2.addresses.size() > 0) {
            bl2 = true;
        }
        if (!bl.booleanValue() && bl2.booleanValue()) {
            return -1;
        }
        if (bl.booleanValue() && !bl2.booleanValue()) {
            return 1;
        }
        String string = "";
        String string2 = "";
        if (bl.booleanValue() && bl2.booleanValue()) {
            Interface_IP_Address interface_IP_Address;
            try {
                interface_IP_Address = (Interface_IP_Address)((Vector)interface_.addresses()).firstElement();
                string = interface_IP_Address.address().toString(16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interface_IP_Address = (Interface_IP_Address)((Vector)interface_2.addresses()).firstElement();
                string2 = interface_IP_Address.address().toString(16);
            }
            catch (Exception exception) {}
        } else {
            if (interface_.id != null) {
                string2 = interface_.id.toString();
            }
            if (interface_2.id != null) {
                string = interface_2.id.toString();
            }
        }
        return string.compareTo(string2);
    }

    protected static Interface extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception {
        Interface interface_ = new Interface(netDB_Datastore);
        interface_.flag_as_system_created();
        interface_.extract(hashtable);
        return interface_;
    }

    protected Interface extract(Hashtable hashtable) throws Exception {
        Object object;
        Object object2;
        if (hashtable == null) {
            return this;
        }
        this.settings = new Multi_Value_Attribute();
        this.names = new Multi_Value_Attribute();
        this.addresses = new Multi_Value_Attribute();
        this.dhcp((Boolean)hashtable.get("use-dhcp?"));
        hashtable.remove("use-dhcp?");
        this.roaming((Boolean)hashtable.get("roaming?"));
        hashtable.remove("roaming?");
        this.comment((String)hashtable.get("comment"));
        hashtable.remove("comment");
        this.hardware_address((String)hashtable.get("hw"));
        hashtable.remove("hw");
        Hashtable hashtable2 = (Hashtable)hashtable.get("names");
        Object object3 = hashtable2.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            this.add_name(A_Name.extract(this.datastore, (Hashtable)hashtable2.get(object2)));
        }
        hashtable.remove("names");
        object3 = (Hashtable)hashtable.get("ips");
        object2 = ((Hashtable)object3).keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            this.add_address(Interface_IP_Address.extract(this.datastore, (Hashtable)((Hashtable)object3).get(object)));
        }
        hashtable.remove("ips");
        object2 = (Hashtable)hashtable.get("dhcp-options");
        if (object2 != null) {
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.add_dhcp_setting(DHCP_Setting.extract(this.datastore, (Hashtable)((Hashtable)object2).get(string)));
            }
        }
        hashtable.remove("dhcp-options");
        NetDB.unhandled_keys(hashtable, "Interface.extract");
        return this;
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Interface.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Interface.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Interface.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_interface().has_access(user, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Interface._has_access("", netDB_Datastore, user, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n = netDB_Datastore.iface().verify_or_die(string, string2);
            if (Node._has_access(string, netDB_Datastore, user).booleanValue() && Group._has_access(string, netDB_Datastore, user.id(), Record_Type.INTERFACE.toString(), n).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            Boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return false;
    }

    @Override
    protected Interface complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this;
    }

    protected void delete(String string, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (!this.has_been_loaded().booleanValue()) {
            throw new Exception("Unable to delete the interface: The Interface must be loaded.");
        }
        if (this.id() == null) {
            throw new Exception("Unable to delete the interface: The ID is null.");
        }
        netDB_Datastore.iface().delete(string, timestamp, this.id());
        this.flag_as_modified().flag_as_user_created();
    }

    protected void delete_children(String string, Interface interface_, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.names, interface_.names, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
        Vector vector = comparison_Result.only_in_set2();
        for (int i = 0; i < vector.size(); ++i) {
            ((A_Name)vector.get(i)).delete(string, timestamp);
        }
        Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.addresses, interface_.addresses, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
        Vector vector2 = comparison_Result2.only_in_set2();
        Vector vector3 = comparison_Result2.both_sets();
        for (n = 0; n < vector3.size(); ++n) {
            ((Interface_IP_Address)vector3.get(n)).delete_children(string, (IP_Address)comparison_Result2.both_sets_alternate(n), timestamp);
        }
        for (n = 0; n < vector2.size(); ++n) {
            ((Interface_IP_Address)vector2.get(n)).delete(string, timestamp);
        }
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, Interface interface_, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        String string2 = "Ethernet";
        if (this.type != null) {
            string2 = this.type.handle();
        }
        if (interface_ == EMPTY) {
            Hashtable hashtable = netDB_Datastore.iface().insert(string, timestamp, string2, n, NetDB.boolean_to_integer(this.roam), NetDB.boolean_to_integer(this.dhcp), this.hardware_address, this.comment);
            this.id = new Integer((String)hashtable.get("id"));
        } else {
            netDB_Datastore.iface().update(string, timestamp, this.id, string2, NetDB.boolean_to_integer(this.roam), NetDB.boolean_to_integer(this.dhcp), this.hardware_address, this.comment);
        }
        this.commit_children(string, netDB_Datastore, interface_, n, timestamp);
    }

    protected void commit_children(String string, NetDB_Datastore netDB_Datastore, Interface interface_, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n2;
        int n3;
        int n4;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.names, interface_.names, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
        Vector vector = comparison_Result.only_in_set1();
        Vector vector2 = comparison_Result.both_sets();
        for (n4 = 0; n4 < vector.size(); ++n4) {
            ((A_Name)vector.get(n4)).commit(string, netDB_Datastore, A_Name.EMPTY, this.id, timestamp, Record_Type.INTERFACE);
        }
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            ((A_Name)vector2.get(n4)).commit_children(string, netDB_Datastore, (A_Name)comparison_Result.both_sets_alternate(n4), this.id, timestamp, Record_Type.INTERFACE);
        }
        Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.addresses, interface_.addresses, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
        Vector vector3 = comparison_Result2.only_in_set1();
        Vector vector4 = comparison_Result2.both_sets();
        for (n3 = 0; n3 < vector3.size(); ++n3) {
            ((Interface_IP_Address)vector3.get(n3)).commit(string, netDB_Datastore, Interface_IP_Address.EMPTY, this.id, timestamp, Record_Type.INTERFACE);
        }
        for (n3 = 0; n3 < vector4.size(); ++n3) {
            ((Interface_IP_Address)vector4.get(n3)).commit(string, netDB_Datastore, (IP_Address)comparison_Result2.both_sets_alternate(n3), this.id, timestamp, Record_Type.INTERFACE);
        }
        Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.settings, interface_.settings);
        Vector vector5 = comparison_Result3.only_in_set1();
        Vector vector6 = comparison_Result3.only_in_set2();
        Vector vector7 = comparison_Result3.both_sets();
        for (n2 = 0; n2 < vector6.size(); ++n2) {
            netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.INTERFACE.toString(), ((DHCP_Setting)vector6.get(n2)).handle());
        }
        for (n2 = 0; n2 < vector5.size(); ++n2) {
            netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.INTERFACE.toString(), ((DHCP_Setting)vector5.get(n2)).handle(), ((DHCP_Setting)vector5.get(n2)).value());
        }
        for (n2 = 0; n2 < vector7.size(); ++n2) {
            DHCP_Setting dHCP_Setting = (DHCP_Setting)vector7.get(n2);
            DHCP_Setting dHCP_Setting2 = (DHCP_Setting)comparison_Result3.both_sets_alternate(n2);
            String string2 = dHCP_Setting.value();
            String string3 = dHCP_Setting2.value();
            if (string2 == null || string3 == null || string2.equals(string3)) continue;
            netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.INTERFACE.toString(), dHCP_Setting.handle());
            netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.INTERFACE.toString(), dHCP_Setting2.handle(), string3);
        }
    }

    public static enum COMPARISON_TYPE {
        NAME,
        HARDWARE_ADDRESS,
        IP;

    }
}

