/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Comparison_Result;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Field;
import stanford.netdb.IP_Address;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public final class IP_Pool
extends NetDB<IP_Pool> {
    public static String template_name = "templates/toString/ip_pool.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final IP_Pool EMPTY = new IP_Pool();
    private Integer id = null;
    private String comment = null;
    private Multi_Value_Attribute<IP_Address> addresses = null;
    private Multi_Value_Attribute<DHCP_Setting> settings = null;

    public IP_Pool() {
        this.init();
    }

    protected IP_Pool(String string) {
        this.init(string);
    }

    public IP_Pool(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected IP_Pool(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    private void init() {
        this.init(null);
    }

    private void init(String string) {
        if (string != null) {
            this.comment(string);
        }
    }

    public Collection<IP_Address> addresses() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.addresses, NetDB.unset_mva_ip, "IP_Pool.addresses");
        if (this.addresses == null || this.addresses == NetDB.unset_mva_ip) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.addresses.all_values();
    }

    protected Collection<DHCP_Setting> DHCP_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp_settings();
    }

    protected Collection<DHCP_Setting> dhcp_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.settings, NetDB.unset_mva_dhcp_setting, "IP_Pool.settings");
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.settings.all_values();
    }

    protected String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "IP_Pool.comment");
        return this.comment;
    }

    @Override
    public String handle() {
        if (this.addresses != null && this.addresses != NetDB.unset_mva_ip && this.addresses.size() > 0) {
            try {
                return ((IP_Address)((Vector)this.addresses.all_values()).firstElement()).address().toString();
            }
            catch (Exception exception) {
            }
        } else if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    protected IP_Pool id(Integer n) {
        this.id = n;
        return this;
    }

    public IP_Pool add_address(IP_Address iP_Address) {
        if (this.addresses == null || this.addresses == NetDB.unset_mva_ip) {
            this.addresses = new Multi_Value_Attribute();
        }
        this.addresses.add(iP_Address);
        return this;
    }

    public IP_Pool add_addresses(Collection<IP_Address> collection) {
        Iterator<IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_address(iterator.next());
        }
        return this;
    }

    public IP_Pool remove_address(IP_Address iP_Address) {
        if (this.addresses != null) {
            this.addresses.remove(iP_Address, (Boolean)true);
        }
        return this;
    }

    public IP_Pool remove_addresses(Collection<IP_Address> collection) {
        Iterator<IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_address(iterator.next());
        }
        return this;
    }

    protected IP_Pool add_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.add_dhcp_setting(dHCP_Setting);
    }

    protected IP_Pool add_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = new Multi_Value_Attribute();
        }
        this.settings.add(dHCP_Setting);
        return this;
    }

    protected IP_Pool add_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.add_dhcp_settings(collection);
    }

    protected IP_Pool add_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_dhcp_setting(iterator.next());
        }
        return this;
    }

    protected IP_Pool remove_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.remove_dhcp_setting(dHCP_Setting);
    }

    protected IP_Pool remove_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings != null) {
            this.settings.remove(dHCP_Setting, (Boolean)true);
        }
        return this;
    }

    protected IP_Pool remove_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.remove_dhcp_settings(collection);
    }

    protected IP_Pool remove_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_dhcp_setting(iterator.next());
        }
        return this;
    }

    protected IP_Pool comment(String string) {
        this.comment = string;
        return this;
    }

    @Override
    public IP_Pool bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.addresses, netDB_Datastore);
        this.bind_children(this.settings, netDB_Datastore);
        return this;
    }

    @Override
    public IP_Pool unbind() {
        super.unbind();
        this.unbind_children(this.addresses);
        this.unbind_children(this.settings);
        return this;
    }

    @Override
    public IP_Pool unlink() {
        super.unlink();
        this.unlink_children(this.addresses);
        this.unlink_children(this.settings);
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        IP_Pool iP_Pool = null;
        if (!(netDB instanceof IP_Pool)) {
            return;
        }
        iP_Pool = (IP_Pool)netDB;
        this.id = iP_Pool.id;
        this.comment = iP_Pool.comment;
        this.settings = iP_Pool.settings;
        if (this.addresses != NetDB.unset_mva_ip) {
            for (IP_Address iP_Address : this.addresses()) {
                iP_Address.deep_update(netDB_Datastore, iP_Pool.addresses());
            }
        }
    }

    @Override
    public String single_value_attributes() {
        return this.comment;
    }

    @Override
    protected void initialize_member_data() {
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.addresses == null) {
            this.addresses = NetDB.unset_mva_ip;
        }
        if (this.settings == null) {
            this.settings = NetDB.unset_mva_dhcp_setting;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.ADDRESS) {
            if (this.addresses == NetDB.unset_mva_ip) {
                this.addresses = null;
            }
        } else if (field == Field.DHCP_SETTING && this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.addresses == NetDB.unset_mva_ip) {
            this.addresses = null;
        }
        if (this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = null;
        }
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.addresses != null) {
            for (IP_Address iP_Address : this.addresses.all_values(true)) {
                iP_Address.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.addresses != null) {
            for (IP_Address iP_Address : this.addresses.all_values(true)) {
                iP_Address.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected IP_Pool flag_as_system_created() {
        super.flag_as_system_created();
        if (this.addresses != null) {
            for (IP_Address iP_Address : this.addresses.all_values(true)) {
                iP_Address.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected IP_Pool flag_as_loaded() {
        super.flag_as_loaded();
        if (this.addresses != null) {
            for (IP_Address iP_Address : this.addresses.all_values(true)) {
                iP_Address.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "ip_pool", this, bl);
    }

    @Override
    public int compareTo(IP_Pool iP_Pool) {
        return this.compare(this, iP_Pool);
    }

    @Override
    public int compare(IP_Pool iP_Pool, IP_Pool iP_Pool2) {
        if (iP_Pool == null && iP_Pool2 == null) {
            return 0;
        }
        if (iP_Pool == null && iP_Pool2 != null) {
            return 1;
        }
        if (iP_Pool != null && iP_Pool2 == null) {
            return -1;
        }
        Boolean bl = false;
        Boolean bl2 = false;
        if (iP_Pool.addresses.size() > 0) {
            bl = true;
        }
        if (iP_Pool2.addresses.size() > 0) {
            bl2 = true;
        }
        if (!bl.booleanValue() && bl2.booleanValue()) {
            return -1;
        }
        if (bl.booleanValue() && !bl2.booleanValue()) {
            return 1;
        }
        String string = "";
        String string2 = "";
        if (bl.booleanValue() && bl2.booleanValue()) {
            IP_Address iP_Address;
            try {
                iP_Address = (IP_Address)((Vector)iP_Pool.addresses()).firstElement();
                string = iP_Address.address().toString(16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                iP_Address = (IP_Address)((Vector)iP_Pool2.addresses()).firstElement();
                string2 = iP_Address.address().toString(16);
            }
            catch (Exception exception) {}
        } else {
            if (iP_Pool.id != null) {
                string2 = iP_Pool.id.toString();
            }
            if (iP_Pool2.id != null) {
                string = iP_Pool2.id.toString();
            }
        }
        return string.compareTo(string2);
    }

    protected static IP_Pool extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        IP_Pool iP_Pool = new IP_Pool(netDB_Datastore);
        iP_Pool.flag_as_system_created();
        iP_Pool.extract(hashtable);
        return iP_Pool;
    }

    protected IP_Pool extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        this.addresses = new Multi_Value_Attribute();
        this.settings = new Multi_Value_Attribute();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.add_address(IP_Address.extract(this.datastore, (Hashtable)hashtable.get(string)));
            hashtable.remove(string);
        }
        NetDB.unhandled_keys(hashtable, "IP_Pool.extract");
        return this;
    }

    @Override
    protected IP_Pool complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this;
    }

    protected void delete(String string, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.delete(string, this.get_datastore(), timestamp);
    }

    protected void delete(String string, NetDB_Datastore netDB_Datastore, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (this.addresses == null) {
            this.addresses = new Multi_Value_Attribute();
        }
        Vector vector = (Vector)this.addresses.all_values();
        for (int i = 0; i < vector.size(); ++i) {
            ((IP_Address)vector.get(i)).delete(string, timestamp);
        }
        this.flag_as_modified().flag_as_user_created();
    }

    protected void delete_children(String string, IP_Pool iP_Pool, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.addresses, iP_Pool.addresses);
        Vector vector = comparison_Result.only_in_set2();
        Vector vector2 = comparison_Result.both_sets();
        for (n = 0; n < vector2.size(); ++n) {
            ((IP_Address)vector2.get(n)).delete_children(string, (IP_Address)comparison_Result.both_sets_alternate(n), timestamp);
        }
        for (n = 0; n < vector.size(); ++n) {
            ((IP_Address)vector.get(n)).delete(string, timestamp);
        }
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, IP_Pool iP_Pool, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        int n2;
        this.bind(netDB_Datastore);
        if (this.comment != null) {
            System.err.println("IP_Pools are not fully implemented.  Unable to commit comment.");
        }
        if (this.settings != null && this.settings.size() > 0) {
            System.err.println("IP_Pools are not fully implemented.  Unable to commit DHCP Settings.");
        }
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.addresses, iP_Pool.addresses);
        Vector vector = comparison_Result.only_in_set1();
        Vector vector2 = comparison_Result.both_sets();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((IP_Address)vector.get(n2)).commit(string, netDB_Datastore, IP_Address.EMPTY, this.id, timestamp, Record_Type.ADDRESS_SPACE);
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            ((IP_Address)vector2.get(n2)).commit(string, netDB_Datastore, (IP_Address)comparison_Result.both_sets_alternate(n2), this.id, timestamp, Record_Type.ADDRESS_SPACE);
        }
    }
}

