/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.IP;

import java.math.BigInteger;
import stanford.netdb.IP.IP;
import stanford.netdb.IP.IPaddress;

public class Prefix
extends IP {
    private static final long serialVersionUID = 1L;
    private IPaddress network_address;
    private IPaddress broadcast_address;
    private int prefix_length;
    private static int default_format = 100;
    private BigInteger net_mask = BigInteger.ZERO;
    private BigInteger host_mask = BigInteger.ZERO;

    protected static Prefix create(String string) {
        Prefix prefix = null;
        try {
            prefix = new Prefix(string);
        }
        catch (Exception exception) {
            System.err.println("Error instantiating the prefix '" + string + "' (" + exception.getMessage() + ").");
            System.exit(1);
        }
        return prefix;
    }

    public Prefix(String string) throws Exception {
        int n;
        if (string.matches(".*/.*/.*") || string.indexOf("/") == -1) {
            throw new Exception("Prefix '" + string + "' is malformed.");
        }
        String[] stringArray = (string = string.trim()).split("/");
        if (stringArray[0].indexOf(58) < 0) {
            if (stringArray[0].charAt(stringArray[0].length() - 1) == '.') {
                stringArray[0] = stringArray[0] + "0";
            }
            n = 0;
            int n2 = 0;
            while (n2 > -1) {
                n2 = stringArray[0].indexOf(46, n2 + 1);
                ++n;
            }
            while (n < 4) {
                stringArray[0] = stringArray[0] + ".0";
                ++n;
            }
        }
        this.network_address = new IPaddress(stringArray[0]);
        n = this.format();
        try {
            this.prefix_length = Integer.parseInt(stringArray[1]);
            if (n == 1 && this.prefix_length > 32 || this.prefix_length > 128) {
                throw new Exception("Prefix length is too large.");
            }
            if (this.prefix_length < 0) {
                throw new Exception("Prefix is negative.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Prefix length is not a number.");
        }
        if (n == 1) {
            this.prefix_length += 96;
        }
        this.net_mask = Prefix.build_net_mask(this.prefix_length);
        this.host_mask = Prefix.build_host_mask(this.prefix_length);
        this.network_address = new IPaddress(this.network_address.toBigInteger().and(this.net_mask), n);
        this.broadcast_address = new IPaddress(this.network_address.toBigInteger().or(this.host_mask), n);
    }

    public Prefix(String string, int n) throws Exception {
        this(string + "/" + n);
    }

    private Prefix(BigInteger bigInteger, int n, int n2) throws Exception {
        this.net_mask = Prefix.build_net_mask(n);
        this.host_mask = Prefix.build_host_mask(n);
        this.prefix_length = n;
        this.network_address = new IPaddress(bigInteger.and(this.net_mask), n2);
        this.broadcast_address = new IPaddress(bigInteger.or(this.host_mask), n2);
    }

    public Prefix clone() {
        Prefix prefix = null;
        try {
            prefix = new Prefix(this.network_address.toString(), this.prefix_length());
        }
        catch (Exception exception) {
            System.err.println("Unexpected exception caught in clone.\n" + exception.getMessage());
        }
        return prefix;
    }

    public static int default_format() {
        return default_format;
    }

    public static void default_compressed() {
        Prefix.set(8);
        Prefix.clear(48);
    }

    public static void default_normalized() {
        Prefix.set(16);
        Prefix.clear(40);
    }

    public static void default_preferred() {
        Prefix.set(32);
        Prefix.clear(24);
    }

    public static void default_passed() {
        Prefix.set(4);
        Prefix.clear(3);
    }

    public static void default_IPv4() {
        Prefix.set(1);
        Prefix.clear(6);
    }

    public static void default_IPv6() {
        Prefix.set(2);
        Prefix.clear(5);
    }

    public static void default_lower() {
        Prefix.set(64);
        Prefix.clear(128);
    }

    public static void default_upper() {
        Prefix.set(128);
        Prefix.clear(64);
    }

    public int format() {
        return this.network_address.format();
    }

    @Override
    public int compare(Object object, Object object2) throws ClassCastException {
        return IPaddress.ZERO.compare(object, object2);
    }

    @Override
    public int compareTo(Object object) {
        return this.compare(this, object);
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        if (n == 0) {
            n = default_format;
        }
        return this.network_address.toString(n) + "/" + this.corrected_prefix_length(n);
    }

    public BigInteger available_addresses() {
        return this.host_mask;
    }

    public int prefix_length(int n) {
        return this.corrected_prefix_length(n);
    }

    public int prefix_length() {
        return this.prefix_length(0);
    }

    public IPaddress address() {
        return this.network_address.clone();
    }

    public IPaddress broadcast() {
        return this.broadcast_address.clone();
    }

    public boolean contains(IPaddress iPaddress) {
        return IPaddress.cmp(this.network_address, iPaddress) <= 0 && IPaddress.cmp(this.broadcast_address, iPaddress) >= 0;
    }

    public Prefix[] split() throws Exception {
        if (this.prefix_length > 126) {
            throw new Exception("Prefixes smaller than " + this.corrected_prefix_length(0) + " can't be split.");
        }
        int n = this.prefix_length + 1;
        BigInteger bigInteger = BigInteger.ONE.shiftLeft(128 - n);
        BigInteger bigInteger2 = this.network_address.toBigInteger();
        BigInteger bigInteger3 = this.network_address.toBigInteger().add(bigInteger);
        Prefix[] prefixArray = new Prefix[]{new Prefix(bigInteger2, n, this.format()), new Prefix(bigInteger3, n, this.format())};
        return prefixArray;
    }

    public Prefix increase_prefix_size() throws Exception {
        return this.adjust_prefix_size(-1);
    }

    public Prefix adjust_prefix_size(int n) throws Exception {
        if (this.prefix_length == 0 || this.network_address.format() == 1 && this.prefix_length == 32 || (this.network_address.format() == 2 || this.network_address.format() == 3) && this.prefix_length == 128) {
            return this.clone();
        }
        return new Prefix(this.network_address.toString(), this.prefix_length() + n);
    }

    public static Prefix join(String string, Prefix[] prefixArray) throws Exception {
        Prefix prefix = null;
        try {
            prefix = new Prefix(string);
        }
        catch (Exception exception) {
            throw new Exception("An error occurred while creating the new prefix: " + exception.toString());
        }
        for (int i = 0; i < prefixArray.length; ++i) {
            if (prefix.contains(prefixArray[i].address()) && prefix.contains(prefixArray[i].broadcast())) continue;
            throw new Exception("The prefix " + prefixArray[i].toString() + " would not be contained within the prefix '" + prefix.toString() + "'.");
        }
        return prefix;
    }

    public static Prefix join(String string, int n, Prefix[] prefixArray) throws Exception {
        return Prefix.join(string + "/" + n, prefixArray);
    }

    private int corrected_prefix_length(int n) {
        boolean bl;
        int n2 = this.prefix_length;
        boolean bl2 = bl = (n & 3) <= 0;
        if (bl && this.format() == 1 || (n & 3) == 1) {
            n2 -= 96;
        }
        return n2 < 0 ? 0 : n2;
    }

    private static BigInteger build_net_mask(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 1; i <= n; ++i) {
            bigInteger = bigInteger.setBit(128 - i);
        }
        return bigInteger;
    }

    private static BigInteger build_host_mask(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < 128 - n; ++i) {
            bigInteger = bigInteger.setBit(i);
        }
        return bigInteger;
    }

    private static void set(int n) {
        default_format = IP.set(n, default_format);
    }

    private static void clear(int n) {
        default_format = IP.clear(n, default_format);
    }
}

