/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Full_Search_Parameters;
import stanford.netdb.Group;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.middleware.Result_Hash;

public final class Group_FS_Parameters
extends Full_Search_Parameters<Group_FS_Parameters, Group> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_NAME = "displayOrder.txt.1.Group Name";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String NAME_COLUMN = "Group Name";
    private static final String COMMENT_COLUMN = "Comment";
    private String name = "";

    public Group_FS_Parameters() {
        this.INCLUDE_MODIFIED_BY = "displayOrder.txt.3.Modified By";
        this.INCLUDE_MODIFIED = "displayOrder.tst.4.Date Modified";
        this.INCLUDE_CREATED_BY = "displayOrder.txt.5.Created By";
        this.INCLUDE_CREATED = "displayOrder.tst.6.Date Created";
        this.INCLUDE_COMMENT = "displayOrder.txt.2.Comment";
        this.include_fields.put(INCLUDE_NAME, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_OWNER, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_COMMENT, Boolean.FALSE);
    }

    public String name() {
        return this.name;
    }

    public Boolean include_name() {
        return (Boolean)this.include_fields.get(INCLUDE_NAME);
    }

    public Group_FS_Parameters name(String string) {
        if (string == null) {
            string = "";
        }
        this.name = string;
        return this;
    }

    public Group_FS_Parameters name(String string, Boolean bl) {
        this.name(string);
        this.include_name(bl);
        return this;
    }

    public Group_FS_Parameters include_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NAME, bl);
        return this;
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        Hashtable<String, String> hashtable = this.legacy_search_params();
        String string2 = "SELECT DISTINCT id \"ID\", owner \"handle\"" + (hashtable.get(INCLUDE_NAME).equals("-1") ? "" : ", owner \"Group Name\"") + (hashtable.get(this.INCLUDE_COMMENT).equals("-1") ? "" : ", nvl(comments, ' ') \"Comment\"") + this.modBlock(hashtable) + " FROM " + hashtable.get("fs.table") + " WHERE ID IN ( SELECT unique(id) FROM ";
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        Vector<Exception> vector2 = new Vector<Exception>();
        string2 = string2 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        return string2;
    }

    @Override
    protected Vector<Group> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        for (String object : result_Hash.get_vector("column_names")) {
            if (object.equals(ID_COLUMN)) {
                n = n9;
            } else if (object.equals(HANDLE_COLUMN)) {
                n2 = n9;
            } else if (object.equals(NAME_COLUMN)) {
                n3 = n9;
            } else if (object.equals(COMMENT_COLUMN)) {
                n4 = n9;
            } else if (object.equals("Modified By")) {
                n6 = n9;
            } else if (object.equals("Date Modified")) {
                n5 = n9;
            } else if (object.equals("Created By")) {
                n8 = n9;
            } else if (object.equals("Date Created")) {
                n7 = n9;
            } else {
                netDB_Datastore.logger().severe("'" + object + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n9;
        }
        Vector vector = new Vector();
        for (Vector vector2 : (Vector)result_Hash.get("resultSet")) {
            Group group = new Group(netDB_Datastore);
            group.flag_as_system_created();
            BigDecimal bigDecimal = (BigDecimal)vector2.get(n);
            if (bigDecimal != null) {
                group.id(new Integer(bigDecimal.intValue()));
            }
            if (n2 != -1) {
                group.name((String)vector2.get(n2));
            }
            if (n4 != -1) {
                String string = (String)vector2.get(n4);
                if (string != null && (string = string.trim()).length() > 0) {
                    group.comment(string);
                }
                group.flag_field_as_defined(Field.COMMENT);
            }
            super.process_common_results(group, vector2, n5, n6, n7, n8);
            vector.add(group);
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected String child_params() {
        String string = "";
        if (this.name != null) {
            string = string + " name: " + this.name;
        }
        if (this.include_name().booleanValue()) {
            string = string + " include_name";
        }
        return string;
    }

    public Hashtable<String, String> legacy_search_params() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_Owner");
        for (String string : this.include_fields.keySet()) {
            String string2 = "-1";
            if (((Boolean)this.include_fields.get(string)).booleanValue()) {
                string2 = "1";
            }
            hashtable.put(string, string2);
        }
        super.legacy_search_params(hashtable);
        hashtable.put("txt.lower(owner)", this.name.toLowerCase());
        hashtable.put("txt.lower(comments)", this.comment.toLowerCase());
        return hashtable;
    }
}

