/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Group_FS_Parameters;
import stanford.netdb.Group_SS_Result;
import stanford.netdb.Lockable;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;

public final class Group
extends Lockable<Group> {
    public static String template_name = "templates/toString/group.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String comment = null;

    public Group() {
        this.init();
    }

    public Group(String string) {
        this.init(string);
    }

    public Group(String string, String string2) {
        this.init(string, string2);
    }

    public Group(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Group(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Group(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(string, null);
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Group.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Group.name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Group.comment");
        return this.comment;
    }

    @Override
    public String handle() {
        return this.name;
    }

    @Override
    protected Group id(Integer n) {
        this.id = n;
        return this;
    }

    public Group name(String string) {
        this.name = string;
        return this;
    }

    public Group comment(String string) {
        this.comment = string;
        return this;
    }

    @Override
    public Group unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((Group)netDB).id;
        this.name = ((Group)netDB).name;
        this.comment = ((Group)netDB).comment;
    }

    @Override
    public String single_value_attributes() {
        return this.name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT && NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "group", this, bl);
    }

    protected static Group extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Group group = new Group(netDB_Datastore);
        group.flag_as_system_created();
        group.extract(hashtable);
        return group;
    }

    @Override
    protected Group extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (hashtable == null) {
            return this;
        }
        super.extract(hashtable);
        if (hashtable.containsKey("id")) {
            this.id(new Integer((String)hashtable.get("id")));
            hashtable.remove("id");
        }
        if (hashtable.containsKey("name")) {
            this.name((String)hashtable.get("name"));
            hashtable.remove("name");
        }
        if (hashtable.containsKey("comment")) {
            this.comment((String)hashtable.get("comment"));
            hashtable.remove("comment");
        }
        NetDB.unhandled_keys(hashtable, "Group.extract");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = "";
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.owner().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        Integer n = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n = this.datastore.remote_owner().verify_or_die(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n = Group._verify_or_die("", this.datastore, null, string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.owner().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.owner().verify_or_die(string, n) : netDB_Datastore.owner().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.GROUP);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.GROUP);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.GROUP);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.GROUP);
    }

    protected static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege._has_access(string, netDB_Datastore, null, Record_Type.GROUP.toString(), user.id());
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        if (Group.has_access(netDB_Datastore, user).booleanValue()) {
            String string2 = string.toLowerCase();
            for (Group group : user.owners()) {
                if (!group.handle().toLowerCase().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Integer n, String string, Integer n2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_owner().has_access(n, string, n2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Group._has_access("", netDB_Datastore, n, string, n2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2, Integer n2) throws Exception {
        Comparable<User> comparable;
        NetDB.rmi_exception(netDB_Datastore);
        if (n == null) {
            comparable = netDB_Datastore.operating_user();
            if (comparable == null) {
                throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
            }
            n = ((User)comparable).id();
        }
        comparable = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                comparable = true;
            }
            Boolean bl = netDB_Datastore.owner().check_access(string, n, n2, string2);
            return bl;
        }
        finally {
            if (((Boolean)comparable).booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
    }

    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        Lock_Result lock_Result = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                lock_Result = this.datastore.remote_owner().lock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            lock_Result = Group._lock_record("", this.datastore, this.handle());
        }
        this.id = lock_Result.record_id();
        this.lock(lock_Result.lock());
        this.locked_by(lock_Result.locked_by());
        return lock_Result.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock_Result _lock_record(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Lock_Result lock_Result = new Lock_Result();
        Boolean bl = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            Integer n = netDB_Datastore.owner().verify_or_die(string, string2);
            Hashtable hashtable = netDB_Datastore.owner().lock_record(string, n);
            lock_Result.record_id(n);
            lock_Result.lock((Timestamp)hashtable.get("locked"));
            lock_Result.locked_by(netDB_Datastore.operating_user());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else if (bl2.booleanValue()) {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return lock_Result;
    }

    @Override
    public Group unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_owner().unlock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._unlock(this.datastore);
        }
        this.clear_lock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _unlock(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.owner().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return bl;
    }

    public static Group load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Group.load(NetDB.default_datastore(), bl, string);
    }

    public static Group load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Group group = new Group(netDB_Datastore);
        group.name(string);
        if (bl.booleanValue()) {
            group.lock_record();
        }
        group.load_object("", string);
        return group;
    }

    public static Group load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Group.load(NetDB.default_datastore(), string);
    }

    public static Group load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Group.load("", netDB_Datastore, string);
    }

    private static Group load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Group group = new Group(netDB_Datastore);
        group.load_object(string, string2);
        return group;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string2 == null || string2.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_owner().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = Group._load_object(string, this.datastore, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            Integer n = Group._verify_or_die(string, netDB_Datastore, null, string2);
            hashtable = netDB_Datastore.owner().info(string, n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    public static Collection<Group> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(NetDB.default_datastore());
    }

    public static Collection<Group> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Group> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(netDB_Datastore, false);
    }

    public static Collection<Group> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<Group> vector = new Vector<Group>();
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_owner().list(bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Group._list(netDB_Datastore, bl);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Group group = new Group(netDB_Datastore, string);
                if (n != null) {
                    group.comment((String)hashtable.get(string));
                }
                group.flag_as_system_created();
                vector.add(group);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.owner().list(string, n) : netDB_Datastore.simple_search().get_groups(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Group.delete(netDB_Datastore, this.handle());
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Group.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_owner().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            Group._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Lock_Result lock_Result = Group._lock_record(string2, netDB_Datastore, string);
            netDB_Datastore.owner().delete(string2, lock_Result.lock(), lock_Result.record_id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    @Override
    public Group commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.name, "name");
        Group group = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                group = netDB_Datastore.remote_owner().commit(this, bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            group = this._commit(netDB_Datastore, bl);
        }
        if (group != null) {
            this.deep_update(netDB_Datastore, group);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group _commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception {
        Boolean bl2 = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                Hashtable hashtable = netDB_Datastore.owner().insert(string, this.name, this.comment);
                this.id = new Integer((String)hashtable.get("id"));
                super.lock((Timestamp)hashtable.get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id(), netDB_Datastore.operating_user().netid());
            } else {
                netDB_Datastore.owner().update(string, this.lock(), this.id, this.name, this.comment);
            }
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl2.booleanValue() && bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Group_SS_Result> search() throws Exception, No_Datastore_Defined {
        return Group.search(NetDB.default_datastore(), null);
    }

    public static Collection<Group_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Group.search(NetDB.default_datastore(), string);
    }

    public static Collection<Group_SS_Result> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Group.search(netDB_Datastore, null);
    }

    public static Collection<Group_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_owner().search(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Group._search(netDB_Datastore, string);
        }
        Vector<Group_SS_Result> vector = new Vector<Group_SS_Result>();
        for (String string2 : hashtable.keySet()) {
            vector.add(new Group_SS_Result(string2));
        }
        Collections.sort(vector, new Group_SS_Result(""));
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _search(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name(), true);
            hashtable = string != null ? netDB_Datastore.simple_search().get_groups(string2, string) : netDB_Datastore.simple_search().get_groups(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    public static Collection<Group> full_search(Group_FS_Parameters group_FS_Parameters) throws Exception {
        return Group.full_search(NetDB.default_datastore(), group_FS_Parameters);
    }

    public static Collection<Group> full_search(NetDB_Datastore netDB_Datastore, Group_FS_Parameters group_FS_Parameters) throws Exception {
        return group_FS_Parameters.search(netDB_Datastore);
    }
}

