/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Lockable;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Full_Search;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.util.TZ_Timestamp;

public abstract class Full_Search_Parameters<T extends Full_Search_Parameters, R>
extends Full_Search<R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String INCLUDE_MODIFIED_BY = "";
    protected String INCLUDE_MODIFIED = "";
    protected String INCLUDE_CREATED_BY = "";
    protected String INCLUDE_CREATED = "";
    protected String INCLUDE_OWNER = "";
    protected String INCLUDE_COMMENT = "";
    protected String created_by_netid = "";
    protected String created_by_name = "";
    protected String created_after_date = "";
    protected String created_before_date = "";
    protected String modified_by_netid = "";
    protected String modified_by_name = "";
    protected String modified_after_date = "";
    protected String modified_before_date = "";
    protected String owner = "";
    protected String comment = "";

    protected Full_Search_Parameters() {
    }

    public String created_by_netID() {
        return this.created_by_netid();
    }

    public String created_by_netid() {
        return this.created_by_netid;
    }

    public String created_by_name() {
        return this.created_by_name;
    }

    public String created_after_date() {
        return this.created_after_date;
    }

    public String created_before_date() {
        return this.created_before_date;
    }

    public Boolean include_created_by() {
        return (Boolean)this.include_fields.get(this.INCLUDE_CREATED_BY);
    }

    public Boolean include_created_at() {
        return (Boolean)this.include_fields.get(this.INCLUDE_CREATED);
    }

    public String modified_by_netID() {
        return this.modified_by_netid();
    }

    public String modified_by_netid() {
        return this.modified_by_netid;
    }

    public String modified_by_name() {
        return this.modified_by_name;
    }

    public String modified_after_date() {
        return this.modified_after_date;
    }

    public String modified_before_date() {
        return this.modified_before_date;
    }

    public Boolean include_modified_by() {
        return (Boolean)this.include_fields.get(this.INCLUDE_MODIFIED_BY);
    }

    public Boolean include_modified_at() {
        return (Boolean)this.include_fields.get(this.INCLUDE_MODIFIED);
    }

    public String owner() {
        return this.owner;
    }

    public Boolean include_owner() {
        return (Boolean)this.include_fields.get(this.INCLUDE_OWNER);
    }

    public String comment() {
        return this.comment;
    }

    public Boolean include_comment() {
        return (Boolean)this.include_fields.get(this.INCLUDE_COMMENT);
    }

    public T created_by_netID(String string) {
        return this.created_by_netid(string);
    }

    public T created_by_netid(String string) {
        if (string == null) {
            string = "";
        }
        this.created_by_netid = string;
        return (T)this;
    }

    public T created_by_netID(String string, Boolean bl) {
        return this.created_by_netid(string, bl);
    }

    public T created_by_netid(String string, Boolean bl) {
        this.created_by_netid(string);
        this.include_created_by(bl);
        return (T)this;
    }

    public T created_by_name(String string) {
        if (string == null) {
            string = "";
        }
        this.created_by_name = string;
        return (T)this;
    }

    public T created_by_name(String string, Boolean bl) {
        this.created_by_name(string);
        this.include_created_by(bl);
        return (T)this;
    }

    public T include_created_by(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_CREATED_BY, bl);
        return (T)this;
    }

    public T created_after_date(String string) {
        if (string == null) {
            string = "";
        }
        this.created_after_date = string;
        return (T)this;
    }

    public T created_after_date(String string, Boolean bl) {
        this.created_after_date(string);
        this.include_created_at(bl);
        return (T)this;
    }

    public T created_before_date(String string) {
        if (string == null) {
            string = "";
        }
        this.created_before_date = string;
        return (T)this;
    }

    public T created_before_date(String string, Boolean bl) {
        this.created_before_date(string);
        this.include_created_at(bl);
        return (T)this;
    }

    public T include_created_at(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_CREATED, bl);
        return (T)this;
    }

    public T modified_by_netID(String string) {
        return this.modified_by_netid(string);
    }

    public T modified_by_netid(String string) {
        if (string == null) {
            string = "";
        }
        this.modified_by_netid = string;
        return (T)this;
    }

    public T modified_by_netID(String string, Boolean bl) {
        return this.modified_by_netid(string, bl);
    }

    public T modified_by_netid(String string, Boolean bl) {
        this.modified_by_netid(string);
        this.include_modified_by(bl);
        return (T)this;
    }

    public T modified_by_name(String string) {
        if (string == null) {
            string = "";
        }
        this.modified_by_name = string;
        return (T)this;
    }

    public T modified_by_name(String string, Boolean bl) {
        this.modified_by_name(string);
        this.include_modified_by(bl);
        return (T)this;
    }

    public T include_modified_by(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, bl);
        return (T)this;
    }

    public T modified_after_date(String string) {
        if (string == null) {
            string = "";
        }
        this.modified_after_date = string;
        return (T)this;
    }

    public T modified_after_date(String string, Boolean bl) {
        this.modified_after_date(string);
        this.include_modified_at(bl);
        return (T)this;
    }

    public T modified_before_date(String string) {
        if (string == null) {
            string = "";
        }
        this.modified_before_date = string;
        return (T)this;
    }

    public T modified_before_date(String string, Boolean bl) {
        this.modified_before_date(string);
        this.include_modified_at(bl);
        return (T)this;
    }

    public T include_modified_at(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_MODIFIED, bl);
        return (T)this;
    }

    public T owner(String string) {
        if (string == null) {
            string = "";
        }
        this.owner = string;
        return (T)this;
    }

    public T owner(String string, Boolean bl) {
        this.owner(string);
        this.include_owner(bl);
        return (T)this;
    }

    public T include_owner(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_OWNER, bl);
        return (T)this;
    }

    public T comment(String string) {
        if (string == null) {
            string = "";
        }
        this.comment = string;
        return (T)this;
    }

    public T comment(String string, Boolean bl) {
        this.comment(string);
        this.include_comment(bl);
        return (T)this;
    }

    public T include_comment(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(this.INCLUDE_COMMENT, bl);
        return (T)this;
    }

    protected Vector<R> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        Vector vector = this.perform_search(netDB_Datastore);
        Vector<Object> vector2 = new Vector();
        if (vector != null && vector.size() > 0 && vector.get(0) instanceof Result_Hash) {
            vector2 = this.process_results(netDB_Datastore, (Result_Hash)vector.get(0));
        }
        return vector2;
    }

    protected void process_common_results(Lockable lockable, Vector vector, int n, int n2, int n3, int n4) throws Exception {
        Object object;
        if (n != -1) {
            object = (TZ_Timestamp)vector.get(n);
            if (object != null) {
                lockable.modified_at((Timestamp)object);
            }
            lockable.flag_field_as_defined(Field.MODIFIED_AT);
        }
        if (n2 != -1) {
            object = (String)vector.get(n2);
            if (object != null && !((String)object).equals("()")) {
                lockable.modified_by(lockable.datastore(), (String)object);
            }
            lockable.flag_field_as_defined(Field.MODIFIED_BY);
        }
        if (n3 != -1) {
            object = (TZ_Timestamp)vector.get(n3);
            if (object != null) {
                lockable.created_at((Timestamp)object);
            }
            lockable.flag_field_as_defined(Field.CREATED_AT);
        }
        if (n4 != -1) {
            object = (String)vector.get(n4);
            if (object != null && !((String)object).equals("()")) {
                lockable.created_by(lockable.datastore(), (String)object);
            }
            lockable.flag_field_as_defined(Field.CREATED_BY);
        }
    }

    public String all_parameters() {
        String string = "";
        if (this.created_by_netid != null) {
            string = string + " created_by_netid: " + this.created_by_netid;
        }
        if (this.created_by_name != null) {
            string = string + " created_by_name: " + this.created_by_name;
        }
        if (this.created_after_date != null) {
            string = string + " created_after_date: " + this.created_after_date;
        }
        if (this.created_before_date != null) {
            string = string + " created_before_date: " + this.created_before_date;
        }
        if (this.modified_by_netid != null) {
            string = string + " modified_by_netid: " + this.modified_by_netid;
        }
        if (this.modified_by_name != null) {
            string = string + " modified_by_name: " + this.modified_by_name;
        }
        if (this.modified_after_date != null) {
            string = string + " modified_after_date: " + this.modified_after_date;
        }
        if (this.modified_before_date != null) {
            string = string + " modified_before_date: " + this.modified_before_date;
        }
        if (this.owner != null) {
            string = string + " owner: " + this.owner;
        }
        if (this.comment != null) {
            string = string + " comment: " + this.comment;
        }
        if (this.include_created_by().booleanValue()) {
            string = string + " include_created_by";
        }
        if (this.include_created_at().booleanValue()) {
            string = string + " include_created_at";
        }
        if (this.include_modified_by().booleanValue()) {
            string = string + " include_modified_by";
        }
        if (this.include_modified_at().booleanValue()) {
            string = string + " include_modified_at";
        }
        if (this.include_owner().booleanValue()) {
            string = string + " include_owner";
        }
        if (this.include_comment().booleanValue()) {
            string = string + " include_comment";
        }
        string = string.trim();
        return string + this.child_params();
    }

    protected abstract String child_params();

    public void legacy_search_params(Hashtable<String, String> hashtable) {
        hashtable.put("txt.groupC.lower(created_by_netid)", this.created_by_netid);
        hashtable.put("txt.groupC.lower(created_by_name)", this.created_by_name);
        hashtable.put("tst.created >= ", this.created_after_date);
        hashtable.put("tst.created <= ", this.created_before_date);
        hashtable.put("txt.groupM.lower(mod_by_netid)", this.modified_by_netid);
        hashtable.put("txt.groupM.lower(mod_by_name)", this.modified_by_name);
        hashtable.put("tst.modified >= ", this.modified_after_date);
        hashtable.put("tst.modified <= ", this.modified_before_date);
    }
}

