/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.lang.reflect.Method;
import java.util.Hashtable;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;

public final class FS_Hashtable<T1, T2 extends NetDB>
extends Hashtable<T1, T2> {
    private static final long serialVersionUID = 1L;
    private String method_name = null;
    private Method method = null;

    protected FS_Hashtable() {
    }

    public FS_Hashtable(String string) throws Exception {
        this.method_name = string;
    }

    public T2 get(T1 T1, NetDB netDB, NetDB_Datastore netDB_Datastore) throws Exception {
        if (T1 == null && this.method_name != null) {
            return null;
        }
        NetDB<Object> netDB2 = (NetDB)this.get(T1);
        if (netDB2 == null) {
            netDB2 = this.new_instance(netDB);
            netDB2.bind(netDB_Datastore);
            netDB2.flag_as_system_created();
            if (this.method_name != null) {
                this.invoke_method(netDB2, T1);
            }
            this.put(T1, netDB2);
        }
        return (T2)netDB2;
    }

    private T2 new_instance(NetDB netDB) throws Exception {
        if (netDB == null) {
            return null;
        }
        return (T2)((NetDB)netDB.getClass().newInstance());
    }

    private Object invoke_method(T2 T2, T1 T1) throws Exception {
        Class[] classArray = new Class[]{T1.getClass()};
        Class<?> clazz = T2.getClass();
        while (clazz != null && this.method == null) {
            try {
                this.method = clazz.getDeclaredMethod(this.method_name, classArray);
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        if (this.method == null) {
            throw new Exception("Unable to find method '" + T2.getClass().getName() + "." + this.method_name + " (" + T1.getClass().getName() + ")'.");
        }
        Object object = this.method.invoke(T2, T1);
        return object;
    }
}

