/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Domain_FS_Parameters;
import stanford.netdb.Domain_Name;
import stanford.netdb.Domain_SS_Result;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;

public final class Domain
extends Lockable<Domain> {
    public static String template_name = "templates/toString/domain.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private Domain_Name name = null;
    private Boolean limited = null;
    private Boolean delegated = null;
    private String comment = null;
    private Multi_Value_Attribute<Group> create_names_in_groups = null;
    private Multi_Value_Attribute<Group> use_as_name_groups = null;

    public Domain() {
        this.init();
    }

    public Domain(Domain_Name domain_Name) {
        this.init(domain_Name);
    }

    public Domain(Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        this.init(domain_Name, bl, bl2, string);
    }

    public Domain(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Domain(NetDB_Datastore netDB_Datastore, Domain_Name domain_Name) {
        super(netDB_Datastore);
        this.init(domain_Name);
    }

    public Domain(NetDB_Datastore netDB_Datastore, Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        super(netDB_Datastore);
        this.init(domain_Name, bl, bl2, string);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(Domain_Name domain_Name) {
        this.init(domain_Name, null, null, null);
    }

    private void init(Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        if (domain_Name != null) {
            this.name(domain_Name);
        }
        if (bl != null) {
            this.limited(bl);
        }
        if (bl2 != null) {
            this.delegated(bl2);
        }
        if (string != null) {
            this.comment(string);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Domain.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public Domain_Name name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_domain_name, "Domain.name");
        return this.name;
    }

    public Boolean is_limited() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.limited, NetDB.unset_boolean, "Domain.limited");
        return this.limited;
    }

    public Boolean is_delegated() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.delegated, NetDB.unset_boolean, "Domain.delegated");
        return this.delegated;
    }

    public Boolean limited() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.is_limited();
    }

    public Boolean delegated() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.is_delegated();
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Domain.comment");
        return this.comment;
    }

    public Collection<Group> get_acl(ACCESS_TYPE aCCESS_TYPE) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            this.internal_complete(this.groups, NetDB.unset_mva_group, "Domain.groups");
            if (this.groups == null || this.groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.groups.all_values();
        }
        if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            this.internal_complete(this.create_names_in_groups, NetDB.unset_mva_group, "Domain.create_names_in_groups");
            if (this.create_names_in_groups == null || this.create_names_in_groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.create_names_in_groups.all_values();
        }
        if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME) {
            this.internal_complete(this.use_as_name_groups, NetDB.unset_mva_group, "Domain.use_as_name_groups");
            if (this.use_as_name_groups == null || this.use_as_name_groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.use_as_name_groups.all_values();
        }
        return null;
    }

    @Override
    public String handle() throws Exception {
        if (this.name != null && this.name != NetDB.unset_domain_name) {
            return this.name.handle();
        }
        if (this.id == null) {
            throw new Insufficient_Information("The handle was not found and could not be loaded.");
        }
        this.name = this.handle(this.id);
        return this.name.handle();
    }

    @Override
    protected Domain id(Integer n) {
        this.id = n;
        return this;
    }

    public Domain name(Domain_Name domain_Name) {
        this.name = domain_Name;
        return this;
    }

    public Domain limited(Boolean bl) {
        this.limited = bl;
        return this;
    }

    public Domain delegated(Boolean bl) {
        this.delegated = bl;
        return this;
    }

    public Domain comment(String string) {
        this.comment = string;
        return this;
    }

    public Domain grant_access(Group group, ACCESS_TYPE aCCESS_TYPE) {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            if (this.groups == null || this.groups == NetDB.unset_mva_group) {
                this.groups = new Multi_Value_Attribute();
            }
            this.groups.add(group);
        } else if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            if (this.create_names_in_groups == null || this.create_names_in_groups == NetDB.unset_mva_group) {
                this.create_names_in_groups = new Multi_Value_Attribute();
            }
            this.create_names_in_groups.add(group);
        } else if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME) {
            if (this.use_as_name_groups == null || this.use_as_name_groups == NetDB.unset_mva_group) {
                this.use_as_name_groups = new Multi_Value_Attribute();
            }
            this.use_as_name_groups.add(group);
        }
        return this;
    }

    public Domain grant_access(Collection<Group> collection, ACCESS_TYPE aCCESS_TYPE) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.grant_access(iterator.next(), aCCESS_TYPE);
        }
        return this;
    }

    public Domain revoke_access(Group group, ACCESS_TYPE aCCESS_TYPE) {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            if (this.groups != null) {
                this.groups.remove(group, (Boolean)true);
            }
        } else if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            if (this.create_names_in_groups != null) {
                this.create_names_in_groups.remove(group, (Boolean)true);
            }
        } else if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME && this.use_as_name_groups != null) {
            this.use_as_name_groups.remove(group, (Boolean)true);
        }
        return this;
    }

    public Domain revoke_access(Collection<Group> collection, ACCESS_TYPE aCCESS_TYPE) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.revoke_access(iterator.next(), aCCESS_TYPE);
        }
        return this;
    }

    @Override
    public Domain bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.create_names_in_groups, netDB_Datastore);
        this.bind_children(this.use_as_name_groups, netDB_Datastore);
        return this;
    }

    @Override
    public Domain unbind() {
        super.unbind();
        this.unbind_children(this.create_names_in_groups);
        this.unbind_children(this.use_as_name_groups);
        return this;
    }

    @Override
    public Domain unlink() {
        super.unlink();
        this.unlink_children(this.create_names_in_groups);
        this.unlink_children(this.use_as_name_groups);
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        Domain domain = null;
        if (!(netDB instanceof Domain)) {
            return;
        }
        domain = (Domain)netDB;
        this.id = domain.id;
        this.name = domain.name;
        this.limited = domain.limited;
        this.delegated = domain.delegated;
        this.comment = domain.comment;
        if (this.create_names_in_groups != NetDB.unset_mva_group) {
            for (Group group : this.get_acl(ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN)) {
                group.deep_update(netDB_Datastore, domain.get_acl(ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN));
            }
        }
        if (this.use_as_name_groups != NetDB.unset_mva_group) {
            for (Group group : this.get_acl(ACCESS_TYPE.USE_DOMAIN_AS_NAME)) {
                group.deep_update(netDB_Datastore, domain.get_acl(ACCESS_TYPE.USE_DOMAIN_AS_NAME));
            }
        }
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.name != null) {
            string = this.name.single_value_attributes();
        }
        return string + " " + this.limited + " " + this.delegated + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_domain_name;
        }
        if (this.limited == null) {
            this.limited = NetDB.unset_boolean;
        }
        if (this.delegated == null) {
            this.delegated = NetDB.unset_boolean;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.create_names_in_groups == null) {
            this.create_names_in_groups = NetDB.unset_mva_group;
        }
        if (this.use_as_name_groups == null) {
            this.use_as_name_groups = NetDB.unset_mva_group;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (this.name == NetDB.unset_domain_name) {
                this.name = null;
            }
        } else if (field == Field.LIMITED) {
            if (this.limited == NetDB.unset_boolean) {
                this.limited = null;
            }
        } else if (field == Field.DELEGATED) {
            if (this.delegated == NetDB.unset_boolean) {
                this.delegated = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.CREATE_NAMES) {
            if (this.create_names_in_groups == NetDB.unset_mva_group) {
                this.create_names_in_groups = null;
            }
        } else if (field == Field.USE_AS_NAME && this.use_as_name_groups == NetDB.unset_mva_group) {
            this.use_as_name_groups = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (this.name == NetDB.unset_domain_name) {
            this.name = null;
        }
        if (this.limited == NetDB.unset_boolean) {
            this.limited = null;
        }
        if (this.delegated == NetDB.unset_boolean) {
            this.delegated = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.create_names_in_groups == NetDB.unset_mva_group) {
            this.create_names_in_groups = null;
        }
        if (this.use_as_name_groups == NetDB.unset_mva_group) {
            this.use_as_name_groups = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "domain", this, bl);
    }

    protected static Domain extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Domain domain = new Domain(netDB_Datastore);
        domain.flag_as_system_created();
        domain.extract(hashtable);
        return domain;
    }

    @Override
    protected Domain extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Hashtable hashtable2;
        if (hashtable == null) {
            return this;
        }
        this.groups = new Multi_Value_Attribute();
        this.create_names_in_groups = new Multi_Value_Attribute();
        this.use_as_name_groups = new Multi_Value_Attribute();
        super.extract(hashtable);
        this.name(Domain_Name.extract(this.datastore, hashtable));
        if (hashtable.containsKey("id")) {
            this.id(new Integer((String)hashtable.get("id")));
            hashtable.remove("id");
        }
        if (hashtable.containsKey("comment")) {
            this.comment((String)hashtable.get("comment"));
            hashtable.remove("comment");
        }
        if (hashtable.containsKey("delegated?")) {
            this.delegated((Boolean)hashtable.get("delegated?"));
            hashtable.remove("delegated?");
        }
        if (hashtable.containsKey("limited?")) {
            this.limited((Boolean)hashtable.get("limited?"));
            hashtable.remove("limited?");
        }
        if ((hashtable2 = (Hashtable)hashtable.get("groups")) != null) {
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = new Group(this.datastore, (String)object2);
                ((NetDB)((Object)enumeration)).flag_as_system_created();
                this.grant_access((Group)((Object)enumeration), ACCESS_TYPE.MODIFY_DOMAIN);
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("useAsName");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                object = new Group(this.datastore, (String)((Object)enumeration));
                ((NetDB)object).flag_as_system_created();
                this.grant_access((Group)object, ACCESS_TYPE.USE_DOMAIN_AS_NAME);
            }
        }
        hashtable.remove("useAsName");
        object2 = (Hashtable)hashtable.get("assign");
        if (object2 != null) {
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Group group = new Group(this.datastore, (String)object);
                group.flag_as_system_created();
                this.grant_access(group, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN);
            }
        }
        hashtable.remove("assign");
        NetDB.unhandled_keys(hashtable, "Domain.extract");
        return this;
    }

    protected Domain_Name handle(Integer n) throws Exception, No_Datastore_Defined {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                string = this.datastore.remote_domain().handle(n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            string = Domain._handle(this.datastore, n);
        }
        this.name(new Domain_Name(string));
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = "";
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.domain().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(null, this.handle());
    }

    protected Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    protected Integer verify_or_die(Integer n, String string) throws Exception {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Integer n2 = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = this.datastore.remote_domain().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n2 = Domain._verify_or_die("", this.datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.domain().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.domain().verify_or_die(string, n) : netDB_Datastore.domain().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public Boolean usable() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_domain().can_use(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._can_use(this.datastore);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _can_use(NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (netDB_Datastore.operating_user() == null) {
            throw new Insufficient_Information("The operating user has not been set.");
        }
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            this.id = Domain._verify_or_die(string, netDB_Datastore, this.id, this.handle());
            Boolean bl = netDB_Datastore.domain().can_use(string, netDB_Datastore.operating_user().id(), this.id);
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
    }

    public Boolean usable_as_name() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_domain().can_use_as_name(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._can_use_as_name(this.datastore);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _can_use_as_name(NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (netDB_Datastore.operating_user() == null) {
            throw new Insufficient_Information("The operating user has not been set.");
        }
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            this.id = Domain._verify_or_die(string, netDB_Datastore, this.id, this.handle());
            Boolean bl = netDB_Datastore.domain().can_use_as_name(string, netDB_Datastore.operating_user().id(), this.id);
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.DOMAIN);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.DOMAIN);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.DOMAIN);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.DOMAIN);
    }

    protected static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege._has_access(string, netDB_Datastore, user.id(), Record_Type.DOMAIN.toString(), null);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_domain().has_access(user, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Domain._has_access("", netDB_Datastore, user, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n = netDB_Datastore.domain().verify_or_die(string, string2);
            if (Domain._has_access(string, netDB_Datastore, user).booleanValue() && Group._has_access(string, netDB_Datastore, user.id(), Record_Type.DOMAIN.toString(), n).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            Boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return false;
    }

    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        Lock_Result lock_Result = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                lock_Result = this.datastore.remote_domain().lock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            lock_Result = Domain._lock_record("", this.datastore, this.handle());
        }
        this.id = lock_Result.record_id();
        this.lock(lock_Result.lock());
        this.locked_by(lock_Result.locked_by());
        return lock_Result.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock_Result _lock_record(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Lock_Result lock_Result = new Lock_Result();
        Boolean bl = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            Integer n = netDB_Datastore.domain().verify_or_die(string, string2);
            Hashtable hashtable = netDB_Datastore.domain().lock_record(string, n);
            lock_Result.record_id(n);
            lock_Result.lock((Timestamp)hashtable.get("locked"));
            lock_Result.locked_by(netDB_Datastore.operating_user());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else if (bl2.booleanValue()) {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return lock_Result;
    }

    @Override
    public Domain unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_domain().unlock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._unlock(this.datastore);
        }
        this.clear_lock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _unlock(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.domain().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return bl;
    }

    public static Domain load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Domain.load(NetDB.default_datastore(), bl, string);
    }

    public static Domain load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Domain domain = new Domain(netDB_Datastore);
        Domain_Name domain_Name = new Domain_Name(netDB_Datastore, string);
        domain_Name.flag_as_system_created();
        domain.name(domain_Name);
        if (bl.booleanValue()) {
            domain.lock_record();
        }
        domain.load_object("", string);
        return domain;
    }

    public static Domain load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Domain.load(NetDB.default_datastore(), string);
    }

    public static Domain load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Domain.load("", netDB_Datastore, string);
    }

    private static Domain load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Domain domain = new Domain(netDB_Datastore);
        domain.load_object(string, string2);
        return domain;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_domain().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = Domain._load_object(string, this.datastore, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            Integer n = Domain._verify_or_die(string, netDB_Datastore, null, string2);
            hashtable = netDB_Datastore.domain().info(string, n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    public static Collection<Domain> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(NetDB.default_datastore());
    }

    public static Collection<Domain> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Domain> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(netDB_Datastore, false);
    }

    public static Collection<Domain> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_domain().list(bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Domain._list(netDB_Datastore, bl);
        }
        Vector<Domain> vector = new Vector<Domain>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Domain domain = new Domain(netDB_Datastore);
                domain.name(new Domain_Name(netDB_Datastore, string));
                String string2 = (String)hashtable.get(string);
                if (string2 != null) {
                    domain.id = Integer.parseInt(string2);
                }
                domain.name.flag_as_system_created();
                domain.flag_as_system_created();
                vector.add(domain);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.domain().list(string, n) : netDB_Datastore.domain().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Domain.delete(netDB_Datastore, this.handle());
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Domain.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_domain().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            Domain._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Lock_Result lock_Result = Domain._lock_record(string2, netDB_Datastore, string);
            netDB_Datastore.domain().delete(string2, lock_Result.lock(), lock_Result.record_id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    @Override
    public Domain commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Domain domain = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                domain = netDB_Datastore.remote_domain().commit(this, bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            domain = this._commit(netDB_Datastore, bl);
        }
        if (domain != null) {
            this.deep_update(netDB_Datastore, domain);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain _commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB.rmi_exception(netDB_Datastore);
        Domain domain = null;
        Boolean bl2 = null;
        String string = "";
        if (this.name == null) {
            throw new Insufficient_Information("The domain must have a name.");
        }
        try {
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                domain = new Domain();
                this.name.reserve(string, netDB_Datastore);
                object = netDB_Datastore.domain().insert(string, this.name.full_name(), NetDB.boolean_to_integer(this.limited), NetDB.boolean_to_integer(this.delegated), this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id(), netDB_Datastore.operating_user().netid());
                this.name.commit(string, netDB_Datastore, Domain_Name.EMPTY, this.id, this.lock(), Record_Type.DOMAIN);
            } else {
                domain = Domain.load(string, netDB_Datastore, netDB_Datastore.domain().handle(string, this.id));
                if (!domain.name.name().equals(this.name.name())) {
                    domain.name._verify_or_die(string, netDB_Datastore);
                    netDB_Datastore.name().update_domain_name(string, this.lock(), domain.name.id(), this.name.name());
                }
                netDB_Datastore.domain().update(string, this.lock(), this.id, this.name.full_name(), NetDB.boolean_to_integer(this.limited), NetDB.boolean_to_integer(this.delegated), this.comment);
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, domain.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.create_names_in_groups, domain.create_names_in_groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.use_as_name_groups, domain.use_as_name_groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result2.only_in_set1();
            Vector vector4 = comparison_Result2.only_in_set2();
            Vector vector5 = comparison_Result3.only_in_set1();
            Vector vector6 = comparison_Result3.only_in_set2();
            for (n = 0; n < vector.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n)).handle(), this.id, ACCESS_TYPE.MODIFY_DOMAIN.toString());
            }
            for (n = 0; n < vector2.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector2.get(n)).handle(), this.id, ACCESS_TYPE.MODIFY_DOMAIN.toString());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector4.get(n)).handle(), this.id, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN.toString());
            }
            for (n = 0; n < vector3.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector3.get(n)).handle(), this.id, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN.toString());
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector6.get(n)).handle(), this.id, ACCESS_TYPE.USE_DOMAIN_AS_NAME.toString());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector5.get(n)).handle(), this.id, ACCESS_TYPE.USE_DOMAIN_AS_NAME.toString());
            }
            netDB_Datastore.domain().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl2.booleanValue() && bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Domain_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Domain.search(NetDB.default_datastore(), string);
    }

    public static Collection<Domain_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_domain().search(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Domain._search(netDB_Datastore, string);
        }
        Vector<Domain_SS_Result> vector = new Vector<Domain_SS_Result>();
        for (String string2 : hashtable.keySet()) {
            vector.add(new Domain_SS_Result(string2));
        }
        Collections.sort(vector, new Domain_SS_Result(""));
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _search(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name(), true);
            hashtable = netDB_Datastore.simple_search().get_domains(string2, string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    public static Collection<Domain> full_search(Domain_FS_Parameters domain_FS_Parameters) throws Exception {
        return Domain.full_search(NetDB.default_datastore(), domain_FS_Parameters);
    }

    public static Collection<Domain> full_search(NetDB_Datastore netDB_Datastore, Domain_FS_Parameters domain_FS_Parameters) throws Exception {
        return domain_FS_Parameters.search(netDB_Datastore);
    }

    public static enum ACCESS_TYPE {
        MODIFY_DOMAIN("domain"),
        CREATE_NAMES_IN_DOMAIN("domain_assign"),
        USE_DOMAIN_AS_NAME("domain_use");

        private String value = null;

        private ACCESS_TYPE(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }
}

