/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Vector;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.directory.Directory_Record;
import stanford.netdb.exceptions.Exception_Formatter;

public final class Directory_Person
extends Person {
    public static String template_name = "templates/toString/person.tmpl";
    private static final long serialVersionUID = 1L;
    protected String department = null;

    private Directory_Person(NetDB_Datastore netDB_Datastore, Directory_Record directory_Record) {
        super(netDB_Datastore);
        super.init(directory_Record.reg_id(), directory_Record.directory_id(), directory_Record.name(), directory_Record.last_name(), directory_Record.phone(), directory_Record.email(), directory_Record.net_id(), directory_Record.active());
        this.department(directory_Record.department());
        this.flag_as_system_created().flag_as_loaded();
    }

    public String department() {
        return this.department;
    }

    protected Directory_Person department(String string) {
        this.department = string;
        return this;
    }

    public static Collection<Directory_Person> search(String string) throws Exception {
        return Directory_Person.search(Directory_Person.default_datastore(), string);
    }

    public static Collection<Directory_Person> search(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Vector<Directory_Person> vector = new Vector<Directory_Person>();
        try {
            Vector<Directory_Record> vector2 = netDB_Datastore.directory().lookup_by_name(string);
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add(new Directory_Person(netDB_Datastore, vector2.get(i)));
            }
        }
        catch (Exception exception) {
            Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "directory");
        }
        return vector;
    }

    public static Directory_Person lookup(SEARCH_TYPE sEARCH_TYPE, String string) throws Exception {
        return Directory_Person.lookup(Directory_Person.default_datastore(), sEARCH_TYPE, string);
    }

    public static Directory_Person lookup(NetDB_Datastore netDB_Datastore, SEARCH_TYPE sEARCH_TYPE, String string) throws Exception {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Vector<Directory_Record> vector = null;
        try {
            if (sEARCH_TYPE == SEARCH_TYPE.NETID) {
                vector = netDB_Datastore.directory().lookup_by_UID(string);
            } else if (sEARCH_TYPE == SEARCH_TYPE.REGID) {
                vector = netDB_Datastore.directory().lookup_by_key(string);
            }
        }
        catch (Exception exception) {
            Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "directory");
        }
        if (vector != null && vector.size() == 1) {
            return new Directory_Person(netDB_Datastore, vector.get(0));
        }
        return null;
    }

    public static enum SEARCH_TYPE {
        NETID,
        REGID;

    }
}

