/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Hashtable;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.State;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.util.Cache;

public final class Defaults
extends NetDB<Defaults> {
    private static final long serialVersionUID = 1L;
    private static String CACHE_NAME = "Defaults";

    private Defaults() {
    }

    public static Integer v6MaxPrefixLength() throws Exception, No_Datastore_Defined {
        return Defaults.v6MaxPrefixLength(NetDB.default_datastore());
    }

    public static Integer v6MinPrefixLength() throws Exception, No_Datastore_Defined {
        return Defaults.v6MinPrefixLength(NetDB.default_datastore());
    }

    public static Integer MinVLAN() throws Exception, No_Datastore_Defined {
        return Defaults.MinVLAN(NetDB.default_datastore());
    }

    public static Integer LockTimeOut() throws Exception, No_Datastore_Defined {
        return Defaults.LockTimeOut(NetDB.default_datastore());
    }

    public static Integer MaxPrefixLengthChange() throws Exception, No_Datastore_Defined {
        return Defaults.MaxPrefixLengthChange(NetDB.default_datastore());
    }

    public static Integer DefaultLowRes() throws Exception, No_Datastore_Defined {
        return Defaults.DefaultLowRes(NetDB.default_datastore());
    }

    public static Integer DefaultHighRes() throws Exception, No_Datastore_Defined {
        return Defaults.DefaultHighRes(NetDB.default_datastore());
    }

    public static Integer v4MaxPrefixLength() throws Exception, No_Datastore_Defined {
        return Defaults.v4MaxPrefixLength(NetDB.default_datastore());
    }

    public static Integer v4MinPrefixLength() throws Exception, No_Datastore_Defined {
        return Defaults.v4MinPrefixLength(NetDB.default_datastore());
    }

    public static Integer MaxNodeCustomFields() throws Exception, No_Datastore_Defined {
        return Defaults.MaxNodeCustomFields(NetDB.default_datastore());
    }

    public static String DefaultDomain() throws Exception, No_Datastore_Defined {
        return Defaults.DefaultDomain(NetDB.default_datastore());
    }

    public static Boolean CheckForLimitedDomain() throws Exception, No_Datastore_Defined {
        return Defaults.CheckForLimitedDomain(NetDB.default_datastore());
    }

    public static Boolean Reserve_IPv4_Midrange() throws Exception, No_Datastore_Defined {
        return Defaults.Reserve_IPv4_Midrange(NetDB.default_datastore());
    }

    public static State DefaultState() throws Exception, No_Datastore_Defined {
        return Defaults.DefaultState(NetDB.default_datastore());
    }

    public static Integer network_max_names() throws Exception, No_Datastore_Defined {
        return Defaults.network_max_names(NetDB.default_datastore());
    }

    public static Boolean network_allow_aliases() throws Exception, No_Datastore_Defined {
        return Defaults.network_allow_aliases(NetDB.default_datastore());
    }

    public static Boolean network_allow_mxes() throws Exception, No_Datastore_Defined {
        return Defaults.network_allow_mxes(NetDB.default_datastore());
    }

    public static Integer network_ip_max_names() throws Exception, No_Datastore_Defined {
        return Defaults.network_ip_max_names(NetDB.default_datastore());
    }

    public static Boolean network_ip_allow_aliases() throws Exception, No_Datastore_Defined {
        return Defaults.network_ip_allow_aliases(NetDB.default_datastore());
    }

    public static Boolean network_ip_allow_mxes() throws Exception, No_Datastore_Defined {
        return Defaults.network_ip_allow_mxes(NetDB.default_datastore());
    }

    public static Integer node_ip_max_names() throws Exception, No_Datastore_Defined {
        return Defaults.node_ip_max_names(NetDB.default_datastore());
    }

    public static Boolean node_ip_allow_aliases() throws Exception, No_Datastore_Defined {
        return Defaults.node_ip_allow_aliases(NetDB.default_datastore());
    }

    public static Boolean node_ip_allow_mxes() throws Exception, No_Datastore_Defined {
        return Defaults.node_ip_allow_mxes(NetDB.default_datastore());
    }

    public static Integer interface_max_names() throws Exception, No_Datastore_Defined {
        return Defaults.interface_max_names(NetDB.default_datastore());
    }

    public static Boolean interface_allow_aliases() throws Exception, No_Datastore_Defined {
        return Defaults.interface_allow_aliases(NetDB.default_datastore());
    }

    public static Boolean interface_allow_mxes() throws Exception, No_Datastore_Defined {
        return Defaults.interface_allow_mxes(NetDB.default_datastore());
    }

    public static Integer interface_ip_max_names() throws Exception, No_Datastore_Defined {
        return Defaults.interface_ip_max_names(NetDB.default_datastore());
    }

    public static Boolean interface_ip_allow_aliases() throws Exception, No_Datastore_Defined {
        return Defaults.interface_ip_allow_aliases(NetDB.default_datastore());
    }

    public static Boolean interface_ip_allow_mxes() throws Exception, No_Datastore_Defined {
        return Defaults.interface_ip_allow_mxes(NetDB.default_datastore());
    }

    public static String PrivateAddressDomain() throws Exception, No_Datastore_Defined {
        return Defaults.PrivateAddressDomain(NetDB.default_datastore());
    }

    public static Boolean display_custom_fields() throws Exception, No_Datastore_Defined {
        return Defaults.display_custom_fields(NetDB.default_datastore());
    }

    public static Boolean display_room() throws Exception, No_Datastore_Defined {
        return Defaults.display_room(NetDB.default_datastore());
    }

    public static Boolean display_users() throws Exception, No_Datastore_Defined {
        return Defaults.display_users(NetDB.default_datastore());
    }

    public static Integer v6MaxPrefixLength(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "v6MaxPrefixLength"));
    }

    public static Integer v6MinPrefixLength(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "v6MinPrefixLength"));
    }

    public static Integer MinVLAN(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "MinVLAN"));
    }

    public static Integer LockTimeOut(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "LockTimeOut"));
    }

    public static Integer MaxPrefixLengthChange(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "MaxPrefixLengthChange"));
    }

    public static Integer DefaultLowRes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "DefaultLowRes"));
    }

    public static Integer DefaultHighRes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "DefaultHighRes"));
    }

    public static Integer v4MaxPrefixLength(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "v4MaxPrefixLength"));
    }

    public static Integer v4MinPrefixLength(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "v4MinPrefixLength"));
    }

    public static Integer MaxNodeCustomFields(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "MaxNodeCustomFields"));
    }

    public static String DefaultDomain(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.get_data(netDB_Datastore, "DefaultDomain");
    }

    public static Boolean CheckForLimitedDomain(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "CheckForLimitedDomain"));
    }

    public static Boolean Reserve_IPv4_Midrange(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "Reserve_IPv4_Midrange"));
    }

    public static State DefaultState(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        State state = new State(netDB_Datastore);
        state.name(Defaults.get_data(netDB_Datastore, "DefaultState"));
        return state;
    }

    public static Integer network_max_names(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "network.max_names"));
    }

    public static Boolean network_allow_aliases(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "network.allow_aliases"));
    }

    public static Boolean network_allow_mxes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "network.allow_mxes"));
    }

    public static Integer network_ip_max_names(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "network.ip.max_names"));
    }

    public static Boolean network_ip_allow_aliases(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "network.ip.allow_aliases"));
    }

    public static Boolean network_ip_allow_mxes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "network.ip.allow_mxes"));
    }

    public static Integer node_ip_max_names(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "node.ip.max_names"));
    }

    public static Boolean node_ip_allow_aliases(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "node.ip.allow_aliases"));
    }

    public static Boolean node_ip_allow_mxes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "node.ip.allow_mxes"));
    }

    public static Integer interface_max_names(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "interface.max_names"));
    }

    public static Boolean interface_allow_aliases(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "interface.allow_aliases"));
    }

    public static Boolean interface_allow_mxes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "interface.allow_mxes"));
    }

    public static Integer interface_ip_max_names(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Integer.parseInt(Defaults.get_data(netDB_Datastore, "interface.ip.max_names"));
    }

    public static Boolean interface_ip_allow_aliases(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "interface.ip.allow_aliases"));
    }

    public static Boolean interface_ip_allow_mxes(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "interface.ip.allow_mxes"));
    }

    public static String PrivateAddressDomain(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.get_data(netDB_Datastore, "PrivateAddressDomain");
    }

    public static Boolean display_custom_fields(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "whois.display.node.custom_fields"));
    }

    public static Boolean display_room(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "whois.display.node.room"));
    }

    public static Boolean display_users(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Defaults.convert_to_boolean(Defaults.get_data(netDB_Datastore, "whois.display.node.users"));
    }

    private static synchronized String get_data(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Cache<Hashtable<String, String>> cache = Cache.fetch_hashtable_cache(netDB_Datastore.cache_name(CACHE_NAME));
        Hashtable<String, String> hashtable = cache.data();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (cache.is_old().booleanValue()) {
            Hashtable hashtable2 = null;
            if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
                try {
                    hashtable2 = netDB_Datastore.remote_default().list();
                }
                catch (Exception exception) {
                    throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
                }
                finally {
                    netDB_Datastore.close_remote_connection();
                }
            } else {
                hashtable2 = Defaults._list(netDB_Datastore);
            }
            hashtable.clear();
            for (String string2 : hashtable2.keySet()) {
                hashtable.put(string2, hashtable2.get(string2).toString());
            }
            cache.data(hashtable);
        }
        return hashtable.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.global_default().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    private static Boolean convert_to_boolean(String string) {
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String single_value_attributes() {
        return "";
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return "";
    }

    @Override
    public String handle() throws Not_Implemented {
        throw new Not_Implemented("This class shouldn't even be able to be instantiated to have a handle.");
    }

    @Override
    protected Defaults complete_object() throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be completed.");
    }

    @Override
    protected void initialize_member_data() {
    }

    @Override
    protected void flag_field_as_defined(Field field) {
    }

    @Override
    protected void clear_default_member_data() {
    }
}

