/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Hashtable;
import stanford.netdb.Attribute;
import stanford.netdb.DHCP_Option;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.exceptions.Exception_Formatter;

public final class DHCP_Setting
extends Attribute<DHCP_Setting> {
    public static String template_name = "templates/toString/dhcp_setting.tmpl";
    private static final long serialVersionUID = 1L;
    private DHCP_Option option = null;
    private String value = null;

    public DHCP_Setting() {
        this.init();
    }

    public DHCP_Setting(DHCP_Option dHCP_Option) {
        this.init(dHCP_Option);
    }

    public DHCP_Setting(DHCP_Option dHCP_Option, String string) {
        this.init(dHCP_Option, string);
    }

    public DHCP_Setting(String string, String string2) throws Exception {
        this.option = new DHCP_Option(string);
        this.value = string2;
    }

    private void init() {
        this.init(null, null);
    }

    private void init(DHCP_Option dHCP_Option) {
        this.init(dHCP_Option, null);
    }

    private void init(DHCP_Option dHCP_Option, String string) {
        if (dHCP_Option != null) {
            this.option(dHCP_Option);
        }
        if (string != null) {
            this.value(string);
        }
    }

    public DHCP_Option option() {
        return this.option;
    }

    public String value() {
        return this.value;
    }

    public String handle() {
        if (this.option != null) {
            return this.option.handle();
        }
        return "";
    }

    @Override
    public String unique_identifier() {
        return this.handle();
    }

    public DHCP_Setting option(DHCP_Option dHCP_Option) {
        this.option = dHCP_Option;
        return this;
    }

    public DHCP_Setting value(String string) {
        this.value = string;
        return this;
    }

    public String toString() {
        String string = "";
        try {
            string = this.toString(NetDB.FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a DHCP_Setting into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    public String toString(NetDB.FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "dhcp_setting", this, bl);
    }

    protected static DHCP_Setting extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        DHCP_Setting dHCP_Setting = new DHCP_Setting();
        dHCP_Setting.option = new DHCP_Option(netDB_Datastore, (String)hashtable.get("option"));
        hashtable.remove("option");
        dHCP_Setting.value = (String)hashtable.get("value");
        hashtable.remove("value");
        dHCP_Setting.option.flag_as_system_created();
        NetDB.unhandled_keys(hashtable, "DHCP_Setting.extract");
        return dHCP_Setting;
    }

    @Override
    public int compare(DHCP_Setting dHCP_Setting, DHCP_Setting dHCP_Setting2) {
        if (dHCP_Setting == null && dHCP_Setting2 == null) {
            return 0;
        }
        if (dHCP_Setting == null) {
            return -1;
        }
        if (dHCP_Setting2 == null) {
            return 1;
        }
        return dHCP_Setting.compare(dHCP_Setting2);
    }

    public Boolean equals(DHCP_Setting dHCP_Setting) {
        if (this.compare(dHCP_Setting) == 0) {
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(DHCP_Setting dHCP_Setting) {
        int n = this.option.compareTo(dHCP_Setting.option);
        if (n == 0) {
            return this.value.compareTo(dHCP_Setting.value);
        }
        return n;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.option != null) {
            this.option.single_value_attributes();
        }
        return string + " " + this.value;
    }

    @Override
    public int compare(Attribute<DHCP_Setting> attribute) {
        return this.compare(attribute, Attribute.COMPARISON_TYPE.SINGLE_VALUES);
    }

    @Override
    public int compare(Attribute<DHCP_Setting> attribute, Attribute.COMPARISON_TYPE cOMPARISON_TYPE) {
        String string = null;
        String string2 = null;
        if (cOMPARISON_TYPE == Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER) {
            string = this.unique_identifier();
            if (attribute != null) {
                string2 = attribute.unique_identifier();
            }
        } else {
            string = this.single_value_attributes();
            if (attribute != null) {
                string2 = attribute.single_value_attributes();
            }
        }
        return string.toLowerCase().compareTo(string2.toLowerCase());
    }
}

