/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;

public final class DHCP_Option
extends Record<DHCP_Option> {
    public static String template_name = "templates/toString/dhcp_option.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private DATA_TYPE data_type = null;
    private TYPE type = null;
    private Hashtable<SCOPE, String> applications = new Hashtable();

    public DHCP_Option() {
        this.init();
    }

    protected DHCP_Option(String string) {
        this.init(string);
    }

    public DHCP_Option(String string, DATA_TYPE dATA_TYPE) {
        this.init(string, dATA_TYPE);
    }

    public DHCP_Option(String string, DATA_TYPE dATA_TYPE, TYPE tYPE) {
        this.init(string, dATA_TYPE, tYPE);
    }

    public DHCP_Option(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected DHCP_Option(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public DHCP_Option(NetDB_Datastore netDB_Datastore, String string, DATA_TYPE dATA_TYPE) {
        super(netDB_Datastore);
        this.init(string, dATA_TYPE);
    }

    public DHCP_Option(NetDB_Datastore netDB_Datastore, String string, DATA_TYPE dATA_TYPE, TYPE tYPE) {
        super(netDB_Datastore);
        this.init(string, dATA_TYPE, tYPE);
    }

    private void init() {
        this.init(null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null);
    }

    private void init(String string, DATA_TYPE dATA_TYPE) {
        this.init(string, dATA_TYPE, null);
    }

    private void init(String string, DATA_TYPE dATA_TYPE, TYPE tYPE) {
        if (string != null) {
            this.name(string);
        }
        if (dATA_TYPE != null) {
            this.data_type(dATA_TYPE);
        }
        if (tYPE != null) {
            this.type(tYPE);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.id, NetDB.unset_integer, "DHCP_Option.id");
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "DHCP_Option.name");
        return this.name;
    }

    public DATA_TYPE data_type() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete((Object)this.data_type, null, "data_type");
        return this.data_type;
    }

    public TYPE type() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete((Object)this.type, null, "type");
        return this.type;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public DHCP_Option name(String string) {
        this.name = string;
        return this;
    }

    public DHCP_Option data_type(DATA_TYPE dATA_TYPE) {
        this.data_type = dATA_TYPE;
        return this;
    }

    public DHCP_Option type(TYPE tYPE) {
        this.type = tYPE;
        return this;
    }

    @Override
    public DHCP_Option unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.id = ((DHCP_Option)netDB).id;
        this.name = ((DHCP_Option)netDB).name;
        this.data_type = ((DHCP_Option)netDB).data_type;
        this.type = ((DHCP_Option)netDB).type;
        this.applications = ((DHCP_Option)netDB).applications;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + (Object)((Object)this.data_type) + " " + (Object)((Object)this.type);
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.applications == null) {
            this.applications = NetDB.unset_hashtable;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.APPLICATION && this.applications == NetDB.unset_hashtable) {
            this.applications = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (this.applications == NetDB.unset_hashtable) {
            this.applications = null;
        }
    }

    @Override
    public String toString() {
        String string = "";
        try {
            string = this.toString(NetDB.FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a DHCP_Option into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "dhcp_option", this, bl);
    }

    protected static DHCP_Option extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        DHCP_Option dHCP_Option = new DHCP_Option(netDB_Datastore);
        dHCP_Option.flag_as_system_created();
        dHCP_Option.extract(hashtable);
        return dHCP_Option;
    }

    protected DHCP_Option extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        this.applications = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SCOPE sCOPE = SCOPE.fetch(string);
            if (sCOPE != null) {
                this.applications.put(sCOPE, "");
            }
            hashtable.remove(string);
        }
        NetDB.unhandled_keys(hashtable, "DHCP_Option.extract");
        return this;
    }

    protected Integer verify_or_die(Integer n) throws Exception {
        return this.verify_or_die(n, null);
    }

    protected Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    protected Integer verify_or_die(Integer n, String string) throws Exception {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Integer n2 = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = this.datastore.remote_dhcp_option().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n2 = DHCP_Option._verify_or_die("", this.datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.dhcp_option().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.dhcp_option().verify_or_die(string, n) : netDB_Datastore.dhcp_option().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.DHCP_OPTION);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.DHCP_OPTION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.DHCP_OPTION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.DHCP_OPTION);
    }

    public static DHCP_Option load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return DHCP_Option.load(NetDB.default_datastore(), string);
    }

    public static DHCP_Option load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return DHCP_Option.load("", netDB_Datastore, string);
    }

    private static DHCP_Option load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        DHCP_Option dHCP_Option = new DHCP_Option(netDB_Datastore);
        dHCP_Option.load_object(string, string2);
        return dHCP_Option;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        if (this.id == null) {
            this.id = this.verify_or_die(string2);
        }
        this.name = string2;
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<DHCP_Option> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return DHCP_Option.list(NetDB.default_datastore(), null);
    }

    public static Collection<DHCP_Option> list(SCOPE sCOPE) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return DHCP_Option.list(NetDB.default_datastore(), sCOPE);
    }

    public static Collection<DHCP_Option> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return DHCP_Option.list(netDB_Datastore, null);
    }

    public static Collection<DHCP_Option> list(NetDB_Datastore netDB_Datastore, SCOPE sCOPE) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<DHCP_Option> vector = new Vector<DHCP_Option>();
        Hashtable hashtable = null;
        String string = "";
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_dhcp_option().list();
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = DHCP_Option._list(netDB_Datastore);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                DHCP_Option dHCP_Option = DHCP_Option.extract(netDB_Datastore, (Hashtable)hashtable.get(string2));
                dHCP_Option.name(string2);
                if (sCOPE != null && dHCP_Option.applications.get((Object)sCOPE) == null) continue;
                vector.add(dHCP_Option);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.dhcp_option().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        return hashtable;
    }

    @Override
    public void delete() throws Not_Implemented {
        this.delete(NetDB.default_datastore());
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        DHCP_Option.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public DHCP_Option commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }

    public static enum SCOPE {
        ADDRESS_SPACE("addressspace"),
        DHCP_SERVICE("dhcpservice"),
        INTERFACE("interface"),
        NETWORK("network"),
        NODE_GROUP("nodegroup");

        private String value = "";

        private SCOPE(String string2) {
            this.value = string2;
        }

        public static SCOPE fetch(String string) {
            string = string.trim();
            for (SCOPE sCOPE : SCOPE.values()) {
                if (!sCOPE.value.equals(string)) continue;
                return sCOPE;
            }
            return null;
        }
    }

    public static enum DATA_TYPE {
        FLAG,
        HOST,
        INTEGER,
        KEYWORD,
        STRING;

    }

    public static enum TYPE {
        OPTION,
        PARAMETER;

    }
}

