/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Hashtable;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;

public final class Consultant
extends Person {
    public static String template_name = "templates/toString/consultant.tmpl";
    private static final long serialVersionUID = 1L;
    private Boolean primary = null;

    public Consultant() {
        this.init();
    }

    public Consultant(Person person, Boolean bl) {
        super(person.reg_id, person.dir_id, person.name, person.last_name, person.phone, person.email, person.netid, person.active);
        this.id = person.id;
        this.init(bl);
    }

    public Consultant(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Consultant(NetDB_Datastore netDB_Datastore, Person person, Boolean bl) {
        super(netDB_Datastore, person.reg_id, person.dir_id, person.name, person.last_name, person.phone, person.email, person.netid, person.active);
        this.id = person.id;
        this.init(bl);
    }

    @Override
    protected void init() {
        this.init(false);
    }

    private void init(Boolean bl) {
        if (bl != null) {
            this.primary(bl);
        }
    }

    public Boolean is_primary() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.primary, NetDB.unset_boolean, "Consultant.primary");
        return this.primary;
    }

    @Override
    public String handle() {
        return super.handle();
    }

    public Consultant primary(Boolean bl) {
        this.primary = bl;
        return this;
    }

    public Consultant set_primary() {
        return this.primary(true);
    }

    public Consultant clear_primary() {
        return this.primary(false);
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        this.primary = ((Consultant)netDB).primary;
    }

    @Override
    public String single_value_attributes() {
        return super.single_value_attributes() + " " + this.primary;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.primary == null) {
            this.primary = NetDB.unset_boolean;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.PRIMARY && this.primary == NetDB.unset_boolean) {
            this.primary = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.primary == NetDB.unset_boolean) {
            this.primary = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Person.toString(fORMAT, template_name, "consultant", this, bl);
    }

    public String name_and_primary_string() throws Exception {
        String string = this.name();
        if (this.is_primary().booleanValue()) {
            string = string + "*";
        }
        return string;
    }

    protected static Consultant extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Consultant consultant = new Consultant(netDB_Datastore);
        consultant.extract(hashtable);
        consultant.flag_as_system_created();
        return consultant;
    }

    @Override
    protected Consultant extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        super.extract(hashtable);
        this.primary((Boolean)hashtable.get("primary?"));
        hashtable.remove("primary?");
        NetDB.unhandled_keys(hashtable, "Consultant.extract");
        return this;
    }

    protected void load_object(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be loaded.");
    }

    @Override
    public Person commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

