/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Admin_Team_FS_Parameters;
import stanford.netdb.Admin_Team_SS_Result;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Department;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Lock_Result;

public final class Admin_Team
extends Lockable<Admin_Team> {
    public static String template_name = "templates/toString/admin_team.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String email = null;
    private String phone = null;
    private String comment = null;
    private Multi_Value_Attribute<Person> members = null;
    private Multi_Value_Attribute<Department> departments = null;

    public Admin_Team() {
        this.init();
    }

    public Admin_Team(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Admin_Team(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore, String string, String string2, String string3, String string4) {
        super(netDB_Datastore);
        this.init(string, string2, string3, string4);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string, String string2, String string3) {
        this.init(string, string2, string3, null);
    }

    private void init(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.email(string2);
        }
        if (string3 != null) {
            this.phone(string3);
        }
        if (string4 != null) {
            this.comment(string4);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.complete_required(this.id, NetDB.unset_integer, "Admin_Team.id").booleanValue()) {
            this.verify_or_die();
            this.complete();
        }
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "Admin_Team.name");
        return this.name;
    }

    public String email() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.email, NetDB.unset_string, "Admin_Team.email");
        return this.email;
    }

    public String phone() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.phone, NetDB.unset_string, "Admin_Team.phone");
        return this.phone;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "Admin_Team.comment");
        return this.comment;
    }

    public Collection<Person> members() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.members, NetDB.unset_mva_person, "Admin_Team.members");
        if (this.members == null || this.members == NetDB.unset_mva_person) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.members.all_values();
    }

    public Collection<Department> departments() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.departments, NetDB.unset_mva_department, "Admin_Team.departments");
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.departments.all_values();
    }

    @Override
    public String handle() throws Exception {
        if (this.name != null && this.name != NetDB.unset_string) {
            return this.name;
        }
        if (this.id == null) {
            throw new Insufficient_Information("The handle was not found and could not be loaded.");
        }
        this.name = this.handle(this.id);
        return this.name;
    }

    @Override
    protected Admin_Team id(Integer n) {
        this.id = n;
        return this;
    }

    public Admin_Team name(String string) {
        this.name = string;
        return this;
    }

    public Admin_Team email(String string) {
        this.email = string;
        return this;
    }

    public Admin_Team phone(String string) {
        this.phone = string;
        return this;
    }

    public Admin_Team comment(String string) {
        this.comment = string;
        return this;
    }

    public Admin_Team add_member(Person person) {
        if (this.members == null || this.members == NetDB.unset_mva_person) {
            this.members = new Multi_Value_Attribute();
        }
        this.members.add(person);
        return this;
    }

    public Admin_Team add_members(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_member(iterator.next());
        }
        return this;
    }

    public Admin_Team remove_member(Person person) {
        if (this.members != null) {
            this.members.remove(person);
        }
        return this;
    }

    public Admin_Team remove_members(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_member(iterator.next());
        }
        return this;
    }

    public Admin_Team add_department(Department department) {
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            this.departments = new Multi_Value_Attribute();
        }
        this.departments.add(department);
        return this;
    }

    public Admin_Team add_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_department(iterator.next());
        }
        return this;
    }

    public Admin_Team remove_department(Department department) {
        if (this.departments != null) {
            this.departments.remove(department, (Boolean)true);
        }
        return this;
    }

    public Admin_Team remove_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_department(iterator.next());
        }
        return this;
    }

    @Override
    public Admin_Team bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.members, netDB_Datastore);
        this.bind_children(this.departments, netDB_Datastore);
        return this;
    }

    @Override
    public Admin_Team unbind() {
        super.unbind();
        this.unbind_children(this.members);
        this.unbind_children(this.departments);
        return this;
    }

    @Override
    public Admin_Team unlink() {
        super.unlink();
        this.unlink_children(this.members);
        this.unlink_children(this.departments);
        this.id = null;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        Admin_Team admin_Team = null;
        if (!(netDB instanceof Admin_Team)) {
            return;
        }
        admin_Team = (Admin_Team)netDB;
        this.id = admin_Team.id;
        this.name = admin_Team.name;
        this.email = admin_Team.email;
        this.phone = admin_Team.phone;
        this.comment = admin_Team.comment;
        if (this.members != NetDB.unset_mva_person) {
            for (Person record : this.members()) {
                record.deep_update(netDB_Datastore, admin_Team.members());
            }
        }
        if (this.departments != NetDB.unset_mva_department) {
            for (Department department : this.departments()) {
                department.deep_update(netDB_Datastore, admin_Team.departments());
            }
        }
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.email + " " + this.phone + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.email == null) {
            this.email = NetDB.unset_string;
        }
        if (this.phone == null) {
            this.phone = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.members == null) {
            this.members = NetDB.unset_mva_person;
        }
        if (this.departments == null) {
            this.departments = NetDB.unset_mva_department;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.EMAIL) {
            if (NetDB.unset_string.equals(this.email)) {
                this.email = null;
            }
        } else if (field == Field.PHONE) {
            if (NetDB.unset_string.equals(this.phone)) {
                this.phone = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.MEMBER) {
            if (this.members == NetDB.unset_mva_person) {
                this.members = null;
            }
        } else if (field == Field.DEPARTMENT && this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.email)) {
            this.email = null;
        }
        if (NetDB.unset_string.equals(this.phone)) {
            this.phone = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.members == NetDB.unset_mva_person) {
            this.members = null;
        }
        if (this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "admin_team", this, bl);
    }

    protected static Admin_Team extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.flag_as_system_created();
        admin_Team.extract(hashtable);
        return admin_Team;
    }

    @Override
    protected Admin_Team extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Hashtable hashtable2;
        if (hashtable == null) {
            return this;
        }
        this.groups = new Multi_Value_Attribute();
        this.members = new Multi_Value_Attribute();
        this.departments = new Multi_Value_Attribute();
        super.extract(hashtable);
        if (hashtable.containsKey("id")) {
            this.id(new Integer((String)hashtable.get("id")));
            hashtable.remove("id");
        }
        if (hashtable.containsKey("name")) {
            this.name((String)hashtable.get("name"));
            hashtable.remove("name");
        }
        if (hashtable.containsKey("email")) {
            this.email((String)hashtable.get("email"));
            hashtable.remove("email");
        }
        if (hashtable.containsKey("phone")) {
            this.phone((String)hashtable.get("phone"));
            hashtable.remove("phone");
        }
        if (hashtable.containsKey("comment")) {
            this.comment((String)hashtable.get("comment"));
            hashtable.remove("comment");
        }
        if ((hashtable2 = (Hashtable)hashtable.get("groups")) != null) {
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = new Group(this.datastore, (String)object2);
                ((NetDB)((Object)enumeration)).flag_as_system_created();
                this.add_owner((Group)((Object)enumeration));
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("departments");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                object = new Department(this.datastore, (String)((Object)enumeration));
                ((NetDB)object).flag_as_system_created();
                this.add_department((Department)object);
            }
        }
        hashtable.remove("departments");
        object2 = (Hashtable)hashtable.get("members");
        if (object2 != null) {
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.add_member(Person.extract(this.datastore, (Hashtable)((Hashtable)object2).get(object)));
            }
        }
        hashtable.remove("members");
        NetDB.unhandled_keys(hashtable, "Admin_Team.extract");
        return this;
    }

    protected String handle(Integer n) throws Exception, No_Datastore_Defined {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                string = this.datastore.remote_admin_team().handle(n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            string = Admin_Team._handle(this.datastore, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _handle(NetDB_Datastore netDB_Datastore, Integer n) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        String string = "";
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string = netDB_Datastore.admin_team().handle(string2, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return string;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception {
        return this.verify_or_die(null, string);
    }

    private Integer verify_or_die(Integer n, String string) throws Exception {
        if (n != null && n != NetDB.unset_integer) {
            return n;
        }
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Integer n2 = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                n2 = this.datastore.remote_access().verify_or_die(n, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            n2 = Admin_Team._verify_or_die("", this.datastore, n, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer _verify_or_die(String string, NetDB_Datastore netDB_Datastore, Integer n, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Integer n2 = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n2 = n == null ? netDB_Datastore.admin_team().verify_or_die(string, string2) : (string2 == null ? netDB_Datastore.admin_team().verify_or_die(string, n) : netDB_Datastore.admin_team().verify_or_die(string, n, string2));
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return n2;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.ADMIN_TEAM);
    }

    protected static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege._has_access(string, netDB_Datastore, user.id(), Record_Type.ADMIN_TEAM.toString(), null);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = netDB_Datastore.remote_admin_team().has_access(user, string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            bl = Admin_Team._has_access("", netDB_Datastore, user, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean _has_access(String string, NetDB_Datastore netDB_Datastore, User user, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            n = netDB_Datastore.admin_team().verify_or_die(string, string2);
            if (Admin_Team._has_access(string, netDB_Datastore, user).booleanValue() && Group._has_access(string, netDB_Datastore, user.id(), Record_Type.ADMIN_TEAM.toString(), n).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            Boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return false;
    }

    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        Lock_Result lock_Result = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                lock_Result = this.datastore.remote_admin_team().lock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            lock_Result = Admin_Team._lock_record("", this.datastore, this.handle());
        }
        this.id = lock_Result.record_id();
        this.lock(lock_Result.lock());
        this.locked_by(lock_Result.locked_by());
        return lock_Result.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock_Result _lock_record(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Lock_Result lock_Result = new Lock_Result();
        Boolean bl = null;
        Boolean bl2 = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl2 = true;
            }
            bl = false;
            Integer n = netDB_Datastore.admin_team().verify_or_die(string, string2);
            Hashtable hashtable = netDB_Datastore.admin_team().lock_record(string, n);
            lock_Result.record_id(n);
            lock_Result.lock((Timestamp)hashtable.get("locked"));
            lock_Result.locked_by(netDB_Datastore.operating_user());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else if (bl2.booleanValue()) {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return lock_Result;
    }

    @Override
    public Admin_Team unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                bl = this.datastore.remote_admin_team().unlock_record(this);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            bl = this._unlock(this.datastore);
        }
        this.clear_lock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean _unlock(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.admin_team().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return bl;
    }

    public static Admin_Team load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Admin_Team.load(NetDB.default_datastore(), bl, string);
    }

    public static Admin_Team load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.name(string);
        if (bl.booleanValue()) {
            admin_Team.lock_record();
        }
        admin_Team.load_object("", string);
        return admin_Team;
    }

    public static Admin_Team load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Admin_Team.load(NetDB.default_datastore(), string);
    }

    public static Admin_Team load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Admin_Team.load("", netDB_Datastore, string);
    }

    private static Admin_Team load(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.load_object(string, string2);
        return admin_Team;
    }

    @Override
    protected void load_object(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        Hashtable hashtable = null;
        if (this.datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = this.datastore.remote_admin_team().info(string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection();
            }
        } else {
            hashtable = Admin_Team._load_object(string, this.datastore, string2);
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _load_object(String string, NetDB_Datastore netDB_Datastore, String string2) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        if (string2 == null || string2.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        Hashtable hashtable = null;
        Boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
                bl = true;
            }
            Integer n = netDB_Datastore.admin_team().verify_or_die(string, string2);
            hashtable = netDB_Datastore.admin_team().info(string, n);
        }
        finally {
            if (bl.booleanValue()) {
                netDB_Datastore.rollback_transaction(string);
            }
        }
        return hashtable;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Admin_Team.delete(netDB_Datastore, this.handle());
        this.id = null;
        this.flag_as_modified().flag_as_user_created();
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Admin_Team.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                netDB_Datastore.remote_admin_team().delete(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            Admin_Team._delete(netDB_Datastore, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _delete(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Lock_Result lock_Result = Admin_Team._lock_record(string2, netDB_Datastore, string);
            netDB_Datastore.admin_team().delete(string2, lock_Result.lock(), lock_Result.record_id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    @Override
    public Admin_Team commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Admin_Team admin_Team = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                admin_Team = netDB_Datastore.remote_admin_team().commit(this, bl);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            admin_Team = this._commit(netDB_Datastore, bl);
        }
        if (admin_Team != null) {
            this.deep_update(netDB_Datastore, admin_Team);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Admin_Team _commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Admin_Team admin_Team = null;
        Boolean bl2 = null;
        String string = "";
        try {
            int n;
            int n2;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                admin_Team = new Admin_Team();
                object = netDB_Datastore.admin_team().insert(string, this.name, this.email, this.phone, this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id(), netDB_Datastore.operating_user().netid());
            } else {
                admin_Team = Admin_Team.load(string, netDB_Datastore, netDB_Datastore.admin_team().handle(string, this.id));
                netDB_Datastore.admin_team().update(string, this.lock(), this.id, this.name, this.email, this.phone, this.comment);
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, admin_Team.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.members, admin_Team.members);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.departments, admin_Team.departments, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result2.only_in_set1();
            Vector vector4 = comparison_Result2.only_in_set2();
            Vector vector5 = comparison_Result3.only_in_set1();
            Vector vector6 = comparison_Result3.only_in_set2();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n2)).handle(), this.id, Record_Type.ADMIN_TEAM.toString());
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector2.get(n2)).handle(), this.id, Record_Type.ADMIN_TEAM.toString());
            }
            if (this.members != null) {
                for (Person person : this.members.all_values(true)) {
                    person._insert_or_update(string, netDB_Datastore);
                }
            }
            for (n = 0; n < vector3.size(); ++n) {
                netDB_Datastore.admin_team().member(string, "add", timestamp, this.id, ((Person)vector3.get(n)).id());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.admin_team().member(string, "remove", timestamp, this.id, ((Person)vector4.get(n)).id());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.admin_team().org(string, "add", timestamp, this.id, ((Department)vector5.get(n)).id());
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.admin_team().org(string, "remove", timestamp, this.id, ((Department)vector6.get(n)).id());
            }
            netDB_Datastore.admin_team().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl2.booleanValue() && bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Admin_Team_SS_Result> search() throws Exception, No_Datastore_Defined {
        return Admin_Team.search(NetDB.default_datastore(), null);
    }

    public static Collection<Admin_Team_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Admin_Team.search(NetDB.default_datastore(), string);
    }

    public static Collection<Admin_Team_SS_Result> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Admin_Team.search(netDB_Datastore, null);
    }

    public static Collection<Admin_Team_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        if (netDB_Datastore.connection_type() == Datastore.TYPE.RMI) {
            try {
                hashtable = netDB_Datastore.remote_admin_team().search(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, netDB_Datastore.logger(), "database"), exception);
            }
            finally {
                netDB_Datastore.close_remote_connection();
            }
        } else {
            hashtable = Admin_Team._search(netDB_Datastore, string);
        }
        Vector<Admin_Team_SS_Result> vector = new Vector<Admin_Team_SS_Result>();
        for (String string2 : hashtable.keySet()) {
            vector.add(new Admin_Team_SS_Result(string2));
        }
        Collections.sort(vector, new Admin_Team_SS_Result(""));
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable _search(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        NetDB.rmi_exception(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name(), true);
            hashtable = string != null ? netDB_Datastore.simple_search().get_ateams(string2, string) : netDB_Datastore.simple_search().get_ateams(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return hashtable;
    }

    public static Collection<Admin_Team> full_search(Admin_Team_FS_Parameters admin_Team_FS_Parameters) throws Exception {
        return Admin_Team.full_search(NetDB.default_datastore(), admin_Team_FS_Parameters);
    }

    public static Collection<Admin_Team> full_search(NetDB_Datastore netDB_Datastore, Admin_Team_FS_Parameters admin_Team_FS_Parameters) throws Exception {
        return admin_Team_FS_Parameters.search(netDB_Datastore);
    }
}

