/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.Prefix;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public final class Address_Space_ACE
extends NetDB<Address_Space_ACE> {
    public static String template_name = "templates/toString/address_space_ace.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final Address_Space_ACE EMPTY = new Address_Space_ACE();
    private Prefix subnet = null;
    private Multi_Value_Attribute<Group> groups = null;

    public Address_Space_ACE() {
        this.init();
    }

    public Address_Space_ACE(Prefix prefix) {
        this.init(prefix);
    }

    public Address_Space_ACE(Prefix prefix, Group group) {
        this.init(prefix, group);
    }

    public Address_Space_ACE(Prefix prefix, Collection<Group> collection) {
        this.init(prefix, collection);
    }

    public Address_Space_ACE(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Address_Space_ACE(NetDB_Datastore netDB_Datastore, Prefix prefix) {
        super(netDB_Datastore);
        this.init(prefix);
    }

    public Address_Space_ACE(NetDB_Datastore netDB_Datastore, Prefix prefix, Group group) {
        super(netDB_Datastore);
        this.init(prefix, group);
    }

    public Address_Space_ACE(NetDB_Datastore netDB_Datastore, Prefix prefix, Collection<Group> collection) {
        super(netDB_Datastore);
        this.init(prefix, collection);
    }

    private void init() {
        this.init(null, (Collection<Group>)null);
    }

    private void init(Prefix prefix) {
        this.init(prefix, (Collection<Group>)null);
    }

    private void init(Prefix prefix, Group group) {
        Vector<Group> vector = null;
        if (group != null) {
            vector = new Vector<Group>();
            vector.add(group);
        }
        this.init(prefix, vector);
    }

    private void init(Prefix prefix, Collection<Group> collection) {
        if (prefix != null) {
            this.subnet(prefix);
        }
        if (collection != null) {
            this.add_groups(collection);
        }
    }

    public Prefix subnet() {
        return this.subnet;
    }

    public Collection<Group> groups() {
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.groups.all_values();
    }

    @Override
    public String handle() {
        return this.subnet.toString();
    }

    public Address_Space_ACE add_group(Group group) {
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            this.groups = new Multi_Value_Attribute();
        }
        this.groups.add(group);
        return this;
    }

    public Address_Space_ACE add_groups(Collection<Group> collection) {
        for (Group group : collection) {
            this.add_group(group);
        }
        return this;
    }

    public Address_Space_ACE remove_group(Group group) {
        if (this.groups != null) {
            this.groups.remove(group, (Boolean)true);
        }
        return this;
    }

    public Address_Space_ACE remove_groups(Collection<Group> collection) {
        for (Group group : collection) {
            this.remove_group(group);
        }
        return this;
    }

    public Address_Space_ACE subnet(Prefix prefix) {
        this.subnet = prefix;
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        Address_Space_ACE address_Space_ACE = null;
        if (!(netDB instanceof Address_Space_ACE)) {
            return;
        }
        address_Space_ACE = (Address_Space_ACE)netDB;
        this.subnet = address_Space_ACE.subnet;
        if (this.groups != NetDB.unset_mva_group) {
            for (Group group : this.groups()) {
                group.deep_update(netDB_Datastore, address_Space_ACE.groups());
            }
        }
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.subnet != null) {
            string = this.subnet.toString();
        }
        return string;
    }

    @Override
    protected void initialize_member_data() {
        if (this.subnet == null) {
            this.subnet = NetDB.unset_prefix;
        }
        if (this.groups == null) {
            this.groups = NetDB.unset_mva_group;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.PREFIX) {
            if (this.subnet == NetDB.unset_prefix) {
                this.subnet = null;
            }
        } else if (field == Field.OWNER && this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.subnet == NetDB.unset_prefix) {
            this.subnet = null;
        }
        if (this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "address_space_ace", this, bl);
    }

    protected static Address_Space_ACE extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Address_Space_ACE address_Space_ACE = new Address_Space_ACE(netDB_Datastore);
        address_Space_ACE.flag_as_system_created();
        address_Space_ACE.extract(hashtable);
        return address_Space_ACE;
    }

    protected Address_Space_ACE extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        return this;
    }

    @Override
    protected Address_Space_ACE complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this;
    }

    protected void delete(String string, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.delete(string, this.get_datastore(), n, timestamp);
    }

    protected void delete(String string, NetDB_Datastore netDB_Datastore, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        for (Group group : this.groups.all_values(true)) {
            netDB_Datastore.owner().remove(string, timestamp, group.handle(), n, Record_Type.ADDRESS_SPACE.toString());
        }
        this.flag_as_modified().flag_as_user_created();
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, Address_Space_ACE address_Space_ACE, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        int n2;
        this.bind(netDB_Datastore);
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, address_Space_ACE.groups);
        Vector vector = comparison_Result.only_in_set1();
        Vector vector2 = comparison_Result.both_sets();
        Vector vector3 = comparison_Result.only_in_set2();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n2)).handle(), n, Record_Type.ADDRESS_SPACE.toString());
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            netDB_Datastore.owner().remove(string, timestamp, ((Group)vector3.get(n2)).handle(), n, Record_Type.ADDRESS_SPACE.toString());
        }
    }
}

