/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Alias;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Field;
import stanford.netdb.MX;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.Name;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;

public final class A_Name
extends Name<A_Name> {
    public static String template_name = "templates/toString/a_name.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final A_Name EMPTY = new A_Name();
    private static final String DNS_TYPE = "A";
    private Multi_Value_Attribute<Alias> aliases = null;
    private Multi_Value_Attribute<MX> mxes = null;

    protected A_Name() {
    }

    public A_Name(String string) {
        super(string);
    }

    public A_Name(String string, String string2) {
        super(string, string2);
    }

    protected A_Name(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
    }

    public A_Name(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore, string);
    }

    public A_Name(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore, string, string2);
    }

    public Collection<Alias> aliases() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.aliases, NetDB.unset_mva_alias, "A_Name.aliases");
        if (this.aliases == null || this.aliases == NetDB.unset_mva_alias) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.aliases.all_values();
    }

    public Collection<MX> MXes() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.mxes();
    }

    public Collection<MX> mxes() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.mxes, NetDB.unset_mva_mx, "A_Name.mxes");
        if (this.mxes == null || this.mxes == NetDB.unset_mva_mx) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.mxes.all_values();
    }

    @Override
    protected String dns_type() {
        return DNS_TYPE;
    }

    public A_Name add_alias(Alias alias) {
        if (this.aliases == null || this.aliases == NetDB.unset_mva_alias) {
            this.aliases = new Multi_Value_Attribute();
        }
        this.aliases.add(alias);
        return this;
    }

    public A_Name add_aliases(Collection<Alias> collection) {
        Iterator<Alias> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_alias(iterator.next());
        }
        return this;
    }

    public A_Name remove_alias(Alias alias) {
        if (this.aliases != null) {
            this.aliases.remove(alias, (Boolean)true);
        }
        return this;
    }

    public A_Name remove_aliases(Collection<Alias> collection) {
        Iterator<Alias> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_alias(iterator.next());
        }
        return this;
    }

    public A_Name add_MX(MX mX) {
        return this.add_mx(mX);
    }

    public A_Name add_mx(MX mX) {
        if (this.mxes == null || this.mxes == NetDB.unset_mva_mx) {
            this.mxes = new Multi_Value_Attribute();
        }
        this.mxes.add(mX);
        return this;
    }

    public A_Name add_MXes(Collection<MX> collection) {
        return this.add_mxes(collection);
    }

    public A_Name add_mxes(Collection<MX> collection) {
        Iterator<MX> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_mx(iterator.next());
        }
        return this;
    }

    public A_Name remove_MX(MX mX) {
        return this.remove_mx(mX);
    }

    public A_Name remove_mx(MX mX) {
        if (this.mxes != null) {
            this.mxes.remove(mX, (Boolean)true);
        }
        return this;
    }

    public A_Name remove_MXes(Collection<MX> collection) {
        return this.remove_mxes(collection);
    }

    public A_Name remove_mxes(Collection<MX> collection) {
        Iterator<MX> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_mx(iterator.next());
        }
        return this;
    }

    @Override
    public A_Name bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.aliases, netDB_Datastore);
        this.bind_children(this.mxes, netDB_Datastore);
        return this;
    }

    @Override
    public A_Name unbind() {
        super.unbind();
        this.unbind_children(this.aliases);
        this.unbind_children(this.mxes);
        return this;
    }

    @Override
    public A_Name unlink() {
        super.unlink();
        this.unlink_children(this.aliases);
        this.unlink_children(this.mxes);
        return this;
    }

    @Override
    protected void perform_deep_update(NetDB_Datastore netDB_Datastore, NetDB netDB) throws Exception {
        super.perform_deep_update(netDB_Datastore, netDB);
        A_Name a_Name = null;
        if (!(netDB instanceof A_Name)) {
            return;
        }
        a_Name = (A_Name)netDB;
        if (this.aliases != NetDB.unset_mva_alias) {
            for (Alias name : this.aliases()) {
                name.deep_update(netDB_Datastore, a_Name.aliases());
            }
        }
        if (this.mxes != NetDB.unset_mva_mx) {
            for (MX mX : this.mxes()) {
                mX.deep_update(netDB_Datastore, a_Name.mxes());
            }
        }
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.aliases == null) {
            this.aliases = NetDB.unset_mva_alias;
        }
        if (this.mxes == null) {
            this.mxes = NetDB.unset_mva_mx;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.ALIAS) {
            if (this.aliases == NetDB.unset_mva_alias) {
                this.aliases = null;
            }
        } else if (field == Field.MX && this.mxes == NetDB.unset_mva_mx) {
            this.mxes = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.aliases == NetDB.unset_mva_alias) {
            this.aliases = null;
        }
        if (this.mxes == NetDB.unset_mva_mx) {
            this.mxes = null;
        }
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.aliases != null) {
            for (Alias name : this.aliases.all_values(true)) {
                name.flag_as_user_created();
            }
        }
        if (this.mxes != null) {
            for (MX mX : this.mxes.all_values(true)) {
                mX.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.aliases != null) {
            for (Alias name : this.aliases.all_values(true)) {
                name.flag_as_modified();
            }
        }
        if (this.mxes != null) {
            for (MX mX : this.mxes.all_values(true)) {
                mX.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected A_Name flag_as_system_created() {
        super.flag_as_system_created();
        if (this.aliases != null) {
            for (Alias name : this.aliases.all_values(true)) {
                name.flag_as_system_created();
            }
        }
        if (this.mxes != null) {
            for (MX mX : this.mxes.all_values(true)) {
                mX.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected A_Name flag_as_loaded() {
        super.flag_as_loaded();
        if (this.aliases != null) {
            for (Alias name : this.aliases.all_values(true)) {
                name.flag_as_loaded();
            }
        }
        if (this.mxes != null) {
            for (MX mX : this.mxes.all_values(true)) {
                mX.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Name.toString(fORMAT, template_name, "name", this, bl);
    }

    protected static A_Name extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        A_Name a_Name = new A_Name(netDB_Datastore);
        a_Name.flag_as_system_created();
        a_Name.extract(hashtable);
        return a_Name;
    }

    @Override
    protected A_Name extract(Hashtable hashtable) {
        Object object;
        Object object2;
        if (hashtable == null) {
            return this;
        }
        this.aliases = new Multi_Value_Attribute();
        this.mxes = new Multi_Value_Attribute();
        super.extract(hashtable);
        Hashtable hashtable2 = (Hashtable)hashtable.get("aliases");
        if (hashtable2 != null) {
            object2 = hashtable2.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.add_alias(Alias.extract(this.datastore, (Hashtable)hashtable2.get(object)));
            }
        }
        hashtable.remove("aliases");
        object2 = (Hashtable)hashtable.get("mxs");
        if (object2 != null) {
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.add_mx(MX.extract(this.datastore, (Hashtable)((Hashtable)object2).get(string)));
            }
        }
        hashtable.remove("mxs");
        NetDB.unhandled_keys(hashtable, "A_Name.extract");
        return this;
    }

    protected void delete_children(String string, A_Name a_Name, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.aliases, a_Name.aliases);
        Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.mxes, a_Name.mxes);
        Vector vector = comparison_Result.only_in_set2();
        Vector vector2 = comparison_Result2.only_in_set2();
        for (n = 0; n < vector.size(); ++n) {
            ((Alias)vector.get(n)).delete(string, timestamp);
        }
        for (n = 0; n < vector2.size(); ++n) {
            ((MX)vector2.get(n)).delete(string, timestamp, this.handle());
        }
    }

    @Override
    public A_Name reserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (A_Name)super.reserve("", netDB_Datastore, DNS_TYPE);
    }

    protected A_Name reserve(String string, NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (A_Name)super.reserve(string, netDB_Datastore, DNS_TYPE);
    }

    @Override
    public A_Name unreserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (A_Name)super.unreserve(netDB_Datastore, DNS_TYPE);
    }

    @Override
    protected void commit(String string, NetDB_Datastore netDB_Datastore, A_Name a_Name, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        super.commit(string, netDB_Datastore, a_Name, n, timestamp, record_Type);
        this.commit_children(string, netDB_Datastore, a_Name, n, timestamp, record_Type);
    }

    protected void commit_children(String string, NetDB_Datastore netDB_Datastore, A_Name a_Name, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n2;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.aliases, a_Name.aliases);
        Vector vector = comparison_Result.only_in_set1();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((Alias)vector.get(n2)).commit(string, netDB_Datastore, Alias.EMPTY, this.full_name(), timestamp, Record_Type.ALIAS);
        }
        comparison_Result = Multi_Value_Attribute.compare_for_commit(this.mxes, a_Name.mxes);
        vector = comparison_Result.only_in_set1();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((MX)vector.get(n2)).commit(string, netDB_Datastore, MX.EMPTY, this.full_name(), timestamp, Record_Type.MX);
        }
    }

    public static enum ALLOW {
        ALL,
        ALIAS,
        MX;

    }
}

