# NAME

kdc-test - Run client-side tests against Stanford Kerberos KDC servers

# SYNOPSIS

kdc-test --test=_test_ --master=_kerberos-master_ \[--slave=_server-list_\]
         (--local|--keytab=_path\_to\_keytab_) \[--verbose\] \[--port=_kdc-port_\]

# DESCRIPTION

The **kdc-test** script runs kadmin tests against the KDC servers. As we do
not run the kadmind service on KDC slaves, most of these tests are run
against the master only. Each test that can only be run against the master
will be marked "\[master only\]". Only use the **--slave** option for tests
marked "\[any KDC\]" and for the **replication** test.

\* simple

\* basic

\* dictionary

\* history

\* check

\* ad-krb5-sync

\* authentication

\* replication

# AUTHENTICATION AND AUTHORIZATION

There are two ways to authenticate when running this script: local
authentication or with credentials supplied by a keytab file.

## local authentication

You can run this script directly on the KDC you want to test if you
are logged in as root. To do this use the `--local` command-line option.
Note that if you do this you should also omit the `--master` option as
when running locally the implied master is the localhost.

The dictionary, history, and ad-krb5-sync commands will not be run in
local mode as kadmin run in local mode skips plugins needed by these tests.

## keytab authentication

You specify Kerberos credentials via a Kerberos keytab file using the
command-line switch **--keytab**. This keytab file must contain the
credentials for a principal that has authorization to create and delete
certain principals. If the principal used for this purpose is
**service/regression-testing@stanford.edu** then these entries must be
added to the `/etc/heimdal-kdc/kadmind.acl` file:

service/regression-testing   get    kadmin/\*

service/regression-testing   all    testing\_\_\*

service/regression-testing   all    krbtst\_hXjxc5uiyvaqk

Also, be sure that the kerberos servers you are attempting to reach are
running the kadmind service and allow connection to the kadmind port from
the machine you are running this script on.

# PRINCIPALS CREATED

Several of the tests will create and then delete a random principal. These
random principals have the form "testing\_\_YYYYMMDDHHMMSS\_\_RRRRRR" where
"YYYYMMDDHHMMSS" is the current date and time and "RRRRRR" are six random
lower-case letters. Those tests that create and then delete a random
principal will be marked "(CRUD)" in the section "TESTS" below.

If a test that creates one of these principals is run in non-local mode,
an entry for that principal will be created in the Heimdal history
database. Use the manage-heimdal-history script to delete these extra
entries.

Tests run in local mode will not create Heimdal password history
database entries.

# TESTS

Some of the tests only make sense when running on a KDC master. Those
are marked "\[master only\]". Tests that create and then delete a test
principal are marked "(CRUD)".

## ALL

Run all the master tests except for **check** and **authentication**.

## simple \[any KDC\]

The **simple** test looks for all principals that start "kadmin" and
passes if it finds at least two.

## basic (CRUD) \[master only\]

The **basic** test creates and deletes a service principal.

## dictionary (CRUD) \[master only, not in local mode\]

This test verifies that you cannot use easy-to-guess passwords by
exercising the krb5-strength plugin. Due to the fact that the dictionary
is not checked when run in local mode, this command will exit with an
error if `--local` is specified.

## history (CRUD) \[master only, not in local mode\]

This test verifies that the password history feature is functioning
properly. It creates a principal, sets its password, and then attempts to
change the password to the same password. This password re-use should be
caught by the heimdal-history system. Due to the fact that the history
database is not checked when run in local mode, this command will exit
with an error if `--local` is specified.

## check \[any KDC\]

This test runs the "kadmin check" command. This test can be very slow.

## ad-krb5-sync \[master only, not in local mode\]

The `ad-krb5-sync` tests the syncing of passwords from the Kerberos
master to the Active Directory via the `krb5-sync` plugin. The test
changes the password of the principal `krbtst_hXjxc5uiyvaqk` to a random
value and checks that the password was synced to the Active Directory by
attempting to get a Kerberos ticket for `krbtst_hXjxc5uiyvaqk` in the
Active Directory \_domain. Thus, for this test to work, the principal
`krbtst_hXjxc5uiyvaqk` must exist in both the Kerberos stanford.edu realm
and in the Active Directory domain you are testing against.

This test can be run on the master only. It cannot be run in local mode as
running in local mode skips the creation of the AD password file that is
used to sync the password to the Active Directory.

You need to provide two extra parameters, one for the AD domain name and
one for the AD domain controller. Example:

    kdc-test --test ad-krb5-sync                  \
             --master kdc-master-qa.stanford.edu  \
             --principal service/regression-testing-qa  \
             --win-realm WINUAT.STANFORD.EDU      \
             --win-dc    winuatdc1.winuat.stanford.edu

## replication (CRUD) \[slave only, not in local mode\]

This test is a hybrid: it **must** be run on the SLAVE and
a principal that has the access described in the section _AUTHENTICATION
AND AUTHORIZATION_ above must be specified via the `--principal` option.
Do **not** use the `--local` or `--keytab` options with this test.

This test creates a test principal on the master, waits a bit, and then
verifies that the principal exists on slave. Example:

    kdc-test --master kerberos-qa1.stanford.edu \
             --slave kerberos-qa2.stanford.edu \
             --principal service/regression-testing-qa  \
             --test replication

## authentication (CRUD) \[master only, not in local mode\]

This test creates a test principal and then does a kinit against it.
Use the **--slave** option for this test. Example:

    kdc-test --master kerberos-qa1.stanford.edu \
             --slave kerberos-qa2.stanford.edu \
             --principal service/regression-testing-qa  \
             --test authentication

# OPTIONS

- **--master**

    Specify which server is kerberos master. This is required for all tests.

- **--slave**

    The KDC slave to perform authentication against. Only needed for the
    "authentication" and "replication" tests.

- **--test**

    A required option specifying which test to run. See the above section
    **TESTS** for a description of which tests are available.

- **--local**

    Run the test in local mode (`kadmin -l`).
    See the above TESTS section to see which tests cannot be run
    in local mode.

- **--verbose**

    Display detailed processing information.

- **--principal**

    This option specifies the principal to use when running the
    tests.

- **--keytab**

    The keytab file used when running tests. The default value is
    `/etc/heimdal-kdc/regression-testing.keytab`.

- **--win-realm** and **--win-dc**

    These options are required when running the ad-krb5-sync test. See the
    ad-krb5-sync test in the TESTS section above for an example.

- **--nagios-server** and **--hostname**

    Use these two options when running kdc-test in Nagios mode.  A passive
    alert will be sent to the IP address indicated by `--nagios-server`.  The
    `--hostname` option tells the Nagios server which hostname to associate
    this passive monitor to.

# EXIT STATUS

The script will exit with 0 if the script completes and there were no
failures, 1 for any other reason.

# NOTES

Later.

# SEE ALSO

ldapsearch(1)

# AUTHOR

Adam Lewenberg <adamhl@stanford.edu>

# COPYRIGHT AND LICENSE

Copyright 2017 The Board of Trustees of the Leland Stanford Junior
University.  All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Stanford University not be used in
advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  Stanford University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
