<?php
  /*
    Copyright (C) 2009 - 2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  session_start();

  $CONFDIR="../../config";
  require $CONFDIR."/config.php";
  require "../functions/config_functions.php";
  require "../functions/ldap_functions.php";
  require "../functions/network_functions.php";
  require "../functions/json_functions.php";
  require "../phpldap/ldap_class.php";
  require "../phpfile/file_class.php";
  require "../objects/rootdnobject.php";
  require "../objects/querytimeobject.php";
  require "../objects/monitorobject.php";
  require "../objects/snmpobject.php";
  require "../objects/serverobject.php";
  require "../objects/cacheobject.php";
  require "../objects/replicainfoobject.php";
  require "../objects/replicationagreementobject.php";
  require "../objects/vendorinfoobject.php";
  require "../objects/schemaobject.php";
  $languageCode = getLanguage();
  require "../language/".$languageCode.".php";

  /****************************************************
  #####################################################
  # Local Functions
  #####################################################
  ****************************************************/

  /****************************************************
    Reset Existing authentication
    authlevel = environment or server
  ****************************************************/
  function resetAuthentication($authlevel, $environmentid, $serverid) {

    if($authlevel == "all") {
      delConfigValue("scheme");
      delConfigValue("tls");
      delConfigValue("dn");
      delConfigValue("password");
    }  
    else if($authlevel == "env") {
      delConfigValue("scheme", $environmentid);
      delConfigValue("tls", $environmentid);
      delConfigValue("dn", $environmentid);
      delConfigValue("password", $environmentid);
    }
    else if($authlevel == "server") {
      delConfigValue("scheme", $environmentid, $serverid);
      delConfigValue("tls", $environmentid, $serverid);
      delConfigValue("dn", $environmentid, $serverid);
      delConfigValue("password", $environmentid, $serverid);
    }
  }

  /****************************************************
    Cool auto completion (JQuery plugin) array format
  ****************************************************/
  function coolautoFormatter($inArray) {
    $out = array();
    $i = 0;
    foreach(array_unique($inArray) as $value) {
      $out[$i]["data"] = $value;
      $i++;
    }
    return $out;
  }


  /****************************************************
  #####################################################
  # Services Logic
  #####################################################
  ****************************************************/

  /****************************************************
    Get environment configuration incl. servers
  ****************************************************/
  function getEnvironmentConfiguration() {
    $environments = getEnvironments("nocollect", false);
    for($i = 0; $i < count($environments); $i++) {
      $out["environments"][$i]["name"] = $environments[$i][1];
      $out["environments"][$i]["environmentid"] = $i;
      // check for load balancer, description and url
      $out["environments"][$i]["loadbalancer"] = getConfigValue("loadbalancer", $environments[$i][0], 0);
      $out["environments"][$i]["description"] = getConfigValue("description", $environments[$i][0], 0);
      $out["environments"][$i]["url"] = getConfigValue("url", $environments[$i][0], 0);
      
      // now for each server in this environment
      $servers = getServers($environments[$i][0]);
      for($j = 0; $j < count($servers); $j++) {
        $out["environments"][$i]["servers"][$j]["name"] = $servers[$j][1];
        $out["environments"][$i]["servers"][$j]["description"] = getConfigValue("description", $i, $servers[$j][0]);
        $out["environments"][$i]["servers"][$j]["url"] = getConfigValue("url", $i, $servers[$j][0]);
        $out["environments"][$i]["servers"][$j]["serverid"] = $servers[$j][0];
        $out["environments"][$i]["servers"][$j]["environmentid"] = $i;
      }      
    }
    echo __json_encode($out);
  }


  /****************************************************
    Get the status for all servers within an environment
    This includes loadbalancer verification and 
    basic monitor attributes (start_time, current connetions)
  ****************************************************/
  function getEnvironmentServerStatus($environmentid) {
    $environmentname = getConfigValue("name", $environmentid, 0);  
    $loadbalancer    = getConfigValue("loadbalancer", $environmentid, 0);
    $servers         = getServers($environmentid);

    $out["environmentname"] = $environmentname;
    if(!empty($loadbalancer)) {
      $out["loadbalancer"] = setServer($loadbalancer);
    }
  
    for($i = 0; $i < count($servers); $i++) {
      $out["servers"][$i] = setServer($servers[$i][1]);
      // check replica type
      if($out["servers"][$i]->getRespondLDAP()) {
         $replicaInfo = setReplicaInfo($servers[$i][1], $servers[$i][1], true);
         $replicaInfoType = $replicaInfo->getReplicaType();
         $out["servers"][$i]->verifyRespondSecurePort();
         $out["servers"][$i]->setReplicaType($replicaInfoType);
         if(in_array($replicaInfoType, array("master", "hub"))) {
           $replicationInfo = setReplicationAgreement($servers[$i][1]);
           $out["servers"][$i]->setReplicationAgreements($replicationInfo->getNrOfAgreements());
           $out["servers"][$i]->setReplicationAgreementsOk($replicationInfo->getAgreementsOk());
        }
      }
      $out["monitor"][$i] = setMonitor($servers[$i][1], array("start_time", "cur_con"));      
    }      
    echo __json_encode($out);
  }

  /****************************************************
    Get monitoring information
  ****************************************************/
  function getServerStatus($environmentid, $serverid) {
    $out = array();
    $servername = getConfigValue("name", $environmentid, $serverid);  
    $out["server"] = setServer($servername);
    $out["monitor"] = setMonitor($servername);      
    $out["snmp"] = setSnmp($servername);      
    echo __json_encode($out);
  }

  /****************************************************
    Get Query Config By Wildcard
  ****************************************************/
  function getQueryConfigByWildCard($q) {
    $configMatch = queryConfigByWildcard($q);    
    echo __json_encode(coolautoFormatter($configMatch));
  }

  /****************************************************
    Get Query Config By Wildcard
  ****************************************************/
  function getQuerySchemaByWildCard($servername, $q) {
    $oSchema = setSchema($servername, 0);
    $attributes = $oSchema->getAttributeType($q);
    echo __json_encode(coolautoFormatter($attributes));  
  }

  /****************************************************
    Get Query Cache
  ****************************************************/
  function getQueryCache($environmentid, $q) {

    // exit if this functionality is not allowed
    if(!functionIsEnabled("cache")) {
      return;
    }

    $out["servers"] = array();
    $out["backenddb"] = array();
    $out["warning"] = "";
    $servers = array();
    if(empty($q)) {
      $serverArray = getServers($environmentid);
      for($i = 0; $i < count($serverArray); $i++) {
        $servers[count($servers)] = $serverArray[$i][1];
      }
    }
    else {
      $servers = explode(";", $q);
    }
    // get cache object from each server if it repsonds to ldap
    for($i = 0; $i < count($servers); $i++) {
      $currentServer = $servers[$i];
      $oServer = setServer($currentServer);
      if($oServer->getRespondLDAP()) {
        $cacheObject = setCache($currentServer);
        // we need to get the available backend db:s but only set it once
        if(empty($out["backenddb"])) {
          $backenddb = $cacheObject->getBackendDB();
          if(!empty($backenddb)) {
            $out["backenddb"] = $backenddb;
          } // if backend found for server
          $out["servers"][count($out["servers"])] = $cacheObject;
        } // if backend not set
        else {
          $allBackendMatch = true;
          // check that this server holds the same backends
          $currBackEnd = $cacheObject->getBackendDb();
          for($j = 0; $j < count($out["backenddb"]); $j++) {
            if(!in_array($out["backenddb"][$j], $currBackEnd)) {
              $allBackendMatch = false;
              $out["warning"] = "Backends does not match";
            }
          }
          if($allBackendMatch) {
            $out["servers"][count($out["servers"])] = $cacheObject;
          } // add server if first retrieved backends match
        } // backend exists
      } // responds to ldap
    }
    if(empty($out["backenddb"])) {
      $out["warning"] = getLang("page.cache.unablebackend");
    }
    echo __json_encode($out);
  }

  /****************************************************
    Authenticate, test and set / reset authentication
  ****************************************************/
  function getAuthenticate($servername, $q) {
    // exit if this functionality is not allowed
    if(!functionIsEnabled("authenticate")) {
      return;
    }

    $aServerId = getEnvironmentId($servername);
    if(empty($aServerId)) {
      echo __json_encode(array("success" => false));
      return;    
    }
    $environmentid = $aServerId[0];
    $serverid = $aServerId[1];
    
    // set options
    $aoptions = explode(";", $q);
    if(count($aoptions) != 5) {
      echo __json_encode(array("success" => false));
      return;    
    }

    $authdn = $aoptions[0];
    $authpassword = $aoptions[1];
    $authlevel = $aoptions[2];
    $authsecurity = $aoptions[3];
    $authenticatereset = $aoptions[4];

    // if this isn't a full dn we should query for the user dn
    // the rules are as follows:
    // get dn IF neither @ and = is present
    if((strpos($authdn, "@") === false) && (strpos($authdn, "=") === false)) {
      $returnedDN = getDNByID($servername, $authdn);
      if(!empty($returnedDN)) {
        // use this DN
        $authdn = $returnedDN;
      }
    }

    if($authsecurity == "ldaps") {
      $authsecuritykey = "scheme";
      $authsecuritykvalue = "ldaps";
    }
    else if($authsecurity == "tls") {
      $authsecuritykey = "tls";
      $authsecuritykvalue = "yes";
    }
    else {
      $authsecuritykey = "";
      $authsecuritykvalue = "";
    }

    // if we should reset configuration
    if($authenticatereset) {
      resetAuthentication($authlevel, $environmentid, $serverid);
      echo __json_encode(array("success" => true));
      return;
    }
  
    if($authlevel == "all") {
      setConfigValue("dn", $authdn);
      setConfigValue("password", $authpassword);

      // reset values
      delConfigValue("scheme");
      delConfigValue("tls");
      setConfigValue($authsecuritykey, $authsecuritykvalue);
    }

    // environment
    if($authlevel == "env") {
      setConfigValue("dn", $authdn, $environmentid);
      setConfigValue("password", $authpassword, $environmentid);
      // reset values
      delConfigValue("scheme", $environmentid);
      delConfigValue("tls", $environmentid);
      setConfigValue($authsecuritykey, $authsecuritykvalue, $environmentid);
    }

    // server
    if($authlevel == "server") {
      setConfigValue("dn", $authdn, $environmentid, $serverid);
      setConfigValue("password", $authpassword, $environmentid, $serverid);
      // reset values
      delConfigValue("scheme", $environmentid, $serverid);
      delConfigValue("tls", $environmentid, $serverid);
      setConfigValue($authsecuritykey, $authsecuritykvalue, $environmentid, $serverid);
    }
  
    $oServer = setServer($servername);

    if($oServer->isAvailable()) {
      if(authenticate($servername, $authdn, $authpassword)) {
        echo __json_encode(array("success" => true));
        return;    
      }
    }
    // if its not working we should reset all config values
    resetAuthentication($authlevel, $environmentid, $serverid);
    echo __json_encode(array("success" => false));
    return;
  }

  /****************************************************
    Add Server to Session
  ****************************************************/
  function getAddServer($servername, $q) {
    global $_SESSION;

    // exit if this functionality is not allowed
    if(!functionIsEnabled("addserver")) {
      return;
    }

    $sessionName = getLang("page.environments.sessionenv");
    $environments = getEnvironments();
    $environmentExist = false;
    
    // check if we have created a session environment?
    if($environments[(count($environments) - 1)][1] != $sessionName) {
      $environmentid = count($environments);
    }
    else {
      // already registered
      $environmentid = (count($environments) - 1);
      $environmentExist = true;
    }
    $_SESSION["envadd"][0][0]["name"] = $sessionName;
    $_SESSION["env"][$environmentid][0]["session"] = 1;
    $nServer = count($_SESSION["envadd"][0]);
    $_SESSION["envadd"][0][$nServer]["name"] = $servername;
    $_SESSION["env"][$environmentid][$nServer]["port"] = $q;
    
    // build JSON data to return
    $returnJSON = array();
    $returnJSON["environmentid"] = $environmentid;
    $returnJSON["name"] = $sessionName;
    $returnJSON["exist"] = $environmentExist;
    $returnJSON["servers"] = getServers($environmentid);
    $returnJSON["success"] = true;
    
    echo __json_encode($returnJSON);
    return;
  }

  /****************************************************
    Query and Compare Value for specific configuration options
  ****************************************************/
  function getCompareValue($environmentid, $q) {
    $out["compare"] = array();
    $out["options"] = array();
    // summary means that the values can be summarized
    $out["options"]["summary"] = 0;
    // $q is in format <comparekey>,<server1>;<server2>...
    $qSplit = explode(",", $q);
    $comparekey = $qSplit[0];
    $serverlist = explode(";", $qSplit[1]);
    for($i = 0; $i < count($serverlist); $i++) {
      $currentServer = $serverlist[$i];
      $serverIndex = count($out["compare"]);
      $out["compare"][$serverIndex][0] = $currentServer;
      $currentServer = $serverlist[$i];
      if($comparekey == "ipaddress") {
        $out["compare"][$serverIndex][1] = getServerIP($currentServer);
      }
      else {
        // requires LDAP support
        $oServer = setServer($currentServer);
        if($oServer->getRespondLDAP()) {
          if($comparekey == "vendor" || $comparekey == "version") {
             $vendorInfo = setVendorInfo($currentServer);
             if($comparekey == "vendor") {
               $out["compare"][$serverIndex][1] = $vendorInfo->getVendor();
             }
             if($comparekey == "version") {
               $out["compare"][$serverIndex][1] = $vendorInfo->getVersion();
             }
          } // vendor or version
          if($comparekey == "curr_con" || $comparekey == "tot_con" || $comparekey == "threads" ||
             $comparekey == "con_peak" ||  $comparekey == "server_start") {
            $monitor = setMonitor($currentServer);
             if($comparekey == "curr_con") {
               $out["compare"][$serverIndex][1] = intval($monitor->getCurrentConnections());
               $out["options"]["summary"] += $out["compare"][$serverIndex][1];
             }
             if($comparekey == "tot_con") {
               $out["compare"][$serverIndex][1] = $monitor->getTotalConnections();
             }
             if($comparekey == "threads") {
               $out["compare"][$serverIndex][1] = $monitor->getThreads();
             }
             if($comparekey == "con_peak") {
               $out["compare"][$serverIndex][1] = $monitor->getConnectionPeak();
             }
             if($comparekey == "server_start") {
               $out["compare"][$serverIndex][1] = $monitor->getStartTime();
             }
          } // monitor
          if($comparekey == "anon_bind" || $comparekey == "unauth_bind" || $comparekey == "simple_bind" ||
             $comparekey == "strong_bind" || $comparekey == "search" || $comparekey == "add" || $comparekey == "modify" ||
             $comparekey == "modifyrdn" || $comparekey == "remove") {
             $snmp = setSNMP($currentServer);
             if($comparekey == "anon_bind") {
               $out["compare"][$serverIndex][1] = $snmp->getAnonymousBinds();
             }
             if($comparekey == "unauth_bind") {
               $out["compare"][$serverIndex][1] = $snmp->getUnAuthenticatedBinds();
             }
             if($comparekey == "simple_bind") {
               $out["compare"][$serverIndex][1] = $snmp->getSimpleAuthBinds();
             }
             if($comparekey == "strong_bind") {
               $out["compare"][$serverIndex][1] = $snmp->getStrongAuthBinds();
             }
             if($comparekey == "search") {
               $out["compare"][$serverIndex][1] = $snmp->getSearchOps();
             }
             if($comparekey == "add") {
               $out["compare"][$serverIndex][1] = $snmp->getAddEntryOps();
             }
             if($comparekey == "modify") {
               $out["compare"][$serverIndex][1] = $snmp->getModifyEntryOps();
             }
             if($comparekey == "modifyrdn") {
               $out["compare"][$serverIndex][1] = $snmp->getModifyRdnOps();
             }
             if($comparekey == "remove") {
               $out["compare"][$serverIndex][1] = $snmp->getRemoveEntryOps();
             }
          } // snmp object
        } // respond to LDAP
      } // requires LDAP support
    }
        
    echo __json_encode($out);
    return;
  }
  
  
  /****************************************************
  #####################################################
  # Retrieve Information
  #####################################################
  ****************************************************/
  $sessionid = session_id();
  $SERVICE_SERVICE = getFormValue("service");
  $ENVIRONMENT_ID = getFormValue("environmentid");
  $SERVER_ID = getFormValue("serverid");
  $QUERY_STRING = getFormValue("q");
  $SERVER_NAME = getFormValue("servername");
  $USER_SESSION_ID = base64_decode(getFormValue("sid"));

/*
    if(empty($SERVICE_SERVICE)) {
      return;
    }
    if($USER_SESSION_ID != $sessionid) {
      return;
    }
*/

  /****************************************************
  #####################################################
  # Call Services
  #####################################################
  ****************************************************/
  if($SERVICE_SERVICE == "environmentconfiguration") {
    getEnvironmentConfiguration();
  }

  if($SERVICE_SERVICE == "serverstatus") {
    if(isset($ENVIRONMENT_ID) && (!empty($SERVER_ID))) {
      getServerStatus($ENVIRONMENT_ID, $SERVER_ID);
    }
    else if(isset($ENVIRONMENT_ID)) {
      getEnvironmentServerStatus($ENVIRONMENT_ID);
    }
  }

  if($SERVICE_SERVICE == "configquery") {
    if(!empty($QUERY_STRING)) {
      getQueryConfigByWildCard($QUERY_STRING);
    }
  }

  if($SERVICE_SERVICE == "schemaquery") {
    if(!empty($QUERY_STRING) && !empty($SERVER_NAME)) {
      getQuerySchemaByWildCard($SERVER_NAME, $QUERY_STRING);
    }
  }

  if($SERVICE_SERVICE == "cachequery") {
    getQueryCache($ENVIRONMENT_ID, $QUERY_STRING);
  }

  if($SERVICE_SERVICE == "authenticate") {
    if(!empty($QUERY_STRING) && !empty($SERVER_NAME)) {
      getAuthenticate($SERVER_NAME, $QUERY_STRING);
    }
  }

  if($SERVICE_SERVICE == "addserver") {
    if(!empty($QUERY_STRING) && !empty($SERVER_NAME)) {
      getAddServer($SERVER_NAME, $QUERY_STRING);
    }
  }

  if($SERVICE_SERVICE == "comparevalue") {
    getCompareValue($ENVIRONMENT_ID, $QUERY_STRING);
  }
?>