<?php
  session_start();
  $CONFDIR="../../config";

  require "../functions/config_functions.php";
  require "../phpldap/ldap_class.php";
  require "../phpfile/file_class.php";
  require "../functions/ldap_functions.php";
  require "../functions/network_functions.php";
  require "../functions/json_functions.php";
  require "../objects/serverobject.php";
  require "../objects/loadbalancerobject.php";
  $languageCode = getLanguage();
  require "../language/".$languageCode.".php";

  // check that this is not called from somewhere else
  $sessionid = session_id();
  $USER_SESSION_ID = base64_decode(getFormValue("sid"));
  if($USER_SESSION_ID != $sessionid) {
    return;
  }
  
  // Get input
  $environmentid = getFormValue("environmentid");
  $lbtype = getFormValue("lbtype");
  $lbqueries = getFormValue("lbqueries");
  $lbqueryport = getFormValue("lbqueryport");
  $loadbalancer = getConfigValue("loadbalancer", $environmentid);
  $lbaverage = 1;
  if(empty($loadbalancer)) {
    return;
  }

  // Check configured load balancer limit value
  $lb_limit = getConfigValue("loadbalancerlimit", $environmentid);
  if(empty($lb_limit)) {
    $lb_limit = 50;
  }
  
  // check load balancer limit
  if($lbqueries > $lb_limit) {
    $returnValues["message"] = "The limit of number of queries is set to: <b>".$lb_limit."</b>\n".
                               "You can increase this limit by adding the config option <b>&lt;loadbalancerlimit&gt;</b>#value#<b>&lt;/loadbalancerlimit&gt;</b>";
    echo __json_encode($returnValues);
    return;
  }

  $oLoad = setLoadBalancer($environmentid, $loadbalancer, $lbqueryport, $lbqueries, $lbtype);
  $returnValues = array();
  
  // if any messages exist, return
  $returnValues["message"] = $oLoad->getMessage();
  if(!empty($returnValues["message"])) {
    echo __json_encode($returnValues);
    return;
  }
  
  $returnValues["querytime"] = array();
  $returnValues["weight"] = array();
  
  $balancedHosts = $oLoad->getHosts();
  $points = 0;
  $pointsCombinedValue = 0;
  foreach ($balancedHosts as $host => $value) {
    $currIndex = count($returnValues["querytime"]);
    $returnValues["querytime"][$currIndex]["label"] = $host;    
    $returnValues["weight"][$currIndex]["label"] = $host;
    $returnValues["weight"][$currIndex]["data"][0] = array($oLoad->getEndTime(), $value);
    
    // next step is to set all meassured querytime for this host
    $balancedTime = $oLoad->getResponseTime($host, $lbqueryport);
    for($i = 0; $i < count($balancedTime); $i++) {
      $returnValues["querytime"][$currIndex]["data"][$i] = array($balancedTime[$i][1], $balancedTime[$i][0]);
      $pointsCombinedValue += $balancedTime[$i][0];
      $points++;
    }
  }
  
  if($pointsCombinedValue > 0) {
    $averageValue = round(($pointsCombinedValue / $points), 3);
    if($lbaverage) {
        $serverCount = count($returnValues["querytime"]);
        $returnValues["querytime"][$serverCount]["label"] = getLang("page.general.average");
        $returnValues["querytime"][$serverCount]["data"][0] = array($oLoad->getStartTime(), 
                                               $averageValue);
        $returnValues["querytime"][$serverCount]["data"][1] = array($oLoad->getEndTime(), 
                                               $averageValue);
        $returnValues["querytime"][$serverCount]["color"] = "#CCC";  
        $returnValues["querytime"][$serverCount]["lines"]["show"] = "true";  
    }
  }
  
  echo __json_encode($returnValues);
?>